unit Main;

interface

uses WinProcs, Classes, Graphics, Controls, Forms, StdCtrls, ExtCtrls,
  ProCtrls, ProDlgs, ProCalc;

const
  crHand = 100;

type
  TMainForm = class(TForm)
    Panel: TProPanel;
    LogoLabel: TProLabel;
    CopyrightLabel: TProLabel;
    VersionLabel: TProLabel;
    Bevel: TBevel;

    SelDirDialog: TProSelDirDialog;
    ConfirmDialog: TProConfirmDialog;
    WarningDialog: TProWarningDialog;
    InfoDialog: TProInfoDialog;
    PasswordDialog: TProPasswordDialog;
    LoginDialog: TProLoginDialog;
    ImageViewDialog: TProImageViewDialog;
    CalcModalDialog: TProCalcDialog;
    CalcDialog: TProCalcDialog;
    Labels: TProLabel;
    ButtonsLabel: TProLabel;
    PanelsLabel: TProLabel;
    ListBoxesLabel: TProLabel;
    ColorGridLabel: TProLabel;
    ControlsLabel: TProLabel;

    DialogsLabel: TProLabel;
    DirectoryLabel: TProLabel;
    ConfirmLabel: TProLabel;
    WarningLabel: TProLabel;
    InfoLabel: TProLabel;
    PasswordLabel: TProLabel;
    LoginLabel: TProLabel;
    ImageViewLabel: TProLabel;
    CalcModalLabel: TProLabel;
    CalcLabel: TProLabel;

    FinishLabel: TProLabel;

    LabelImage: TImage;
    ButtonImage: TImage;
    ListBoxImage: TImage;
    PanelImage: TImage;
    ColorGridImage: TImage;
    DirectoryImage: TImage;
    ConfirmImage: TImage;
    WarningImage: TImage;
    InfoImage: TImage;
    StopImage: TImage;
    StopLabel: TProLabel;
    PasswordImage: TImage;
    LoginImage: TImage;
    ImageViewImage: TImage;
    CalcModalImage: TImage;
    CalcImage: TImage;
    FinishImage: TImage;
    StopDialog: TProStopDialog;

    procedure FormCreate(Sender: TObject);
    procedure LabelMouseEnter(Sender: TObject);
    procedure LabelMouseLeave(Sender: TObject);
    procedure LabelsClick(Sender: TObject);
    procedure ButtonsLabelClick(Sender: TObject);
    procedure ListBoxesLabelClick(Sender: TObject);
    procedure PanelsLabelClick(Sender: TObject);
    procedure ColorGridLabelClick(Sender: TObject);
    procedure DirectoryLabelClick(Sender: TObject);
    procedure ConfirmLabelClick(Sender: TObject);
    procedure WarningLabelClick(Sender: TObject);
    procedure InfoLabelClick(Sender: TObject);
    procedure PasswordLabelClick(Sender: TObject);
    procedure LoginLabelClick(Sender: TObject);
    procedure ImageViewLabelClick(Sender: TObject);
    procedure CalcModalLabelClick(Sender: TObject);
    procedure CalcLabelClick(Sender: TObject);
    procedure FinishLabelClick(Sender: TObject);
    procedure StopDialogClick(Sender: TObject);
  end;

var
  MainForm: TMainForm;

implementation

uses Labels, Btns, ListBoxes, Panels, ColorGrid;

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
{$IFNDEF WIN32}
  VersionLabel.Caption := '16-bit Demo';
{$ENDIF}

  Screen.Cursors[crHand] := LoadCursor(HInstance, 'HANDCURSOR');

  Labels.Cursor := crHand;
  ButtonsLabel.Cursor := crHand;
  PanelsLabel.Cursor := crHand;
  ListBoxesLabel.Cursor := crHand;
  ColorGridLabel.Cursor := crHand;
  DirectoryLabel.Cursor := crHand;
  ConfirmLabel.Cursor := crHand;
  WarningLabel.Cursor := crHand;
  InfoLabel.Cursor := crHand;
  PasswordLabel.Cursor := crHand;
  LoginLabel.Cursor := crHand;
  ImageViewLabel.Cursor := crHand;
  CalcModalLabel.Cursor := crHand;
  CalcLabel.Cursor := crHand;
  FinishLabel.Cursor := crHand;

  LabelImage.Cursor := crHand;
  ButtonImage.Cursor := crHand;
  ListBoxImage.Cursor := crHand;
  PanelImage.Cursor := crHand;
  ColorGridImage.Cursor := crHand;
  DirectoryImage.Cursor := crHand;
  ConfirmImage.Cursor := crHand;
  WarningImage.Cursor := crHand;
  InfoImage.Cursor := crHand;
  PasswordImage.Cursor := crHand;
  LoginImage.Cursor := crHand;
  ImageViewImage.Cursor := crHand;
  CalcModalImage.Cursor := crHand;
  CalcImage.Cursor := crHand;
  FinishImage.Cursor := crHand;
end;

procedure TMainForm.LabelMouseEnter(Sender: TObject);
begin
  TProLabel(Sender).Font.Color := clPurple;
end;

procedure TMainForm.LabelMouseLeave(Sender: TObject);
begin
  TProLabel(Sender).Font.Color := clWhite;
end;

procedure TMainForm.LabelsClick(Sender: TObject);
begin
  LabelsForm.ShowModal;
end;

procedure TMainForm.ButtonsLabelClick(Sender: TObject);
begin
  ButtonsForm.ShowModal;
end;

procedure TMainForm.ListBoxesLabelClick(Sender: TObject);
begin
  ListBoxesForm.ShowModal;
end;

procedure TMainForm.PanelsLabelClick(Sender: TObject);
begin
  PanelsForm.ShowModal;
end;

procedure TMainForm.ColorGridLabelClick(Sender: TObject);
begin
  ColorGridForm.ShowModal;
end;

procedure TMainForm.DirectoryLabelClick(Sender: TObject);
begin
  SelDirDialog.Execute;
end;

procedure TMainForm.ConfirmLabelClick(Sender: TObject);
begin
  ConfirmDialog.Execute;
end;

procedure TMainForm.WarningLabelClick(Sender: TObject);
begin
  WarningDialog.Execute;
end;

procedure TMainForm.InfoLabelClick(Sender: TObject);
begin
  InfoDialog.Execute;
end;

procedure TMainForm.StopDialogClick(Sender: TObject);
begin
  StopDialog.Execute;
end;

procedure TMainForm.PasswordLabelClick(Sender: TObject);
begin
  PasswordDialog.Execute;
end;

procedure TMainForm.LoginLabelClick(Sender: TObject);
begin
  LoginDialog.Execute;
end;

procedure TMainForm.ImageViewLabelClick(Sender: TObject);
begin
  ImageViewDialog.Execute;
end;

procedure TMainForm.CalcModalLabelClick(Sender: TObject);
begin
  CalcModalDialog.Execute;
end;

procedure TMainForm.CalcLabelClick(Sender: TObject);
begin
  CalcDialog.Execute;
end;

procedure TMainForm.FinishLabelClick(Sender: TObject);
begin
  Close;
end;


end.
