unit Labels;

interface

uses Classes, Controls, Forms, Dialogs, StdCtrls, ExtCtrls,
  Tabnotbk, Spin, ProCtrls, ProDBCtl {$IFDEF WIN32}, ComCtrls {$ENDIF};

type
  TLabelsForm = class(TForm)
    TabbedNotebook: TTabbedNotebook;

    { ProLabel page }
    DemoLabel: TProLabel;
    Bevel: TBevel;

    AngleLabel: TProLabel;
    AngleEdit: TSpinEdit;
    ShadowSizeLabel: TProLabel;
    ShadowSizeEdit: TSpinEdit;
    ShadowDepthLabel: TProLabel;
    ShadowDepthEdit: TSpinEdit;
    OffsetXLabel: TProLabel;
    OffsetXEdit: TSpinEdit;
    OffsetYLabel: TProLabel;
    OffsetYEdit: TSpinEdit;

    ShadowStyleGroupBox: TGroupBox;
    CustomRadioButton: TRadioButton;
    NoneRadioButton: TRadioButton;
    RaisedRadioButton: TRadioButton;
    RecessedRadioButton: TRadioButton;
    ShadowRadioButton: TRadioButton;
    ThickShadowRadioButton: TRadioButton;

    AlignmentGroupBox: TGroupBox;
    TopLeftRadioButton: TRadioButton;
    TopRadioButton: TRadioButton;
    TopRightRadioButton: TRadioButton;
    CenterLeftRadioButton: TRadioButton;
    CenterRadioButton: TRadioButton;
    CenterRightRadioButton: TRadioButton;
    BottomLeftRadioButton: TRadioButton;
    BottomRadioButton: TRadioButton;
    BottomRightRadioButton: TRadioButton;

    ShadowDirectionGroupBox: TGroupBox;
    UpLeftRadioButton: TRadioButton;
    UpRadioButton: TRadioButton;
    UpRightRadioButton: TRadioButton;
    LeftRadioButton: TRadioButton;
    RightRadioButton: TRadioButton;
    DownLeftRadioButton: TRadioButton;
    DownRadioButton: TRadioButton;
    DownRightRadioButton: TRadioButton;

    FontDialog: TFontDialog;
    ColorDialog: TColorDialog;
    ShadowColorButton: TProButton;
    FontButton: TProButton;

    { ProClockLabel page }
    ClockImage: TImage;
    ClockGroupBox: TGroupBox;
    ClockLabel: TProClockLabel;
    ClockOptGroupBox: TGroupBox;
    FormatLabel: TProLabel;
    FormatComboBox: TComboBox;
    ShadowStyleLabel: TProLabel;
    ShadowStyleComboBox: TComboBox;

    DoneButton: TProButton;

    procedure FormCreate(Sender: TObject);
    procedure AngleEditChange(Sender: TObject);
    procedure ShadowSizeEditChange(Sender: TObject);
    procedure ShadowDepthEditChange(Sender: TObject);
    procedure OffsetXEditChange(Sender: TObject);
    procedure OffsetYEditChange(Sender: TObject);
    procedure ShadowStyleRadioGroupClick(Sender: TObject);
    procedure AlignmentRadioGroupClick(Sender: TObject);
    procedure ShadowDirectionRadioGroupClick(Sender: TObject);
    procedure ShadowColorButtonClick(Sender: TObject);
    procedure FontButtonClick(Sender: TObject);

    procedure FormatComboBoxChange(Sender: TObject);
    procedure ShadowStyleComboBoxChange(Sender: TObject);
  private
    procedure EnableControls;
    procedure DisableControls;
  end;

var
  LabelsForm: TLabelsForm;

implementation

{$R *.DFM}

{ Private routines }

procedure TLabelsForm.EnableControls;
begin
  ShadowDepthLabel.Enabled := True;
  ShadowDepthEdit.Enabled := True;
  ShadowSizeLabel.Enabled := True;
  ShadowSizeEdit.Enabled := True;
  UpLeftRadioButton.Enabled := True;
  UpRadioButton.Enabled := True;
  UpRightRadioButton.Enabled := True;
  LeftRadioButton.Enabled := True;
  RightRadioButton.Enabled := True;
  DownLeftRadioButton.Enabled := True;
  DownRadioButton.Enabled := True;
  DownRightRadioButton.Enabled := True;
  ShadowColorButton.Enabled := True;
end;

procedure TLabelsForm.DisableControls;
begin
  ShadowDepthLabel.Enabled := False;
  ShadowDepthEdit.Enabled := False;
  ShadowSizeLabel.Enabled := False;
  ShadowSizeEdit.Enabled := False;
  UpLeftRadioButton.Enabled := False;
  UpRadioButton.Enabled := False;
  UpRightRadioButton.Enabled := False;
  LeftRadioButton.Enabled := False;
  RightRadioButton.Enabled := False;
  DownLeftRadioButton.Enabled := False;
  DownRadioButton.Enabled := False;
  DownRightRadioButton.Enabled := False;
  ShadowColorButton.Enabled := False;
end;


{ Published routines }

procedure TLabelsForm.FormCreate(Sender: TObject);
begin
  ShadowStyleComboBox.ItemIndex := 1;
end;

procedure TLabelsForm.AngleEditChange(Sender: TObject);
begin
  DemoLabel.Angle := AngleEdit.Value;
end;

procedure TLabelsForm.ShadowSizeEditChange(Sender: TObject);
begin
  DemoLabel.ShadowSize := ShadowSizeEdit.Value;
end;

procedure TLabelsForm.ShadowDepthEditChange(Sender: TObject);
begin
  DemoLabel.ShadowDepth := ShadowDepthEdit.Value;
end;

procedure TLabelsForm.OffsetXEditChange(Sender: TObject);
begin
  DemoLabel.OffsetX := OffsetXEdit.Value;
end;

procedure TLabelsForm.OffsetYEditChange(Sender: TObject);
begin
  DemoLabel.OffsetY := OffsetYEdit.Value;
end;

procedure TLabelsForm.ShadowStyleRadioGroupClick(Sender: TObject);
begin
  if TRadioButton(Sender).TabOrder = 0 then
  begin
    EnableControls;
    DemoLabel.ShadowSize := ShadowSizeEdit.Value;
    DemoLabel.ShadowDepth := ShadowDepthEdit.Value;
  end
  else
  begin
    if TRadioButton(Sender).TabOrder = 1 then
      DemoLabel.ShadowStyle := ssNone
    else
      DemoLabel.ShadowStyle := TShadowStyle(TRadioButton(Sender).TabOrder);
    DisableControls;
  end;
end;

procedure TLabelsForm.AlignmentRadioGroupClick(Sender: TObject);
begin
  case TRadioButton(Sender).TabOrder of
    0 :
      begin
        DemoLabel.Alignment := taLeftJustify;
        DemoLabel.VerticalAlignment := vaTop;
      end;
    1 :
      begin
        DemoLabel.Alignment := taCenter;
        DemoLabel.VerticalAlignment := vaTop;
      end;
    2 :
      begin
        DemoLabel.Alignment := taRightJustify;
        DemoLabel.VerticalAlignment := vaTop;
      end;
    3 :
      begin
        DemoLabel.Alignment := taLeftJustify;
        DemoLabel.VerticalAlignment := vaCenter;
      end;
    4 :
      begin
        DemoLabel.Alignment := taCenter;
        DemoLabel.VerticalAlignment := vaCenter;
      end;
    5 :
      begin
        DemoLabel.Alignment := taRightJustify;
        DemoLabel.VerticalAlignment := vaCenter;
      end;
    6 :
      begin
        DemoLabel.Alignment := taLeftJustify;
        DemoLabel.VerticalAlignment := vaBottom;
      end;
    7 :
      begin
        DemoLabel.Alignment := taCenter;
        DemoLabel.VerticalAlignment := vaBottom;
      end;
    8 :
      begin
        DemoLabel.Alignment := taRightJustify;
        DemoLabel.VerticalAlignment := vaBottom;
      end;
  end;
end;

procedure TLabelsForm.ShadowDirectionRadioGroupClick(Sender: TObject);
begin
  case TRadioButton(Sender).TabOrder of
    0 : DemoLabel.ShadowDirection := drUpLeft;
    1 : DemoLabel.ShadowDirection := drUp;
    2 : DemoLabel.ShadowDirection := drUpRight;
    3 : DemoLabel.ShadowDirection := drLeft;
    4 : DemoLabel.ShadowDirection := drRight;
    5 : DemoLabel.ShadowDirection := drDownLeft;
    6 : DemoLabel.ShadowDirection := drDown;
    7 : DemoLabel.ShadowDirection := drDownRight;
  end;
end;

procedure TLabelsForm.ShadowColorButtonClick(Sender: TObject);
begin
  if ColorDialog.Execute then
    DemoLabel.ShadowColor := ColorDialog.Color;
end;

procedure TLabelsForm.FontButtonClick(Sender: TObject);
begin
  if FontDialog.Execute then
    DemoLabel.Font := FontDialog.Font;
end;

procedure TLabelsForm.FormatComboBoxChange(Sender: TObject);
begin
  ClockLabel.Format := FormatComboBox.Text;
end;

procedure TLabelsForm.ShadowStyleComboBoxChange(Sender: TObject);
begin
  if ShadowStyleComboBox.ItemIndex = 0 then
    ClockLabel.ShadowStyle := ssNone
  else
    ClockLabel.ShadowStyle := TShadowStyle(ShadowStyleComboBox.ItemIndex + 1);
end;

end.
