unit Btns;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ProCtrls, Buttons, Spin;

type
  TButtonsForm = class(TForm)
    DoneButton: TProButton;
    GrpButton: TGroupBox;
    CbxKind: TComboBox;
    LblCustomText: TLabel;
    EdtCustomText: TEdit;
    BtnDemo: TProButton;
    GrpSpeedButton: TGroupBox;
    BtnSpeedDemo: TProSpeedButton;
    EdtInitInterval: TSpinEdit;
    EdtInterval: TSpinEdit;
    LblInitInterval: TLabel;
    LblInterval: TLabel;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CbxKindChange(Sender: TObject);
    procedure EdtCustomTextChange(Sender: TObject);
    procedure EdtInitIntervalChange(Sender: TObject);
    procedure EdtIntervalChange(Sender: TObject);
    procedure BtnSpeedDemoClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ButtonsForm: TButtonsForm;

implementation

{$R *.DFM}


procedure TButtonsForm.FormCreate(Sender: TObject);
begin
  CbxKind.ItemIndex := 0;
end;

procedure TButtonsForm.CbxKindChange(Sender: TObject);
begin
  BtnDemo.Kind := TProButtonKind(CbxKind.ItemIndex);

  LblCustomText.Enabled := BtnDemo.Kind = pbkCustom;
  EdtCustomText.Enabled := BtnDemo.Kind = pbkCustom;
  if BtnDemo.Kind = pbkCustom then
    BtnDemo.Caption := EdtCustomText.Text;
end;

procedure TButtonsForm.EdtCustomTextChange(Sender: TObject);
begin
  BtnDemo.Caption := EdtCustomText.Text;
end;


procedure TButtonsForm.EdtInitIntervalChange(Sender: TObject);
begin
  BtnSpeedDemo.RepeatInitInterval := EdtInitInterval.Value;
end;

procedure TButtonsForm.EdtIntervalChange(Sender: TObject);
begin
  BtnSpeedDemo.RepeatInterval := EdtInterval.Value;
end;

procedure TButtonsForm.BtnSpeedDemoClick(Sender: TObject);
begin
  Beep;
end;


end.
