unit Prntraid;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Printers, ComAbout, DsgnIntf;

type
  TPrinterAid = class(TComponent)
  private
    { Private declarations }
    FDriverVersion: integer;
    FPageWidth, FPageHeight, FHorzPixelsPerInch, FVertPixelsPerInch: integer;
    FColorBits, FColorPlanes, FColors, FColorRes: integer;
    FBrushes, FPens, FMarkers, FFonts: integer;
    FLinePixelWidth, FLinePixelHeight, FLinePixelDiagonal: integer;
    FSystemPalette, FReservedPalette: integer;
    FOutput, FAbout: string;
    FColorMode: Boolean;
  protected
    { Protected declarations }
    procedure SetInteger(Value: integer);
    procedure SetString(Value: string);
    procedure SetBoolean(Value: Boolean);
  public
    { Public declarations }
     constructor Create(AOwner: TComponent); override;
     procedure Refresh;
     procedure DrawBitmap(X, Y: Integer; Picture: TBitmap);
  published
    { Published declarations }
    property DriverVersion: integer read FDriverVersion write FDriverVersion;

    property PageWidth: integer read FPageWidth write SetInteger;
    property PageHeight: integer read FPageHeight write SetInteger;
    property HorzPixelsPerInch: integer read FHorzPixelsPerInch write SetInteger;
    property VertPixelsPerInch: integer read FVertPixelsPerInch write SetInteger;

    property ColorBits: integer read FColorBits write SetInteger;
    property ColorPlanes: integer read FColorPlanes write SetInteger;
    property Colors: integer read FColors write SetInteger;
    property ColorRes: integer read FColorRes write SetInteger;

    property Brushes: integer read FBrushes write SetInteger;
    property Pens: integer read FPens write SetInteger;
    property Markers: integer read FMarkers write SetInteger;
    property Fonts: integer read FFonts write SetInteger;

    property LinePixelWidth: integer read FLinePixelWidth write SetInteger;
    property LinePixelHeight: integer read FLinePixelHeight write SetInteger;
    property LinePixelDiagonal: integer read FLinePixelDiagonal write SetInteger;

    property Output: string read FOutput write SetString;

    property SystemPalette: integer read FSystemPalette write SetInteger;
    property ReservedPalette: integer read FReservedPalette write SetInteger;

    property ColorMode: Boolean read FColorMode write SetBoolean;

    property About: string read FAbout write FAbout;
  end;


    { AboutTypeProperty }

type
  TAboutTypeProperty = class(TPropertyEditor)
  private

  public
     function GetValue: string; override;
     procedure SetValue(const Value: string); override;
     procedure Edit; override;
     function GetAttributes: TPropertyAttributes; override;
  end;

var
   AboutPrinterAid: TAboutComponent;

procedure Register;
procedure RunAboutBox;

implementation

procedure Register;
begin
  RegisterComponents('BealeARTS', [TPrinterAid]);
  RegisterPropertyEditor(TypeInfo(string), TPrinterAid, 'About', TAboutTypeProperty);
end;

constructor TPrinterAid.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  { Set default values }
  Refresh;
end;



procedure TPrinterAid.SetInteger(Value: integer);
begin
end;

procedure TPrinterAid.SetString(Value: string);
begin
end;

procedure TPrinterAid.SetBoolean(Value: Boolean);
begin
end;



procedure TPrinterAid.Refresh;
var
   WorkValue: integer;
begin

FDriverVersion := GetDeviceCaps(Printer.Handle, DRIVERVERSION);

FPageWidth := GetDeviceCaps(Printer.Handle, HORZSIZE);
FPageHeight := GetDeviceCaps(Printer.Handle, VERTSIZE);
FHorzPixelsPerInch := GetDeviceCaps(Printer.Handle, LOGPIXELSX);
FVertPixelsPerInch := GetDeviceCaps(Printer.Handle, LOGPIXELSY);

FColorBits:= GetDeviceCaps(Printer.Handle, BITSPIXEL);
FColorPlanes:= GetDeviceCaps(Printer.Handle, PLANES);
FColors:= GetDeviceCaps(Printer.Handle, NUMCOLORS);
FColorRes:= GetDeviceCaps(Printer.Handle, COLORRES);

FBrushes:= GetDeviceCaps(Printer.Handle, NUMBRUSHES);
FPens:= GetDeviceCaps(Printer.Handle, NUMPENS	);
FMarkers:= GetDeviceCaps(Printer.Handle, NUMMARKERS);
FFonts:= GetDeviceCaps(Printer.Handle, NUMFONTS);

FLinePixelWidth := GetDeviceCaps(Printer.Handle, ASPECTX);
FLinePixelHeight := GetDeviceCaps(Printer.Handle, ASPECTY);
FLinePixelDiagonal := GetDeviceCaps(Printer.Handle, ASPECTXY);

WorkValue := GetDeviceCaps(Printer.Handle, CLIPCAPS);
case WorkValue of
  CP_NONE: FOutput := 'Not Clipped';
  CP_RECTANGLE: FOutput := 'Clipped To Rectangles';
  CP_REGION: FOutput := 'Clipped To Regions';
else
  FOutput := '';
end;

FSystemPalette := GetDeviceCaps(Printer.Handle, SIZEPALETTE);
FReservedPalette := GetDeviceCaps(Printer.Handle, NUMRESERVED);

if FColorPlanes > 1 then
   FColorMode := True
else
   FColorMode := False; 

end;




procedure TPrinterAid.DrawBitmap(X, Y: Integer; Picture: TBitmap);
var
   XPos, YPos: integer;
begin

For YPos := 0 to Picture.Height-1 do
For XPos := 0 to Picture.Width-1 do
    Printer.Canvas.Pixels[XPos+X,YPos+y] := Picture.Canvas.Pixels[XPos,YPos];

end;




procedure RunAboutBox;
begin
 { Create dialog in memory }
     AboutPrinterAid := TAboutComponent.Create(Application);

     { Set dialog strings }
     AboutPrinterAid.ProductName.Caption := 'PrinterAid';
     AboutPrinterAid.Caption := 'About PrinterAid';
     AboutPrinterAid.Copyright.Caption := 'Copyright 1998, David Beale';

AboutPrinterAid.Memo.Lines.Add('Properties');
AboutPrinterAid.Memo.Lines.Add('_______________________________________________');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('About - String');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Displays this about dialog. Performs no function when set from within your code.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Brushes - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of printer-specific brushes.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('ColorBits - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of adjacent color bits for each pixel.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('ColorMode - Boolean');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Ture is printer is in colour mode.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('ColorPlanes - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of color planes.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('ColorRes - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Color resolution of the device, in bits per pixel.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Colors - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of entries in the printer''s color table.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('DriverVersion - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Version number of the printer driver.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Fonts - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of printer-specific fonts.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('HorzPixlesPerInch - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of pixels per logical inch along the printer width.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('LinePixelDiagonal - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Diagonal width of a printer pixel used for line drawing.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('LinePixelHeight - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Relative height of a printer pixel used for line drawing.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('LinePixelWidth - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Relative width of a printer pixel used for line drawing.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Markers - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of printer-specific markers.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Name - String');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Name of this component, ie PrinterAid1.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Output - String');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Output clipping of the printer.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('PageHeight - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Height of the physical page, in millimeters.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('PageWidth - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Width of the physical page, in millimeters.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Pens - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of printer-specific pens.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('ReservedPalette - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of reserved entries in the system palette.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('SystemPalette - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of entries in the system palette.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Tag - LongInt');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Components Tag.');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('VertPixlesPerInch - Integer');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Number of pixels per logical inch along the printer Height.');

AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Events');
AboutPrinterAid.Memo.Lines.Add('_______________________________________________');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');

AboutPrinterAid.Memo.Lines.Add('Methods');
AboutPrinterAid.Memo.Lines.Add('_______________________________________________');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('DrawBitmap - Procedure');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Forces the drawing of a Bitmap. For use then');
AboutPrinterAid.Memo.Lines.Add('the Printer.Canvas.Draw method fails');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Refresh - Procedure');
AboutPrinterAid.Memo.Lines.Add('');
AboutPrinterAid.Memo.Lines.Add('Refreshs the printer infomation');


  { Set result to OK }
    AboutPrinterAid.Icon := Application.Icon;
    AboutPrinterAid.ShowModal;

AboutPrinterAid.Free
end;



function TAboutTypeProperty.GetValue: string;
begin
Result := 'PrinterAid';
end;

procedure TAboutTypeProperty.SetValue(const Value: string);
begin
RunAboutBox;
end;

procedure TAboutTypeProperty.Edit;
begin
RunAboutBox;
end;

function TAboutTypeProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;



end.
