unit Prman_u;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, IniFiles, Menus, DB,
  DBTables, DBCtrls, Mask;

type
  EIniList = class(exception);

  TForm1 = class(TForm)
    Panel1: TPanel;
    BitBtn1: TBitBtn;
    BitBtn3: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    MainMenu1: TMainMenu;
    Konfiguration1: TMenuItem;
    DelphiPfad1: TMenuItem;
    DelphiIniDatei1: TMenuItem;
    OpenDialog1: TOpenDialog;
    Button1: TButton;
    Button3: TButton;
    Table1: TTable;
    DataSource1: TDataSource;
    thename: TDBEdit;
    dcl: TDBEdit;
    dclpfad: TDBEdit;
    dpr: TDBEdit;
    DBNavigator1: TDBNavigator;
    DBMemo1: TDBMemo;
    Label3: TLabel;
    Version: TDBRadioGroup;
    Delphi101: TMenuItem;
    Delphi102: TMenuItem;
    Inifile1: TMenuItem;
    Path1: TMenuItem;
    Import1: TMenuItem;
    Version101: TMenuItem;
    Table2: TTable;
    OpenDialog2: TOpenDialog;
    procedure FormCreate(Sender: TObject);
    procedure DelphiPfad1Click(Sender: TObject);
    procedure DelphiIniDatei1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Path1Click(Sender: TObject);
    procedure Inifile1Click(Sender: TObject);
    procedure Version101Click(Sender: TObject);
  private
    { Private-Deklarationen }
    DelphiExe:String;
    DelphiINI:String;
    Delphi32Exe:String;
    Delphi32INI:String;
    procedure OpenDelphi1;
    procedure OpenDelphi2;
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.FormCreate(Sender: TObject);
var TheIniFile:TIniFile;
begin
  table1.tablename:=extractfilepath(paramstr(0))+'prmanag.db';
  table1.active:=true;
  TheIniFile:=TIniFile.Create(extractfilepath(paramstr(0))+'prmanag.ini');
  delphiexe:=theInifile.readstring('Konfiguration','DelphiEXE','');
  delphiINI:=theInifile.readstring('Konfiguration','DelphiINI','');
  delphi32exe:=theInifile.readstring('Konfiguration','Delphi32EXE','');
  delphi32INI:=theInifile.readstring('Konfiguration','Delphi32INI','');
  TheIniFile.free;
end;

procedure TForm1.DelphiPfad1Click(Sender: TObject);
var TheIniFile:TIniFile;
begin
  if delphiEXE<>'' then
    opendialog1.filename:=delphiexe;
  opendialog1.filterindex:=1;
  if opendialog1.execute then
  begin
    delphiexe:=opendialog1.fileName;
    TheIniFile:=TIniFile.Create(extractfilepath(paramstr(0))+'prmanag.ini');
    theInifile.writestring('Konfiguration','DelphiEXE',delphiexe);
    TheIniFile.Free;
  end;
end;

procedure TForm1.DelphiIniDatei1Click(Sender: TObject);
var TheIniFile:TIniFile;
begin
  if delphiINI<>'' then
    opendialog1.filename:=delphiINI;
  opendialog1.filterindex:=2;
  if opendialog1.execute then
  begin
    delphiINI:=opendialog1.fileName;
    TheIniFile:=TIniFile.Create(extractfilepath(paramstr(0))+'prmanag.ini');
    theInifile.writestring('Konfiguration','DelphiINI',delphiINI);
    TheIniFile.Free;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  opendialog1.filterindex:=4;
  opendialog1.fileName:='';
  if opendialog1.execute then
  begin
    table1.edit;
    dpr.text:=opendialog1.fileName;
    table1.post;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  opendialog1.filterindex:=3;
  opendialog1.fileName:='';
  if opendialog1.execute then
  begin
    table1.edit;
    dcl.text:=opendialog1.fileName;
    table1.post;
  end;
end;

procedure TForm1.Opendelphi2;
var delphiIniFile:TIniFile;
    pdelphiexe:array[0..256] of char;

  function MakeRegCompatible(aString:String):String;
  var a:integer;
  begin
    result:='';
    for a:=1 to length(astring) do
    begin
      result:=result+astring[a];
      if astring[a]='\' then
        result:=result+'\';
    end;
    result:='"'+result+'"';
  end;

begin
  if fileexists(delphi32Ini) and fileexists(delphi32exe) then
  begin
    delphiIniFile:=TIniFile.Create(delphi32Ini);
    delphiIniFile.WriteString('HKEY_CURRENT_USER\Software\Borland\Delphi\2.0\Library','"SearchPath"',
      makeRegCompatible(dclpfad.text));
    delphiIniFile.WriteString('HKEY_CURRENT_USER\Software\Borland\Delphi\2.0\Library','"ComponentLibrary"',
      makeRegCompatible(dcl.text));
    delphiIniFile.WriteString('HKEY_CURRENT_USER\Software\Borland\Delphi\2.0\Session','"Project"',
      makeRegCompatible(dpr.text));
    strpcopy(pdelphiexe,'regedit.exe /s '+delphi32ini);
    winexec(pdelphiexe,sw_show);
    strpcopy(pdelphiexe,delphi32exe);
    winexec(pdelphiexe,sw_show);
    delphiIniFile.Free;
  end
  else
    messagedlg('Please check the settings for correct filenames!',mterror,[mbok],0);
end;

procedure TForm1.OpenDelphi1;
var delphiIniFile:TIniFile;
    pdelphiexe:array[0..256] of char;
begin
  if fileexists(delphiINI) and fileexists(delphiexe) then
  begin
    delphiIniFile:=TIniFile.Create(delphiIni);
    delphiIniFile.WriteString('Library','SearchPath',dclpfad.text);
    delphiIniFile.WriteString('Library','ComponentLibrary',dcl.text);
    delphiIniFile.WriteString('Session','Project',dpr.text);
    strpcopy(pdelphiexe,delphiexe);
    winexec(pdelphiexe,sw_show);
    delphiIniFile.Free;
  end
  else
    messagedlg('Please check the settings for correct filenames!',mterror,[mbok],0);
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
  if version.value='Delphi 1.0' then
    opendelphi1
  else
  if version.value='Delphi 2.0' then
    opendelphi2;
end;

procedure TForm1.Path1Click(Sender: TObject);
var TheIniFile:TIniFile;
begin
  if delphi32EXE<>'' then
    opendialog1.filename:=delphi32exe;
  opendialog1.filterindex:=1;
  if opendialog1.execute then
  begin
    delphi32exe:=opendialog1.fileName;
    TheIniFile:=TIniFile.Create(extractfilepath(paramstr(0))+'prmanag.ini');
    theInifile.writestring('Konfiguration','Delphi32EXE',delphi32exe);
    TheIniFile.Free;
  end;
end;

procedure TForm1.Inifile1Click(Sender: TObject);
var TheIniFile:TIniFile;
begin
  if delphi32INI<>'' then
    opendialog1.filename:=delphi32INI;
  opendialog1.filterindex:=6;
  if opendialog1.execute then
  begin
    delphi32INI:=opendialog1.fileName;
    TheIniFile:=TIniFile.Create(extractfilepath(paramstr(0))+'prmanag.ini');
    theInifile.writestring('Konfiguration','Delphi32INI',delphi32INI);
    TheIniFile.Free;
  end;
end;

procedure TForm1.Version101Click(Sender: TObject);
begin
  if opendialog2.execute then
    if fileexists(opendialog2.filename) then
    begin
      table2.tablename:=opendialog2.filename;
      table2.active:=true;
      table2.first;
      while not table2.eof do
      begin
        table1.appendrecord([table2.fields[0].asstring,nil,table2.fields[2].asstring,
          table2.fields[3].asstring,table2.fields[4].asstring, 'Delphi 1.0']);
        table1.edit;
        tmemofield(table1.fields[1]).assign(tmemofield(table2.fields[1]));
        table1.post;
        table2.next;
      end;
      table2.close;
      table1.first;
    end;
end;

end.
