unit wEshippr;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Tabs, StdCtrls, Buttons, ExtCtrls, Mask, DBFserver;

type
	oShippr=Class(TObject)
	Private
		aShippr:oDB;
	Public
		{ variable declarations }
		FromRecNo:longint;
		Locked:boolean;

		job_no,ship_via,cust_bill,cust_ship:String[10];
		shipper_no:String[20];
		odd_note:String[60];
    invless:string[20];
		plines:pchar;
    tlines:tstringlist;
		seq_no,qty,sreq_no,odd_qty,odd_uprice,odd_amount:Double;
		freight,tax_amount,amount,invcomp,invmat,invpart:Double;
		ship_date,post_date,dayposted,inv_date:Longint;
		fromcal,complete,resale,oktopost,jc_posted,ar_posted:Boolean;
		proofed,printed,invprinted,fvoid:Boolean;
		procedure Init(aDBvar:oDB);
		function  Load(WithLock:Boolean):boolean;
		procedure Save;
	end;
  oShipreq=Class(TObject)
  Private
    aShipreq:oDB;
  Public
    { variable declarations }
    FromRecNo:longint;
    Locked:boolean;

    job_no,type1,type2,type3:String[10];
    shipper_no:String[20];
    tline_com:String[30];
    com1,com2,com3,com4:String[40];
    qty,qty1,qty2,qty3,totqty:Double;
    seq_no,cnt1,cnt2,cnt3,skids:double;
    ship_date:Longint;
    complete,processed,call_cust,truck_line,fvoid:Boolean;
    procedure Init(aDBvar:oDB);
    function  Load(WithLock:Boolean):Boolean;
    procedure Save;
  end;
  TwShippers = class(TForm)
    Notebook1: TNotebook;
    TabSet1: TTabSet;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit9: TEdit;
    Label12: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    Button1: TButton;
    MaskEdit1: TMaskEdit;
    Label13: TLabel;
    Edit8: TEdit;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    ListBox1: TListBox;
    Button2: TButton;
    Label21: TLabel;
    Edit10: TEdit;
    Edit11: TEdit;
    Edit12: TEdit;
    Label22: TLabel;
    Button3: TButton;
    Label23: TLabel;
    Edit13: TEdit;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;
    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Edit14: TEdit;
    Edit15: TEdit;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    MaskEdit2: TMaskEdit;
    Label37: TLabel;
    Label39: TLabel;
    Edit21: TEdit;
    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Edit22: TEdit;
    Edit23: TEdit;
    Edit24: TEdit;
    Edit25: TEdit;
    Button4: TButton;
    Button5: TButton;
    Button6: TButton;
    Panel1: TPanel;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    MaskEdit3: TMaskEdit;
    Button7: TButton;
    ListBox2: TListBox;
    Label47: TLabel;
    Edit26: TEdit;
    Label48: TLabel;
    Label49: TLabel;
    Label50: TLabel;
    MaskEdit4: TMaskEdit;
    Button8: TButton;
    Label51: TLabel;
    Label52: TLabel;
    RadioGroup1: TRadioGroup;
    Label53: TLabel;
    Edit27: TEdit;
    Button9: TButton;
    Panel2: TPanel;
    CheckBox6: TCheckBox;
    CheckBox9: TCheckBox;
    CheckBox10: TCheckBox;
    CheckBox11: TCheckBox;
    Button10: TButton;
    Edit28: TEdit;
    Edit29: TEdit;
    Label54: TLabel;
    Edit30: TEdit;
    Label55: TLabel;
    Edit31: TEdit;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;
    Label60: TLabel;
    Edit32: TEdit;
    Edit33: TEdit;
    Edit34: TEdit;
    Edit35: TEdit;
    Edit36: TEdit;
    ListBox3: TListBox;
    Edit37: TEdit;
    Edit38: TEdit;
    Edit39: TEdit;
    Edit40: TEdit;
    Button11: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label8: TLabel;
    Label38: TLabel;
    Label61: TLabel;
    Memo1: TMemo;
    procedure TabSet1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit13KeyPress(Sender: TObject; var Key: Char);
    procedure MaskEdit1KeyPress(Sender: TObject; var Key: Char);
    procedure MaskEdit1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit2KeyPress(Sender: TObject; var Key: Char);
    procedure Edit2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit37KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit37KeyPress(Sender: TObject; var Key: Char);
    procedure Edit5KeyPress(Sender: TObject; var Key: Char);
    procedure Edit5KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit3KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit3KeyPress(Sender: TObject; var Key: Char);
    procedure Edit38KeyPress(Sender: TObject; var Key: Char);
    procedure Edit38KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit6KeyPress(Sender: TObject; var Key: Char);
    procedure Edit6KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit4KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit4KeyPress(Sender: TObject; var Key: Char);
    procedure Edit39KeyPress(Sender: TObject; var Key: Char);
    procedure Edit39KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit7KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit7KeyPress(Sender: TObject; var Key: Char);
    procedure Edit8KeyPress(Sender: TObject; var Key: Char);
    procedure Edit8KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit9KeyPress(Sender: TObject; var Key: Char);
    procedure Edit9KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CheckBox1KeyPress(Sender: TObject; var Key: Char);
    procedure Edit10KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit10KeyPress(Sender: TObject; var Key: Char);
    procedure Edit11KeyPress(Sender: TObject; var Key: Char);
    procedure Edit11KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit12KeyPress(Sender: TObject; var Key: Char);
    procedure Edit12KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CheckBox1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Button1Click(Sender: TObject);
    procedure CheckBox4KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CheckBox4KeyPress(Sender: TObject; var Key: Char);
    procedure MaskEdit2KeyPress(Sender: TObject; var Key: Char);
    procedure MaskEdit2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit21KeyPress(Sender: TObject; var Key: Char);
    procedure Edit21KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CheckBox5KeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox5KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit15KeyPress(Sender: TObject; var Key: Char);
    procedure Edit15KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit22KeyPress(Sender: TObject; var Key: Char);
    procedure Edit22KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit24KeyPress(Sender: TObject; var Key: Char);
    procedure Edit24KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit23KeyPress(Sender: TObject; var Key: Char);
    procedure Edit23KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit25KeyPress(Sender: TObject; var Key: Char);
    procedure Edit25KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Edit8Enter(Sender: TObject);
    procedure Edit37Exit(Sender: TObject);
    procedure Edit38Exit(Sender: TObject);
    procedure Edit39Exit(Sender: TObject);
    procedure Edit9Exit(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: Char);
    procedure BitBtn2Click(Sender: TObject);
    procedure Edit14KeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
		control,inventor,cust,parts,jobs,shippr,shipreq:oDB;
		srec:oShippr;
		reqrec:oShipreq;
		pShipList:Tstringlist;
		procedure ReqToWin;
		procedure WinToReq;
		procedure ShipToWin;
		procedure WinToShip;
		procedure ReCalc;
		procedure ShowShip;
    procedure doShipSave;
		procedure ShowShipTo;
		function  settype(cqty:double;tstart:string):string;
		procedure pshipreq(proclist:tstringlist);
  public
    { Public declarations }
  end;

var
  wShippers: TwShippers;

implementation

{$R *.DFM}

Uses CommonCode, wPreview;

procedure TwShippers.TabSet1Click(Sender: TObject);
begin
  notebook1.pageindex:=tabset1.tabindex;
end;

procedure TwShippers.ReCalc;
var tot,sub:double;
begin
  tot:=0;
  sub:=procdbl(edit2.text)*procdbl(edit5.text);
	tot:=tot+sub;
	label18.caption:=strd(sub,0);
  sub:=procdbl(edit3.text)*procdbl(edit6.text);
	tot:=tot+sub;
	label19.caption:=strd(sub,0);
  sub:=procdbl(edit4.text)*procdbl(edit7.text);
	tot:=tot+sub;
	label20.caption:=strd(sub,0);
	label11.caption:=strd(tot,0);
end;

procedure TwShippers.FormCreate(Sender: TObject);
begin
  top:=0;
  width:=620;
  height:=413;
  left:=0;
	centerhoriz(self);
	Gen.AddWin('Shippers',self);
  tabset1.tabs:=notebook1.pages;
	control:=nil;
	inventor:=nil;
	cust:=nil;
	parts:=nil;
	jobs:=nil;
	shippr:=nil;
	shipreq:=nil;
	pShipList:=tstringlist.create;
	pShipList.clear;
	srec:=oShippr.create;
	reqrec:=oShipreq.create;
	reqrec.init(nil);
  reqtowin;
	srec.plines:=stralloc(MaxMemoSize);
  srec.tlines:=tstringlist.create;
  strpcopy(srec.plines,'');
	srec.init(nil);
  shiptowin;
  if Not pin(Gen.User,'DIANNE JEFF BRAD SONIA ') then begin
    button2.enabled:=false;
    button3.enabled:=false;
  End;
	{ must have access, would fail if someone is trying to "purge" old info }
  if dbUse(shippr,compath('shippr')) then begin
		if dbUse(shipreq,jcpath('shipreq')) then begin
      shippr.setorder(2);
			dbUse(control,jcpath('control'));
			dbUse(inventor,jcpath('inventor'));
			dbUse(cust,compath('cust'));
			dbUse(parts,compath('parts'));
			dbUse(jobs,compath('jobs'));
			jobs.SetRelation(parts.area,'part_no');
			reqrec.init(shipreq);
			srec.init(shippr);
		end else begin
		  OKbox('Shipper Requests Unavailable - Try Again Later');
			close;
		end;
	end else begin
		OKbox('Shippers Unavailable - Try Again Later');
		close;
  End;
end;

procedure TwShippers.CheckBox7Click(Sender: TObject);
begin
  checkbox8.checked:=not checkbox7.checked;
end;

procedure TwShippers.CheckBox8Click(Sender: TObject);
begin
  checkbox7.checked:=not checkbox8.checked;
end;

procedure TwShippers.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  dbClose(shippr);
	dbClose(shipreq);
	dbClose(control);
	dbClose(inventor);
	dbClose(cust);
	dbClose(parts);
	dbClose(jobs);
  strdispose(srec.plines);
  srec.tlines.free;
  srec.free;
  reqrec.free;
	pShipList.free;
	Gen.ReleaseWin(self);
  action:=caFree;
end;

procedure oShippr.Init(aDBvar:oDB);
var ii:integer;
begin
  { init vars }
  if dbIsOpen(aDBvar) then aShippr:=aDBvar;
  FromRecno:=0;
  Locked:=false;
  job_no:='';
  ship_via:='';
  cust_bill:='';
  cust_ship:='';
  shipper_no:='';
  odd_note:='';
  strpcopy(plines,'');
  tlines.clear;
  seq_no:=0;
  qty:=0;
  sreq_no:=0;
  odd_qty:=0;
  odd_uprice:=0;
  odd_amount:=0;
  freight:=0;
  tax_amount:=0;
  amount:=0;
  ship_date:=0;
  post_date:=0;
  dayposted:=0;
  inv_date:=0;
  fromcal:=false;
  complete:=false;
  resale:=false;
  oktopost:=false;
  jc_posted:=false;
  ar_posted:=false;
  proofed:=false;
  printed:=false;
  invprinted:=false;
  fvoid:=false;
  invcomp:=0;
  invmat:=0;
  invpart:=0;
  invless:='';
end;

function oShippr.Load(WithLock:Boolean):Boolean;
begin
  Init(Nil);
  Result:=true;
  Locked:=false;
  FromRecNo:=aShippr.RecNo;
  if WithLock then begin
    Result:=aShippr.aLock;
    if not Result then Exit else Locked:=true;
  end;
  { set vars from fields }
  job_no:=aShippr.s('job_no');
  ship_via:=aShippr.st('ship_via');
  cust_bill:=aShippr.st('cust_bill');
  cust_ship:=aShippr.st('cust_ship');
  shipper_no:=aShippr.st('shipper_no');
  odd_note:=aShippr.st('odd_note');
  seq_no:=aShippr.f('seq_no');
  qty:=aShippr.f('qty');
  sreq_no:=aShippr.f('sreq_no');
  odd_qty:=aShippr.f('odd_qty');
  odd_uprice:=aShippr.f('odd_uprice');
  odd_amount:=aShippr.f('odd_amount');
  freight:=aShippr.f('freight');
  tax_amount:=aShippr.f('tax_amount');
  amount:=aShippr.f('amount');
  ship_date:=aShippr.d('ship_date');
  post_date:=aShippr.d('post_date');
  dayposted:=aShippr.d('dayposted');
  inv_date:=aShippr.d('inv_date');
  fromcal:=aShippr.b('fromcal');
  complete:=aShippr.b('complete');
  resale:=aShippr.b('resale');
  oktopost:=aShippr.b('oktopost');
  aShippr.longs('lines',plines);
  longsplit(plines,'^',tlines);
  jc_posted:=aShippr.b('jc_posted');
  ar_posted:=aShippr.b('ar_posted');
  proofed:=aShippr.b('proofed');
  printed:=aShippr.b('printed');
  invprinted:=aShippr.b('invprinted');
  fvoid:=aShippr.b('fvoid');
end;

procedure oShippr.Save;
begin
  if not Locked then begin
    OKbox(aShippr.Alias+' Error: Tried to save to a non-locked record');
    Exit;
  end;
  if FromRecNo>0 then aShippr.Go(FromRecNo);
  { set fields from vars }
  aShippr.ss('job_no',job_no);
  aShippr.ss('ship_via',ship_via);
  aShippr.ss('cust_bill',cust_bill);
  aShippr.ss('cust_ship',cust_ship);
  aShippr.ss('shipper_no',shipper_no);
  aShippr.ss('odd_note',odd_note);
  longunsplit(plines,'^',tlines);
  aShippr.longss('lines',plines);
  aShippr.ff('seq_no',seq_no);
  aShippr.ff('qty',qty);
  aShippr.ff('sreq_no',sreq_no);
  aShippr.ff('odd_qty',odd_qty);
  aShippr.ff('odd_uprice',odd_uprice);
  aShippr.ff('odd_amount',odd_amount);
  aShippr.ff('freight',freight);
  aShippr.ff('tax_amount',tax_amount);
  aShippr.ff('amount',amount);
  aShippr.dd('ship_date',ship_date);
  aShippr.dd('post_date',post_date);
  aShippr.dd('dayposted',dayposted);
  aShippr.dd('inv_date',inv_date);
  aShippr.bb('fromcal',fromcal);
  aShippr.bb('complete',complete);
  aShippr.bb('resale',resale);
  aShippr.bb('oktopost',oktopost);
  aShippr.bb('jc_posted',jc_posted);
  aShippr.bb('ar_posted',ar_posted);
  aShippr.bb('proofed',proofed);
  aShippr.bb('printed',printed);
  aShippr.bb('invprinted',invprinted);
  aShippr.bb('fvoid',fvoid);
  Locked:=false;
  aShippr.Unlock;
end;

procedure oShipreq.Init(aDBvar:oDB);
begin
  { init vars }
  if dbIsOpen(aDBvar) then aShipreq:=aDBvar;
  FromRecno:=0;
  Locked:=false;
  job_no:='';
  type1:='';
  type2:='';
  type3:='';
  shipper_no:='';
  tline_com:='';
  com1:='';
  com2:='';
  com3:='';
  com4:='';
  qty:=0;
  qty1:=0;
  qty2:=0;
  qty3:=0;
  totqty:=0;
  seq_no:=0;
  cnt1:=0;
  cnt2:=0;
  cnt3:=0;
  skids:=0;
  ship_date:=0;
  complete:=false;
  processed:=false;
  call_cust:=false;
  truck_line:=false;
  fvoid:=false;
end;

function oShipreq.Load(WithLock:Boolean):boolean;
begin
  Init(nil);
  Result:=true;
  Locked:=false;
  FromRecNo:=aShipreq.RecNo;
  if WithLock then begin
    Result:=aShipreq.aLock;
    if not Result then Exit else Locked:=true;
  end;
  { set vars from fields }
  job_no:=aShipreq.s('job_no');
  type1:=aShipreq.st('type1');
  type2:=aShipreq.st('type2');
  type3:=aShipreq.st('type3');
  shipper_no:=aShipreq.st('shipper_no');
  tline_com:=aShipreq.st('tline_com');
  com1:=aShipreq.st('com1');
  com2:=aShipreq.st('com2');
  com3:=aShipreq.st('com3');
  com4:=aShipreq.st('com4');
  qty:=aShipreq.f('qty');
  qty1:=aShipreq.f('qty1');
  qty2:=aShipreq.f('qty2');
  qty3:=aShipreq.f('qty3');
  totqty:=aShipreq.f('totqty');
  seq_no:=aShipreq.f('seq_no');
  cnt1:=aShipreq.f('cnt1');
  cnt2:=aShipreq.f('cnt2');
  cnt3:=aShipreq.f('cnt3');
  skids:=aShipreq.f('skids');
  ship_date:=aShipreq.d('ship_date');
  complete:=aShipreq.b('complete');
  processed:=aShipreq.b('processed');
  call_cust:=aShipreq.b('call_cust');
  truck_line:=aShipreq.b('truck_line');
  fvoid:=aShipreq.b('fvoid');
end;

procedure oShipreq.Save;
begin
  if not Locked then begin
    OKbox(aShipreq.Alias+' Error: Tried to save to a non-locked record');
    Exit;
  end;
  if FromRecNo>0 then aShipreq.Go(FromRecNo);
  { set fields from vars }
  aShipreq.ss('job_no',job_no);
  aShipreq.ss('type1',type1);
  aShipreq.ss('type2',type2);
  aShipreq.ss('type3',type3);
  aShipreq.ss('shipper_no',shipper_no);
  aShipreq.ss('tline_com',tline_com);
  aShipreq.ss('com1',com1);
  aShipreq.ss('com2',com2);
  aShipreq.ss('com3',com3);
  aShipreq.ss('com4',com4);
  aShipreq.ff('qty',qty);
  aShipreq.ff('qty1',qty1);
  aShipreq.ff('qty2',qty2);
  aShipreq.ff('qty3',qty3);
  aShipreq.ff('totqty',totqty);
  aShipreq.ff('seq_no',seq_no);
  aShipreq.ff('cnt1',cnt1);
  aShipreq.ff('cnt2',cnt2);
  aShipreq.ff('cnt3',cnt3);
  aShipreq.ff('skids',skids);
  aShipreq.dd('ship_date',ship_date);
  aShipreq.bb('complete',complete);
  aShipreq.bb('processed',processed);
  aShipreq.bb('call_cust',call_cust);
  aShipreq.bb('truck_line',truck_line);
  aShipreq.bb('fvoid',fvoid);
  Locked:=false;
  aShipreq.Unlock;
end;


procedure TwShippers.ShowShip;
begin
  label14.caption:='';
  label15.caption:='';
  label16.caption:='';
  label17.caption:='';
  if not empty(edit9.text) then begin
		if cust.seek(edit9.text+' ') then begin
		  label14.caption:=cust.st('name');
		  label15.caption:=cust.st('address_1');
		  label16.caption:=cust.st('address_2');
		  label17.caption:=cust.st('address_3');
		end;
  end;
end;

procedure TwShippers.ReqToWin;
var tt,tshipno:string;
begin
	with reqrec do begin
    tt:='';
    tshipno:='';
    if not empty(shipper_no) and jobs.seek(cutjobno(shipper_no)) then begin
      if cust.seek(jobs.s('cust_no')) then
        label12.caption:=cust.st('name')+' ('+cust.st('cust_no')+')'
      else label12.caption:='';
      tt:='P/N '+jobs.s('part_no');
      if not empty(jobs.s('rev_no')) then
        tt:=tt+' "'+jobs.st('rev_no')+'"';
      if parts.seek(jobs.s('part_no')) then
        tt:=tt+' '+parts.st('name');
      tshipno:=jobs.s('cust_no');
      if not empty(jobs.s('ship_no')) then tshipno:=jobs.s('ship_no');
    end;
    maskedit1.text:=dtoc(ship_date);
    label2.caption:=tt;
    edit9.text:=trim(tshipno);
    ShowShip;
    edit2.text:=strd(cnt1,0);
    edit3.text:=strd(cnt2,0);
    edit4.text:=strd(cnt3,0);
    edit37.text:=type1;
    edit38.text:=type2;
    edit39.text:=type3;
    edit5.text:=strd(qty1,0);
    edit6.text:=strd(qty2,0);
    edit7.text:=strd(qty3,0);
    edit8.text:=strd(skids,0);
    edit10.text:=com1;
    edit11.text:=com2;
    edit12.text:=com3;
    checkbox1.checked:=complete;
    checkbox2.checked:=call_cust;
    checkbox3.checked:=truck_line;
    edit40.text:=tline_com;
    ReCalc;
  end;
end;

procedure TwShippers.ShipToWin;
var tbillno,tshipno:string;
    ii:integer;
begin
  label25.caption:='';
  label26.caption:='';
  label27.caption:='';
  label33.caption:='';
  label29.caption:='';
  label30.caption:='';
  label31.caption:='';
  label32.caption:='';
  edit14.text:='';
  tbillno:='';
  tshipno:='';
  label34.caption:='';
  edit22.text:='';
  edit23.text:='';
  edit24.text:='';
  edit25.text:='';
  label39.caption:='';
  with srec do begin
	  if not empty(shipper_no) then begin
      if jobs.seek(cutjobno(shipper_no)) then begin
        if empty(jobs.s('bill_to')) then tbillno:=jobs.s('cust_no')
        else tbillno:=jobs.s('bill_to');
        cust.seek(tbillno);
        label25.caption:=cust.s('name');
        label26.caption:=cust.s('address_1');
        label27.caption:=cust.s('address_2');
        label33.caption:=cust.s('address_3');
        if empty(jobs.s('ship_no')) then tshipno:=jobs.s('cust_no')
        else tshipno:=jobs.s('ship_no');
        edit14.text:=tshipno;
        ShowShipTo;
        label34.caption:='P.O. '+jobs.st('po_no');
        invcomp:=jobs.f('complete');
        invpart:=jobs.f('partial');
        invmat:=jobs.f('material');
        invless:=jobs.st('less');
        edit22.text:=strd(invcomp,0);
        edit23.text:=strd(invpart,0);
        edit24.text:=strd(invmat,0);
        edit25.text:=invless;
        if gen.canseeprice then begin
	        label39.caption:='@ '+
		      ltrim(transform(jobs.f('unit_price'),'99,999,999.9999'))+
          +' = $'+ltrim(transform(jobs.f('unit_price')*procdbl(edit15.text),
          '99,999.99'));
        end;
       end else begin
        OKbox('Job Not Found');
        edit13.setfocus;
      end;
    end;
    checkbox4.checked:=complete;
    maskedit2.text:=dtoc(ship_date);
    edit21.text:=ship_via;
    checkbox5.checked:=not resale;
    edit15.text:=ltrim(transform(qty,'99,999,999'));
    longsplit(plines,'^',srec.tlines);
    memo1.clear;
    memo1.lines.assign(srec.tlines);
 end;
end;

procedure TwShippers.WinToShip;
var dd,ee,ff:double;
		ii:integer;
begin
  with srec do begin
    complete:=checkbox4.checked;
    ship_date:=ctod(maskedit2.text);
    ship_via:=edit21.text;
    resale:=not checkbox5.checked;
    qty:=procdbl(edit15.text);
    tlines.assign(memo1.lines);
    longunsplit(plines,'^',tlines);
    dd:=procdbl(edit22.text);
    ee:=procdbl(edit23.text);
    ff:=procdbl(edit24.text);
    if not numsequal(dd,jobs.f('complete')) or
     	  not numsequal(dd,jobs.f('partial')) or
        not numsequal(dd,jobs.f('material')) or
      	(edit25.text<>jobs.st('less')) then begin
      if jobs.seek(cutjobno(shipper_no)) and jobs.alock then begin
		    jobs.ff('complete',procdbl(edit22.text));
  		  jobs.ff('partial',procdbl(edit23.text));
    		jobs.ff('material',procdbl(edit24.text));
				jobs.ss('less',edit25.text);
      end else OKBox('Job In Use - Unable to save inventory changes');
    end;
    save;
  end;
end;

procedure TwShippers.WinToReq;
var tshipno:string;
begin
  with reqrec do begin
    tshipno:=padr(edit9.text,6);
    if jobs.seek(trim(job_no)+' ') then begin
      if tshipno<>jobs.s('ship_no') then begin
        if jobs.alock then begin
          jobs.ss('ship_no',tshipno);
          jobs.unlock;
        end else OKBox('Unable to change Ship To number in Job Setup');
      end;
    end;
  	ship_date:=ctod(maskedit1.text);
    cnt1:=procdbl(edit2.text);
    cnt2:=procdbl(edit3.text);
    cnt3:=procdbl(edit4.text);
    type1:=edit37.text;
    type2:=edit38.text;
    type3:=edit39.text;
    qty1:=procdbl(edit5.text);
    qty2:=procdbl(edit6.text);
    qty3:=procdbl(edit7.text);
    skids:=procdbl(edit8.text);
    com1:=edit10.text;
    com2:=edit11.text;
    com3:=edit12.text;
    complete:=checkbox1.checked;
    call_cust:=checkbox2.checked;
    truck_line:=checkbox3.checked;
    tline_com:=edit40.text;
  end;
end;

procedure TwShippers.Edit1KeyPress(Sender: TObject; var Key: Char);
var ii:integer;
    jj:double;
    p2:string;
begin
  if getret(key) then begin
    if not empty(edit1.text) then begin
      if gen.AtPDS then begin { check for valid shipper no }
        ii:=pos('-',edit1.text);
        jj:=0;
        if ii>1 then begin
          p2:=copy(edit1.text,ii+1,2);
          jj:=procdbl(p2);
        end;
        if (jj<1) or (jj>100) then begin
          OKbox('Shipper Must Have A Valid Lot Code');
          edit1.setfocus;
          exit;
        end;
      end;
      if shipreq.seek(edit1.text) then begin
	      if reqrec.load(true) then begin
				  { change an existing entry }
          edit1.enabled:=false;
          button11.enabled:=true;
          button1.enabled:=true;
          reqtowin;
          maskedit1.setfocus;
        end else begin
          OKbox('Unable to lock Shipper Request');
        end;
			end else begin
				p2:=' ';
				ii:=pos('-',edit1.text);
				if ii>1 then begin
					p2:=trim(Copy(edit1.text,ii+1,10));
				End;
				jj:=ProcDbl(p2);
				if (Not ((jj>0) And (jj<100))) And (Gen.AtPDS) then begin
					OKbox('All Shipments Must Have A Lot Code');
          edit1.setfocus;
          exit;
				End;
        if not jobs.seek(cutjobno(edit1.text)) then begin
					OKbox('Job Not Found');
          edit1.setfocus;
          exit;
        end;
				edit1.enabled:=false;
        button11.enabled:=true;
        button1.enabled:=true;
				shipreq.append;
				reqrec.locked:=true;  { set status }
				shipreq.ss('shipper_no',edit1.text);
				shipreq.ss('job_no',cutjobno(edit1.text));
	      reqrec.load(false);  { already locked }
				reqtowin;
				maskedit1.setfocus;
      end;
    end;
  end;
end;

procedure TwShippers.Edit13KeyPress(Sender: TObject; var Key: Char);
begin
  if getret(key) then begin
    if not empty(edit13.text) then begin
      shippr.setorder(2);
      if shippr.seek(edit13.text) then begin
	      if srec.load(true) then begin
          shiptowin;
          edit13.enabled:=false;
          button4.enabled:=true;
          bitbtn2.enabled:=true;
          bitbtn1.enabled:=true;
          checkbox4.setfocus;
        end else begin
          OKbox('Unable to lock Shipper');
          edit1.setfocus;
        end;
      end;
    end;
  end;
end;

procedure TwShippers.doShipSave;
begin
  wintoship;
end;

procedure TwShippers.MaskEdit1KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.MaskEdit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getdown(key) then edit2.setfocus;
end;

procedure TwShippers.Edit2KeyPress(Sender: TObject; var Key: Char);
begin
	getret(key);
end;

procedure TwShippers.Edit2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit37KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	getmove(key,self);
end;

procedure TwShippers.Edit37KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit5KeyPress(Sender: TObject; var Key: Char);
begin
  if getret(key) then ReCalc;
end;

procedure TwShippers.Edit5KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
	getmove(key,self);
end;

procedure TwShippers.Edit3KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getup(key) then edit5.setfocus;
  if getdown(key) then edit38.setfocus;
end;

procedure TwShippers.Edit3KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit38KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit38KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit6KeyPress(Sender: TObject; var Key: Char);
begin
  if getret(key) then ReCalc;
end;

procedure TwShippers.Edit6KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getup(key) then edit38.setfocus;
  if getdown(key) then edit4.setfocus;
end;

procedure TwShippers.Edit4KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getup(key) then edit6.setfocus;
  if getdown(key) then edit39.setfocus;
end;

procedure TwShippers.Edit4KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit39KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit39KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit7KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getup(key) then edit39.setfocus;
  if getdown(key) then edit8.setfocus;
end;

procedure TwShippers.Edit7KeyPress(Sender: TObject; var Key: Char);
begin
  if getret(key) then ReCalc;
end;

procedure TwShippers.Edit8KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit8KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit9KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit9KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getup(key) then maskedit1.setfocus;
  if getdown(key) then edit2.setfocus;
end;

procedure TwShippers.CheckBox1KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit10KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getdown(key) then edit11.setfocus;
end;

procedure TwShippers.Edit10KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit11KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit11KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit12KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit12KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.CheckBox1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Button1Click(Sender: TObject);
begin
  wintoreq;
  reqrec.save;
  reqrec.init(nil);
  reqtowin;
  edit1.enabled:=true;
  button11.enabled:=false;
  button1.enabled:=false;
  edit1.setfocus;
end;

procedure TwShippers.CheckBox4KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.CheckBox4KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.MaskEdit2KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.MaskEdit2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit21KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit21KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.CheckBox5KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.CheckBox5KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit15KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit15KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit22KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit22KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if getdown(key) then edit24.setfocus;
end;

procedure TwShippers.Edit24KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit24KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit23KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit23KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit25KeyPress(Sender: TObject; var Key: Char);
begin
  getret(key);
end;

procedure TwShippers.Edit25KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  getmove(key,self);
end;

procedure TwShippers.Edit8Enter(Sender: TObject);
begin
  ReCalc;
end;

function TwShippers.settype(cqty:double;tstart:string):string;
Begin
  Result:='';
  tstart:=Copy(tstart,1,2);
  if (tstart = 'B ') Or (tstart = 'BO') then begin
    Result:='BOX'+iifs(cqty>1,'ES','');
  End Else
  if (tstart = 'T ') Or (tstart = 'TO') then begin
    Result:='TOTE'+iifs(cqty>1,'S','');
  End Else
  if (tstart = 'R ') Or (tstart = 'RE') then begin
    Result:='REEL'+iifs(cqty>1,'S','');
  End Else
  if tstart = 'CA' then begin
    Result:='CARTON'+iifs(cqty>1,'S','');
  End Else
  if (tstart = 'CO') Or (empty(tstart)) then begin
    Result:='CONTAINER'+iifs(cqty>1,'S','');
  End;
End;


procedure TwShippers.Edit37Exit(Sender: TObject);
begin
  edit37.text:=settype(procdbl(edit2.text),edit37.text);
end;

procedure TwShippers.Edit38Exit(Sender: TObject);
begin
  edit38.text:=settype(procdbl(edit3.text),edit38.text);
end;

procedure TwShippers.Edit39Exit(Sender: TObject);
begin
  edit39.text:=settype(procdbl(edit4.text),edit39.text);
end;

procedure TwShippers.Edit9Exit(Sender: TObject);
begin
  ShowShip;
end;

procedure TwShippers.Button2Click(Sender: TObject);
begin
  pShipReq(pShipList);
	listbox1.items.assign(pshiplist);
end;

procedure TwShippers.Button3Click(Sender: TObject);
begin
  notebook1.pageindex:=2;
  tabset1.tabindex:=2;
end;

procedure TwShippers.pshipreq(proclist:tstringlist);
var treq:oShipreq;
    plines:pchar;
    linkup,temptot:double;
    ii,tcnt:integer;
    snum:longint;
    tlines:tstringlist;
    adding:boolean;
Begin
	treq:=oShipreq.create;
	treq.init(shipreq);
  plines:=stralloc(MaxMemoSize);
  tlines:=tstringlist.create;
  strpcopy(plines,'');
	shipreq.gotop;
	While Not shipreq.eof do begin
	  treq.load(false);
	  if not empty(treq.shipper_no) and not empty(treq.job_no) then begin
			if (Not treq.fvoid) And (Not treq.processed) then begin
				if shipreq.aLock then begin
					proclist.add(treq.shipper_no);
					shipreq.unLock;
				End;
			End;
    end;
		shipreq.skip;
  End;
  if proclist.count=0 then begin
    proclist.add('No New Requests');
  End Else Begin
    for ii:=0 to proclist.count-1 do begin
      if pin('*',proclist[ii]) then continue; { skip processed items }
      proclist[ii]:=copy(proclist[ii],1,12); { trim off excess }
      shipreq.seek(proclist[ii]);
      if shipreq.aLock then begin
        treq.load(false);
        if (Not treq.fvoid) And (Not treq.processed) then begin
          shippr.SetOrder(2);
          adding:=False;
          linkup:=0;
          if shippr.Seek(shipreq.s('shipper_no')) then begin
					  proclist[ii]:=proclist[ii]+padr('  Updated',10)+'*';
            snum := shippr.l('seq_no');
            shippr.SetOrder(1);
            if shippr.b('invprinted') then begin
              OKbox('WARNING - '+trim(shipreq.s('shipper_no'))+
                ' Already Invoiced, Check Release Letter');
            End;
            shippr.Lock;
            shippr.bb('proofed',False);
          End Else Begin
            shippr.SetOrder(1);
            shippr.GoBottom;
					  proclist[ii]:=proclist[ii]+space(10)+'*';
            if shippr.eof then begin
              snum:=1;
            End Else Begin
              snum := shippr.l('seq_no')+1;
            End;
            adding:=True;
            shippr.Append;
          End;
					if jobs.Seek(shipreq.s('job_no')) then begin
						if Not empty(jobs.s('joblink')) then begin
							if jobs.Seek(jobs.s('joblink')) then begin
								linkup:=jobs.f('unit_price');
							End;
						End;
						jobs.Seek(shipreq.s('job_no'));   { seek back to org job }
					End;
					parts.Seek(jobs.s('part_no'));
					shippr.ll('seq_no',snum);
					shippr.ss('job_no',shipreq.s('job_no'));
					shippr.ss('shipper_no',shipreq.s('shipper_no'));
					shippr.dd('ship_date',shipreq.d('ship_date'));
					shippr.ff('sreq_no',shipreq.f('seq_no'));
					shippr.bb('complete',shipreq.b('complete'));
					with treq do begin
						shippr.ff('qty',(cnt1*qty1)+(cnt2*qty2)+(cnt3*qty3));
						if numsequal(shippr.f('qty'),0) then begin
							shippr.ff('qty',totqty);
						End;
					end;
					temptot:=linkup+jobs.f('unit_price');
					if temptot<0 then begin  { lot price }
						shippr.ff('amount',abs(temptot));
					End Else Begin
						shippr.ff('amount',shippr.f('qty'));
					End;
					shippr.ss('cust_bill',jobs.s('cust_no'));
					if Not empty(jobs.s('ship_no')) then begin
						shippr.ss('cust_ship',jobs.s('ship_no'));
					End Else Begin
						shippr.ss('cust_ship',jobs.s('cust_no'));
					End;
					shippr.bb('resale',True);
          tcnt:=0;
					if empty(jobs.s('rev_no')) then begin
						tlines[tcnt]:='P/N '+trim(parts.s('part_no'))+'  '+
							trim(upper(parts.s('name')));
					End Else Begin
						tlines[tcnt]:='P/N '+trim(parts.s('part_no'))+' '''+
							trim(jobs.s('rev_no'))+'''  '+ trim(upper(parts.s('name')));
					End;
          tcnt:=tcnt+1;
          tlines[tcnt]:='';
					with treq do begin
						if cnt1>0 then begin
		          tcnt:=tcnt+1;
    		      tlines[tcnt]:=ltrim(strd(cnt1,0))+' '+trim(type1)+' ';
							if qty1>1 then begin
								tlines[tcnt]:=tlines[tcnt]+'@'+
								  ltrim(transform(qty1,'9,999,999'))+' PCS';
								if cnt1>1 then begin
									tlines[tcnt]:=tlines[tcnt]+' PER';
								End;
							End;
						End;
						if cnt2>0 then begin
		          tcnt:=tcnt+1;
    		      tlines[tcnt]:=ltrim(strd(cnt2,0))+' '+trim(type2)+' ';
							if qty2>1 then begin
								tlines[tcnt]:=tlines[tcnt]+'@'+
								  ltrim(transform(qty2,'9,999,999'))+' PCS';
								if cnt2>1 then begin
									tlines[tcnt]:=tlines[tcnt]+' PER';
								End;
							End;
						End;
						if (cnt3>0) And (qty3>0) then begin
		          tcnt:=tcnt+1;
    		      tlines[tcnt]:=ltrim(strd(cnt3,0))+' '+trim(type3)+' ';
							if qty3>1 then begin
								tlines[tcnt]:=tlines[tcnt]+'@'+
								  ltrim(transform(qty3,'9,999,999'))+' PCS';
								if cnt3>1 then begin
									tlines[tcnt]:=tlines[tcnt]+' PER';
								End;
							End;
						End;
						if skids>1 then begin
		          tcnt:=tcnt+1;
    		      tlines[tcnt]:=ltrim(str2(skids,3))+' SKIDS  ';
						End Else Begin
							if skids=1 then begin
			          tcnt:=tcnt+1;
  	  		      tlines[tcnt]:=ltrim(str2(skids,3))+' SKID  ';
							End;
						End;
	          tcnt:=tcnt+1;
            tlines[tcnt]:='';
 	          tcnt:=tcnt+1;
						tlines[tcnt]:=trim(shipreq.s('com1'));
	          tcnt:=tcnt+1;
						tlines[tcnt]:=trim(shipreq.s('com2'));
	          tcnt:=tcnt+1;
   		      tlines[tcnt]:=trim(shipreq.s('com3'));
						if Not empty(com4) then begin
		          tcnt:=tcnt+1;
  	 		      tlines[tcnt]:=trim(shipreq.s('com4'));
						End;
						if (call_cust) Or (truck_line) then begin
							if call_cust then begin
			          tcnt:=tcnt+1;
		   		      tlines[tcnt]:='CALL CUST. FOR P/U ';
							End;
							if truck_line then begin
				        tcnt:=tcnt+1;
			   		    tlines[tcnt]:='CALL TRUCK LINE - '+
									trim(shipreq.s('tline_com'));
							End;
						End;
					end;
          longunsplit(plines,'^',tlines);
					shippr.longss('lines',plines);
					shippr.ss('cust_bill',jobs.s('cust_no'));
					shipreq.bb('processed',True);
					shipreq.unLock;
					shippr.unlock;
        End;
      End Else Begin
        OKbox('Had To Skip One - Someone Is Still Entering It - Process Again');
      End;
    End;
  End;
  tlines.free;
	treq.free;
End;

procedure TwShippers.BitBtn1Click(Sender: TObject);
begin
  doShipSave;
  edit13.enabled:=true;
  button4.enabled:=false;
  bitbtn2.enabled:=false;
  bitbtn1.enabled:=false;
  srec.init(nil);
  shiptowin;
  edit13.setfocus;
end;

procedure TwShippers.Button4Click(Sender: TObject);
begin
  doShipSave;
end;

procedure TwShippers.Memo1KeyPress(Sender: TObject; var Key: Char);
var tt:string[2];
begin
  tt[1]:=key;
  tt:=upper(tt);
  key:=tt[1];
end;

procedure TwShippers.BitBtn2Click(Sender: TObject);
begin
  edit13.enabled:=true;
  button4.enabled:=false;
  bitbtn2.enabled:=false;
  bitbtn1.enabled:=false;
  srec.init(nil);
  shiptowin;
  edit13.setfocus;
end;

procedure TwShippers.ShowShipTo;
begin
  if not empty(edit14.text) then begin
    if cust.seek(edit14.text) then begin
      label29.caption:=cust.s('name');
      label30.caption:=cust.s('address_1');
      label31.caption:=cust.s('address_2');
      label32.caption:=cust.s('address_3');
    end;
  end else begin
    label29.caption:='';
    label30.caption:='';
    label31.caption:='';
    label32.caption:='';
  end;
end;

procedure TwShippers.Edit14KeyPress(Sender: TObject; var Key: Char);
begin
  if getret(key) then begin
    ShowShipTo;
    checkbox4.setfocus;
  end;
end;

end.
