Unit RoutCards;

Interface

uses DBFserver, CommonCode, wPreview;

const

	MAXOPS=38;
	LOCALLAZ='JEFF TONY CARL GEORGE ';
	QCGANG='RUDY BOB TOM SHIP ';
	rcwid1=40;
	rcwid2=12;
	rcwid3=12;
	rcwid4=25;

type
  oRC=Class(TObject)
	private
	  partnum:string20;
		sheet,custnum:string10;
		ndated:longint;
		usepnum,usecnum,usejnum,usernum:string20;
		usemotd:longint;
		rlp:Lpr;
    ocnt,ocnt2,pgoffset:integer;
    p1,p2,ucustname,ucustnum,upartname,upartnum:string80;
		oper:array [1..MAXOPS] of string[3];
		cstatus:array [1..MAXOPS] of boolean; { change status }
		des1,des2,des3:array [1..MAXOPS] of string40;
		wpt1,wpt2,wpt3:array [1..MAXOPS] of string20;
		tool1,tool2,tool3:array [1..MAXOPS] of string20;
		com1,com2,com3:array [1..MAXOPS] of string30;
		procedure rclzhead;
		procedure rclzline(seln,posit:integer);
		procedure DrawMainVerts(ocnt2:integer);
	public
	  routcard,jobs,cust,parts,matspecs:oDB;
    ForceToScreen:boolean;
	  constructor Create;
		procedure PrintRC(var jlist:array of string40);
		function  loadrc(loadpn:string):boolean;
		procedure lazrc;
	end;

Implementation

constructor oRC.Create;
begin
  routcard:=nil;
  cust:=nil;
  parts:=nil;
  matspecs:=nil;
  jobs:=nil;
  ForceToScreen:=false;
end;

procedure oRC.PrintRC(var jlist:array of string40);
var ii,cord:integer;
    ra,ca,pa,ma,ja:boolean;
    thisjob:string10;
begin
	ra:=dbIsClosed(routcard);
	ca:=dbIsClosed(cust);
	pa:=dbIsClosed(parts);
	ma:=dbIsClosed(matspecs);
	ja:=dbIsClosed(jobs);
	if ra then dbUse(routcard,jcpath('routcard'));
	if ca then dbUse(cust,compath('cust'));
	if pa then dbUse(parts,compath('parts'));
	if ma then dbUse(matspecs,jcpath('matspecs'));
	if ja then dbUse(jobs,compath('jobs'));
  cord:=matspecs.CurOrder;
  matspecs.setorder(1);
  rlp:=Lpr.Create;
  rlp.SetDestination;
  if ForceToScreen then rlp.ForceToScreen;
  for ii:=0 to high(jlist) do begin
    thisjob:=padr(substr(jlist[ii],1,10),10);
    if not empty(thisjob) then begin
	    if jobs.seek(thisjob) then begin
        partnum:=jobs.s('part_no');
        usepnum:=partnum;
        usecnum:=jobs.s('cust_no');
        usejnum:=jobs.s('job_no');
        usernum:=jobs.s('rev_no');
        usemotd:=jobs.d('mot_date');
        ucustname:='UNKNOWN';
        if cust.seek(jobs.s('cust_no')) then
          ucustname:=upper(cust.s('name'));
        ucustnum:=usecnum;
        upartname:='';
        if parts.seek(jobs.s('part_no')) then
          upartname:=upper(parts.s('name'));
        upartnum:=usepnum;
        if loadrc(partnum) then begin
  		  	lazrc;
        end;
      end;
  	end;
  end;
  if ra then dbClose(routcard);
  if ca then dbClose(cust);
  if pa then dbClose(parts);
  matspecs.setorder(cord);
  if ma then dbClose(matspecs);
  if ja then dbClose(jobs);
  rlp.free;
end;

function oRC.loadrc(loadpn:string):boolean;
var ii,jj:integer;
    ftext,tgroup,tline:string135;
begin
  partnum:=loadpn;
  if Not routcard.Seek(partnum+' 00') then begin
    Result:=False;
		exit;
	end;
	Result:=True;
  for ii:=1 to MAXOPS do begin
	  des1[ii]:=space(rcwid1);
		des2[ii]:=space(rcwid1);
		des3[ii]:=space(rcwid1);
		wpt1[ii]:=space(rcwid2);
		wpt2[ii]:=space(rcwid2);
		wpt3[ii]:=space(rcwid2);
		tool1[ii]:=space(rcwid3);
		tool2[ii]:=space(rcwid3);
		tool3[ii]:=space(rcwid3);
		com1[ii]:=space(rcwid4);
		com2[ii]:=space(rcwid4);
		com3[ii]:=space(rcwid4);
		cstatus[ii]:=False;
	end;
  jj:=5;
  for ii:=1 to MAXOPS do begin
    jj:=jj+5;
    oper[ii]:=str(jj,3,0);
  End;
  While (not routcard.eof) and (partnum=routcard.s('part_no')) do begin
    jj:=0;
    for ii:=1 to MAXOPS do begin
      if routcard.s('operation')=oper[ii] then begin
        jj:=ii;
        break;
      End;
    End;
    if jj>0 then begin
      tgroup:=Copy(routcard.s('groupline'),1,1);
      tline:=Copy(routcard.s('groupline'),2,1);
      ftext:=space(40);
      if tgroup='A' then begin  { description }
        ftext:=routcard.s('textline');
				if tline='1' then begin
					des1[jj]:=ftext;
				End Else
				if tline='2' then begin
					des2[jj]:=ftext;
				End Else
				if tline='3' then begin
					des3[jj]:=ftext;
				End;
			end;
			if tgroup='B' then begin  { work point }
				ftext:=Copy(routcard.s('textline'),1,rcwid2);
				if tline='1' then begin
					wpt1[jj]:=ftext;
				End Else
				if tline='2' then begin
					wpt2[jj]:=ftext;
				End Else
				if tline='3' then begin
					wpt3[jj]:=ftext;
				End;
			end;
			if tgroup='C' then begin  { tools required }
				ftext:=Copy(routcard.s('textline'),1,rcwid3);
				if tline='1' then begin
					tool1[jj]:=ftext;
				End Else
				if tline='2' then begin
					tool2[jj]:=ftext;
				End Else
				if tline='3' then begin
					tool3[jj]:=ftext;
				End;
			end;
			if tgroup='D' then begin  { comments }
				ftext:=Copy(routcard.s('textline'),1,rcwid4);
				if tline='1' then begin
					com1[jj]:=ftext;
				End Else
				if tline='2' then begin
					com2[jj]:=ftext;
				End Else
				if tline='3' then begin
					com3[jj]:=ftext;
				End;
      End;
    End;
    routcard.skip;
  End;
	custnum:='';
	sheet:='11';
	ndated:=xDate;
  if routcard.Seek(partnum+' 00') then begin
    custnum:=Copy(routcard.s('textline'),1,6);
    ndated:=ctod(Copy(routcard.s('textline'),8,8));
    sheet:=Copy(routcard.s('textline'),17,2);
  End;
end;

procedure oRC.rclzhead;
var ii,kk,zz,jj:integer;
    cname,tt,tt2:string;
begin
  pgoffset:=0;
  if Not empty(usejnum) then begin
    pgoffset:=20;
  End;
  rlp.LazLine(pgoffset+21,0,576,1);
  rlp.LazBox(pgoffset+43,0,576,12,15);
  rlp.LazLine(pgoffset+43,0,576,1);
  rlp.LazLine(pgoffset+54,0,576,1);
  { vertical lines }
  rlp.LazLine(pgoffset+0,187,1,20);
  rlp.LazLine(pgoffset+0,365,1,20);
  rlp.LazLine(pgoffset+0,508,1,20);
  if Not empty(usejnum) then begin
    rlp.Laztext(0,250,'12','S.O.');
    rlp.Laztext(0,283,'12b',usejnum);
  End;
  rlp.LazLine(pgoffset+21,0,576,1);
  rlp.Laztext(pgoffset+11,0,'8','PART');
  rlp.Laztext(pgoffset+19,2,'8','NO.');
  rlp.Laztext(pgoffset+11,190,'8','PART');
  rlp.Laztext(pgoffset+19,190,'8','NAME');
  rlp.Laztext(pgoffset+19,368,'8','COMPANY');
  rlp.Laztext(pgoffset+19,511,'8','DATE');
  rlp.Laztext(pgoffset+33,2,'8','MATL');
  rlp.Laztext(pgoffset+41,0,'8','SPECS');
  rlp.Laztext(pgoffset+41,510,'8','SHEET');
  rlp.Laztext(pgoffset+41,550,'8','OF');
  rlp.Laztext(pgoffset+52,2,'8','OPER NO.');
  rlp.Laztext(pgoffset+52,118,'8','DETAILS OF OPERATION');
  rlp.Laztext(pgoffset+52,297,'8','WORK POINT');
  rlp.Laztext(pgoffset+52,366,'8','EMP');
  rlp.Laztext(pgoffset+52,406,'8','TOOLS.');
  rlp.Laztext(pgoffset+52,502,'8','REMARKS');
  rlp.Laztext(pgoffset+39,538,'12',Copy(sheet,1,1));
  rlp.Laztext(pgoffset+39,561,'12',Copy(sheet,2,1));
  { if empty(usernum) }
    { usernum=parts->rev_mot }
  { endif }
  if empty(usernum) then begin
    rlp.Laztext(pgoffset+13,30,'12b',trim(usepnum));
  End Else
  Begin
    rlp.Laztext(pgoffset+13,30,'12b',
      trim(usepnum)+' '''+trim(usernum)+'''');
  End;
  if usemotd=0 then begin
    usemotd:=parts.d('mot_date');
  End;
  if usemotd>0 then begin
    rlp.Laztext(pgoffset+20,134,'8','MOT '+datehyph(usemotd));
  End;
  rlp.Laztext(pgoffset+13,213,'12',trim(upartname));
  cname:=upper(ucustname);
  {grpother(cname);}  { found in einvent.prg }
  tt:=trim(cname);
  tt2:='';
  if length(tt)>23 then begin
    tt:='';
    split(cname,' ',pars,parscnt);
    if parscnt>1 then begin
      tt:=pars[1];
      for ii:=2 to parscnt do begin
        kk:=length(tt);
        jj:=length(pars[ii]);
        if kk<23 then begin
          tt:=tt+' '+pars[ii];
        End Else
        Begin
          tt2:=tt2+' '+pars[ii];
        End;
      End;
    End;
  End;
  if empty(tt2) then begin
    if length(tt)<19 then begin
      rlp.Laztext(pgoffset+11,368,'12',trim(tt));
    End Else
    Begin
      rlp.Laztext(pgoffset+11,368,'10b',trim(tt));
    End;
  End Else
  Begin
    rlp.Laztext(pgoffset+10,368,'10b',trim(tt));
    rlp.Laztext(pgoffset+19,398,'10b',trim(tt2));
  End;
  rlp.Laztext(pgoffset+9,513,'12',datehyph(ndated));
  tt:=p1;
  split(tt,' ',pars,parscnt);
  jj:=0;
  tt:='';
  if parscnt>0 then begin
    for ii:=1 to parscnt do begin
      { check for times symbol, but ignore if part of name }
      if (pos('X',pars[ii])>0) And (Not (pos('''',pars[ii])>0)) then begin
        if ii>1 then begin
          zz:=ii-1;
          tt:=unsplit(pars,' ',zz);
          break;
        End;
      End Else
      Begin
        if pos('~',pars[ii])>0 then begin
          zz:=ii;
          tt:=unsplit(pars,' ',zz);
          break;
        End Else
        Begin
          if (pos('+/-',pars[ii])>0) And (length(pars[ii])>3) then begin
            zz:=ii;
            pars[ii]:='~'+Copy(pars[ii],4,length(pars[ii])-3);
            tt:=unsplit(pars,' ',zz);
            break;
          End;
        End;
      End;
    End;
  End;
  if matspecs.seek(usepnum) then begin
    tt:=trim(tt)+'  '+trim(matspecs.s('mattype'))+'  '+trim(matspecs.s('spec'));
    if length(tt)>66 then begin
      rlp.Laztext(pgoffset+36,32,'10',rlp.SpecChars(tt));
    End Else
    Begin
      rlp.Laztext(pgoffset+36,32,'12',rlp.SpecChars(tt));
    End;
  End Else
  Begin
    rlp.Laztext(pgoffset+30,32,'10',p2);
    rlp.Laztext(pgoffset+40,32,'10',p1);
  End;
end;

procedure oRC.DrawMainVerts(ocnt2:integer);
var jj:integer;
begin
  jj:=83+((ocnt2-1)*36);
  rlp.LazLine(pgoffset+43,36,1,jj);
  rlp.LazLine(pgoffset+43,281,1,jj);
  rlp.LazLine(pgoffset+43,355,1,jj);
  rlp.LazLine(pgoffset+43,390,1,jj);
  rlp.LazLine(pgoffset+43,466,1,jj);
end;

procedure oRC.lazrc;
var bool:boolean;
		ii,jj,kk:integer;
		tt,tt2,tt3,cname:string80;
	  oplist:array [1..MAXOPS] of boolean;
begin
  for ii:=1 to MAXOPS do oplist[ii]:=False;
  rlp.StartDoc(for8x11,'Route Card');
  { horizontal lines }
  ucustname:=cust.s('name');
  ucustnum:=usecnum;
  upartnum:=partnum;
  if empty(ucustnum) then begin
    ucustname:='ALL CUSTOMERS';
  End Else
  Begin
    if cust.Seek(ucustnum) then begin
      ucustname:=upper(cust.s('name'));
    End;
  End;
  ocnt:=0;  { add up number of ops that will be displayed }
  for ii:=1 to MAXOPS do begin
    tt3:=des1[ii]+des2[ii]+des3[ii];
    if Not empty(tt3) then begin
      if empty(ucustnum) then begin
        ocnt:=ocnt+1;
        oplist[ii]:=True;
      End Else
      Begin
        jj:=pos('{',tt3);
        if jj>0 then begin
          if pos(trim(ucustnum),Copy(tt3,jj,jj+15))>0 then begin
            ocnt:=ocnt+1;
            oplist[ii]:=True;
          End;
        End Else
        Begin
          ocnt:=ocnt+1;
          oplist[ii]:=True;
        End;
      End;
    End;
  End;
  sheet:='11';
  if ocnt>17 then begin
    sheet:='12';
  End;
  pgoffset:=0;
  ocnt2:=ocnt;  { need for rclzhead() }
  rclzhead;
  jj:=83;
  ocnt:=0;
  for ii:=1 to MAXOPS do begin
    if oplist[ii] then begin
      ocnt:=ocnt+1;
      if ocnt=18 then begin
        DrawMainVerts(17);
        rlp.Eject;
        sheet:='22';
        rclzhead;
        jj:=83;
      End;
      rlp.LazBox(pgoffset+jj,0,576,8,15);
      rlp.LazLine(pgoffset+jj,0,576,1);
      rlp.LazLine(pgoffset+jj+7,0,576,1);
      rlp.Laztext(pgoffset+jj-10,4,'12b',
			  str((ocnt+1)*5,3,0));
      rclzline(ii,jj);
      jj:=jj+36;
    End;
  End;
  DrawMainVerts(ocnt);
  rlp.StopDoc;
end;


procedure oRC.rclzline(seln,posit:integer);
var wid,gap,mm,lcnt,offset,ii:integer;
    l1,l2,l3:string135;
    fsize:string10;
begin
  for mm:=1 to 4 do begin
    if mm=1 then begin
      l1:=des1[seln];
      l2:=des2[seln];
      l3:=des3[seln];
      offset:=39;
      fsize:='10';
      gap:=9;
      wid:=rcwid1;
      ii:=posit-2;  { starting bottom line }
    End Else
    if mm=2 then begin
      l1:=wpt1[seln];
      l2:=wpt2[seln];
      l3:=wpt3[seln];
      offset:=283;
      fsize:='10';
      gap:=9;
      wid:=rcwid2;
      ii:=posit-2;  { starting bottom line }
    End Else
    if mm=3 then begin
      l1:=tool1[seln];
      l2:=tool2[seln];
      l3:=tool3[seln];
      offset:=393;
      fsize:='10';
      gap:=9;
      wid:=rcwid3;
      ii:=posit-2;  { starting bottom line }
    End Else
    if mm=4 then begin
      l1:=com1[seln];
      l2:=com2[seln];
      l3:=com3[seln];
      offset:=468;
      fsize:='8';
      gap:=8;
      wid:=rcwid4;
      ii:=posit-3;  { starting bottom line }
    End;
    lcnt:=3;
    l1:=trim(l1);
    l2:=trim(l2);
    l3:=trim(l3);
    if empty(l3) then begin
      lcnt:=2;
    End;
    if empty(l2) then begin
      lcnt:=1;
    End;
    if Not empty(l1) then
      rlp.Laztext(pgoffset+ii-gap-gap,offset,fsize,rlp.specchars(l1));
    if Not empty(l2) then
      rlp.Laztext(pgoffset+ii-gap,offset,fsize,rlp.specchars(l2));
    if Not empty(l3) then
      rlp.Laztext(pgoffset+ii,offset,fsize,rlp.specchars(l3));
  End;
end;


end.
