unit wSelprn;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, wPreview, DBFserver, CommonCode;

const

  DirectNote='Direct To My Printer';

type
  Tnewprinter = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    prnlist: TComboBox;
    qlist: TComboBox;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure prnlistClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure qlistClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    ActualPrnNum:array [0..MaxPrns-1] of integer;
		procedure GetAvailQueues;
		procedure SetupLists;
  public
    { Public declarations }
  end;

var
  newprinter: Tnewprinter;

implementation

{$R *.DFM}

uses DLmain;

procedure Tnewprinter.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure Tnewprinter.GetAvailQueues;
var ii,jj,kk:integer;
begin
  qlist.clear;
  jj:=-1;
  with lp do begin
    if (CurDest>0) and (QueueCnt>0) and (lptprinters[CurDest].PrType>0) then begin
      if (pin('LPT',upper(LptPrinters[CurDest].PrPort))) and
         (procint(LptPrinters[CurDest].PrPort)=1) then
        qlist.items.add(' '+DirectNote);
      for ii:=1 to QueueCnt do begin
        for kk:=1 to MaxQTypes do begin
	        if LptPrinters[CurDest].Prtype=QueueType[ii][kk] then begin
		        qlist.items.add(' '+padr(QueueTitle[ii],25)+'  '+QueueName[ii]);
          end;
        end;
      end;
      for ii:=0 to qlist.items.count-1 do begin
        if not empty(LptPrinters[CurDest].Queue) then begin
          if pin(LptPrinters[CurDest].Queue,qlist.items[ii]) then begin
            jj:=ii;
          end;
        end;
      end;
    end;
  end;
  if qlist.items.count>0 then begin
    if jj>=0 then qlist.itemindex:=jj
    else qlist.itemindex:=0;
  end;
end;

procedure Tnewprinter.SetupLists;
var ii,jj,kk:integer;
    tt,tt2:string;
begin
  kk:=lp.curdest;
  prnlist.clear;
  qlist.clear;
  if lp.PrnCnt>0 then begin
    for ii:=1 to lp.PrnCnt do begin
      with lp.LptPrinters[ii] do begin
        if CanSelect then begin
         tt2:=' '+padr(Prname,22)+' '+padr(PrPort,5);
         jj:=lp.GetQueueNum(queue);
         if jj>0 then tt2:=tt2+'  '+lp.QueueTitle[jj]
         else begin
           if procint(PrPort)>0 then tt2:=tt2+'  '+DirectNote;
         end;
         prnlist.items.add(tt2);
         ActualPrnNum[prnlist.items.count-1]:=ii;
        end;
      end;
    end;
  end;
  jj:=-1;
  for ii:=1 to prnlist.items.count do begin
    if kk=ActualPrnNum[ii-1] then begin
      jj:=ii-1;
      break;
    end;
  end;
  if jj>=0 then prnlist.itemindex:=jj;
  GetAvailQueues;
end;

procedure Tnewprinter.FormCreate(Sender: TObject);
begin
  top:=0;
  left:=0;
  width:=509;
  height:=201;
  centerhoriz(self);
  Gen.AddWin('Select Printer',self);
  SetupLists;
  checkbox1.checked:=lp.WantsPreview;
  show;
end;

procedure Tnewprinter.prnlistClick(Sender: TObject);
var ii,jj:integer;
begin
  lp.CurDest:=ActualPrnNum[prnlist.itemindex];
  with lp.LptPrinters[lp.CurDest] do begin
    MainWin.SetPreview;
  end;
  SetupLists;
end;

procedure Tnewprinter.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  lp.WantsPreview:=checkbox1.checked;
  MainWin.SetPreview;
  Gen.ReleaseWin(self);
  action:=caFree;
end;

procedure Tnewprinter.qlistClick(Sender: TObject);
begin
  with lp.LptPrinters[lp.CurDest] do begin
    Queue:=iifs(pin('Direct',qlist.items[qlist.itemindex]),'',
    	ltrim(trim(copy(qlist.items[qlist.itemindex],29,20))));
    MainWin.SetPreview;
  end;
  SetupLists;
end;

procedure Tnewprinter.CheckBox1Click(Sender: TObject);
begin
  lp.WantsPreview:=checkbox1.checked;
  MainWin.SetPreview;
end;

end.
