unit Nudelphi;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, DBFserver, CommonCode, wPreview,
  wAboutbx, wDL, wDL2, Menus;

const
  wFirstPrgDir='';
  wFieldListDir='';

type
  Tdb2dl = class(TForm)
    prglist: TListBox;
    paslist: TListBox;
    OpenDialog1: TOpenDialog;
    cdir: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    BitBtn3: TBitBtn;
    Label3: TLabel;
    fromprg: TLabel;
    Label5: TLabel;
    topas: TLabel;
    progress: TLabel;
    BitBtn4: TBitBtn;
    Button1: TButton;
    MainMenu1: TMainMenu;
    Options1: TMenuItem;
    PRGtoPAS1: TMenuItem;
    DBFtoPAS1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn2Click(Sender: TObject);
    procedure paslistDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure prglistDrawItem(Control: TWinControl; Index: Integer;
      Rect: TRect; State: TOwnerDrawState);
    procedure BitBtn3Click(Sender: TObject);
    procedure paslistDblClick(Sender: TObject);
    procedure prglistDblClick(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure PRGtoPAS1Click(Sender: TObject);
    procedure DBFtoPAS1Click(Sender: TObject);
  private
    { Private declarations }
    curdir:string;
    dlConv:oDL;
    dbfConv:oFldpas;
    prnpas:lpr;
    procedure procprgs;
		procedure PRG2PAS;
		procedure DBF2PAS;
  public
    { Public declarations }
    indir:string;
    DoPRGconversion:boolean;
		procedure SelDir;
    procedure loadlists;
  end;

var
  db2dl: Tdb2dl;
  InstalledTo:string;

implementation

{$R *.DFM}

procedure Tdb2dl.FormCreate(Sender: TObject);
begin
  width:=517;
  height:=345;
  top:=0;
  centerhoriz(self);
  dlConv:=oDL.Create;
  dbfConv:=oFldpas.Create;
  prnpas:=lpr.create;
  fromprg.caption:='';
  topas.caption:='';
  progress.caption:='';
  DoPRGconversion:=true;
  indir:=InstalledTo;
  gen.addwin('Translate xBase',self);
end;

procedure Tdb2dl.SelDir;
begin
  with opendialog1 do begin
    title:='Select Any PRG File In This Directory';
    if empty(initialdir) then initialdir:=wFirstPrgDir
    else initialdir:=indir;
    if DoPRGconversion then begin
      filename:='*.Prg';
      filter:='Programs (*.PRG)|*.PRG';
      defaultext:='PRG';
    end else begin
      filename:='*.Dbf';
      filter:='Databases (*.DBF)|*.DBF';
      defaultext:='DBF';
    end;
    execute;
    if files.count>0 then indir:=files[0];
  end;
  LoadLists;
end;

procedure Tdb2dl.LoadLists;
var prg:TStringList;
    ii:integer;
    tt:string;
begin
  prg:=TStringList.Create;
	split(indir,'\',pars,parscnt);
  if pin('.',pars[parscnt]) then begin
    parscnt:=parscnt-1;  { knock of file on end }
    indir:=unsplit(pars,'\',parscnt);
  end;
  curdir:=indir;
  cdir.caption:='Current Dir:   '+curdir;
  if DoPRGconversion then LoadFileList(curdir,'*.PRG',prg)
  else LoadFileList(curdir,'*.DBF',prg);
  prglist.clear;
  paslist.clear;
  if prg.count>0 then begin
    for ii:=0 to prg.count-1 do begin
      prglist.items.add(prg[ii]);
    end;
    for ii:=0 to prglist.items.count-1 do begin
	    if DoPRGconversion then tt:=indir+'\'+noext(prglist.items[ii])+'.pas'
	    else tt:=indir+'\'+noext(prglist.items[ii])+'.int';
      if fileexists(tt) then begin
        paslist.items.add(noext(prglist.items[ii])+'.PAS');
      end else begin
        paslist.items.add('');
      end;
    end;
  end;
  prg.free;
  bitbtn4.caption:='&Select All';
end;

procedure Tdb2dl.BitBtn1Click(Sender: TObject);
begin
  close;
end;

procedure Tdb2dl.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  prnpas.free;
  dlConv.free;
  dbfConv.free;
  gen.releasewin(self);
  action:=caFree;
end;

procedure Tdb2dl.BitBtn2Click(Sender: TObject);
begin
  SelDir;
end;

procedure Tdb2dl.paslistDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var ii:integer;
begin
  with (control as TListBox).Canvas do begin
    ii:=paslist.items.count;
    if prglist.items.count<ii then ii:=prglist.items.count;
	  fillrect(rect);
  	textout(rect.left+2,rect.top,paslist.items[index]);
    if (prglist.topindex<ii) and (prglist.items.count>0) then
      prglist.topindex:=paslist.topindex;
  end;
end;

procedure Tdb2dl.prglistDrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var ii:integer;
begin
  with (control as TListBox).Canvas do begin
    ii:=prglist.items.count;
    if paslist.items.count<ii then ii:=paslist.items.count;
	  fillrect(rect);
  	textout(rect.left+2,rect.top,prglist.items[index]);
    if (paslist.topindex<ii) and (paslist.items.count>0) then
      paslist.topindex:=prglist.topindex;
  end;
end;

procedure Tdb2dl.procprgs;
var ii:integer;
    tt:string;
begin
  if prglist.items.count>0 then begin
    Mousewait;
    for ii:=0 to prglist.items.count-1 do begin
      if prglist.selected[ii] then begin
	      tt:=prglist.items[ii];
        fromprg.caption:=tt;
        if doPRGconversion then topas.caption:=noext(tt)+'.PAS'
        else topas.caption:=noext(tt)+'.INT/.IMP';
			  DLconv.DoDBWconv:=checkbox1.checked;
			  if DoPRGconversion then dlconv.dbase2delphi(curdir,tt)
        else begin
          progress.caption:='';
          dbfConv.dbf2pas(curdir,tt);
          progress.caption:='Done';
          doevents;
        end;
        paslist.items[ii]:=padr(noext(tt)+'.PAS',13)+'*';
      end;
    end;
    MouseGo;
  end;
end;

procedure Tdb2dl.BitBtn3Click(Sender: TObject);
begin
  procprgs;
end;

procedure Tdb2dl.paslistDblClick(Sender: TObject);
var tt,tt2:string;
    f1,f2:tstringlist;
    ii,seg2:integer;
begin
  tt:=paslist.items[paslist.itemindex];
  if not empty(tt) then begin
    f1:=tstringlist.create;
    f2:=tstringlist.create;
    if DoPRGconversion then begin
      tt:=trim(noext(tt))+'.PAS';
	    tt2:=trim(noext(tt))+'.TXT';
    end else begin
      tt:=trim(noext(tt))+'.INT';
      tt2:=trim(noext(tt))+'.IMP';
    end;
	  prnpas.setdestination;
  	prnpas.startdoc(for8x11,'View '+
      trim(tt+iifs(length(tt2)>0,'/'+tt2,'')));
    f1.loadfromfile(curdir+'\'+tt);
    seg2:=0;
    with prnpas do begin
      for ii:=0 to f1.count-1 do writeln(f1[ii]);
  	  if not empty(tt2) then begin
        Eject;
        seg2:=prnpas.Page+1;
	  	  f2.loadfromfile(curdir+'\'+tt2);
	    	textfont('b');
		    writeln(padc('FILE: '+tt2,79));
        writeln('');
      	textfont('n');
	      for ii:=0 to f2.count-1 do writeln(f2[ii]);
      end;
    end;
  	prnpas.SetCaption('View '+
      trim(tt+iifs(length(tt2)>0,'/'+tt2+' (Starts Pg '+inttostr(seg2)+
      ')','')));
    prnpas.stopdoc;
    f1.free;
    f2.free;
  end;
end;

procedure Tdb2dl.prglistDblClick(Sender: TObject);
begin
  procprgs;
end;

procedure Tdb2dl.BitBtn4Click(Sender: TObject);
var ii:integer;
    bool:boolean;
begin
  if prglist.items.count>0 then begin
    if pin('Unselect',bitbtn4.caption) then begin
      bool:=false;
      bitbtn4.caption:='&Select All';
    end else begin
      bool:=true;
      bitbtn4.caption:='&Unselect All';
    end;
    for ii:=0 to prglist.items.count-1 do prglist.selected[ii]:=bool;
    prglist.topindex:=0;
  end;
end;

procedure Tdb2dl.Exit1Click(Sender: TObject);
begin
  close;
end;

procedure Tdb2dl.PRG2PAS;
begin
  DoPRGconversion:=true;
  label1.caption:='xBase Files';
  checkbox1.visible:=true;
  PRGtoPAS1.checked:=true;
	DBFtoPAS1.checked:=false;
  loadlists;
end;

procedure Tdb2dl.DBF2PAS;
begin
  DoPRGconversion:=false;
  label1.caption:='DataBase Files';
  checkbox1.visible:=false;
  PRGtoPAS1.checked:=false;
	DBFtoPAS1.checked:=true;
  loadlists;
end;

procedure Tdb2dl.Button1Click(Sender: TObject);
begin
  close;
end;

procedure Tdb2dl.PRGtoPAS1Click(Sender: TObject);
begin
  prg2pas;
end;

procedure Tdb2dl.DBFtoPAS1Click(Sender: TObject);
begin
  dbf2pas;
end;

end.
