Unit pdfSign;

{$I DelVer.inc}

Interface

const

  { PDF Symbolic Font - Standard PostScript Font Type 1 - #14 ZapfDingbats }
  psfYes       = 01; 
  psfBoldYes   = 02; 
  psfNo        = 03; 
  psfBoldNo    = 04;

  psfPenUp     = 05; 
  psfPenDown   = 06; 
  psfNoPen     = 07;
  psfPenHead1  = 08;
  psfPenHead2  = 09;

  psfWriteDown = 10;
  psfSee       = 11;
  psfBlackSee  = 12;

  psfTelephone       = 13;
  psfPublicPhone     = 14; 
  psfAirplane        = 15;
  psfMail            = 16;

  psfOK              = 17;
  psfWrong           = 18;
  psfWait            = 19;
  psfFirstAid        = 20;
  psfOutlineFirstAid = 21;

  psfCutter          = 22;
  psfBlackCutter     = 23;
  psfCutUp           = 24;
  psfCutDown         = 25;

  psfFlower          = 26;
  psfBlackFlower     = 27;
  psfOutlineFlower   = 28;
  psfBwFlower1       = 29;
  psfBwFlower2       = 30;

  psfCross           = 31;
  psfShadowCross     = 32;
  psfOutlineCross    = 33;

  psfStar              = 34;
  psfBlackStar         = 35;
  psfShadowStar        = 36;
  psfStar4             = 37;
  psfStar6             = 38;
  psfStar8             = 39;
  psfStar12            = 40;
  psfCircleInStar      = 41;
  psfCircleInBlackStar = 42;
  psfOutlineStar       = 43;
  psfBoldOutlineStar   = 44;

  psfBlackBox      = 45;
  psfShadowUpBox   = 46;
  psfShadowDownBox = 47;
  psfMotionUpBox   = 48;
  psfMotionDownBox = 49;
  psfHalfBox       = 50;
  psfTallBox       = 51;
  psfThinBox       = 52;
 
  psfTriUp         = 53;
  psfTriDown       = 54;

  psfBlackCircle   = 55;
  psfShadowCircle  = 56;
  psfHalfCircle    = 57;
  psfStarInCircle  = 58;
  psfcStarInCircle = 59;
  psfDriveCircle   = 60;

  psfCommandMax    = 60;

  psfList = { 01..04 } '3478'         + { Yes/No 2+2 }
            { 05..09 } '0./12'        + { Pen 3+2 }
            { 10..12 } '-+*'          + { WriteDown/Seex2 }
            { 13..16 } '%&()'         + { Telephone/PublicPhone/Airplane/Mail }
            { 17..21 } ',6@:9'        + { OK/Wrong/Wait/FirstAidsx2 }
            { 22..25 } '$"#!'         + { Cutter x4 }
            { 26..30 } '`_a^c'        + { Flower x5 }
            { 31..33 } '=>?'          + { Cross x3 }
            { 34..44 } 'IHPFVXYLKMN'  + { Star x11 }
            { 45..52 } 'npoqrzyx'     + { Box x8 }
            { 53..54 } 'st'           + { Tri-Angle x2 }
            { 55..60 } 'lmwJb''';       { Circle x6 }

  psfCommands : Array [ 01..psfCommandMax ] of String [20] = (
    { 01..04 } 'Yes', 'BoldYes', 'No', 'BoldNo',
    { 05..09 } 'PenUp', 'PenDown', 'NoPen', 'PenHead1', 'PenHead2',
    { 10..12 } 'WriteDown', 'See', 'BlackSee',
    { 13..16 } 'Telephone', 'PublicPhone', 'Airplane', 'Mail',
    { 17..21 } 'OK', 'Wrong', 'Wait', 'FirstAid', 'OutlineFirstAid',
    { 22..25 } 'Cutter', 'BlackCutter', 'CutUp', 'CutDown',
    { 26..30 } 'Flower', 'BlackFlower', 'OutlineFlower', 
               'bwFlower1', 'bwFlower2',
    { 31..33 } 'Cross', 'ShadowCross', 'OutlineCross',
    { 34..44 } 'Star', 'BlackStar', 'ShadowStar',
               'Star4', 'Star6', 'Star8', 'Star12',
               'CircleInStar', 'CircleInBlackStar', 
               'OutlineStar', 'OutlineBlackStar',
    { 45..52 } 'BlackBox', 'ShadowUpBox', 'ShadowDownBox',
               'MotionUpBox', 'MotionDownBox',
               'HalfBox', 'TallBox', 'ThinBox',
    { 53..54 } 'TriUp', 'TriDown',
    { 55..60 } 'BlackCircle', 'ShadowCircle', 'HalfCircle',
               'StarInCircle', 'cStarInCircle', 'DriveCircle' );

  function PDF_FindSymbol ( _str : String ) : Word;

Implementation

Uses {$ifndef Pascal} SysUtils, {$endif}
     _StrNum_;

function PDF_FindSymbol ( _str : String ) : Word;
var _at : Word;
begin
  _str := UpperCase ( Trim ( _str ) ); _at := Length ( _str );
  if _at > 0 then begin
    _at := Length ( psfList );
    while ( _at > 0 ) and ( _str <> UpperCase ( psfCommands [ _at ] ) ) do
      Dec ( _at );
  end;
  PDF_FindSymbol := _at;
end;

end.
