Unit pdfFrTxt;

{$I DelVer.inc}

interface

  procedure PDF_CreateFromFile ( _inputfilename, _pdffilename : String );


implementation
 
uses
  {$ifdef Pascal} DOS,
  {$else}         SysUtils,
    {$ifndef WIN32}
      WinTypes, WinProcs,
    {$else}
      Windows,
    {$endif}
  {$endif}
  _StrNum_, pdfCmd;


procedure PDF_CreateFromFile ( _inputfilename, _pdffilename : String );
var _inputfile : Text; _at : Word; _str : String;

  procedure __WritePages;
  var _streamBegin : Longint; _str1, _str2 : String; _nextColumn : Boolean;
  begin
    while ( not eof ( _inputfile ) ) do begin
      ReadLn ( _inputfile, _str1 );
      repeat
        if ( pdf_pagesetup.currentColumn = 0 ) and ( pdf_pagesetup.currentRow = 0 ) then
          _streamBegin := PDF_StartPage;
        if pdf_textcontrol.WordWrap then
          _str2 := PDF_WordWrap ( _str1, pdf_pagesetup.columns [ pdf_pagesetup.currentColumn,
                                                                 pdf_pagesetup.currentRow ].charCount )
        else begin _str2 := _str1; _str1 := ''; end;
        if ( not ( PDF_SpecialParser ( _str2, _str1 ) ) ) then begin
          _nextColumn := PDF_TextParser ( _str2, _str1 );
          PDF_WriteLn ( _str2 );

          with pdf_pagesetup do begin
            Inc ( columns [ currentColumn, currentRow ].currentPoint.y, columnLeadingPointSize );
            if ( columns [ currentColumn, currentRow ].currentPoint.y + columnLeadingPointSize >
                 columns [ currentColumn, currentRow ].workarea.bottom ) or ( _nextColumn ) then
              PDF_NextColumn ( _streamBegin );
          end;
        end;
      until _str1 = '';
    end;
    if pdf_pagesetup.currentColumn >= 01 then PDF_EndPage ( _streamBegin );
  end;

begin
  if Length ( Trim ( _pdffilename ) ) = 0 then _pdffilename := _inputfilename;
  _pdffilename := Trim ( _pdffilename );
  if ( UpperCase ( Copy ( _pdffilename, Length ( _pdffilename ) - 03, 04 ) ) <> '.PDF' ) then begin
    _at := RPos ( '.', _pdffilename );
    if _at = 0 then _at := Length ( _pdffilename ) + 01;
    _pdffilename := Copy ( _pdffilename, 01, _at - 01 ) + '.pdf';
  end;
  Assign ( _inputfile, _inputfilename ); Reset ( _inputfile );

  SetScriptStyle ( _inputfilename );
  PDF_Open ( _pdffilename );
  PDF_Reset;
  PDF_WriteHeader;
  __WritePages;
  PDF_Close;
  { SetScript2Html; - reset back to "HTML Script Style" if necessary }
  Close ( _inputfile );
end;

end.

