Unit pdfCmd;

{$I DelVer.inc}

{ *********************************************************************** }
{       Delphi Component : PasPDF - Native PDF Creation for Delphi        }
{ ***************************** n o t i c e ***************************** }
{ "PasPDF" distributed as "FREEWARE Delphi Component" with source code.   }
{ You need to pay "SOURCE CODE DISTRIBUTION LICENCE" if source code of    }
{ "PasPDF" has been modified or distributed with your Commercial Delphi   }
{ Products. In this case, contact me for further information via e-mail : }
{                                               gongxi@tm.net.my (tkcham) }
{ *********************************************************************** }
{     Copyright [c] 1998-99 VISION Software (M) Sdn. Bhd. (393369-T)      }
{ *********************************************************************** }

{ *chg* v0.943 - fix bugs in "margin / columnMargin"      }
{ *hint* - PDF using "Bottom-Top" to draw the graphic     }
{        - margin.top    will be changed to margin.bottom }
{        - margin.bottom will be changed to margin.top    }

Interface

const

  PDF_MAXCOLUMNS  = 08; { you may change this but... }
  PDF_MAXROWS     = 04; { you may change this but... }

  PDF_MAXPSTYPE1  = 14; { max. standard PostScript Font Type 1 }

type

  pdf_textcontrolType = record
                FormFeed : Boolean;
                WordWrap : Boolean; { *new* v0.930 }
                 TabSize : Word;
  end;

  pdf_docInfoType = record
    Title,             { <filename>                 e.g. Acrobat Reader 3.0 Online Guide      }
    Subject,           { <none>                     e.g. HELP                                 }
    Author,            { <none>                     e.g. Adobe User Education                 }
    KeyWords,          { <none>                     e.g. Reader, Acrobat, help, online guide  }
    Creator,           { pdf_libname+pdf_libversion e.g. FrameMaker 5.1.1                     }
    Producer : String; { pdf_appname+pdf_appversion e.g. Acrobat Distiller 3.0 for Windows 95 }
  end;

  PaperSizeType = record
    width, height : Word;
  end;

  { *new* v0.940 *start* Graphic Control - *beta* }
  pdf_dashpatternType = ( pdpRegular, pdpSolid, pdp33, pdp1222,
                          pdp2121, pdp23535, pdp13232 );
  { *new* v0.940 *end* Graphi Control - *beta* }

  { *new* v0.940 *start* Page Setup - Margin / Column Control }

  columnBorderType = ( cbRegular, cbSplitter, cbBorder ); { *chg* v0.942 }

  MarginType = record
    top, bottom, left, right, width, height : Word;
  end;

  LocationType = record
    x, y : Word;
  end;

  columnType = record
    workarea          : MarginType;   { runtime - PDF_FixPageSetup }
    charCount         : Word;         { runtime - PDF_FixPageSetup }
    lineCount         : Word;         { runtime - PDF_FixPageSetup }
    currentpoint      : LocationType; { runtime - application }
    currentCharPoint  : Word;         { runtime - application }
    currentline       : Word;         { runtime - application }
  end;

  PageSetupType = record
    papersize         : PaperSizeType;       { user-definable }
    { *new* v0.942 *start* landscape and mediasize }
    landscape         : Boolean;             { user-definable }
    mediasize         : PaperSizeType;       { runtime - PDF_FixPageSetup }
    { *new* v0.942 *end* landscape and mediasize }
    margin            : MarginType;          { user-definable }
    pageBorder        : Boolean;             { user-definable }
    columnBorder      : columnBorderType;    { user-definable }
    borderDashPattern : pdf_dashPatternType; { user-definable }
    columnMargin      : MarginType;          { user-definable }
    columnGap         : LocationType;        { user-definable }
    columnCount       : Word;                { user-definable }
    rowCount          : Word;                { user-definable }
    fontPointSize     : Word;                { user-definable }
    columnFontPointSize    : Word;           { user-definable }
    leadingPointSize  : Word;                { runtime - PDF_FixPageSetup }
    columnLeadingPointSize : Word;           { runtime - PDF_FixPageSetup }
    charCount         : Word;                { runtime - PDF_FixPageSetup }
    workarea          : MarginType;          { runtime - PDF_FixPageSetup }
    currentpoint      : LocationType;        { runtime - application }
    currentpage       : Word;                { runtime - application }
    currentColumn     : Word;                { runtime - application }
    currentRow        : Word;                { runtime - application }
    columns           : Array [ 01..PDF_MAXCOLUMNS, 01..PDF_MAXROWS ] of columnType;
                                             { runtime - PDF_FixPageSetup + application -> columnCount }
  end;

  { *new* v0.940 *end* Page Setup - Margin / Column Control }

  { *new* v0.940 *start* Text Rendering and Page Mode / Layout Control }
  pdf_textrendingType = ( ptrRegular, ptrFill,     ptrStroke,     ptrFillStroke,     ptrInvisible,
                                      ptrClipFill, ptrClipStroke, ptrClipFillStroke, ptrClipText );
  pdf_pagemodeType = ( ppmRegular, ppmOutlines, ppmThumbs, ppmFullScreen );
  { *new* v0.940 PageMode / PageLayout }
  pdf_pagelayoutType = ( pplRegular, pplSinglePage, pplOneColumn, pplTwoColumnLeft, pplTwoColumnRight );
  { *new* v0.940 *end* Text Rendering and Page Mode / Layout Control }

  pdf_outlineType = record
    objid, page : Word;
    title : String [60];
  end;

  pdf_fonttypeType = ( pftPsType1, pftTrueType );
  pdf_fontEncodingType = ( pfeNoEncoding, pfeMacRomanEncoding, pfeWinAnsiEncoding );

  ColorRGBType = record       { *new* v0.930 Font Color }
    red, green, blue : Byte;
  end;

const

  { PasPDF - library identification }
  pdf_libname      : String = 'PasPDF'; { do not change }
  {$ifdef PDF_PRO}
    { professional edition : source codes included for 32-bit Delphi }
    { you may change -> e.g.   0.943Pa }
    pdf_libversion : String = '0.943P';
  {$else}
    pdf_libversion : String = '0.943'; { freeware edition }
  {$endif}
  pdf_libcopyright : String = 'VISION Software (M) Sdn. Bhd.'; { do not change }

  { PasPDF - application identification }
  pdf_appname       : String = ''; { 'txt2pdf for DOS' }
  pdf_appversion    : String = ''; { '1.0' }
  pdf_appcopyright  : String = ''; { 'gongxi@tm.net.my' }

  pdf_fileversion   : String = '1.2'; { default PDF version }

  pdf_objidResources : Word   = 00; { object for /Resources }
  pdf_objidKids      : Word   = 00; { object for /Pages }
  pdf_objidFont      : Word   = 00; { object for /Font  }
  pdf_objidSymbolic  : Word   = 00; { object for "Symbolic Font" ZapfDingbats }
  pdf_objidOutlines  : Word   = 00; { object for /Outlines }

  pdf_ps1Courier    = 01;
  pdf_ps1Helvetica  = 05;
  pdf_ps1TimesRoman = 10;

  pdf_ps1fontname : Array [ 01..PDF_MAXPSTYPE1 ] of String =
    ( 'Courier',
      'Courier-Bold',
      'Courier-Oblique',
      'Courier-BoldOblique',
      'Helvetica',
      'Helvetica-Bold',
      'Helvetica-Oblique',
      'Helvetica-BoldOblique',
      'Symbol',
      'Times-Roman',
      'Times-Bold',
      'Times-Italic',
      'Times-BoldItalic',
      'ZapfDingbats' );

  pdf_objShortEnd    = 'endobj';
  pdf_objEnd         = '>> ' + pdf_objShortEnd;

  pdf_objStreamBegin = 'stream';
  pdf_objStreamEnd   = 'endstream' + #13 + pdf_objShortEnd;

  pdf_fonttype : pdf_fonttypeType = pftPsType1;

  pdf_fontEncoding : pdf_fontEncodingType = pfeNoEncoding;
  pdf_fontForceASCII : Boolean = False;

  pfsRegular    = $00;
  pfsBold       = $01;
  pfsItalic     = $02;
  pfsBoldItalic = pfsBold + pfsItalic;

  pdf_fontStyle : Word = pfsRegular;

  { *new* v0.940 *start* multi-font control }
  pdf_fontidCount    : Word = 0;
  pdf_fontidDefault  : Word = 0;
  pdf_fontidSymbolic : Word = 0;
  { *new* v0.940 *end* multi-font control }

  { *new* v0.940 *start* PageMode / PageLayout }
  pvpRegular          = $00;
  pvpHideToolBar      = $01; { boolean = false }
  pvpHideMenuBar      = $02; { boolean = false }
  pvpHideWindowUI     = $04; { boolean = false }
  pvpFitWindow        = $08; { boolean = false }
  pvpCenterWindow     = $10; { boolean = false }
{ pvpPageLayout       -> ppl* }

  pdf_textrending : pdf_textrendingType = ptrRegular;
  pdf_pagemode : pdf_pagemodeType = ppmRegular;
  pdf_viewerPreferences     : Word = pvpRegular;
  pdf_vpPageLayout          : pdf_pagelayoutType = pplRegular;
  pdf_nonFullScreenPageMode : pdf_pagemodeType = ppmRegular;
                              { valid for pdf_pagemode = ppmFullScreen
                                after existing Full Screen Mode }
  { *new* v0.940 *end* PageMode and PageLayout }

  pdf_styler    : Boolean = False;
  pdf_symbolic  : Boolean = False; { *new* v0.940 }
  pdf_pageTitle : String  = '';    { *new* v0.930 }
  pdf_outline   : Boolean = False; { *new* v0.943 }

  pdf_pointsPerInch = 72; { Point Size Reference : 12p = 72 = 7.2 per character }

  { *new* v0.940 *start* Outline Control }
  pdf_outlineCount   : Word   = 00; { Total Number of Outlines }
  { *new* v0.940 *end* Outline Control }

  pdf_currentobject  : Word   = 00; { Current Object }
  pdf_currentfilepos : Longint = 0; { Current File Position }

var pdf_fontname : String;
    pdf_textcontrol : pdf_textcontrolType;
    pdf_docInfo : pdf_docInfoType;

    pdf_systemTextControl : pdf_textcontrolType;
    pdf_systemDocInfo : pdf_docInfoType;

    PaperSizeLetter     : PaperSizeType;
    PaperSizeA4         : PaperSizeType;
    PaperSizeA3         : PaperSizeType;
    PaperSizeLegal      : PaperSizeType; { *new* v0.930 }
    PaperSizeB5         : PaperSizeType; { *new* v0.930 }
    PaperSizeC5         : PaperSizeType; { *new* v0.930 }
    PaperSize8x11       : PaperSizeType;
    PaperSizeB4         : PaperSizeType; { *new* v0.942 }
    PaperSizeA5         : PaperSizeType; { *new* v0.942 }
    PaperSizeFolio      : PaperSizeType; { *new* v0.942 }
    PaperSizeExecutive  : PaperSizeType; { *new* v0.942 }
    PaperSizeEnvB4      : PaperSizeType; { *new* v0.942 }
    PaperSizeEnvB5      : PaperSizeType; { *new* v0.942 }
    PaperSizeEnvC6      : PaperSizeType; { *new* v0.942 }
    PaperSizeEnvDL      : PaperSizeType; { *new* v0.942 }
    PaperSizeEnvMonarch : PaperSizeType; { *new* v0.942 }
    PaperSizeEnv9       : PaperSizeType; { *new* v0.942 }
    PaperSizeEnv10      : PaperSizeType; { *new* v0.942 }
    PaperSizeEnv11      : PaperSizeType; { *new* v0.942 }

    pdf_systemPaperSize : PaperSizeType;
    pdf_systemFontName : String;

    { *new* v0.943 *start* Font Point Size }
    pdf_fontOldPointSizeID : Byte;
    pdf_fontOldPointSizes : Array [ 01..64 ] of Word;
    { *new* v0.930 *start* Font Color }
    pdf_fontOldColorID : Byte;
    pdf_fontOldColors     : Array [ 01..64 ] of ColorRGBType;
    pdf_fontColor : ColorRGBType;
    pdf_fcRed     : ColorRGBType;
    pdf_fcGreen   : ColorRGBType;
    pdf_fcBlue    : ColorRGBType;
    pdf_fcBlack   : ColorRGBType;
    pdf_fcWhite   : ColorRGBType;
    pdf_fcYellow  : ColorRGBType;
    pdf_fcCyan    : ColorRGBType;
    pdf_fcGray    : ColorRGBType;
    pdf_fcBrown   : ColorRGBType;
    pdf_fcLtRed   : ColorRGBType;
    pdf_fcLtBlue  : ColorRGBType;
    pdf_fcLtGreen : ColorRGBType;
    pdf_fcMagenta : ColorRGBType;
    pdf_fcOrange  : ColorRGBType;
    pdf_fcTeal    : ColorRGBType;

    { *new* v0.930 *end* Font Color }

    pdf_pagesetup : PageSetupType; { *new* v0.940 }
    pdf_filename : String; { *new* 0.945 }

  function  PDF_mm2pdf ( _mm : Word ) : Word;
  function  PDF_pdf2mm ( _pdf : Word ) : Word;
  function  PDF_in2pdf ( _in : {$ifdef Pascal}Real{$else}Extended{$endif} ) : Word;
  function  PDF_pdf2in ( _pdf : Word ) : {$ifdef Pascal}Real{$else}Extended{$endif};
  function  PDF_pdf2mmStr ( _pdf : Word ) : String;
  function  PDF_pdf2inStr ( _pdf : Word ) : String;
  function  PDF_str2pdf   ( _str : String ) : Word;

  function  PDF_CalcTextLeadingPointSize ( _fontsize : Word ) : Word;
  procedure PDF_FixPageSetup;

  function  PDF_CurrentDateTime : String;
  function  PDF_objShortBegin : String;
  function  PDF_objBegin : String;
  function  PDF_objIndirect ( _obj : Word ) : String;

  function  PDF_GetDashPattern ( _pdp : pdf_dashpatternType ) : String;
  function  PDF_GetSymbol ( _str : String ) : String;
  function  PDF_SetSymbol ( _str : String ) : String;

  function  PDF_SetFontPointSize ( _cstr : String ) : String;
  function  PDF_ResetFontPointSize : String;
  function  PDF_SetFontColor ( _cstr : String) : String;
  function  PDF_ResetFontColor : String;
  function  PDF_SetFontStyle ( _style : Word ) : String;
  function  PDF_ResetFontStyle ( _style : Word ) : String;
  function  PDF_WordWrap ( var _str : String; _count : Word ) : String;
  function  PDF_SpecialParser ( var _str2, _str1 : String ) : Boolean; { special command if true }
  function  PDF_TextParser ( var _str2, _str1 : String ) : Boolean; { next column if true }
  function  PDF_AdjustTj ( _str : String ) : String;

  procedure PDF_AddOutlineTitle ( _page : Word; _title : String );
  procedure PDF_Open ( _fn : String );
  procedure PDF_Reset;
  procedure PDF_WriteHeader;

  function  PDF_StartPage : Longint;
  procedure PDF_EndPage ( _streamBegin : Longint );
  procedure PDF_NextColumn ( _streamBegin : LongInt );

  procedure PDF_Write ( _str : String );
  procedure PDF_WriteLn ( _str : String );

  procedure PDF_Close;

Implementation

Uses
  {$ifdef Pascal} DOS,
  {$else}         SysUtils,
    {$ifndef WIN32}
      WinTypes, WinProcs,
    {$else}
      Windows,
    {$endif}
  {$endif}
  _StrNum_,
  PdfSign;

const
  PDF_MAXKIDS     = 500;
  PDF_MAXOBJECTS  = 1000;
  PDF_MAXOUTLINES = 250;

var pdf_filehandle : FILE;
    pdf_pageKids : Array [01..PDF_MAXKIDS] of Integer;
    pdf_objFilePos : Array [01..PDF_MAXOBJECTS] of Longint;
    pdf_outlines : Array [01..PDF_MAXOUTLINES] of pdf_outlineType;

function  PDF_mm2pdf ( _mm : Word ) : Word;
begin
  PDF_mm2pdf := Round ( _mm * 2.83333333 );
end;

function  PDF_pdf2mm ( _pdf : Word ) : Word;
begin
  PDF_pdf2mm := Round ( _pdf / 2.83333333 );
end;

function  PDF_in2pdf ( _in : {$ifdef Pascal}Real{$else}Extended{$endif} ) : Word;
begin
  PDF_in2pdf := Round ( _in * 72 );
end;

function  PDF_pdf2in ( _pdf : Word ) : {$ifdef Pascal}Real{$else}Extended{$endif};
begin
  PDF_pdf2in := _pdf / 72;
end;

function  PDF_pdf2mmStr ( _pdf : Word ) : String;
begin
  PDF_pdf2mmStr := WordToStr ( PDF_pdf2mm ( _pdf ), 0 );
end;

function  PDF_pdf2inStr ( _pdf : Word ) : String;
begin
  PDF_pdf2inStr := ThreeDecPtStr ( PDF_pdf2in ( _pdf ) );
end;

function  PDF_str2pdf ( _str : String ) : Word;
var _at : Word;
begin
  _at := Pos ( 'MM', UpperCase (_str ) );
  if _at >= 01 then begin
    _at := PDF_mm2pdf ( StrToWord ( Trim ( Copy ( _str, 01, _at - 01 ) ) ) );
  end
  else begin
    _at := Pos ( 'IN', UpperCase (_str ) );
    if _at >= 01 then begin
      _at := PDF_in2pdf ( StrToFloat ( Trim ( Copy ( _str, 01, _at - 01 ) ) ) );
    end
    else begin
      _at := StrToWord ( Trim ( _str ) );
    end;
  end;
  PDF_str2pdf := _at;
end;

function  PDF_CalcTextLeadingPointSize ( _fontsize : Word ) : Word;
begin
 if _fontsize <= 0 then _fontsize := 10;
 PDF_CalcTextLeadingPointSize := Round ( ( _fontsize * 14.5 ) / 12 );
end;

procedure PDF_FixPageSetup;
var _at, _xp, _yp, _xw, _yw, _c, _r : Word; _column : columnType;
begin
  with pdf_pagesetup do begin

    { ----------------- user-definable ----------------- }
    {           papersize -> width, height               }
    {           landscape -> Yes/No                      }
    {              margin -> top, bottom, left, right    }
    {              border -> Yes/No                      }
    {        columnBorder -> Yes/No                      }
    {   borderDashPattern -> pdf_dashpatternType         }
    {        columnMargin -> top, bottom, left, right    }
    {         columnCount -> 1..8  as PDF_MAXCOLUMNS     }
    {            rowCount -> 1..4  as PDF_MAXROWS        }
    {       fontPointSize -> default to [initialization] }
    { columnFontPointSize -> default to [initialization] }
    { -------------------------------------------------- }

    { <Page> calculate "TL" (Text Leading) in Point Size from "Tf" (Text Font) }
    if fontPointSize <= 0 then fontPointSize := 10;
    leadingPointSize := PDF_CalcTextLeadingPointSize ( fontPointSize );

    { <column> calculate "TL" (Text Leading) in Point Size from "Tf" (Text Font) }
    if columnFontPointSize <= 0 then columnFontPointSize := 10;
    columnLeadingPointSize := PDF_CalcTextLeadingPointSize ( columnFontPointSize );

    { calculate actual height and width for "Landscape" }
    if landscape then begin
      mediasize.height := papersize.width;
      mediasize.width  := papersize.height;
      end
    else begin
      mediasize.height := papersize.height;
      mediasize.width  := papersize.width;
    end;
    { calculate "page workarea" - absolute address location in Point Size }
    with workarea do begin
      top    := margin.bottom;                 
      if Length ( pdf_pageTitle ) >= 01 then
        Inc ( top, Round ( leadingPointSize * 1.5 ) );
      bottom := mediasize.height - margin.top; 
      left   := margin.left;
      right  := mediasize.width  - margin.right;

      height := bottom - top + 01; { runtime calculation here }
      width  := right - left + 01; { runtime calculation here }
    end;

    { calculate "characters per line" }
    charCount := Round ( workarea.width * 11.5 ) div pdf_pointsPerInch;

    { calculate "column workarea" - absolute address location in Point Size }
    if columnCount <= 0 then columnCount := 01;
    if columnCount > PDF_MAXCOLUMNS then columnCount := PDF_MAXCOLUMNS;
    if rowCount    <= 0 then rowCount    := 01;
    if rowCount    > PDF_MAXROWS    then rowCount    := PDF_MAXROWS;
    if ( columnCount = 01 ) and ( rowCount = 01 ) then begin
      columns [ 01, 01 ].workarea  := workarea;
      columns [ 01, 01 ].charCount := charCount; end
    else begin
      if columnCount > 01 then
        _xw := ( workarea.width div columnCount ) -
               ( columnMargin.left + columnMargin.right  + columnGap.x )
      else
        _xw := workarea.width;
      if rowCount > 01 then
        _yw := ( workarea.height div rowCount ) -
               ( columnMargin.top  + columnMargin.bottom + columnGap.y )
      else
        _yw := workarea.height;

      _c := 01; _r := 01;
      while ( ( _c <= columnCount ) and ( _r <= rowCount ) ) do begin
        if _c = 01 then begin
          _xp := workarea.left;
          if columnCount > 01 then Inc ( _xp, columnMargin.left );
        end;
        if _r = 01 then begin
          _yp := workarea.top;
          if rowCount    > 01 then Inc ( _yp, columnMargin.bottom ); 
        end;
        columns [ _c, _r ].workarea.top    := _yp;
        columns [ _c, _r ].workarea.bottom := _yp + _yw;
        columns [ _c, _r ].workarea.left   := _xp;
        columns [ _c, _r ].workarea.right  := _xp + _xw;
        columns [ _c, _r ].workarea.width  := 
          columns [ _c, _r ].workarea.right -
          columns [ _c, _r ].workarea.left + 01;
        columns [ _c, _r ].workarea.height :=
          columns [ _c, _r ].workarea.bottom -
          columns [ _c, _r ].workarea.top + 01;
        columns [ _c, _r ].charCount := Round ( columns [ _c, _r ].workarea.width * 11.5 ) div pdf_pointsPerInch;

        Inc ( _c );
        if _c > columnCount then begin
          Inc ( _r );
          if ( not ( _r > rowCount ) ) then begin
            _c := 01;
            Inc ( _yp, _yw + columnMargin.bottom + columnGap.y +
                             columnMargin.top );
          end;
        end
        else begin
          Inc ( _xp, _xw + columnMargin.right + columnGap.x +
                           columnMargin.left );
        end;
      end;
      { PDF always drawing from bottom-up }
      _yp := rowCount div 02; _r := 0;
      while ( _r < _yp ) do begin
       Inc ( _r );
       _c := 0;
       while _c < columnCount do begin
         Inc ( _c );
         _column := columns [ _c, _r ];
         columns [ _c, _r ] := columns [ _c, rowCount - _r + 01 ];
         columns [ _c, rowCount - _r + 01 ] := _column;
       end;
      end;
    end;
  end;
end;

function  __rgStr ( _str : String) : String;
begin
  if '0.' = Copy ( _str, 01, 02 ) then Delete ( _str, 01, 01 );
  __rgStr := _str;
end;

function  __CurrentFontColor : String;
begin
  with pdf_fontColor do
    __CurrentFontColor := __rgStr ( ThreeDecPtStr ( red / 255 ) )   + ' ' +
                          __rgStr ( ThreeDecPtStr ( green / 255 ) ) + ' ' +
                          __rgStr ( ThreeDecPtStr ( blue / 255 ) )  + ' rg';
end;

function  __CurrentFontStyle : String;
begin
  case pdf_fontStyle of
    pfsBold :
      __CurrentFontStyle := '/F2 ' + WordToStr ( pdf_pagesetup.columnFontPointSize, 0 ) + ' Tf';
    pfsItalic :
      __CurrentFontStyle := '/F3 ' + WordToStr ( pdf_pagesetup.columnFontPointSize, 0 ) + ' Tf';
    pfsBoldItalic :
      __CurrentFontStyle := '/F4 ' + WordToStr ( pdf_pagesetup.columnFontPointSize, 0 ) + ' Tf';
    else pdf_fontStyle := pfsRegular;
  end;
  if pdf_fontStyle = pfsRegular then
    __CurrentFontStyle := '/F1 ' + WordToStr ( pdf_pagesetup.columnFontPointSize, 0 ) + ' Tf';
end;

function PDF_GetDashPattern ( _pdp : pdf_dashPatternType ) : String;
begin
  case _pdp of
    pdpRegular   : PDF_GetDashPattern := '';
    pdpSolid     : PDF_GetDashPattern := '[] 0 d';
    pdp33        : PDF_GetDashPattern := '[3] 0 d';
    pdp1222      : PDF_GetDashPattern := '[2] 0 d';
    pdp2121      : PDF_GetDashPattern := '[2 1] 0 d';
    pdp23535     : PDF_GetDashPattern := '[3 5] 6 d';
    pdp13232     : PDF_GetDashPattern := '[2 3] 11 d';
  end;
end;

function  PDF_GetSymbol ( _str : String ) : String;
var _at : Word;
begin
  { parsing HTML remark as <!! --> }
  while ( Length ( _str ) > 01 ) and
        ( Copy ( _str, Length ( _str ), 01 ) = '-' ) do
    Delete ( _str, Length ( _str ), 01 );
  _at := PDF_FindSymbol ( _str );
  if _at = 0 then begin { *chg* v0.943 }    
    if Copy ( _str, 01, 01 ) = '\' then { for "\\" "\(" "\)" }
      PDF_GetSymbol := Copy ( _str, 02, 01 )
    else if Copy ( _str, 01, 01 ) = '#' then { for "#hh" ascii in hex }
      PDF_GetSymbol := Chr ( HexToWord ( Copy ( _str, 02, 02 ) ) )
    else
      PDF_GetSymbol := Copy ( _str, 01, 01 ); end
  else            PDF_GetSymbol := Copy ( psfList, _at, 01 );
end;

function  PDF_SetSymbol ( _str : String ) : String;
begin
  _str := PDF_GetSymbol ( _str );
  if _str = '' then PDF_SetSymbol := ''
  else begin
    if Pos ( _str, '()\' ) >= 01 then _str := '\' + _str;
    PDF_SetSymbol := '/F' + WordToStr ( pdf_fontidSymbolic, 0 ) + ' ' +
                     WordToStr ( pdf_pagesetup.columnFontPointSize, 0 ) + ' Tf' +
                     ' (' + _str + ') ' +
                    __CurrentFontStyle;
  end;

end;

function  PDF_SetFontPointSize ( _cstr : String ) : String;
var _w : Word;
begin
  Inc ( pdf_fontOldPointSizeID );
  pdf_fontOldPointSizes [ pdf_fontOldPointSizeID ] := pdf_pagesetup.columnFontPointSize;
  if Copy ( _cstr, 01, 01 ) = '"' then Delete ( _cstr, 01, 01 );
  if Copy ( _cstr, Length ( _cstr ), 01 ) = '"' then Delete ( _cstr, Length ( _cstr ), 01 );
  _cstr := Trim ( _cstr );
  if Copy ( _cstr, 01, 01 ) = '+' then begin
    { <font pointsize=+5> -or- <font pointsize=+50%> }
    if Length ( _cstr ) = 01 then _w := 01
    else begin
      if Copy ( _cstr, Length ( _cstr ), 01 ) = '%' then begin
        _w := StrToWord ( Copy ( _cstr, 02, Length ( _cstr ) - 02 ) );
        if _w > 0 then _w := Round ( pdf_pagesetup.columnFontPointSize * _w / 100 );
        end
      else
        _w := StrToWord ( Copy ( _cstr, 02, Length ( _cstr ) - 01 ) );
    end;
    Inc ( pdf_pagesetup.columnFontPointSize, _w );
  end
  else if Copy ( _cstr, 01, 01 ) = '-' then begin
    { <font pointsize=-5> -or- <font pointsize=-50%> }
    if Length ( _cstr ) = 01 then _w := 01
    else begin
      if Copy ( _cstr, Length ( _cstr ), 01 ) = '%' then begin
        _w := StrToWord ( Copy ( _cstr, 02, Length ( _cstr ) - 02 ) );
        if _w > 0 then _w := Round ( pdf_pagesetup.columnFontPointSize * _w / 100 );
        end
      else
        _w := StrToWord ( Copy ( _cstr, 02, Length ( _cstr ) - 01 ) );
    end;
    Dec ( pdf_pagesetup.columnFontPointSize, _w );
  end
  else if Copy ( _cstr, Length ( _cstr ), 01 ) = '%' then begin
    { <font pointsize=120%> -or- <font pointsize=60%> }
    _w := StrToWord ( Copy ( _cstr, 01, Length ( _cstr ) - 01 ) );
    if _w > 0 then
      pdf_pagesetup.columnFontPointSize := Round ( pdf_pagesetup.columnFontPointSize * _w / 100 );
  end
  else if Length ( _cstr ) >= 01 then
    { <font pointsize=15> -or- <font pointsize=12> }
    pdf_pagesetup.columnFontPointSize := StrToWord ( _cstr );
  pdf_pagesetup.columnLeadingPointSize := PDF_CalcTextLeadingPointSize ( pdf_pagesetup.columnFontPointSize );
  PDF_SetFontPointSize := __CurrentFontStyle +
      ' ' + WordToStr ( pdf_pagesetup.columnLeadingPointSize, 0 ) + ' TL';
end;

function  PDF_ResetFontPointSize : String;
begin
  if pdf_fontOldPointSizeID > 0 then begin
    pdf_pagesetup.columnFontPointSize := pdf_fontOldPointSizes [ pdf_fontOldPointSizeID ];
    pdf_pagesetup.columnLeadingPointSize := PDF_CalcTextLeadingPointSize ( pdf_pagesetup.columnFontPointSize );
    PDF_ResetFontPointSize := __CurrentFontStyle +
      ' ' + WordToStr ( pdf_pagesetup.columnLeadingPointSize, 0 ) + ' TL';
    Dec ( pdf_fontOldPointSizeID );
    end
  else
    PDF_ResetFontPointSize := '';
end;

function  PDF_SetFontColor ( _cstr : String ) : String;
begin
  Inc ( pdf_fontOldColorID );
  pdf_fontOldColors [ pdf_fontOldcolorID ] := pdf_fontColor;
  if Copy ( _cstr, 01, 01 ) = '"' then Delete ( _cstr, 01, 01 );
  if Copy ( _cstr, Length ( _cstr ), 01 ) = '"' then Delete ( _cstr, Length ( _cstr ), 01 );
  _cstr := Trim ( _cstr );
  if Copy ( _cstr, 01, 01 ) = '#' then begin { <font color=#000000 }
    with pdf_fontColor do begin
      red   := HexToWord ( Copy ( _cstr, 02, 02 ) );
      green := HexToWord ( Copy ( _cstr, 04, 02 ) );
      blue  := HexToWord ( Copy ( _cstr, 06, 02 ) );
    end;
    end
  else begin
    _cstr := UpperCase ( _cstr );
    if      _cstr = 'RED'        then pdf_fontColor := pdf_fcRed
    else if _cstr = 'GREEN'      then pdf_fontColor := pdf_fcGreen
    else if _cstr = 'BLUE'       then pdf_fontColor := pdf_fcBlue
    else if _cstr = 'BLACK'      then pdf_fontColor := pdf_fcBlack
    else if _cstr = 'WHITE'      then pdf_fontColor := pdf_fcWhite
    else if _cstr = 'YELLOW'     then pdf_fontColor := pdf_fcYellow
    else if _cstr = 'CYAN'       then pdf_fontColor := pdf_fcCyan
    else if _cstr = 'GRAY'       then pdf_fontColor := pdf_fcGray
    else if _cstr = 'BROWN'      then pdf_fontColor := pdf_fcBrown
    else if _cstr = 'LTRED'      then pdf_fontColor := pdf_fcLtRed
    else if _cstr = 'LTGREEN'    then pdf_fontColor := pdf_fcLtGreen
    else if _cstr = 'LTBLUE'     then pdf_fontColor := pdf_fcLtBlue
    else if _cstr = 'MAGENTA'    then pdf_fontColor := pdf_fcMagenta
    else if _cstr = 'ORANGE'     then pdf_fontColor := pdf_fcOrange
    else if _cstr = 'TEAL'       then pdf_fontColor := pdf_fcTeal
    ;
  end;
  PDF_SetFontColor := __CurrentFontColor;
end;

function  PDF_ResetFontColor : String;
begin
  if pdf_fontOldColorID > 0 then begin
    pdf_fontColor      := pdf_fontOldColors [ pdf_fontOldColorID ];
    PDF_ResetFontColor := __CurrentFontColor;
    Dec ( pdf_fontOldColorID ); end
  else
    PDF_ResetFontColor := '';
end;

function  PDF_SetFontStyle ( _style : Word ) : String;
begin
  pdf_fontStyle := pdf_fontStyle or _style;
  PDF_SetFontStyle := __CurrentFontStyle;
end;

function  PDF_ResetFontStyle ( _style : Word ) : String;
begin
  pdf_fontStyle := pdf_fontStyle - _style;
  PDF_ResetFontStyle := __CurrentFontStyle;
end;

function  PDF_CurrentDateTime : String;
{$ifdef Pascal}
  var yr, mth, day, dow, hr, mn, sec, hund : Word;
  begin
    GetDate ( yr, mth, day, dow );
    GetTime ( hr, mn, sec, hund );
    PDF_CurrentDateTime := 'D:' +
      WordToZeroStr ( yr, 04 ) + WordToZeroStr ( mth, 02 ) + WordToZeroStr ( day, 02 ) +
      WordToZeroStr ( hr, 02 ) + WordToZeroStr ( mn,  02 ) + WordToZeroStr ( sec, 02 );
  end;
{$else}
  var _currentTime : TSystemTime;
  begin
    GetSystemTime ( _currentTime );
    with _currentTime do
    PDF_CurrentDateTime := 'D:' +
      WordToZeroStr ( wYear, 04 ) + WordToZeroStr ( wMonth, 02 ) + WordToZeroStr ( wDay, 02 ) +
      WordToZeroStr ( wHour, 02 ) + WordToZeroStr ( wMinute,  02 ) + WordToZeroStr ( wSecond, 02 );
  end;
{$endif}

function  PDF_objShortBegin : String;
begin
  PDF_objShortBegin := WordToStr ( pdf_currentobject, 0 ) + ' 0 obj';
end;

function  PDF_objBegin : String;
begin
  PDF_objBegin := WordToStr ( pdf_currentobject, 0 ) + ' 0 obj <<';
end;

function  PDF_objIndirect ( _obj : Word ) : String;
begin
  PDF_objIndirect := WordToStr ( _obj, 0 ) + ' 0 R';
end;

function  PDF_WordWrap ( var _str : String; _count : Word ) : String;
var _i : Word; 
begin
  if Length ( _str ) > _count then begin
    _i := _count;
    while ( _i > 0 ) and ( Pos ( _str [ _i ], ' ()' ) = 0 ) do Dec ( _i );
    if _i = 0 then _i := _count;
    PDF_WordWrap := Copy ( _str, 01, _i );
    Delete ( _str, 01, _i ); end
  else begin
    PDF_WordWrap := _str; _str := '';
  end;
end;

function  PDF_SpecialParser ( var _str2, _str1 : String ) : Boolean;
var _at1 : Word; _str0 : String; _isSpecial : Boolean;

  procedure __i_ValidateSpecial;
  begin
    Delete ( _str2, script_posresult, script_lenresult );
    _isSpecial := Length ( Trim ( _str2 ) ) = 0;
  end;
  
begin
  _isSpecial := False;
  _at1 := ScriptPos ( _str2, 0 );
  if _at1 >= 01 then begin
    if Pos ( 'PAGEBREAK', UpperCase ( script_textresult ) ) = 01 then begin
      __i_ValidateSpecial;
      if _isSpecial then _str2 := #12
      else Insert ( #12, _str2, _at1 );
      _isSpecial := False; end
    else if Pos ( 'OUTLINE', UpperCase ( script_textresult ) ) = 01 then begin
      _str0 := ScriptReadString ( 'OUTLINE', script_textresult );
      _isSpecial := True;
      if _str0 <> '' then PDF_AddOutlineTitle ( 0, _str0 );
    end;
  end;
  if _isSpecial then __i_ValidateSpecial;
  PDF_SpecialParser := _isSpecial;
end;

function  PDF_TextParser ( var _str2, _str1 : String ) : Boolean;
var _i, _at, _0len, _1len, _2len : Word; _ch : char; _isSpecial, _nextColumn : Boolean; _str3, _str4 : String;

  procedure __pdfValidateOperator;
  begin
     _str3 := ') ' + _str3 + ' (';
     Delete ( _str2, _i, script_lenresult );
     Insert ( _str3, _str2, _i );
     _i := _i + Length ( _str3 ) - 01;
  end;

begin

  _nextColumn := False; _i := 0;
  _0len := Length ( script_start );
  _1len := Length ( script_1start );
  _2len := Length ( script_2start );

  while _i < Length ( _str2 ) do begin
    Inc ( _i );
    _ch := _str2 [ _i ];

    if _ch = #13 then begin
      { -> parsing CRLF : we accept String with CRLF }
      {    move back String to "_str1" for String at the back of "_str2" }
      {    [hint] Unix-Text-File will be parsed correctly (CR only) }
      _str1 := Copy ( _str2, _i + 01, 255 ) + _str1;
      _str2 := Copy ( _str2, 01, _i - 01 ); end
    else if _ch = #10 then begin
      { -> parsing CRLF : we accept String with CRLF }
      {    ignore this ASCII }
      Delete ( _str2, _i, 01 );
      Dec ( _i ); end
    else if _ch = #09 { tab } then begin
      { -> adjust spaces for TAB to correct location }
      Delete ( _str2, _i, 01 );
      Insert ( ReplicateStr ( ' ', pdf_textcontrol.TabSize ), _str2, _i );
      Inc ( _i, pdf_textcontrol.TabSize - 01 ); end
    else if _ch = #12 { formfeed } then begin
      { -> always move to next page/column }
      if ( not pdf_textcontrol.FormFeed ) then begin
        Delete ( _str2, _i, 01 );
        Dec ( _i ); end
      else begin
        _str1 := Copy ( _str2, _i + 01, 255 ) + _str1;
        _str2 := Copy ( _str2, 01, _i - 01 );
        _nextColumn := True;
      end; end
    else begin
      _isSpecial := pdf_styler;
      if _isSpecial then begin
        if _2len >= 01 then _isSpecial := Copy ( _str2, _i, _2len ) = script_2start;
        if ( not _isSpecial ) then begin
          if _1len >= 01 then _isSpecial := Copy ( _str2, _i, _1len ) = script_1start;
        end;
        if ( not _isSpecial ) then begin
          if _0len >= 01 then _isSpecial := Copy ( _str2, _i, _1len ) = script_start;
        end;
      end;
      if _isSpecial then begin
        _at := ScriptPos ( _str2, _i );
        if script_remresult then begin
          Delete ( _str2, _i, 01 ); Inc ( _i ); end
        else if script_posresult >= 01 then begin
          if        'B'   = UpperCase ( script_textresult ) then begin
            _str3 := PDF_SetFontStyle ( pfsBold );
            __pdfValidateOperator; end
          else if   'I'   = UpperCase ( script_textresult ) then begin
            _str3 := PDF_SetFontStyle ( pfsItalic );
            __pdfValidateOperator; end
          else if ( 'BI'  = UpperCase ( script_textresult ) ) or
                  ( 'IB'  = UpperCase ( script_textresult ) ) then begin
            _str3 := PDF_SetFontStyle ( pfsBoldItalic );
            __pdfValidateOperator; end
          else if   '/B'  = UpperCase ( script_textresult ) then begin
            _str3 := PDF_ResetFontStyle ( pfsBold );
            __pdfValidateOperator; end
          else if   '/I'  = UpperCase ( script_textresult ) then begin
            _str3 := PDF_ResetFontStyle ( pfsItalic );
            __pdfValidateOperator; end
          else if ( '/BI' = UpperCase ( script_textresult ) ) or
                  ( '/IB' = UpperCase ( script_textresult ) ) then begin
            _str3 := PDF_ResetFontStyle ( pfsBoldItalic );
            __pdfValidateOperator; end
          else if Pos ( 'S.', UpperCase ( script_textresult ) ) = 01 then begin
            _str3 := PDF_SetSymbol ( Copy ( script_textresult, 03, Length ( script_textresult ) - 02 ) );
            __pdfValidateOperator; end
          else if '/FONT' = UpperCase ( script_textresult ) then begin
            _str3 :=  PDF_ResetFontPointSize + ' ' + PDF_ResetFontColor;
            __pdfValidateOperator; end
          else if Pos ( 'FONT', UpperCase ( script_textresult ) ) = 01 then begin
            _str3 := '';
            _str4 := ScriptReadString ( 'COLOR', script_textresult );
            { if Length ( _str4 ) >= 01 then }
              _str3 := _str3 + PDF_SetFontColor ( _str4 );
            _str4 := ScriptReadString ( 'POINTSIZE', script_textresult );
            { if Length ( _str4 ) >= 01 then }
              _str3 := TrimLeft ( _str3 + ' ' ) + PDF_SetFontPointSize ( _str4 );
            __pdfValidateOperator; end
        end;
      end;
      if ( not _isSpecial ) and ( _ch IN [ '(', ')', '\' ] ) then begin
        { "\" added as request for the rules of PDF formatting }
        Insert ( '\', _str2, _i ); Inc ( _i );
      end;
    end;

  end;

  { Delete unwanted text (blank) due to non-text-operators }
  repeat
    _at := Pos ( ' () ', _str2 );
    if _at >= 01 then Delete ( _str2, _at, 03 );
  until _at = 0;

  if Length ( _str2 ) = 0 then _str2 := '()'
  else begin
    if Pos ( ') ', _str2 ) = 01 then
      Delete ( _str2, 01, 02 )
    else           _str2 := '(' + _str2;
    if Pos ( ' (', _str2 ) = Length ( _str2 ) - 01 then
      Delete ( _str2, Length ( _str2 ) - 01, 02 )
    else           _str2 := _str2 + ')';
    if Copy ( _str2, Length ( _str2 ) - 01, 02 ) = '()' then begin
      Delete ( _str2, Length ( _str2 ) - 01, 02 );
      _str2 := TrimRight ( _str2 );
    end;
  end;
  _str2 := PDF_AdjustTj ( _str2 );

  PDF_TextParser := _nextColumn;
end;

function PDF_AdjustTj ( _str : String ) : String;
var _at : Word; _isText : Boolean;
begin
  _at := 0; _isText := False;
  while _at < Length ( _str ) do begin
    Inc ( _at );
    if Copy ( _str, _at, 01 ) = '(' then _isText := True
    else if _isText then begin
      _isText := Copy ( _str, _at, 01 ) <> ')';
      if not _isText then
        _isText := Copy ( _str, _at - 01, 02 ) = '\)';
    end;
    if ( not ( _isText ) ) and
       ( Copy ( _str, _at, 01 ) = ')' ) then begin
      if ( Copy ( _str, _at + 01, 01 ) <> '''' ) and
         ( Copy ( _str, _at + 01, 03 ) <> ' Tj' ) then begin
        Insert ( ' Tj', _str, _at + 01 );
        Inc ( _at, 03 );
      end;
    end;
  end;
  if Pos ( ' Tj', _str ) >= 01 then _str := 'T* ' + _str;
  _at := Length ( _str );
  while ( _at > 0 ) and ( Copy ( _str, _at, 01 ) <> ')' ) do Dec ( _at );
  if _at >= 01 then begin
    if ( Pos ( 'T* ', _str ) = 0 ) or
       ( _at = Length ( _str ) ) then Insert ( '''', _str, _at + 01 )
    else                              Insert ( ' Tj', _str, _at + 01 );
  end;
  if ( Copy ( _str, Length ( _str ), 01 ) = '''' ) and
     ( Pos ( 'T* ', _str ) = 01 ) then Delete ( _str, 01, 03 );
  repeat
    _at := Pos ( ' Tj Tj', _str );
    if _at >= 01 then Delete ( _str, _at, 03 ); { *fix* v0.931 }
  until _at = 0;
  if _str = 'T* () Tj' then _str := '()'''; { pdf:optimize }
  PDF_AdjustTj := _str;
end;

procedure PDF_AddOutlineTitle ( _page : Word; _title : String );
begin
  if pdf_outlineCount < PDF_MAXOUTLINES then begin
    Inc ( pdf_outlineCount );
    with pdf_outlines [ pdf_outlineCount ] do begin
      if _page > 01 then begin page := _page; objid := 0; end
      else begin objid := pdf_currentobject - 01; end;
      title  := Trim ( _title );
    end;
  end;
end;

procedure PDF_Open ( _fn : String );
begin
  pdf_filename := '';
  Assign ( pdf_filehandle, _fn ); Rewrite ( pdf_filehandle );
  Reset ( pdf_filehandle, 01 );
  PDF_Reset;
  pdf_filename := _fn;
end;

procedure PDF_Reset;
begin

  PDF_FixPageSetup;
  with pdf_pagesetup do begin currentpage := 0; currentColumn := 0; currentRow := 0; end;

  pdf_currentobject  := 0; { Current Object }
  pdf_currentfilepos := 0; { Current File Position }

  pdf_textcontrol    := pdf_systemTextControl;

  pdf_fontcolor      := pdf_fcBlack; { default font color }
  pdf_fontOldColorID := 0; { Current Old Color ID for </font> } { *new* v0.930 }

  with pdf_docInfo do begin
    Title     := pdf_systemDocInfo.Title;
    Subject   := pdf_systemDocInfo.Subject;
    Author    := pdf_systemDocInfo.Author;
    Keywords  := pdf_systemDocInfo.Keywords;

    { we hold the rights for PDF creation }
    Creator   := pdf_libname + ' v' + pdf_libversion + ' \251 ' + pdf_libcopyright;

    if Length ( pdf_systemDocInfo.Producer ) >= 01 then
      Producer := pdf_systemDocInfo.Producer
    else begin
      Producer := pdf_appname;
      if ( Length ( Producer ) >= 01 ) and
         ( Length ( pdf_appversion ) >= 01 ) then
        Producer := Producer + ' v' + pdf_appversion;
      if ( Length ( pdf_appcopyright ) >= 01 ) then begin
        if ( Length ( Producer ) >= 01 ) then
          Producer := Producer + ' \251 ' + pdf_appcopyright
        else
          Producer := pdf_appcopyright;
      end;
    end;
  end;

end;

procedure PDF_Write ( _str : String );
var _written : {$ifdef Pascal} Word; {$else} Integer; {$endif}
begin
  { write To PDF }
  BlockWrite ( pdf_filehandle, _str [ 01 ], Length ( _str ), _written );
  { increase File Position of PDF }
  Inc ( pdf_currentfilepos,  _written );
end;

procedure PDF_WriteLn ( _str : String );
begin
  PDF_Write ( _str + #13 );
end;

procedure PDF_WriteHeader;
var _str : String; _at : Word;
begin

  PDF_WriteLn ( '%PDF-' + pdf_fileversion );

  pdf_currentobject := 01;    { always start from 1 }
  with pdf_pagesetup do begin { *chg* v0.940 - always start from 0 }
    currentpage := 0;
  end;

  pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
  PDF_WriteLn ( PDF_objBegin );
  PDF_WriteLn ( '/CreationDate(' + PDF_CurrentDateTime + ')' );
  with pdf_docInfo do begin
    if Length ( Title )     >= 01 THEN PDF_WriteLn ( '/Title('    + Title    + ')' );
    if Length ( Subject )   >= 01 THEN PDF_WriteLn ( '/Subject('  + Subject  + ')' );
    if Length ( Author )    >= 01 THEN PDF_WriteLn ( '/Author('  + Author   + ')' );
    if Length ( Keywords )  >= 01 THEN PDF_WriteLn ( '/Keywords(' + Keywords + ')' );
    if Length ( Creator )   >= 01 THEN PDF_WriteLn ( '/Creator('  + Creator  + ')' );
    if Length ( Producer )  >= 01 THEN PDF_WriteLn ( '/Producer(' + Producer + ')' );
  end;
  PDF_WriteLn ( pdf_objEnd );

  pdf_objidOutlines := 0; pdf_outlineCount := 0;

  if pdf_pagemode <> ppmRegular then begin
    _str := #13 + '/PageMode';
    case pdf_pagemode of
    { ppmRegular    : _str := _str + '/UseNone'; } { default to this - pdf:optimize }
      ppmOutlines   : begin
          pdf_outline := True;
          _str := _str + '/UseOutlines';
        end;
      ppmThumbs     : _str := _str + '/UseThumbs';
      ppmFullScreen : _str := _str + '/FullScreen';
    end; end
  else _str := '';

  if pdf_outline then begin { *new* v0.943 - create "outline" if instructed }
    pdf_objidOutlines := pdf_currentobject + 03;
    _str := #13 + '/Outlines ' + PDF_objIndirect ( pdf_objidOutlines ) + _str;
  end;

  if ( pdf_viewerPreferences <> pvpRegular ) or
     ( pdf_vpPageLayout <> pplRegular ) then begin
    _str := _str + '/ViewerPreferences [';
    if ( pdf_viewerPreferences and pvpHideToolBar  ) <> 0 then _str := _str + '/HideToolBar';
    if ( pdf_viewerPreferences and pvpHideMenuBar  ) <> 0 then _str := _str + '/HideMenuBar';
    if ( pdf_viewerPreferences and pvpHideWindowUI ) <> 0 then _str := _str + '/HideWindowUI';
    if ( pdf_viewerPreferences and pvpFitWindow    ) <> 0 then _str := _str + '/FitWindow';
    if ( pdf_viewerPreferences and pvpCenterWindow ) <> 0 then _str := _str + '/CenterWindow';
    if pdf_vpPageLayout <> pplRegular then begin
      _str := _str + '/PageLayout';
      case pdf_vpPageLayout of
        pplSinglePage     : _str := _str + '/SinglePage';
        pplOneColumn      : _str := _str + '/OneColumn';
        pplTwoColumnLeft  : _str := _str + '/TwoColumnLeft';
        pplTwoColumnRight : _str := _str + '/TwoColumnRight';
      end;
    end;
    if ( pdf_pagemode = ppmFullScreen ) and
       ( pdf_nonFullScreenPageMode <> ppmRegular ) then begin
      _str := _str + '/PageMode';
      case pdf_nonFullScreenPageMode of
      { ppmRegular    : _str := _str + '/UseNone'; } { default to this - pdf:optimize }
        ppmOutlines   : _str := _str + '/UseOutlines';
        ppmThumbs     : _str := _str + '/UseThumbs';
        ppmFullScreen : _str := _str + '/FullScreen';
      end;
    end;
    _str := _str + ']';
  end;

  Inc ( pdf_currentobject ); 
  pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
  PDF_WriteLn ( PDF_objBegin );
  Inc ( pdf_currentobject ); 
  pdf_objidKids := pdf_currentobject;
  PDF_WriteLn ( '/Type/Catalog' + #13 + '/Pages ' + PDF_objIndirect ( pdf_objidKids ) + _str );
  PDF_WriteLn ( pdf_objEnd );

  if pdf_outline then Inc ( pdf_currentobject );

  Inc ( pdf_currentobject ); 
  pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
  PDF_WriteLn ( PDF_objBegin );

  _str := '';
  if pdf_fontForceASCII      then _str := _str + #13 + '/FirstChar 0 /LastChar 255';
  case pdf_fontEncoding of
    pfeMacRomanEncoding : _str := _str + #13 + '/Encoding/MacRomanEncoding';
    pfeWinAnsiEncoding  : _str := _str + #13 + '/Encoding/WinAnsiEncoding';
  end;
  pdf_objidFont := pdf_currentobject;
  pdf_fontidDefault := 01;
  if pdf_fonttype = pftPsType1 then begin
    _at := 01;
    while ( _at <= PDF_MAXPSTYPE1 ) and
      ( UpperCase ( pdf_ps1fontname [ _at ] )<> UpperCase ( pdf_fontname ) ) do Inc ( _at );
    if _at > PDF_MAXPSTYPE1 then _at := 01;
    PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                  '/Name/F1/BaseFont/' + pdf_ps1fontname [ _at ] + _str );
    if pdf_styler then begin
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                    '/Name/F2/BaseFont/' + pdf_ps1fontname [ _at + 01 ] + _str );
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                    '/Name/F3/BaseFont/' + pdf_ps1fontname [ _at + 02 ] + _str );
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                    '/Name/F4/BaseFont/' + pdf_ps1fontname [ _at + 03 ] + _str );
      {
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                    '/Name/F5/BaseFont/' + pdf_fontname + ',Underline' + _str );
      }
      pdf_fontidCount := 04;
    end
    else pdf_fontidCount := 01;
    (*
    // if pdf_encoding = pdf_isoEncoded then begin
    //  { ... }
    // end;
    *)
    end
  else if pdf_fonttype = pftTrueType then begin
    PDF_WriteLn ( '/Type/Font/Subtype/TrueType' +
                  '/Name/F1/BaseFont/' + pdf_fontname + _str );

    if pdf_styler then begin
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject ); 
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/TrueType' +
                    '/Name/F2/BaseFont/' + pdf_fontname + ',Bold' + _str );
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/TrueType' +
                    '/Name/F3/BaseFont/' + pdf_fontname + ',Italic' + _str );
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject );
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/TrueType' +
                    '/Name/F4/BaseFont/' + pdf_fontname + ',BoldItalic' + _str );
      {
      PDF_WriteLn ( pdf_objEnd );
      Inc ( pdf_currentobject ); 
      pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
      PDF_WriteLn ( PDF_objBegin );
      PDF_WriteLn ( '/Type/Font/Subtype/TrueType' +
                    '/Name/F5/BaseFont/' + pdf_fontname + ',Underline' + _str );
      }
      pdf_fontidCount := 04;
    end
    else pdf_fontidCount := 01;

  end;
  PDF_WriteLn ( pdf_objEnd );

  if pdf_symbolic then begin
    Inc ( pdf_fontidCount ); pdf_fontidSymbolic := pdf_fontidCount;
    Inc ( pdf_currentobject );
    pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
    pdf_objidSymbolic := pdf_currentobject;
    PDF_WriteLn ( PDF_objBegin );
    PDF_WriteLn ( '/Type/Font/Subtype/Type1' +
                  '/Name/F' +
                  WordToStr ( pdf_fontidSymbolic, 0 ) +
                  '/BaseFont/ZapfDingbats' + _str );
    PDF_WriteLn ( pdf_objEnd ); end
  else pdf_objidSymbolic := 0;

  Inc ( pdf_currentobject );
  pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
  pdf_objidResources := pdf_currentobject;
  PDF_WriteLn ( pdf_objBegin );
  _str := '/F1 ' + PDF_objIndirect ( pdf_objidFont );
  if pdf_styler then begin
    _str := _str + ' /F2 ' + PDF_objIndirect ( pdf_objidFont + 01 ) +
                   ' /F3 ' + PDF_objIndirect ( pdf_objidFont + 02 ) +
                   ' /F4 ' + PDF_objIndirect ( pdf_objidFont + 03 );
    if pdf_fontidSymbolic >= 01 then
      _str := _str + ' /F' + WordToStr ( pdf_fontidSymbolic, 0 ) + ' ' +
              PDF_objIndirect ( pdf_objidSymbolic );
  end;
  PDF_WriteLn ( '/Font << ' + _str + ' >>' + #13 +
                '/ProcSet [ /PDF/Text ]' );
  PDF_WriteLn ( pdf_objEnd );

end;

function  PDF_StartPage : Longint;
var _streamPos : Longint; _isBorder, _isTitle : Boolean; _left, _right, _gapLeft, _gapRight : Word;
begin

  with pdf_pagesetup do begin
    { reset "current location" in Point Size and "current page and column" }
    with currentpoint do begin x := workarea.left; y := workarea.top; end;
    Inc ( currentpage );
    currentColumn := 0; currentRow := 0; { reset later in "PDF_NextColumn" }
  end;

  Inc ( pdf_currentobject );
  pdf_objFilePos [ pdf_currentobject] := pdf_currentfilepos;

  pdf_pageKids [ pdf_pagesetup.currentpage ] := pdf_currentobject;

  PDF_WriteLn ( pdf_objBegin );
  PDF_WriteLn ( '/Type/Page' + #13 + '/Parent ' + PDF_objIndirect ( pdf_objidKids ) + #13 +
                '/Resources ' + PDF_objIndirect ( pdf_objidResources ) + #13 +
                '/Contents ' + PDF_objIndirect ( pdf_currentobject + 01 ) );
  PDF_WriteLn ( pdf_objEnd );

  Inc ( pdf_currentobject );
  pdf_objFilePos [ pdf_currentobject ] := pdf_currentfilepos;
  PDF_WriteLn ( PDF_objBegin );
  PDF_WriteLn ( '/Length ' + PDF_objIndirect ( pdf_currentobject + 01 ) );
  PDF_WriteLn ( '>>' + #13 + pdf_objStreamBegin );
  _streamPos := pdf_currentfilepos;

  PDF_WriteLn ( 'BT' );
  with pdf_pagesetup do begin
    _isTitle  := Length ( pdf_pageTitle ) >= 01;
    _isBorder := ( pageBorder ) and ( columnBorder = cbRegular );
    if ( _isTitle ) or ( _isBorder ) then begin
      { calculate "Page Border" for if "column border" exists }
      if columnBorder = cbRegular then begin
        _left  := workarea.left   - 02;
        _right := workarea.right  + 02;
        end
      else begin
        { *chg* v0.942 _gapLeft and _gapRight added to adjust box of Page Title }
        _left  := columns [ 01, 01 ].workarea.left                ;
        _right := columns [ columnCount, rowCount ].workarea.right;
        if columnBorder = cbBorder then begin
          _gapLeft  := columnMargin.Left;
          _gapRight := columnMargin.Right;
          end
        else begin
          _gapLeft  := 0; _gapRight := 0;
        end;
      end;

      if _isTitle then PDF_WriteLn ( '/F1 ' + WordToStr ( fontPointSize, 0 ) + ' Tf' );
      PDF_WriteLn ( '1 0 0 1 ' + WordToStr ( workarea.left, 0 ) + ' ' +
                                 WordToStr ( workarea.bottom +
                                   ( leadingPointSize + columnGap.y + 05  ) + columnGap.y, 0 ) + ' Tm' );
      if _isTitle then begin
        PDF_WriteLn ( WordToStr ( leadingPointSize, 0 ) + ' TL' );
        PDF_WriteLn ( '(' + TrimRight ( PadC ( pdf_pageTitle, pdf_pagesetup.charCount, '' ) ) + ')''' );
        PDF_WriteLn ( WordToStr ( _left - _gapLeft,   0 ) + ' '   +
                      WordToStr ( workarea.bottom + 04 + columnGap.y, 0 ) + ' m ' +
                      WordToStr ( _right + _gapRight,  0 ) + ' '   +
                      WordToStr ( workarea.bottom + 04 + columnGap.y, 0 ) + ' l ' +
                      WordToStr ( _right + _gapRight,  0 ) + ' '   +
                      WordToStr ( workarea.bottom + ( leadingPointSize + columnGap.y + 06 -
                                    ( leadingPointSize - fontPointSize ) ) + columnGap.y, 0 ) + ' l ' +
                      WordToStr ( _left - _gapLeft,   0 ) + ' '   +
                      WordToStr ( workarea.bottom + ( leadingPointSize + columnGap.y + 06 -
                                    ( leadingPointSize - fontPointSize ) ) + columnGap.y, 0 ) + ' l ' +
                      WordToStr ( _left - _gapLeft,   0 ) + ' ' +
                      WordToStr ( workarea.bottom + 04 + columnGap.y, 0 ) + ' l S' );
      end;
      if _isBorder then begin
        PDF_WriteLn ( TrimLeft ( PDF_GetDashPattern ( borderDashPattern ) + ' ' +
                        WordToStr ( workarea.left   - 02,  0 ) + ' '   +
                        WordToStr ( workarea.bottom + 02,  0 ) + ' m ' +
                        WordToStr ( workarea.right  + 02,  0 ) + ' '   +
                        WordToStr ( workarea.bottom + 02,  0 ) + ' l ' +
                        WordToStr ( workarea.right  + 02,  0 ) + ' '   +
                        WordToStr ( workarea.top    - 02,  0 ) + ' l ' +
                        WordToStr ( workarea.left   - 02,  0 ) + ' '   +
                        WordToStr ( workarea.top    - 02,  0 ) + ' l ' +
                        WordToStr ( workarea.left   - 02,  0 ) + ' '   +
                        WordToStr ( workarea.bottom + 02,  0 ) + ' l S' ) );
      end;
      { PDF_WriteLn ( 's' ); }
    end;
    PDF_WriteLn ( '/F1 ' + WordToStr ( columnFontPointSize, 0 ) + ' Tf' );
    PDF_NextColumn ( _streamPos ); { currentColumn reset to 0 }
                                   { currentRow    reset to 0 }
                                   { before calling Next Column for "PDF_StartPage" }
    PDF_WriteLn ( WordToStr ( columnLeadingPointSize, 0 ) + ' TL' );
  end;
  PDF_StartPage := _streamPos;

end;

procedure PDF_EndPage ( _streamBegin : Longint );
var _streamEnd : Longint;
begin
  PDF_WriteLn ( 'ET' );
  _streamEnd := pdf_currentfilepos;
  PDF_WriteLn ( pdf_objStreamEnd );

  Inc ( pdf_currentobject );
  pdf_objFilePos[ pdf_currentobject ] := pdf_currentfilepos;
  PDF_WriteLn ( pdf_objShortBegin );
  PDF_WriteLn ( WordToStr ( _streamEnd - _streamBegin, 0 ) );
  PDF_WriteLn ( pdf_objShortEnd );
  with pdf_pagesetup do begin
    currentColumn := 0; currentRow := 0;
  end;
end;

procedure PDF_NextColumn ( _streamBegin : LongInt);
var _isNewColumn : Boolean;
begin
  with pdf_pagesetup do begin
    Inc ( currentColumn ); _isNewColumn := True;
    if currentColumn > columnCount then begin
      currentColumn := 01; Inc ( currentRow );
      if currentRow > rowCount then begin
        PDF_EndPage ( _streamBegin ); _isNewColumn := False;
      end;
    end;
    if _isNewColumn then begin
      if currentRow = 0 then Inc ( currentRow );
      if currentRow > rowCount then begin
        PDF_EndPage ( _streamBegin ); _isNewColumn := False;
      end;
      if _isNewColumn then begin
        columns [ currentColumn, currentRow ].currentPoint.x :=
          columns [ currentColumn, currentRow ].workarea.left;
        columns [ currentColumn, currentRow ].currentPoint.y :=
          columns [ currentColumn, currentRow ].workarea.top;
        PDF_WriteLn ( '1 0 0 1 ' +
          WordToStr ( columns [ currentColumn, currentRow ].workarea.left, 0 ) + ' ' +
          WordToStr ( columns [ currentColumn, currentRow ].workarea.bottom, 0 ) + ' Tm' );
        if columnBorder = cbBorder then begin
          with columns [ currentColumn, currentRow ] do begin { *hint* PDF using Bottom-Top }
            PDF_WriteLn ( TrimLeft ( PDF_GetDashPattern ( borderDashPattern ) + ' ' +
                            WordToStr ( workarea.left   - columnMargin.left,    0 ) + ' '   +
                            WordToStr ( workarea.bottom + columnMargin.top,     0 ) + ' m ' +
                            WordToStr ( workarea.right  + columnMargin.right,   0 ) + ' '   +
                            WordToStr ( workarea.bottom + columnMargin.top,     0 ) + ' l ' +
                            WordToStr ( workarea.right  + columnMargin.right,   0 ) + ' '   +
                            WordToStr ( workarea.top    - columnMargin.bottom,  0 ) + ' l ' +
                            WordToStr ( workarea.left   - columnMargin.left,    0 ) + ' '   +
                            WordToStr ( workarea.top    - columnMargin.bottom,  0 ) + ' l ' +
                            WordToStr ( workarea.left   - columnMargin.left,    0 ) + ' '   +
                            WordToStr ( workarea.bottom + columnMargin.top,     0 ) + ' l S' ) );
          end; end
        else if ( columnBorder = cbSplitter ) then begin
          if ( currentColumn < columnCount ) then begin
            with columns [ currentColumn, currentRow ] do begin
              PDF_WriteLn ( TrimLeft ( PDF_GetDashPattern ( borderDashPattern ) + ' ' + { *chg* v0.942 }
                            WordToStr ( workarea.right  + columnMargin.right  + ( columnGap.x div 02 ),  0 ) + ' '   +
                            WordToStr ( workarea.bottom + columnMargin.top    + ( columnGap.y div 02 ),  0 ) + ' m ' +
                            WordToStr ( workarea.right  + columnMargin.right  + ( columnGap.x div 02 ),  0 ) + ' '   +
                            WordToStr ( workarea.top    - columnMargin.bottom - ( columnGap.y div 02 ),  0 ) + ' l S' ) );
            end;
          end;
          if currentRow < rowCount then begin
            with columns [ currentColumn, currentRow ] do begin
              PDF_WriteLn ( TrimLeft ( PDF_GetDashPattern ( borderDashPattern ) + ' ' + { *chg* v0.942 }
                            WordToStr ( workarea.left   - columnMargin.left   - ( columnGap.x div 02 ),  0 ) + ' '   +
                            WordToStr ( workarea.top    - columnMargin.bottom - ( columnGap.y div 02 ),  0 ) + ' m ' +
                            WordToStr ( workarea.right  + columnMargin.right  + ( columnGap.x div 02 ),  0 ) + ' '   +
                            WordToStr ( workarea.top    - columnMargin.bottom - ( columnGap.y div 02 ),  0 ) + ' l S' ) );
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure PDF_Close;
var _xref : Longint; _i : Integer; _xrefobject : Word; _str : String;
begin
  if pdf_objidOutlines >= 01 then begin
    _xrefobject := pdf_currentobject;
    pdf_currentobject := pdf_objidOutlines;
    pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
    PDF_WriteLn ( PDF_objBegin );
    PDF_WriteLn ( '/Count ' + WordToStr ( pdf_outlineCount, 0 ) );
    if pdf_outlineCount >= 01 then
      PDF_WriteLn ( '/First ' + PDF_objIndirect ( _xrefobject + 01 ) + #13 +
                    '/Last '  + PDF_objIndirect ( _xrefobject + pdf_outlineCount ) );
    PDF_WriteLn ( pdf_objEnd );
    pdf_currentobject := _xrefobject;
    _i := 0; 
    while _i < pdf_outlineCount do begin
      Inc ( _i );
      with pdf_outlines [ _i ] do begin
        Inc ( pdf_currentobject );
        pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
        PDF_WriteLn ( PDF_objBegin );
        _str := '';
        if _i > 01 then
          _str := _str + ' /Previous ' + PDF_objIndirect ( pdf_currentobject - 01 );
        if _i < pdf_outlineCount then
          _str := _str + ' /Next '     + PDF_objIndirect ( pdf_currentobject + 01 );

        if ( objid = 0 ) and ( ( page >= 01 ) and
          ( page <= pdf_pagesetup.currentpage ) ) then objid := pdf_pageKids [ page ];

        PDF_WriteLn ( '/Title (' + title + ') ' +
                      '/Dest [' + PDF_objIndirect ( objid ) +
                      { WordToStr ( _i - 01, 0 ) + }
                      ' /XYZ null null null] ' +
                      '/Parent ' + PDF_objIndirect ( pdf_objidOutlines ) + _str );
        PDF_WriteLn ( pdf_objEnd );
      end;
    end;
  end;

  _xrefobject := pdf_currentobject + 01;
  pdf_currentobject := pdf_objidKids;
  pdf_objFilePos [pdf_currentobject] := pdf_currentfilepos;
  PDF_WriteLn ( PDF_objBegin );
  with pdf_pagesetup do begin
    PDF_WriteLn ( '/Type/Pages' + #13 + '/Count ' + WordToStr ( currentpage, 0 ) + #13 +
                  '/MediaBox [ 0 0 ' + WordToStr ( mediasize.width,  0 ) + ' ' +
                                       WordToStr ( mediasize.height, 0 ) + ' ]' );
    PDF_Write ( '/Kids [ ' );
    for _i := 1 to currentpage do
      PDF_Write ( PDF_objIndirect ( pdf_pageKids [ _i ] ) + ' ' );
    PDF_WriteLn ( ']' );
  end;
  PDF_WriteLn ( pdf_objEnd );

  _xref := pdf_currentfilepos;
  PDF_WriteLn ( 'xref' );
  PDF_WriteLn ( '0 ' + WordToStr ( _xrefobject, 0 ) );
  PDF_WriteLn ( '0000000000 65535 f' );
  for _i := 1 to _xrefobject - 01 do
    PDF_WriteLn ( WordToZeroStr ( pdf_objFilePos [ _i ], 10 ) + ' 00000 n' );

  PDF_WriteLn ( 'trailer' + #13 + '<<' );
  PDF_WriteLn ( '/Size ' + WordToStr ( _xrefobject, 0 ) + #13 +
                '/Root 2 0 R' + #13 + '/Info 1 0 R' );
  PDF_WriteLn ( '>>' );

  PDF_WriteLn ( 'startxref' );
  PDF_WriteLn ( WordToStr ( _xref, 0 ) );
  PDF_WriteLn ( '%%EOF' );
  Close ( pdf_filehandle );
end;

begin
    with pdf_systemTextControl do begin
      FormFeed      := True;
      WordWrap      := False;
      TabSize       := 08;
    end;
    pdf_textcontrol := pdf_systemTextControl;

    with pdf_systemDocInfo do begin
      Title := ''; Subject := ''; Author := ''; KeyWords := '';
      Creator := ''; Producer := '';
   end;

  with PaperSizeLetter     do begin width := 612; height :=  792; end; {    8.5" x   11.0" }
  with PaperSizeA4         do begin width := 595; height :=  842; end; {   210mm x   297mm }
  with PaperSizeA3         do begin width := 842; height := 1190; end; {   297mm x   420mm }
  { *new* v0.930 *start* PaperSize -> Legal / B5 / C5 }
  with PaperSizeLegal      do begin width := 612; height := 1008; end; {    8.5" x   14.0" }
  with PaperSizeB5         do begin width := 516; height :=  728; end; {   182mm x   257mm } { *chg* v0.942 }
  with PaperSizeC5         do begin width := 459; height :=  649; end; {   162mm x   229mm }
  { *new* v0.930 *end* PaperSize -> Legal / B5 / C5 }
  { *new* v0.940 *start* PaperSize -> 8" x 11" = suitable for A4 and Letter }
  with PaperSize8x11   do begin width := 595; height :=  792; end; {  8.0" x 11.0" }
  { *new* v0.940 *end* PaperSize -> 8" x 11" }
  { *new* v0.942 *start* PaperSize -> B4 / A5 / Folio / Executive }
  with PaperSizeB4         do begin width := 728; height := 1031; end; {   257mm x   364mm }
  with PaperSizeA5         do begin width := 419; height :=  595; end; {   148mm x   210mm }
  with PaperSizeFolio      do begin width := 612; height :=  936; end; {    8.5" x   13.0" }
  with PaperSizeExecutive  do begin width := 522; height :=  756; end; {   7.25" x   10.5" }
  { *new* v0.942 *end* PaperSize -> B4 / A5 / Folio / Executive }
  { *new* v0.942 *start* PaperSize -> Envelope -> B4/B5/C6/DL/Monarch/9/10/11 }
  with PaperSizeEnvB4      do begin width := 728; height := 1031; end; {   257mm x   364mm }
  with PaperSizeEnvB5      do begin width := 499; height :=  708; end; {   176mm x   250mm }
  with PaperSizeEnvC6      do begin width := 323; height :=  459; end; {   114mm x   162mm }
  with PaperSizeEnvDL      do begin width := 312; height :=  623; end; {   110mm x   220mm }
  with PaperSizeEnvMonarch do begin width := 279; height :=  540; end; {  3.875" x    7.5" }
  with PaperSizeEnv9       do begin width := 279; height :=  639; end; {  3.875" x  8.875" }
  with PaperSizeEnv10      do begin width := 297; height :=  684; end; {  4.125" x    9.5" }
  with PaperSizeEnv11      do begin width := 324; height :=  747; end; {    4.5" x 10.375" }
  { *new* v0.942 *end* PaperSize -> Envelope -> B4/B5/C6/DL/Monarch/9/10/11 }

  pdf_systemFontName := pdf_ps1fontname [ 1 ];
  pdf_fontname       := pdf_systemFontName;

  { *new* v0.930 *start* Font Color }

  with pdf_fcRed     do begin red := 255; green :=   0; blue :=   0; end;
  with pdf_fcGreen   do begin red :=   0; green := 255; blue :=   0; end;
  with pdf_fcBlue    do begin red :=   0; green :=   0; blue := 255; end;
  with pdf_fcBlack   do begin red :=   0; green :=   0; blue :=   0; end;
  with pdf_fcWhite   do begin red := 255; green := 255; blue := 255; end;
  with pdf_fcYellow  do begin red := 255; green := 255; blue :=   0; end;
  with pdf_fcCyan    do begin red :=   0; green := 255; blue := 255; end;
  with pdf_fcGray    do begin red := 128; green := 128; blue := 128; end;
  with pdf_fcBrown   do begin red := 128; green :=   0; blue :=   0; end;
  with pdf_fcLtBlue  do begin red :=  64; green :=  64; blue := 255; end;
  with pdf_fcLtGreen do begin red := 128; green := 255; blue := 128; end;
  with pdf_fcLtRed   do begin red := 255; green :=  64; blue :=  64; end;
  with pdf_fcMagenta do begin red := 255; green :=   0; blue :=   0; end;
  with pdf_fcOrange  do begin red := 255; green := 128; blue :=   0; end;
  with pdf_fcTeal    do begin red :=   0; green := 127; blue := 127; end;
  pdf_fontColor      := pdf_fcBlack;   { default to "Black" <font color=#000000> <font color=red> }
  pdf_fontOldColorID := 0; { initial font color </font> }
  { *new* v0.930 *end* Font Color }

  { *new* v0.940 *start* Page Setup - Margin and Column Control }
  with pdf_pagesetup do begin
    papersize := PaperSizeLetter; { default for General Printing with Stardard Computerized Paper }
                                  {   -> as in Adobe Distiller                                    }
                                  {   -> change to [A4] for publication purpose                   }
    mediasize := papersize; { *new* v0.942 }       
    with margin do begin
      top    := pdf_pointsPerInch div 02; { default Top    Margin = 0.50" }
      bottom := pdf_pointsPerInch div 02; { default Bottom Margin = 0.50" }
      left   := pdf_pointsPerInch div 04; { default Left   Margin = 0.25" }
      right  := pdf_pointsPerInch div 04; { default Right  Margin = 0.25" }
    end;
    pageBorder := False; { default to "no border" }
    { default column margin and gap - valid for 2 or more columns }
    { tm:02+bm:02+g:02 -> 0.125" for top  and bottom margin of column }
    { lm:02+rm:02+g:02 -> 0.125" for left and right  margin of column }
    with columnMargin do begin
      top    := 3; bottom := 3; left   := 3; right  := 3; end;
    with columnGap do begin
      x := 4; y := 4; { - div 02 -> balance = 0 -> 2,4,6,8,10...100 }
                      { - solving page/column border drawing        }
    end;

    columnBorder      := cbRegular;  { default to "no column border" }
    borderDashPattern := pdpRegular; { default to "undeclared Solid Dash Pattern" }
    columnCount       := 01;         { default to "no more than 1 column" }
    rowCount          := 01;         { default to "no more than 1 row" }
    fontPointSize     := 10;         { default to "10p" }
    columnFontPointSize := fontPointSize; { default to 12p as fontPointSize }
  end;     
  { *new* v0.940 *end* Page Setup - Margin and Column Control }

end.

