Unit _StrNum_;

{$I DelVer.inc}

interface

type

  ScriptStyleType = ( scriptHTML, scriptPascal, scriptCPP );

const
  script_start       : String [ 02 ] = '';   { html =      Pascal = '//' C++ = '//' }
  script_1start      : String [ 02 ] = '<';  { html = '<'  Pascal = '{'  C++ =      }
  script_1end        : String [ 02 ] = '>';  { html = '>'  Pascal = '?'  C++ =      }
  script_1ignore     : String [ 02 ] = '';   { html = ''   Pascal = '$'  C++ = ''   }
  script_2start      : String [ 02 ] = '<!'; { html = '<!' Pascal = '(*' C++ = '/*' }
  script_2end        : String [ 02 ] = '->'; { html = '->' Pascal = '*)' C++ = '*/' }
  script_startresult : String [ 02 ] = '';
  script_endresult   : String [ 02 ] = '';
  script_lenresult   : Word = 0;
  script_posresult   : Word = 0;
  script_remresult   : Boolean = False;
  script_textresult  : String     = '';
  script_cutstart    : String [ 01 ] = '"';  { always '"' -> <TABLE BORDER="1"> = <TABLE BORDER=1> }
  script_cutend      : String [ 01 ] = '"';  { always '"' -> <TABLE BORDER="1"> = <TABLE BORDER=1> }

var script_style : ScriptStyleType;

  function ReplicateStr ( _str : String; _count : Word ) : String;

  function OneDecPtStr ( _num : {$ifdef Pascal}Real{$else}Extended{$endif} ) : String;
  function ThreeDecPtStr ( _num : {$ifdef Pascal}Real{$else}Extended{$endif} ) : String;
  function WordToStr ( _w, _len : Word ) : String;
  function WordToZeroStr ( _w, _len : Word ) : String;
  function StrToWord ( _str : String ) : Word;
  function HexToWord ( _str : String ) : Word;
  function StrToFloat ( _str : String ) : {$ifdef Pascal}Real{$else}Extended{$endif};
  function RPos ( _str1, _str2 : String ) : Word;

  function  ScriptPos ( _str : String; _begin : Word ) : Word;
  function  ScriptReadString ( _name, _str : String ) : String;
  procedure SetScriptStyle ( _filename : String );
  procedure SetScript2Pascal;
  procedure SetScript2Html;
  procedure SetScript2CPP; { dBase=Clipper=CPP }

  function PadL      ( _str : String; _count : Word; _rstr : String ) : String;
  function PadR      ( _str : String; _count : Word; _rstr : String ) : String;
  function PadC      ( _str : String; _count : Word; _rstr : String ) : String;

  {$ifdef Pascal}

  function TrimLeft  ( _str : String ) : String;
  function TrimRight ( _str : String ) : String;
  function Trim      ( _str : String ) : String;
  function UpperCase ( _str : String ) : String;

  {$endif}

implementation

{$ifndef Pascal }
  Uses SysUtils;
{$endif}

function ReplicateStr ( _str : String; _count : Word ) : String;
var _strResult : String;
begin
  _strResult := '';
  repeat
    _strResult := _strResult + _str;
    if _count >= 01 then Dec ( _count );
  until _count = 0;
  ReplicateStr := _strResult;
end;

function OneDecPtStr ( _num : {$ifdef Pascal}Real{$else}Extended{$endif} ) : String;
var _s : String;
begin
  Str ( _num:0:1, _s );
  while ( Length ( _s ) >= 01 ) and ( Pos ( Copy ( _s, Length ( _s ), 01 ), '.0' ) >= 01 ) do
    Delete ( _s, Length ( _s ), 01 );
  if Length ( _s ) = 0 then _s := '0';
  OneDecPtStr := _s;
end;

function ThreeDecPtStr ( _num : {$ifdef Pascal}Real{$else}Extended{$endif} ) : String;
var _s : String;
begin
  Str ( _num:0:3, _s );
  if ( not ( Copy ( _s, Length ( _s ), 01 ) = '5' ) ) then Str ( _num:0:2, _s );
  while ( Length ( _s ) >= 01 ) and ( Pos ( Copy ( _s, Length ( _s ), 01 ), '.0' ) >= 01 ) do
    Delete ( _s, Length ( _s ), 01 );
  if Length ( _s ) = 0 then _s := '0';
  ThreeDecPtStr := _s;
end;

function WordToStr ( _w, _len : Word ) : String;
var _strResult : String;
begin
  Str ( _w:_len, _strResult );
  while Length ( _strResult ) < _len do _strResult := ' ' + _strResult;
  WordToStr := _strResult;
end;

function WordToZeroStr ( _w, _len : Word ) : String;
var _at : Word; _strResult : String;
begin
  _strResult := WordToStr ( _w, _len );
  if _len >= 01 then begin
    _at := 01;
    while Copy ( _strResult, _at, 01 ) = ' ' do begin
      Delete ( _strResult, _at, 01 ); Insert ( '0', _strResult, _at ); Inc ( _at );
    end;
  end;
  WordToZeroStr := _strResult;
end;

function StrToWord ( _str : String ) : Word;
var _w : Word; _err : Integer;
begin
  Val ( _str, _w, _err );
  if _err = 0 then begin
       StrToWord := _w;
  end
  else StrToWord := 0;
end;

function HexToWord ( _str : String ) : Word;
var _at, _num : Word;
begin
  _str := UpperCase ( Trim ( _str ) );
  while Length ( _str ) < 04 do _str := '0' + _str;
  _at := 0;
  while _at < 04 do begin
    Inc ( _at );
    if Pos ( _str [ _at ], ' 0123456789' ) >= 01 then
      Insert ( Chr ( Ord (  _str [ _at ] ) - 48 ), _str, _at )
    else
      Insert ( Chr ( Ord ( _str [ _at ] ) - 55 ), _str, _at );
    Delete ( _str, _at + 01, 01 );
  end;
  _num :=     Ord ( _str [ 01 ] ) shl 12;
  Inc ( _num, Ord ( _str [ 02 ] ) shl 08 );
  Inc ( _num, Ord ( _str [ 03 ] ) shl 04 );
  Inc ( _num, Ord ( _str [ 04 ] )        );
  HexToWord := _num;
end;

function StrToFloat ( _str : String ) : {$ifdef Pascal}Real{$else}Extended{$endif};
var _float : {$ifdef Pascal}Real{$else}Extended{$endif}; _err : Integer;
begin
  Val ( _str, _float, _err );
  if _err = 0 then StrToFloat := _float
  else StrToFloat := 0;
end;

function RPos ( _str1, _str2 : String ) : Word;
var _rat, _len1 : Word; _found : Boolean;
begin
  _len1 := Length ( _str1 );
  _rat  := Length ( _str2 );
  if _rat > _len1 then begin
    _rat := _rat - _len1 + 01; _found := False;
    while ( not ( _found ) ) and ( _rat > 0 ) do begin
      _found := Copy ( _str2, _rat, _len1 ) = _str1;
      if not ( _found ) then Dec ( _rat );
    end; end
  else
    _rat := 0;
  RPos := _rat;  
end;

function  PadL      ( _str : String; _count : Word; _rstr : String ) : String;
begin
  if Length ( _rstr ) = 0 then _rstr := ' ';
  while Length ( _str ) < _count do _str := _str + _rstr;
  PadL := Copy ( _str, 01, _count )
end;

function  PadR      ( _str : String; _count : Word; _rstr : String ) : String;
begin
  if Length ( _rstr ) = 0 then _rstr := ' ';
  while Length ( _str ) < _count do _str := _rstr + _str;
  PadR := Copy ( _str, 01, _count )
end;

function  PadC      ( _str : String; _count : Word; _rstr : String ) : String;
var _isLeft : Boolean;
begin
  _isLeft := True;
  if Length ( _rstr ) = 0 then _rstr := ' ';
  while Length ( _str ) < _count do begin
    if _isLeft then _str := _rstr + _str
    else _str := _str + _rstr;
    _isLeft := not ( _isLeft );
  end;
  PadC := Copy ( _str, 01, _count )
end;

procedure SetScriptStyle ( _filename : String );
var _at : Word; _str : String;
begin
  _at := RPos ( '.', UpperCase ( _filename ) );
  if _at > 01 then begin
    _str := UpperCase ( Copy ( _filename, _at, Length ( _filename ) - _at + 01 ) );
    if      Pos ( '/' + _str + '/', '/.PAS/.DPR/.DPK/.INC/' ) >= 01 then
      SetScript2Pascal
    else if Pos ( '/' + _str +'/', '/.CPP/.C/.H/.PRG/.CH/' ) >= 01 then
      SetScript2CPP
    else
      SetScript2Html;
    end
  else SetScript2Html;
end;

procedure SetScript2Html;
begin
  script_1start := '<';  script_1end := '>';  script_1ignore := '';
  script_2start := '<!'; script_2end := '->'; script_start   := '';
  script_style  := scriptHTML;
end;

procedure SetScript2Pascal;
begin
  script_1start := '{';  script_1end := '}';  script_1ignore := '$';
  script_2start := '(*'; script_2end := '*)'; script_start   := '//';
  script_style  := scriptPascal;
end;

procedure SetScript2CPP;
begin
  script_1start := '';   script_1end := '';   script_1ignore := '';
  script_2start := '/*'; script_2end := '*/'; script_start   := '//';
  script_style  := scriptCPP;
end;

function ScriptPos ( _str : String; _begin : Word ) : Word;
var _slen, _2len, _1len, _ilen, _0len, _tpos : Word;
    _ok, _isfind : Boolean;

  { -------- this is non-optimize coding ------- }
  { 1. checking '(*' first    -> ignore if '((*' }
  {    ok -> checking '*)'    -> ignore if '*))' }
  { 2. checking '{'  secondly -> ignore if '{$'  }
  {    ok -> checking '?'     -> ignore if '??'  }
  { 3. checking '//' at last  -> Pos ( '//', TrimLeft ( _str ) ) = 01 }
  { ---- any improvement, please contact me ---- }

  procedure __ValidateScript ( _start, _end : String );
  var _tslen, _telen : Word; _char : char; _is0 : Boolean;
  begin
    _tpos := _begin + 01;
    _tslen := Length ( _start );
    _telen := Length ( _end );
    while ( not ( _ok ) ) and ( _tpos < _slen ) do begin
      Inc ( _tpos );
      if Copy ( _str, _tpos, _telen ) = _end then begin
        if Copy ( _str, _tpos + _telen, 01 ) <> _end [ _telen ] then
          _ok := True;
      end;
    end;
    script_lenresult := _tpos - _begin;
    if _ok then Inc ( script_lenresult, _telen )
    else Inc ( script_lenresult );
    script_startresult := _start; script_endresult := _end;
    script_textresult  := Copy ( _str, _begin + _tslen, script_lenresult - _telen - _tslen );
    if _ok then begin
      if Copy ( script_textresult, Length ( script_textresult ) - _telen + 01, _telen ) = _end then
        Delete ( script_textresult, Length ( script_textresult ) - _telen + 01, _telen );
      end
    else _ok := True;
    if _tslen = 02 then begin
      _char := _start [ 02 ];
      while ( Length ( script_textresult ) >= 01 ) and
        ( script_textresult [ 01 ] = _char ) do Delete ( script_textresult, 01, 01 );
    end;
    if Length ( _end ) = 02 then begin
      _char := _end [ 01 ];
      repeat
        _telen := Length ( script_textresult ); _is0 := _telen < 01;
        if ( not _is0 ) then begin
          if ( script_textresult [ _telen ] = _char ) then Delete ( script_textresult, _telen, 01 )
          else _is0 := True;
        end;
      until _is0;
    end;
  end;

begin
  script_startresult := ''; script_endresult  := '';
  script_lenresult   := 0;  script_textresult := '';
  _slen := Length ( _str );       _0len := Length ( script_start );
  _1len := Length ( script_1start ); _ilen := Length ( script_1ignore );
  _2len := Length ( script_2start );

  _isfind := _begin = 0; _ok := False; if _isfind then _begin := 01;
  repeat
    script_remresult := False;
    if _2len > 0 then begin { checking '(*' first }
      if Copy ( _str, _begin, _2len ) = script_2start then begin
        if _begin >= 01 then begin
          script_remresult := ( _begin > 01 ) and (
            Copy ( _str, _begin - 01, 01 ) = script_2start [ 01 ] );
          if ( not script_remresult ) then __ValidateScript ( script_2start, script_2end );
        end;
      end;
    end;
    if ( not _ok ) and ( _1len > 0 ) then begin { checking '{' secondly }
      if Copy ( _str, _begin, _1len ) = script_1start then begin
        if _begin >= 01 then begin
          script_remresult := ( _begin > 01 ) and (
            Copy ( _str, _begin - 01, 01 ) = script_1start [ 01 ] );
          if ( not script_remresult ) then begin
            script_remresult := ( _ilen >= 01 ) and (
              Copy ( _str, _begin + _1len, _ilen ) = script_1ignore );
            if ( not script_remresult ) then __ValidateScript ( script_1start, script_1end )
            else script_remresult := False;
          end;
        end;
      end;
    end;
    if ( not _ok ) and ( _0len > 0 ) then begin
      { checking '//' at last - there is limitation for }
      {   validating "Syntax of Programming Language"   }
      if ( Copy ( _str, 01, _0len ) = script_start ) then begin
        _ok := True;
        script_startresult := script_start; script_endresult := '';
        script_lenresult   := Length ( _str ) - _begin + 01;
        script_textresult  := Trim ( Copy ( _str, _begin + _0len, Length ( _str ) - _begin + 01 ) );
      end;
    end;
    Inc ( _begin );
  until ( _ok ) or ( _begin > _slen ) or ( not _isfind );
  if _ok then script_posresult := _begin - 01 else script_posresult := 0;
  ScriptPos := script_posresult;
end;

function ScriptReadString ( _name, _str : String ) : String;
var _rstr : String; _at1, _at2, _len : Word; _iscut : Boolean;
begin
  _rstr := ''; _name := ' ' + UpperCase ( Trim ( _name ) );
  _str  := ' ' + Trim ( _str ); _len := Length ( _str );
  _at1  := Pos ( _name, UpperCase ( _str ) );
  if _at1 >= 01 then begin
    Inc ( _at1, Length ( _name ) );
    while ( _at1 <= _len ) and ( _str [ _at1 ] IN [ #32, #09] ) do Inc ( _at1 );
    while ( _at1 <= _len ) and ( _str [ _at1 ] = '='          ) do Inc ( _at1 );
    while ( _at1 <= _len ) and ( _str [ _at1 ] IN [ #32, #09] ) do Inc ( _at1 );
    _at2 := _at1;
    _iscut := ( Length ( script_cutstart ) >= 01 ) and ( _str [ _at1 ] = script_cutstart );
    if _iscut then begin Inc ( _at2 );
      while ( _at2 <= _len ) and ( not ( _str [ _at2 ] = script_cutend   ) ) do Inc ( _at2 ); end
    else
      while ( _at2 <= _len ) and ( not ( _str [ _at2 ] IN [ #32, #09] ) ) do Inc ( _at2 );
    _rstr := Copy ( _str, _at1, _at2 - _at1 + 01 );
    if _iscut then begin
      Delete ( _rstr, 01, 01 );
      if _rstr [ Length ( _rstr ) ] = script_cutend then
        Delete ( _rstr, Length ( _rstr ), 01 );
    end;
  end;
  ScriptReadString := _rstr;
end;

{$ifdef Pascal}

function  TrimLeft  ( _str : String ) : String;
begin
  while ( Copy ( _str, 01, 01 ) = ' ' ) or
        ( Copy ( _str, 01, 01 ) = #09 ) do
    Delete ( _str, 01, 01 ); 
  TrimLeft := _str;
end;

function TrimRight ( _str : String ) : String;
var _at : Word;
begin
  _at := Length ( _str );
  while ( Copy ( _str, _at, 01 ) = ' ' ) or
        ( Copy ( _str, _at, 01 ) = #09 ) do begin
    Delete ( _str, _at, 01 ); Dec ( _at );
  end;
  TrimRight := _str;
end;

function Trim      ( _str : String ) : String;
begin
  Trim := TrimLeft ( TrimRight ( _str ) );
end;

function UpperCase ( _str : String ) : String;
var _at : Word; _strResult : String;
begin
  _strResult := ''; _at := 0;
  while _at < Length ( _str ) do begin
    Inc ( _at );
    _strResult := _strResult + UpCase ( _str [ _at ] );
  end;
  UpperCase := _strResult;
end;

{$endif}

begin
  SetScript2Html;
end.

