Program Text_To_PDF;

{$I ..\DelVer.inc}

{$ifndef Pascal}
{$APPTYPE CONSOLE}
{$endif}

uses
  {$ifdef Pascal} DOS,
  {$else}         SysUtils,
    {$ifdef Delphi1}
      WinTypes, WinProcs,
    {$else}
      Windows,
    {$endif}
  {$endif}
  _StrNum_,
  pdfCmd, pdfFrTxt;

procedure ShowHelp;
begin
  writeln;
  writeln ( 'TxtToPDF - Text-To-PDF Conversion v', pdf_libversion, ' jan.99 -by- tkcham' );
  writeln ( '-----------------------------------------------------------' );
  writeln ( 'Syntax: TxtToPDF.EXE [input_file] [pdf_filehandle] [options]' );
  writeln ( 'Sample: TxtToPDF readme.txt readme.pdf                      ' );
  writeln ( '  /?         show this message' );
  writeln ( '  /F<font>   use PostScript <font> (must be in standard 14, default: Courier)' );
  writeln ( '  /S<size>   use font at given pointsize (default ', pdf_pagesetup.columnFontPointSize:0, ')' );
  writeln ( '  /L<lines>  lines per page (default 60 or auto-detection)' );
  writeln ( '  /T<spaces> spaces per TAB character (default 8)' );
  writeln ( '  /FF  /FF0  ignore formfeed characters (^L)' );
  writeln ( '  /PS1 /TT   PostScript Type 1 or TrueType Font (default to PS1)' );
  writeln ( '  /A4/A3/LEGAL/B5/C5/8x11 use A4/A3/LEGAL/B5/C5/8x11 paper (default Letter)' );
  writeln ( '  /X<width>  independent paper width in points' );
  writeln ( '  /Y<height> independent paper height in points' );
  writeln ( '  /WW        Word Wrap (default=<no>)' );
  writeln ( '  /C<columns> change the number of columns (default=1)' );
  writeln ( '  /R<rows>   change the number of rows (default=1)' );
  writeln ( '  /L         landscape mode' );
  writeln ( '  /EM/EW/EN  Encoding Type : MacRoman/WinAnsi/NoEncoding' );
  writeln ( '  /ASC       Force ASCII characters declaration (0-255)' );
  writeln ( '  /S         PDF Styler (Font/Color/SymbolicFont) Enable' );
  writeln ( '  /OUTL/FITW/CWIN/FWIN/THUM Use Outline/FitWdw/CenterWdw/FullScreen/Thumbs' );
  writeln ( '  /PB/SB/CB/BDP1-6  Page Border / Splitter Border / Column Border / Dash Pattern' );
  writeln ( '  /dt/ds/da/dk Document Info. - Title Subject Author Keywords' );
  writeln ( '  /dc/dp       Document Info. - Creator Producer' );
  writeln ( '  /pt          Page Title on each page' );
  writeln;
end;

const _isLandscape : Boolean = False;
var _i1 : Integer; _pdffilename, _paramstr : String;

begin

  pdf_appname      := 'TxtToPDF';
  pdf_appversion   := '0.943';
  pdf_appcopyright := 'gongxi@tm.net.my';

  _i1 := 0; _pdffilename := '';
  while ( _i1 = 0 ) or  ( _i1 < ParamCount ) do begin
    Inc ( _i1 );
    if ParamCount < 02 then _paramstr := '/?' else _paramstr := UpperCase ( ParamStr ( _i1 ) );
    if      '/?' =      _paramstr        then begin ShowHelp; HALT ( 01 ); end
    else if '/FF' =     _paramstr        then begin pdf_systemTextControl.FormFeed := True; end
    else if '/FF0' =    _paramstr        then begin pdf_systemTextControl.FormFeed := False; end
    else if '/TT' =     _paramstr        then begin
      pdf_fonttype := pftTrueType; end
    else if '/PS1' =    _paramstr        then begin
      pdf_fonttype := pftPsType1; end
    else if '/EN' =     _paramstr        then begin pdf_fontEncoding := pfeNoEncoding; end
    else if '/EW' =     _paramstr        then begin pdf_fontEncoding := pfeWinAnsiEncoding; end
    else if '/EM' =     _paramstr        then begin pdf_fontEncoding := pfeMacRomanEncoding; end
    else if '/WW' =     _paramstr        then begin pdf_systemTextControl.WordWrap := True; end
    else if '/L' =      _paramstr        then begin _isLandscape := True; end
    else if '/S' =      _paramstr        then begin pdf_styler := True; pdf_symbolic := True; end
    else if '/A4' =     _paramstr        then begin
      pdf_pagesetup.papersize := PaperSizeA4; end
    else if '/8X11' =   _paramstr        then begin
      pdf_pagesetup.papersize := PaperSize8x11; end
    else if '/A3' =     _paramstr        then begin
      pdf_pagesetup.papersize := PaperSizeA3; end
    else if '/LEGAL' =  _paramstr        then begin
      pdf_pagesetup.papersize := PaperSizeLegal; end
    else if '/B5' =     _paramstr        then begin
      pdf_pagesetup.papersize := PaperSizeB5; end
    else if '/C5' =     _paramstr        then begin
      pdf_pagesetup.papersize := PaperSizeC5; end
    else if '/PB' =     _paramstr        then pdf_pagesetup.pageBorder   := True
    else if '/SB' =     _paramstr        then pdf_pagesetup.columnBorder := cbSplitter
    else if '/CB' =     _paramstr        then pdf_pagesetup.columnBorder := cbBorder
    else if Pos ( '/BDP', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 );
      _paramstr := Copy ( _paramstr, 05, 01 );
      with pdf_pagesetup do begin
        if      _paramstr = '1' then borderDashPattern := pdpSolid
        else if _paramstr = '2' then borderDashPattern := pdp33
        else if _paramstr = '3' then borderDashPattern := pdp1222
        else if _paramstr = '4' then borderDashPattern := pdp2121
        else if _paramstr = '5' then borderDashPattern := pdp23535
        else if _paramstr = '6' then borderDashPattern := pdp13232;
      end;
      end
    else if Pos ( '/ASC', _paramstr ) = 01 then pdf_fontForceASCII := True
    else if Pos ( '/C', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_pagesetup.columnCount := StrToWord ( _paramstr ); end
    else if Pos ( '/R', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_pagesetup.rowCount    := StrToWord ( _paramstr ); end
    else if Pos ( '/X', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_pagesetup.papersize.width := StrToWord ( _paramstr );
      if pdf_pagesetup.papersize.width < 72 then pdf_pagesetup.papersize.width := 72; end
    else if Pos ( '/Y', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_pagesetup.papersize.height := StrToWord ( _paramstr );
      if pdf_pagesetup.papersize.height < 72 then pdf_pagesetup.papersize.height := 72; end
    else if Pos ( '/OUTL', _paramstr ) = 01 then pdf_pagemode := ppmOutlines
    else if Pos ( '/FITW', _paramstr ) = 01 then pdf_viewerPreferences := pvpFitWindow
    else if Pos ( '/CWIN', _paramstr ) = 01 then pdf_viewerPreferences := pvpCenterWindow
    else if Pos ( '/THUM', _paramstr ) = 01 then pdf_pagemode := ppmThumbs
    else if Pos ( '/F', _paramstr ) = 01 then begin
      pdf_fontname := ParamStr ( _i1 ); Delete ( pdf_fontname, 01, 02 ); end
    else if Pos ( '/S', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_pagesetup.columnFontPointSize := StrToWord ( _paramstr );
      end
    else if Pos ( '/T', _paramstr ) = 01 then begin
      _paramstr := ParamStr ( _i1 ); Delete ( _paramstr, 01, 02 );
      pdf_systemTextControl.TabSize := StrToWord ( _paramstr );
      if pdf_systemTextControl.TabSize < 01 then pdf_systemTextControl.TabSize := 01; end
    else if Pos ( '/DT', _paramstr ) = 01 then begin
      pdf_systemDocInfo.Title    := ParamStr ( _i1 ); Delete ( pdf_systemDocInfo.Title, 01, 03 );    end
    else if Pos ( '/DS', _paramstr ) = 01 then begin
      pdf_systemDocInfo.Subject  := ParamStr ( _i1 ); Delete ( pdf_systemDocInfo.Subject, 01, 03 );  end
    else if Pos ( '/DA', _paramstr ) = 01 then begin
      pdf_systemDocInfo.Author   := ParamStr ( _i1 ); Delete ( pdf_systemDocInfo.Author, 01, 03 );   end
    else if Pos ( '/DK', _paramstr ) = 01 then begin
      pdf_systemDocInfo.Keywords := ParamStr ( _i1 ); Delete ( pdf_systemDocInfo.Keywords, 01, 03 ); end
    else if Pos ( '/PT', _paramstr ) = 01 then begin
      pdf_pageTitle := ParamStr ( _i1 ); Delete ( pdf_pageTitle, 01, 03 ); end
    else if ( Copy ( _paramstr, 01, 01 ) <> '/' ) and
      ( UpperCase ( Copy ( _paramstr, Length ( _paramstr ) - 03, 04 ) ) = '.PDF' ) then begin
      _pdffilename := _paramstr
    end;
    { freeware - not supported
    else if Pos ( '/DC', _paramstr ) = 01 then begin
      pdf_docCreator  := ParamStr ( _i1 ); Delete ( pdf_docCreator, 01, 03 );  end
    else if Pos ( '/DP', _paramstr ) = 01 then begin
      pdf_docProducer := ParamStr ( _i1 ); Delete ( pdf_docProducer, 01, 03 );
    end;
    }
  end;

  if (_isLandscape) then begin
    _i1 := pdf_pagesetup.papersize.height;
    pdf_pagesetup.papersize.height := pdf_pagesetup.papersize.width;
    pdf_pagesetup.papersize.width  := _i1;
  end;

  if Length ( pdf_systemDocInfo.Title ) = 0 then pdf_systemDocInfo.Title := ParamStr ( 01 );

  PDF_CreateFromFile ( ParamStr ( 01 ), _pdffilename );

end.
