unit fm_main;

{$I DelVer.inc}

{ ----------------------------------------------------------------- }
{ vPdfCreator - Copyright [c] 1998-99 VISION Software (M) Sdn. Bhd. }
{ ----------------------------------------------------------------- }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls, ExtCtrls, OleCtrls, ToolWin, Spin, EnhCtrls;

{ ------------------ *note* ------------------ }
{ interface:      EnhCtrls.pas   -> ..\_helper }
{ implementation: PdfLib_TLB.pas -> ..\activeX }
{ -------------------------------------------- }

type
  TzForm_pdfCreator = class(TForm)
    panel_file: TPanel;
    panel_desk: TPanel;
    page_pdf: TPageControl;
    tabsheet_texteditor: TTabSheet;
    tabsheet_acrobat: TTabSheet;
    tabsheet_pdfsetup: TTabSheet;
    status_pdfCreator: TStatusBar;
    label_inputfile: TLabel;
    label_pdffile: TLabel;
    edit_inputfilename: TEdit;
    edit_pdffilename: TEdit;
    sb_inputnew: TSpeedButton;
    sb_viewPDF: TSpeedButton;
    memo_input: TMemo;
    sb_inputsave: TSpeedButton;
    sb_createPDF: TSpeedButton;
    sb_inputload: TSpeedButton;
    panel_pdfViewer: TPanel;
    sb_axPDFoff: TSpeedButton;
    panel_editor: TPanel;
    gb_fontstyle: TGroupBox;
    sb_fsBoldOff: TSpeedButton;
    sb_fsBoldItalicOn: TSpeedButton;
    sb_fsItalicOn: TSpeedButton;
    sb_fsBoldOn: TSpeedButton;
    sb_fsBoldItalicOff: TSpeedButton;
    sb_fsItalicOff: TSpeedButton;
    gb_fontcolor: TGroupBox;
    checkbox_fontstyle: TCheckBox;
    gb_quicktext: TGroupBox;
    edit_quicktext: TEdit;
    checkbox_newline: TCheckBox;
    checkbox_fontcolor: TCheckBox;
    combobox_fontcolor: TComboBox;
    sb_fcComboBox: TSpeedButton;
    edit_hexcolor: TEdit;
    sb_fcHexColor: TSpeedButton;
    GroupBox1: TGroupBox;
    sb_sfComboBox: TSpeedButton;
    combobox_symbolic: TComboBox;
    sb_browseInput: TSpeedButton;
    openDialog_input: TOpenDialog;
    sb_browsePDF: TSpeedButton;
    openDialog_pdf: TOpenDialog;
    sb_outline: TSpeedButton;
    sb_pagebreak: TSpeedButton;
    gb_columnal: TGroupBox;
    label_cpColumns: TLabel;
    label_cpRows: TLabel;
    label_cpColumnBorder: TLabel;
    combobox_cpColumnBorder: TComboBox;
    gb_actions: TGroupBox;
    sb_aRestore: TSpeedButton;
    sb_aLoadINI: TSpeedButton;
    sb_aSaveINI: TSpeedButton;
    combobox_cpBorderDashPattern: TComboBox;
    checkbox_cpPageBorder: TCheckBox;
    gb_pagesetup: TGroupBox;
    gb_margin: TGroupBox;
    label_pgTM: TLabel;
    edit_pgTM: TEdit;
    label_pgBM: TLabel;
    edit_pgBM: TEdit;
    label_pgLM: TLabel;
    edit_pgLM: TEdit;
    label_pgRM: TLabel;
    edit_pgRM: TEdit;
    label_clTM: TLabel;
    edit_clTM: TEdit;
    label_clBM: TLabel;
    edit_clBM: TEdit;
    label_clLM: TLabel;
    edit_clLM: TEdit;
    label_clRM: TLabel;
    edit_clRM: TEdit;
    label_clGapX: TLabel;
    edit_clGapX: TEdit;
    label_columnFontPointSize: TLabel;
    edit_columnFontPointSize: TEdit;
    status_acrobat: TStatusBar;
    gb_PasPDF: TGroupBox;
    checkbox_wordwrap: TCheckBox;
    checkbox_formfeed: TCheckBox;
    spin_tabsize: TSpinEdit;
    label_tabsize: TLabel;
    label_papersize: TLabel;
    combobox_papersize: TComboBox;
    label_customwidth: TLabel;
    edit_customwidth: TEdit;
    label_customheight: TLabel;
    edit_customheight: TEdit;
    gb_docInfo: TGroupBox;
    label_docAuthor: TLabel;
    edit_docAuthor: TEdit;
    edit_docTitle: TEdit;
    label_docTitle: TLabel;
    label_docSubject: TLabel;
    edit_docSubject: TEdit;
    label_docKeywords: TLabel;
    edit_docKeywords: TEdit;
    checkbox_styler: TCheckBox;
    checkbox_symbolic: TCheckBox;
    label_pdfver: TLabel;
    edit_pdfver: TEdit;
    label_pagemode: TLabel;
    combobox_pagemode: TComboBox;
    gb_pageTitle: TGroupBox;
    label_pageTitle: TLabel;
    edit_pageTitle: TEdit;
    label_fontPointSize: TLabel;
    edit_fontPointSize: TEdit;
    label_clGapY: TLabel;
    edit_clGapY: TEdit;
    tabsheet_about: TTabSheet;
    panel_aboutPoweredby: TPanel;
    panel_aboutInfo: TPanel;
    img_poweredby: TImage;
    label_developer: TLabel;
    label_website1: TLabel;
    label_website2: TLabel;
    label_email1: TLabel;
    status_about: TStatusBar;
    label_slogan: TLabel;
    Label1: TLabel;
    combobox_fontname: TComboBox;
    memo_about: TMemo;
    label_memo_input_column: TLabel;
    label_memo_input_row: TLabel;
    checkbox_landscape: TCheckBox;
    label_cpBorder: TLabel;
    spin_cpRows: TSpinEdit;
    spin_cpColumns: TSpinEdit;
    label_compiler: TLabel;
    label_compiledwith: TLabel;
    label_paspdf: TLabel;
    label_AllRightsReserved: TLabel;
    checkbox_outline: TCheckBox;
    gb_fontpointsize: TGroupBox;
    sb_fpsPoint: TSpeedButton;
    edit_fps: TEdit;
    checkbox_fontpointsize: TCheckBox;
    sb_fpsPlus: TSpeedButton;
    sb_fpsMinus: TSpeedButton;
    sb_fpsPercent: TSpeedButton;
    sb_fontend: TSpeedButton;
    rb_pas: TRadioButton;
    rb_cpp: TRadioButton;
    rb_html: TRadioButton;
    bevel_scriptstyle: TBevel;
    label_scriptstyle: TLabel;
    tabsheet_help: TTabSheet;
    gb_helpPsType1: TGroupBox;
    label_manualCourier: TLabel;
    label_manualHelvetica: TLabel;
    gb_helpPasPDF: TGroupBox;
    label_manualUserGuide: TLabel;
    label_manualHistory: TLabel;
    label_manualZapfDingbats: TLabel;
    label_manualTimesRoman: TLabel;
    label_manualSymbol: TLabel;
    label_manual_ascZapfDingbats: TLabel;
    procedure sb_inputnewClick(Sender: TObject);
    procedure sb_viewPDFClick(Sender: TObject);
    procedure sb_inputloadClick(Sender: TObject);
    procedure page_pdfChange(Sender: TObject);
    procedure sb_inputsaveClick(Sender: TObject);
    procedure sb_createPDFClick(Sender: TObject);
    procedure sb_axPDFoffClick(Sender: TObject);
    procedure sb_fontStyleClick(Sender: TObject);
    procedure sb_fontColorClick(Sender: TObject);
    procedure sb_sfComboBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure sb_browseInputClick(Sender: TObject);
    procedure sb_browsePDFClick(Sender: TObject);
    procedure sb_outlineClick(Sender: TObject);
    procedure sb_pagebreakClick(Sender: TObject);
    procedure sb_aRestoreClick(Sender: TObject);
    procedure sb_aMakeChangesClick(Sender: TObject);
    procedure sb_aLoadINIClick(Sender: TObject);
    procedure sb_aSaveINIClick(Sender: TObject);
    procedure label_websitelClick(Sender: TObject);
    procedure memo_inputKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure memo_inputClick(Sender: TObject);
    procedure label_manualClick(Sender: TObject);
    procedure status_acrobatDblClick(Sender: TObject);
    procedure rb_ScriptAsClick(Sender: TObject);
    procedure sb_fontPointSizeClick(Sender: TObject);
    procedure sb_fontendClick(Sender: TObject);
  private
    { Private declarations }
    procedure __axPDF_off;
    procedure __axPDF_on;
    procedure __memo_inputInsert ( _str : String );
    procedure __loadFromUnit;
    procedure __saveToUnit;
    procedure __loadFromINI;
    procedure __saveToINI;
    procedure __memo_inputStatus;
    procedure __verifyPaperSize;
  public
    { Public declarations }
  end;

var
  zForm_pdfCreator: TzForm_pdfCreator;

implementation


{$R *.DFM}

uses _StrNum_,
     pdfSign, pdfCmd, pdfFrTxt,
     ShellAPI, IniFiles, PdfLib_TLB;

var activeXViewer_PDF : TPdf;

procedure TzForm_pdfCreator.__axPDF_off;
begin
  if activeXViewer_PDF <> nil then begin
    activeXViewer_PDF.Free;
    activeXViewer_PDF := nil;
  end;
  panel_pdfViewer.Caption   := '';
  status_acrobat.SimpleText := ''; status_acrobat.Refresh;
end;

procedure TzForm_pdfCreator.__axPDF_on;
var _pdffilename, _foldername : String;
begin
  panel_pdfViewer.Caption := 'Activating Acrobat Reader (ActiveX)...';
  if activeXViewer_PDF = nil then begin
    activeXViewer_PDF := TPdf.Create ( self );
    { trick : using TPanel and TPdf.Align=alClient to activate }
    {         Acrobat Reader 3.x to load PDF file at run-time  }
    panel_pdfViewer.InsertControl ( activeXViewer_PDF );
    activeXViewer_PDF.Align := alClient;
  end;
  _pdffilename := Trim ( edit_pdffilename.Text );
  if Length ( _pdffilename ) = 0 then begin
    _pdffilename := ChangeFileExt ( Trim ( edit_inputfilename.Text ), '.pdf' );
  end;
  if UpperCase ( Copy ( _pdffilename,
    Length ( _pdffilename ) - 03, 04 ) ) <> '.PDF' then
    _pdffilename := _pdffilename + '.pdf';

  { Acrobat Reader will not read PDF file from current folder }
  { ..solution.. add "folder name" to the PDF file            }
  if Pos ( '\', _pdffilename ) = 0 then begin
    GetDir ( 0, _foldername );
    _pdffilename := _foldername + '\' + _pdffilename;
  end;
  if UpperCase ( Copy ( _pdffilename, Length ( _pdffilename ) - 04, 05 ) ) = '\.PDF' then
    _pdffilename := '';
  if _pdffilename = '' then begin
    __axPDF_off;
    panel_pdfViewer.Caption := 'No "PDF Filename" or "Input Filename" specified !';
    _pdffilename := '<none>'; end
  else if ( not ( FileExists ( _pdffilename ) ) ) then begin
    __axPDF_off;
    panel_pdfViewer.Caption := 'PDF file does not exists !';
    end
  else
    activeXViewer_PDF.src := _pdffilename;
  status_acrobat.SimpleText := 'File : [ ' + _pdffilename + ' ]';
  status_acrobat.Refresh;
end;

procedure TzForm_pdfCreator.__verifyPaperSize;
begin
  with pdf_pagesetup do begin

    if      ( papersize.width  = PaperSize8x11.width ) and
            ( papersize.height = PaperSize8x11.height ) then
      combobox_papersize.ItemIndex := 01
    else if ( papersize.width  = PaperSizeLetter.width ) and
            ( papersize.height = PaperSizeLetter.height ) then
      combobox_papersize.ItemIndex := 02
    else if ( papersize.width  = PaperSizeA4.width ) and
            ( papersize.height = PaperSizeA4.height ) then
      combobox_papersize.ItemIndex := 03
    else if ( papersize.width  = PaperSizeA3.width ) and
            ( papersize.height = PaperSizeA3.height ) then
      combobox_papersize.ItemIndex := 04
    else if ( papersize.width  = PaperSizeLegal.width ) and
            ( papersize.height = PaperSizeLegal.height ) then
      combobox_papersize.ItemIndex := 05
    else if ( papersize.width  = PaperSizeB5.width ) and
            ( papersize.height = PaperSizeB5.height ) then
      combobox_papersize.ItemIndex := 06
    else if ( papersize.width  = PaperSizeC5.width ) and
            ( papersize.height = PaperSizeC5.height ) then
      combobox_papersize.ItemIndex := 07
    else if ( papersize.width  = PaperSizeB4.width ) and
            ( papersize.height = PaperSizeB4.height ) then
      combobox_papersize.ItemIndex := 08
    else if ( papersize.width  = PaperSizeA5.width ) and
            ( papersize.height = PaperSizeA5.height ) then
      combobox_papersize.ItemIndex := 09
    else if ( papersize.width  = PaperSizeFolio.width ) and
            ( papersize.height = PaperSizeFolio.height ) then
      combobox_papersize.ItemIndex := 10
    else if ( papersize.width  = PaperSizeExecutive.width ) and
            ( papersize.height = PaperSizeExecutive.height ) then
      combobox_papersize.ItemIndex := 11
    else if ( papersize.width  = PaperSizeEnvB4.width ) and
            ( papersize.height = PaperSizeEnvB4.height ) then
      combobox_papersize.ItemIndex := 12
    else if ( papersize.width  = PaperSizeEnvB5.width ) and
            ( papersize.height = PaperSizeEnvB5.height ) then
      combobox_papersize.ItemIndex := 13
    else if ( papersize.width  = PaperSizeEnvC6.width ) and
            ( papersize.height = PaperSizeEnvC6.height ) then
      combobox_papersize.ItemIndex := 14
    else if ( papersize.width  = PaperSizeEnvDL.width ) and
            ( papersize.height = PaperSizeEnvDL.height ) then
      combobox_papersize.ItemIndex := 15
    else if ( papersize.width  = PaperSizeEnvMonarch.width ) and
            ( papersize.height = PaperSizeEnvMonarch.height ) then
      combobox_papersize.ItemIndex := 16
    else if ( papersize.width  = PaperSizeEnv9.width ) and
            ( papersize.height = PaperSizeEnv9.height ) then
      combobox_papersize.ItemIndex := 17
    else if ( papersize.width  = PaperSizeEnv10.width ) and
            ( papersize.height = PaperSizeEnv10.height ) then
      combobox_papersize.ItemIndex := 18
    else if ( papersize.width  = PaperSizeEnv11.width ) and
            ( papersize.height = PaperSizeEnv11.height ) then
      combobox_papersize.ItemIndex := 19
    else
      combobox_papersize.ItemIndex := 00;
  end;
end;

procedure TzForm_pdfCreator.__loadFromUnit;
begin
  with pdf_pagesetup do begin
    spin_cpColumns.Value := columnCount;
    spin_cpRows.Value    := rowCount;

    combobox_cpColumnBorder.ItemIndex := Ord ( columnBorder );

    checkbox_cpPageBorder.Checked := pageBorder;
    combobox_cpBorderDashPattern.ItemIndex := Ord ( borderDashPattern );

    combobox_pagemode.ItemIndex := Ord ( pdf_pagemode );
    checkbox_outline.Checked    := pdf_outline;

    checkbox_landscape.Checked := landscape;
    __verifyPaperSize;
    if ( Length ( edit_customwidth.Text ) = 0 ) or
       ( StrToInt ( edit_customwidth.Text ) <= 0 ) then
      edit_customwidth.Text := IntToStr ( papersize.width );
    if ( Length ( edit_customheight.Text ) = 0 ) or
       ( StrToInt ( edit_customheight.Text ) <= 0 ) then
      edit_customheight.Text := IntToStr ( papersize.height );

    checkbox_styler.Checked       := pdf_styler;
    checkbox_symbolic.Checked     := pdf_symbolic;
    edit_fontPointSize.Text       := IntToStr ( fontPointSize );
    edit_columnFontPointSize.Text := IntToStr ( columnFontPointSize );
    combobox_fontname.ItemIndex   := combobox_fontname.Items.IndexOf ( pdf_fontname );

    checkbox_styler.Checked       := pdf_styler;
    checkbox_symbolic.Checked     := pdf_symbolic;
    checkbox_formfeed.Checked     := pdf_textcontrol.FormFeed;
    checkbox_wordwrap.Checked     := pdf_textcontrol.WordWrap;
    spin_tabsize.Value            := pdf_textcontrol.tabsize;

    edit_pdfver.Text              := pdf_fileversion;
    edit_docTitle.Text            := pdf_systemDocInfo.Title;
    edit_docSubject.Text          := pdf_systemDocInfo.Subject;
    edit_docAuthor.Text           := pdf_systemDocInfo.Author;
    edit_docKeywords.Text         := pdf_systemDocInfo.Keywords;
    edit_pageTitle.Text           := pdf_pageTitle;

    edit_pgTM.Text                := IntToStr ( margin.Top );
    edit_pgBM.Text                := IntToStr ( margin.Bottom );
    edit_pgLM.Text                := IntToStr ( margin.Left );
    edit_pgRM.Text                := IntToStr ( margin.Right );
    edit_clTM.Text                := IntToStr ( columnMargin.Top );
    edit_clBM.Text                := IntToStr ( columnMargin.Bottom );
    edit_clLM.Text                := IntToStr ( columnMargin.Left );
    edit_clRM.Text                := IntToStr ( columnMargin.Right );
    edit_clGapX.Text              := IntToStr ( columnGap.x );
    edit_clGapY.Text              := IntToStr ( columnGap.y );
  end;
end;

procedure TzForm_pdfCreator.__saveToUnit;
begin
  with pdf_pagesetup do begin
    columnCount         := spin_cpColumns.Value;
    rowCount            := spin_cpRows.Value;
    columnBorder        := columnBorderType ( combobox_cpColumnBorder.ItemIndex );
    pageBorder          := checkbox_cpPageBorder.Checked;
    borderDashPattern   := pdf_dashPatternType ( combobox_cpBorderDashPattern.ItemIndex );
    pdf_pagemode        := pdf_pagemodeType ( combobox_pagemode.ItemIndex );
    pdf_outline         := checkbox_outline.Checked;
    landscape           := checkbox_landscape.Checked;
    case combobox_papersize.ItemIndex of
      00 : begin { <custom> }
          papersize.width  := StrToInt ( edit_customwidth.Text );
          papersize.height := StrToInt ( edit_customheight.Text );
        end;
      01 : begin { 8x11 }
          papersize.width  := PaperSize8x11.width;
          papersize.height := PaperSize8x11.height;
        end;
      02 : begin { Letter }
          papersize.width  := PaperSizeLetter.width;
          papersize.height := PaperSizeLetter.height;
        end;
      03 : begin { A4 }
          papersize.width  := PaperSizeA4.width;
          papersize.height := PaperSizeA4.height;
        end;
      04 : begin { A3 }
          papersize.width  := PaperSizeA3.width;
          papersize.height := PaperSizeA3.height;
        end;
      05 : begin { Legal }
          papersize.width  := PaperSizeLegal.width;
          papersize.height := PaperSizeLegal.height;
        end;
      06 : begin { B5 }
          papersize.width  := PaperSizeB5.width;
          papersize.height := PaperSizeB5.height;
        end;
      07 : begin { C5 }
          papersize.width  := PaperSizeC5.width;
          papersize.height := PaperSizeC5.height;
        end;
      08 : begin { B4 }
          papersize.width  := PaperSizeB4.width;
          papersize.height := PaperSizeB4.height;
        end;
      09 : begin { A5 }
          papersize.width  := PaperSizeA5.width;
          papersize.height := PaperSizeA5.height;
        end;
      10 : begin { Folio }
          papersize.width  := PaperSizeFolio.width;
          papersize.height := PaperSizeFolio.height;
        end;
      11 : begin { Executive }
          papersize.width  := PaperSizeExecutive.width;
          papersize.height := PaperSizeExecutive.height;
        end;
      12 : begin { Envelope B4 }
          papersize.width  := PaperSizeEnvB4.width;
          papersize.height := PaperSizeEnvB4.height;
        end;
      13 : begin { Envelope B5 }
          papersize.width  := PaperSizeEnvB5.width;
          papersize.height := PaperSizeEnvB5.height;
        end;
      14 : begin { Envelope C6 }
          papersize.width  := PaperSizeEnvC6.width;
          papersize.height := PaperSizeEnvC6.height;
        end;
      15 : begin { Envelope DL }
          papersize.width  := PaperSizeEnvDL.width;
          papersize.height := PaperSizeEnvDL.height;
        end;
      16 : begin { Envelope Monarch }
          papersize.width  := PaperSizeEnvMonarch.width;
          papersize.height := PaperSizeEnvMonarch.height;
        end;
      17 : begin { Envelope #9 }
          papersize.width  := PaperSizeEnv9.width;
          papersize.height := PaperSizeEnv9.height;
        end;
      18 : begin { Envelope #10 }
          papersize.width  := PaperSizeEnv10.width;
          papersize.height := PaperSizeEnv10.height;
        end;
      19 : begin { Envelope #11 }
          papersize.width  := PaperSizeEnv11.width;
          papersize.height := PaperSizeEnv11.height;
        end;
    end;

    pdf_styler          := checkbox_styler.Checked;
    pdf_symbolic        := checkbox_symbolic.Checked;
    fontPointSize       := StrToInt ( edit_fontPointSize.Text );
    columnFontPointSize := StrToInt ( edit_columnFontPointSize.Text );
    if combobox_fontname.ItemIndex <= 0 then
      pdf_fontname        := pdf_ps1fontname [ pdf_ps1Courier ]
    else if combobox_fontname.ItemIndex = 01 then
      pdf_fontname        := pdf_ps1fontname [ pdf_ps1Helvetica ]
    else if combobox_fontname.ItemIndex = 02 then
      pdf_fontname        := pdf_ps1fontname [ pdf_ps1TimesRoman ];

    pdf_styler               := checkbox_styler.Checked;
    pdf_symbolic             := checkbox_symbolic.Checked;
    pdf_textcontrol.FormFeed := checkbox_formfeed.Checked;
    pdf_textcontrol.WordWrap := checkbox_wordwrap.Checked;
    pdf_textcontrol.tabsize  := spin_tabsize.Value;

    pdf_fileversion      := Trim ( edit_pdfver.Text );
    pdf_systemDocInfo.Title    := edit_docTitle.Text;
    pdf_systemDocInfo.Subject  := edit_docSubject.Text;
    pdf_systemDocInfo.Author   := edit_docAuthor.Text;
    pdf_systemDocInfo.Keywords := edit_docKeywords.Text;
    pdf_pageTitle        := edit_pageTitle.Text;

    margin.Top          := PDF_str2pdf ( edit_pgTM.Text );
    margin.Bottom       := PDF_str2pdf ( edit_pgBM.Text );
    margin.Left         := PDF_str2pdf ( edit_pgLM.Text );
    margin.Right        := PDF_str2pdf ( edit_pgRM.Text );
    columnMargin.Top    := PDF_str2pdf ( edit_clTM.Text );
    columnMargin.Bottom := PDF_str2pdf ( edit_clBM.Text );
    columnMargin.Left   := PDF_str2pdf ( edit_clLM.Text );
    columnMargin.Right  := PDF_str2pdf ( edit_clRM.Text );
    columnGap.x         := PDF_str2pdf ( edit_clGapX.Text );
    columnGap.y         := PDF_str2pdf ( edit_clGapY.Text );
  end;
end;

procedure TzForm_pdfCreator.__loadFromINI;
var _iniF : TIniFile; _sectionname, _str : String;
begin
  _str := ChangeFileExt ( edit_inputfilename.Text, '.pdi' );
  _iniF := TIniFile.Create ( _str );
  with _iniF do with pdf_pagesetup, pdf_systemDocInfo do begin
    _sectionname := pdf_libname;
    edit_pdfver.Text          := ReadString  ( _sectionname, 'Pdf.FileVersion',      edit_pdfver.Text );
    checkbox_styler.Checked   := ReadBool    ( _sectionname, 'Pdf.Styler',           checkbox_styler.Checked );
    checkbox_symbolic.Checked := ReadBool    ( _sectionname, 'Pdf.SymbolicFont',     checkbox_symbolic.Checked );
    _str                      := Trim ( UpperCase ( ReadString  ( _sectionname, 'Pdf.PageMode',         combobox_pagemode.Text ) ) );
    combobox_pagemode.ItemIndex := combobox_pagemode.Items.IndexOf ( _str );
    checkbox_outline.Checked  := ReadBool    ( _sectionname, 'Pdf.Outline',     checkbox_outline.Checked );
    edit_docTitle.Text        := ReadString  ( _sectionname, 'Document.Title',       edit_docTitle.Text );
    edit_docSubject.Text      := ReadString  ( _sectionname, 'Document.Subject',     edit_docSubject.Text );
    edit_docAuthor.Text       := ReadString  ( _sectionname, 'Document.Author',      edit_docAuthor.Text );
    edit_docKeywords.Text     := ReadString  ( _sectionname, 'Document.Keywords',    edit_docKeywords.Text );

    papersize.width           := ReadInteger ( _sectionname, 'PaperSize.Width',      papersize.width );
    papersize.height          := ReadInteger ( _sectionname, 'PaperSize.Height',     papersize.height );
    __verifyPaperSize;
    if checkbox_landscape.Checked then _str := 'Landscape'
    else                               _str := 'Portrait';
    _str                      := ReadString  ( _sectionname, 'Orientation',          _str );
    checkbox_landscape.Checked :=  Pos ( 'L', Copy ( Trim ( _str ), 01, 01 ) ) = 01;
    spin_cpColumns.Value      := ReadInteger ( _sectionname, 'Columns',              spin_cpColumns.Value );
    spin_cpRows.Value         := ReadInteger ( _sectionname, 'Rows',                 spin_cpRows.Value );

    edit_pageTitle.Text       := ReadString  ( _sectionname, 'Page.Title',           edit_pageTitle.Text );
    edit_pgTM.Text            := ReadString  ( _sectionname, 'Page.Margin.Top',      edit_pgTM.Text );
    edit_pgBM.Text            := ReadString  ( _sectionname, 'Page.Margin.Bottom',   edit_pgBM.Text );
    edit_pgLM.Text            := ReadString  ( _sectionname, 'Page.Margin.Left',     edit_pgLM.Text );
    edit_pgRM.Text            := ReadString  ( _sectionname, 'Page.Margin.Right',    edit_pgRM.Text );
    edit_fontPointSize.Text   := ReadString  ( _sectionname, 'Page.Font.PointSize',  edit_fontPointSize.Text );

    edit_clTM.Text            := ReadString  ( _sectionname, 'Column.Margin.Top',    edit_clTM.Text );
    edit_clBM.Text            := ReadString  ( _sectionname, 'Column.Margin.Bottom', edit_clBM.Text );
    edit_clLM.Text            := ReadString  ( _sectionname, 'Column.Margin.Left',   edit_clLM.Text );
    edit_clRM.Text            := ReadString  ( _sectionname, 'Column.Margin.Right',  edit_clRM.Text );
    edit_clGapX.Text          := ReadString  ( _sectionname, 'Column.Gap.X',         edit_clGapX.Text );
    edit_clGapY.Text          := ReadString  ( _sectionname, 'Column.Gap.Y',         edit_clGapY.Text );
    combobox_cpBorderDashPattern.ItemIndex := combobox_cpBorderDashPattern.Items.IndexOf (
      ReadString  ( _sectionname, 'Border.DashPattern', combobox_cpBorderDashPattern.Text ) );
    checkbox_cpPageBorder.Checked := ReadBool ( _sectionname, 'Border.Page',         checkbox_cpPageBorder.Checked );
    combobox_cpColumnBorder.ItemIndex := combobox_cpColumnBorder.Items.IndexOf (
      ReadString  ( _sectionname, 'Border.Column',     combobox_cpColumnBorder.Text ) );

    combobox_fontname.ItemIndex   := combobox_fontname.Items.IndexOf ( ReadString  ( _sectionname, 'Font.Name',
                                     combobox_fontname.Items [ combobox_fontname.ItemIndex ] ) );
    edit_columnFontPointSize.Text := ReadString  ( _sectionname, 'Font.PointSize',   edit_columnFontPointSize.Text );

    checkbox_wordwrap.Checked := ReadBool    ( _sectionname, 'Text.WordWrap',        checkbox_wordwrap.Checked );
    checkbox_formfeed.Checked := ReadBool    ( _sectionname, 'Text.FormFeed',        checkbox_formfeed.Checked );
    spin_tabsize.Value        := ReadInteger ( _sectionname, 'Text.TabSize',         spin_tabsize.Value );
  end;
  _iniF.Free; // __saveToUnit;
end;

procedure TzForm_pdfCreator.__saveToINI;
var _iniF : TIniFile; _str, _sectionname : String;
begin
  _str := ChangeFileExt ( edit_inputfilename.Text, '.pdi' );
  _iniF := TIniFile.Create ( _str );
  with _iniF do with pdf_pagesetup, pdf_systemDocInfo do begin
    _sectionname := pdf_libname;
    WriteString  ( _sectionname, 'Pdf.CreationInfo',      pdf_appname + ' v' + pdf_appversion );
    WriteString  ( _sectionname, 'Pdf.FileVersion',       edit_pdfver.Text );
    WriteBool    ( _sectionname, 'Pdf.Styler',            checkbox_styler.Checked );
    WriteBool    ( _sectionname, 'Pdf.SymbolicFont',      checkbox_symbolic.Checked );
    WriteString  ( _sectionname, 'Pdf.PageMode',          combobox_pagemode.Items [ combobox_pagemode.ItemIndex ] );
    WriteBool    ( _sectionname, 'Pdf.Outline',           checkbox_outline.Checked );

    WriteString  ( _sectionname, 'Document.Title',        edit_docTitle.Text );
    WriteString  ( _sectionname, 'Document.Subject',      edit_docSubject.Text );
    WriteString  ( _sectionname, 'Document.Author',       edit_docAuthor.Text );
    WriteString  ( _sectionname, 'Document.Keywords',     edit_docKeywords.Text );

    WriteInteger ( _sectionname, 'PaperSize.Width',       papersize.width );
    WriteInteger ( _sectionname, 'PaperSize.Height',      papersize.height );
    if checkbox_landscape.Checked then _str := 'Landscape'
    else                               _str := 'Portrait';
    WriteString  ( _sectionname, 'Orientation',           _str );
    WriteInteger ( _sectionname, 'Columns',               spin_cpColumns.Value );
    WriteInteger ( _sectionname, 'Rows',                  spin_cpRows.Value );

    WriteString  ( _sectionname, 'Page.Title',            edit_pageTitle.Text );
    WriteString  ( _sectionname, 'Page.Margin.Top',       edit_pgTM.Text );
    WriteString  ( _sectionname, 'Page.Margin.Bottom',    edit_pgBM.Text );
    WriteString  ( _sectionname, 'Page.Margin.Left',      edit_pgLM.Text );
    WriteString  ( _sectionname, 'Page.Margin.Right',     edit_pgRM.Text );
    WriteString  ( _sectionname, 'Page.Font.PointSize',   edit_fontPointSize.Text );

    WriteString  ( _sectionname, 'Column.Margin.Top',     edit_clTM.Text );
    WriteString  ( _sectionname, 'Column.Margin.Bottom',  edit_clBM.Text );
    WriteString  ( _sectionname, 'Column.Margin.Left',    edit_clLM.Text );
    WriteString  ( _sectionname, 'Column.Margin.Right',   edit_clRM.Text );
    WriteString  ( _sectionname, 'Column.Gap.X',          edit_clGapX.Text );
    WriteString  ( _sectionname, 'Column.Gap.Y',          edit_clGapY.Text );
    WriteString  ( _sectionname, 'Border.DashPattern',    combobox_cpBorderDashPattern.Items [ combobox_cpBorderDashPattern.ItemIndex ] );
    WriteBool    ( _sectionname, 'Border.Page',           checkbox_cpPageBorder.Checked );
    WriteString  ( _sectionname, 'Border.Column',         combobox_cpColumnBorder.Items [ combobox_cpColumnBorder.ItemIndex ] );

    WriteString  ( _sectionname, 'Font.Name',             combobox_fontname.Items [ combobox_fontname.ItemIndex ] );
    WriteString  ( _sectionname, 'Font.PointSize',        edit_columnFontPointSize.Text );

    WriteBool    ( _sectionname, 'Text.WordWrap',          checkbox_wordwrap.Checked );
    WriteBool    ( _sectionname, 'Text.FormFeed',          checkbox_formfeed.Checked );
    WriteInteger ( _sectionname, 'Text.TabSize',           spin_tabsize.Value );
  end;
  _iniF.Free; // __saveToUnit;
end;

procedure TzForm_pdfCreator.sb_inputnewClick(Sender: TObject);
begin
  edit_inputfilename.Text := '';
  edit_pdffilename.Text   := '';
  memo_input.Lines.Clear;
  page_pdf.ActivePage := tabsheet_texteditor;
  __axPDF_off; __memo_inputStatus;
end;

procedure TzForm_pdfCreator.sb_viewPDFClick(Sender: TObject);
begin
  __axPDF_on; page_pdf.ActivePage := tabsheet_acrobat;
end;

procedure TzForm_pdfCreator.sb_inputloadClick(Sender: TObject);
begin
  if Length ( Trim ( edit_inputfilename.Text ) ) = 0 then
    ShowMessage ( 'No "Input Filename" specified.'#13#13'Failure to load "Input File" !' )
  else if ( not ( FileExists ( edit_inputfilename.Text ) ) ) then
    ShowMessage ( 'Input file does not exists'#13'(' + edit_inputfilename.Text + ')'#13#13'Failure to load "Input File" !' )
  else begin
    memo_input.Lines.LoadFromFile ( edit_inputfilename.Text );
    SetScriptStyle ( edit_inputfilename.Text ); rb_ScriptAsClick ( nil );
    __loadFromINI;
    page_pdf.ActivePage := tabsheet_texteditor;
    __axPDF_off; __memo_inputStatus;
  end;
end;

procedure TzForm_pdfCreator.page_pdfChange(Sender: TObject);
begin
  if ( page_pdf.ActivePage = tabsheet_acrobat ) and
    ( activeXViewer_PDF = nil ) then begin
    if ( Length ( Trim ( edit_inputfilename.Text ) ) >= 01 ) or
       ( Length ( Trim ( edit_pdffilename.Text ) )   >= 01 ) then
      __axPDF_on;
  end;
end;

procedure TzForm_pdfCreator.sb_inputsaveClick(Sender: TObject);
begin
  if Length ( Trim ( edit_inputfilename.Text ) ) = 0 then
    ShowMessage ( 'No "Input Filename" specified.'#13#13'Failure to save "Input File" !' )
  else begin
    memo_input.Lines.SaveToFile ( edit_inputfilename.Text );
    __saveToINI;
  end;
end;

procedure TzForm_pdfCreator.sb_createPDFClick(Sender: TObject);
begin
  __saveToUnit;
  if Length ( Trim ( edit_inputfilename.Text ) ) = 0 then
    ShowMessage ( 'No "Input Filename" specified.'#13#13'Failure to create PDF file !' )
  else begin
    sb_inputSaveClick ( self );
    if ( not ( FileExists ( edit_inputfilename.Text ) ) ) then
      ShowMessage ( 'Input file does not exists'#13'(' + edit_inputfilename.Text + ')'#13#13'Failure to create PDF file !' )
    else begin
      __axPDF_off;
      status_pdfCreator.SimpleText := 'Creating PDF file... [ ' +
                           edit_inputfilename.Text + ' to [ ' +
                           edit_pdffilename.Text + ']';
      status_pdfCreator.Refresh;
      PDF_Reset;
      PDF_CreateFromFile ( edit_inputfilename.Text, edit_pdffilename.Text );
      rb_ScriptAsClick ( nil );
      status_pdfCreator.SimpleText := '[ ' + pdf_filename + ' ' +
        IntToStr ( pdf_currentobject ) + ' objects ' +
        IntToStr ( pdf_pagesetup.currentpage ) + ' page(s) ' +
        IntToStr ( pdf_outlineCount ) + ' outline(s) ' +
        IntToStr ( pdf_currentfilepos ) + ' bytes -> ' +
        ThreeDecPtStr ( pdf_pagesetup.mediasize.width  / pdf_pointsPerInch ) + 'x' +
        ThreeDecPtStr ( pdf_pagesetup.mediasize.height / pdf_pointsPerInch ) + 'in (' +
        IntToStr ( pdf_pagesetup.mediasize.width ) + 'x' +
        IntToStr ( pdf_pagesetup.mediasize.height ) + ')';
      status_pdfCreator.Refresh;
      if pdf_pagesetup.currentpage >= 01 then begin
        edit_pdffilename.Text := pdf_filename;
        sb_viewPDFClick ( self );
      end;
    end;
  end;
end;

procedure TzForm_pdfCreator.sb_axPDFoffClick(Sender: TObject);
begin
  __axPDF_off;
end;

procedure TzForm_pdfCreator.__memo_inputInsert ( _str : String );
var _at : Word;
begin
  _at := 0;
  while _at < Length ( _str ) do begin
    Inc ( _at );
    SendMessage( memo_input.Handle, WM_CHAR, Word ( _str [ _at ] ), 0);
  end;
end;

procedure TzForm_pdfCreator.sb_fontStyleClick(Sender: TObject);
var _str, _start, _end : String; _at : Word;
begin
  if      Sender = sb_fsBoldOn        then _str := sb_fsBoldOn.Caption
  else if Sender = sb_fsBoldOff       then _str := sb_fsBoldOff.Caption
  else if Sender = sb_fsItalicOn      then _str := sb_fsItalicOn.Caption
  else if Sender = sb_fsItalicOff     then _str := sb_fsItalicOff.Caption
  else if Sender = sb_fsBoldItalicOn  then _str := sb_fsBoldItalicOn.Caption
  else if Sender = sb_fsBoldItalicOff then _str := sb_fsBoldItalicOff.Caption;
  if Length ( script_1start ) = 0 then begin
    _start := script_2start; _end := script_2end; end
  else begin
    _start := script_1start; _end := script_1end;
  end;
  Delete ( _str, 01, 01 ); Delete ( _str, Length ( _str ), 01 );
  _str := _start + _str + _end;
  if checkbox_fontstyle.Checked then begin
    _str := _str + edit_quicktext.Text + _str;
    if Copy ( _str, Length ( _start ) + 01, 01 ) = '/' then
      Delete ( _str, Length ( _start ) + 01, 01 );
    _at  := RPos ( _start, _str );
    if Copy ( _str, _at + Length ( _start ), 01 ) <> '/' then
      Insert ( '/', _str, _at + Length ( _start ) );
    if checkbox_newline.Checked then _str := _str + #13;
  end;
  __memo_inputInsert ( _str );
end;

procedure TzForm_pdfCreator.sb_fontColorClick(Sender: TObject);
var _str, _start, _end : String;
begin
  if      Sender = sb_fcComboBox then _str := combobox_fontcolor.Text
  else if Sender = sb_fcHexColor then _str := edit_hexcolor.Text;
  if Length ( script_1start ) = 0 then begin
    _start := script_2start; _end := script_2end; end
  else begin
    _start := script_1start; _end := script_1end;
  end;
  _str := _start + 'font color=' + _str + _end;
  if checkbox_fontcolor.Checked then begin
    _str := _str + edit_quicktext.Text + _start + '/font' + _end;
    if checkbox_newline.Checked then _str := _str + #13;
  end;
  __memo_inputInsert ( _str );
end;

procedure TzForm_pdfCreator.sb_sfComboBoxClick(Sender: TObject);
begin
  if      Sender = sb_sfComboBox then
    __memo_inputInsert ( script_2start + 's.' + combobox_symbolic.Text + script_2end );
end;

procedure TzForm_pdfCreator.FormCreate(Sender: TObject);
var _at : Word;
begin
  { setup default setting of "PasPDF" }
  pdf_styler        := True;
  pdf_symbolic      := True;
  pdf_appname       := 'vPdfCreator';
  pdf_appversion    := '0.943';
  pdf_appcopyright  := 'gongxi@tm.net.my';
  Application.Title := pdf_appname + ' v' + pdf_appversion;


  { *new* v0.942 *start* setup default text of misc. "combo-box"  }

  { setup for combo-box of "Symbolic Font" }
  combobox_symbolic.Items.Clear;
  for _at := 01 to psfCommandMax do
    combobox_symbolic.Items.Add ( psfCommands [ _at ] );
  combobox_symbolic.ItemIndex  := psfSee - 01;

  { setup for combo-box of "Font Name" }
  combobox_fontname.Items.Clear;
  combobox_fontname.Items.Add ( pdf_ps1fontname [ pdf_ps1Courier ] );
  combobox_fontname.Items.Add ( pdf_ps1fontname [ pdf_ps1Helvetica ] );
  combobox_fontname.Items.Add ( pdf_ps1fontname [ pdf_ps1TimesRoman ] );
  combobox_fontname.ItemIndex := combobox_fontname.Items.IndexOf ( pdf_ps1fontname [ pdf_ps1Courier ] );

  { setup for combo-box of "Paper Size" }
  combobox_papersize.Items.Clear;
  combobox_papersize.Items.Add ( '<custom>' );
  combobox_papersize.Items.Add ( '8x11 ('         + PDF_pdf2inStr ( PaperSize8x11.width )        + 'x' +
                                                    PDF_pdf2inStr ( PaperSize8x11.height )       + 'in)' );
  combobox_papersize.Items.Add ( 'Letter ('       + PDF_pdf2inStr ( PaperSizeLetter.width )      + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeLetter.height )     + 'in)' );
  combobox_papersize.Items.Add ( 'A4 ('           + PDF_pdf2mmStr ( PaperSizeA4.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeA4.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'A3 ('           + PDF_pdf2mmStr ( PaperSizeA3.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeA3.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'Legal ('        + PDF_pdf2inStr ( PaperSizeLegal.width )       + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeLegal.height )      + 'in)' );
  combobox_papersize.Items.Add ( 'B5 ('           + PDF_pdf2mmStr ( PaperSizeB5.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeB5.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'C5 ('           + PDF_pdf2mmStr ( PaperSizeC5.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeC5.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'B4 ('           + PDF_pdf2mmStr ( PaperSizeB4.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeB4.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'A5 ('           + PDF_pdf2mmStr ( PaperSizeA5.width )          + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeA5.height )         + 'mm)' );
  combobox_papersize.Items.Add ( 'Folio ('        + PDF_pdf2mmStr ( PaperSizeFolio.width )       + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeFolio.height )      + 'mm)' );
  combobox_papersize.Items.Add ( 'Executive ('    + PDF_pdf2mmStr ( PaperSizeExecutive.width )   + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeExecutive.height )  + 'mm)' );
  combobox_papersize.Items.Add ( 'Envelope B4 ('  + PDF_pdf2mmStr ( PaperSizeEnvB4.width )       + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeEnvB4.height )      + 'mm)' );
  combobox_papersize.Items.Add ( 'Envelope B5 ('  + PDF_pdf2mmStr ( PaperSizeEnvB5.width )       + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeEnvB5.height )      + 'mm)' );
  combobox_papersize.Items.Add ( 'Envelope C6 ('  + PDF_pdf2mmStr ( PaperSizeEnvC6.width )       + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeEnvC6.height )      + 'mm)' );
  combobox_papersize.Items.Add ( 'Envelope DL ('  + PDF_pdf2mmStr ( PaperSizeEnvDL.width )       + 'x' +
                                                    PDF_pdf2mmStr ( PaperSizeEnvDL.height )      + 'mm)' );
  combobox_papersize.Items.Add ( 'Envelope Monarch (' +
                                                    PDF_pdf2inStr ( PaperSizeEnvMonarch.width )  + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeEnvMonarch.height ) + 'in)' );
  combobox_papersize.Items.Add ( 'Envelope #9 ('  + PDF_pdf2inStr ( PaperSizeEnv9.width )        + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeEnv9.height )       + 'in)' );
  combobox_papersize.Items.Add ( 'Envelope #10 (' + PDF_pdf2inStr ( PaperSizeEnv10.width )       + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeEnv10.height )      + 'in)' );
  combobox_papersize.Items.Add ( 'Envelope #11 (' + PDF_pdf2inStr ( PaperSizeEnv11.width )       + 'x' +
                                                    PDF_pdf2inStr ( PaperSizeEnv11.height )      + 'in)' );
  { *new* v0.942 *end* setup default text of misc. "combo box"  }

  gb_PasPDF.Caption := ' [PasPDF] v' + pdf_libversion + ' System Control ';

  zForm_pdfCreator.Caption := 'VISION PDF Creator v' + pdf_appversion +
    ' - freeware (' + pdf_libname + ' - Native PDF Creation for Delphi) ';

  {$ifdef Delphi1} label_compiler.Caption := 'Inprise Delphi 1'; {$endif}
  {$ifdef Delphi2} label_compiler.Caption := 'Inprise Delphi 2'; {$endif}
  {$ifdef Delphi3} label_compiler.Caption := 'Inprise Delphi 3'; {$endif}
  {$ifdef Delphi4} label_compiler.Caption := 'Inprise Delphi 4'; {$endif}

  label_paspdf.Caption := pdf_libname + ' v' + pdf_libversion;

  { load from PasPDF library as the default values }
  __loadFromUnit;

  __memo_inputStatus; page_pdf.ActivePage := tabsheet_about;

  { Application.FormMaximize; }
end;

procedure TzForm_pdfCreator.sb_browseInputClick(Sender: TObject);
begin
  openDialog_input.Filename := edit_inputfilename.Text;
  if openDialog_input.Execute then begin
    edit_inputfilename.Text := openDialog_input.Filename;
    edit_pdffilename.Text   := '';
    sb_inputLoadClick ( self );
  end;
end;

procedure TzForm_pdfCreator.sb_browsePDFClick(Sender: TObject);
begin
  openDialog_pdf.Filename := edit_pdffilename.Text;
  if openDialog_pdf.Execute then begin
    edit_pdffilename.Text := openDialog_pdf.Filename;
    sb_viewPDFClick ( self );
  end;
end;

procedure TzForm_pdfCreator.sb_outlineClick(Sender: TObject);
begin
  __memo_inputInsert ( script_2start + 'outline="' + edit_quicktext.Text + '"' + script_2end + #13 );
end;

procedure TzForm_pdfCreator.sb_pagebreakClick(Sender: TObject);
begin
  __memo_inputInsert ( script_2start + 'pagebreak' + script_2end + #13 );
end;

procedure TzForm_pdfCreator.sb_aRestoreClick(Sender: TObject);
begin
  __loadFromUnit;
end;

procedure TzForm_pdfCreator.sb_aMakeChangesClick(Sender: TObject);
begin
  __saveToUnit;
end;

procedure TzForm_pdfCreator.sb_aLoadINIClick(Sender: TObject);
begin
  __loadFromINI;
end;

procedure TzForm_pdfCreator.sb_aSaveINIClick(Sender: TObject);
begin
  __saveToINI;
end;

procedure TzForm_pdfCreator.label_websitelClick(Sender: TObject);
begin
  status_about.SimpleText := 'Launching [ ' + TLabel ( Sender ).Caption + ' ...';
  status_about.Refresh;
  if Length ( Trim ( TLabel ( Sender ).Hint ) ) = 0 then
    ShellExecute ( Handle, 'open', PChar ( TLabel ( Sender ).Caption ), nil, nil, SW_SHOW )
  else
    ShellExecute ( Handle, 'open', PChar ( TLabel ( Sender ).Hint ), nil, nil, SW_SHOW );
  status_about.SimpleText := '[ ' + TLabel ( Sender ).Caption + ' executed...';
  status_about.Refresh;
end;

procedure TzForm_pdfCreator.memo_inputKeyUp(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  __memo_inputStatus;
end;

procedure TzForm_pdfCreator.memo_inputClick(Sender: TObject);
begin
  __memo_inputStatus;
end;

procedure TzForm_pdfCreator.__memo_inputStatus;
begin
  label_memo_input_column.Caption := 'C:' + WordToStr ( memo_input.Col + 1, 5 );
  label_memo_input_row.Caption    := 'R:' + WordToStr ( memo_input.Row + 1, 5 );
end;

procedure TzForm_pdfCreator.label_manualClick(Sender: TObject);
begin
  edit_pdffilename.Text := ExtractFilePath ( ParamStr ( 0 ) ) +
                           TLabel ( Sender ).Hint + '.pdf';
  sb_viewPDFClick ( self );
end;

procedure TzForm_pdfCreator.status_acrobatDblClick(Sender: TObject);
begin
  if panel_file.Visible then page_pdf.TabHeight := 1
  else                       page_pdf.TabHeight := 0;
  panel_file.Visible := not panel_file.Visible;
end;

procedure TzForm_pdfCreator.rb_ScriptAsClick(Sender: TObject);
begin

  if      Sender = rb_html then script_style := scriptHTML
  else if Sender = rb_pas  then script_style := scriptPascal
  else if Sender = rb_cpp  then script_style := scriptCPP;
  case script_style of
    scriptHTML : begin
        rb_html.Checked := True;  rb_pas.Checked  := False;
        rb_cpp.Checked  := False; SetScript2Html;
      end;
    scriptPascal : begin
        rb_html.Checked := False; rb_pas.Checked  := True;
        rb_cpp.Checked  := False; SetScript2Pascal;
      end;
    scriptCPP : begin
        rb_html.Checked := False; rb_pas.Checked  := False;
        rb_cpp.Checked  := True;  SetScript2CPP;
    end;
  end;
end;

procedure TzForm_pdfCreator.sb_fontPointSizeClick(Sender: TObject);
var _str, _start, _end : String; _at : Word;
begin
  if Length ( script_1start ) = 0 then begin
    _start := script_2start; _end := script_2end; end
  else begin
    _start := script_1start; _end := script_1end;
  end;
  if Sender = sb_fpsPoint then
    _str := _start + 'font pointsize='  + edit_fps.Text + _end
  else if Sender = sb_fpsPlus then
    _str := _start + 'font pointsize=+' + edit_fps.Text + _end
  else if Sender = sb_fpsMinus then
    _str := _start + 'font pointsize=-' + edit_fps.Text + _end
  else if Sender = sb_fpsPercent then
    _str := _start + 'font pointsize=' + edit_fps.Text + '%' + _end;

  if checkbox_fontpointsize.Checked then begin
    _str := _str + edit_quicktext.Text + _start + '/font' + _end;
    if Copy ( _str, Length ( _start ) + 01, 01 ) = '/' then
      Delete ( _str, Length ( _start ) + 01, 01 );
    _at  := RPos ( _start, _str );
    if Copy ( _str, _at + Length ( _start ), 01 ) <> '/' then
      Insert ( '/', _str, _at + Length ( _start ) );
    if checkbox_newline.Checked then _str := _str + #13;
  end;
  __memo_inputInsert ( _str );
end;

procedure TzForm_pdfCreator.sb_fontendClick(Sender: TObject);
var _start, _end : String;
begin
  if Length ( script_1start ) = 0 then begin
    _start := script_2start; _end := script_2end; end
  else begin
    _start := script_1start; _end := script_1end;
  end;
  __memo_inputInsert ( _start + '/font' + _end );
end;

end.
