unit PMDdeGrp;
{	Usage of a var PMDdeGroups:TPMDdeGroups is restricted to the code between the "brackets"
		PMDdeGroups:= TPMDdeGroups.Create(OwnerComponent);
	and
		PMDdeGroups.Destroy;
	Create reserves resources: storage for the object and a dde conbersation with the Program
	Manager. The TStringList PMDdeGroups.Groups contains the names of groups.

	To get access to more information concerning the group with index G and its items,
	associate to it an TPMDDeGroup object by
		PMDdeGroups.OpenGroup(G);
	OpenGroup(G) is idempotent: more than one call (before a CloseGroup(G)) do not matter.

	The TPMDdeGroup may be dissociated explicitly by
		PMDdeGroups.CloseGroup(G);
	CloseGrp will implicitly release all TPMGFItems and free all reserved resources.
	Errors are signalled by Exceptions labelled with PMDdeGrp/severity

	Freeware: P.J. Veger, Best, The Netherlands}
interface
uses SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, DDEMan, PMGrps;

type
	TPMDdeGroups	= class(TDdeClientConv)
		Groups		: TStringList {groupnames, with associated TPMGroup objects};
		constructor	Create(AOwner: TComponent); override;
		destructor	Destroy; override;
		procedure	OpenGroup(G: GroupIndexSet);
		procedure	CloseGroup(G: GroupIndexSet);
	end;
	TPMDdeGroup		= class(TObject)
		GrpFileName	: string[80];
		Items			: TStringList {itemnames, with associated TPMItem objects};
	private
		constructor	Create;
		destructor	Destroy; override;
	end;
	TPMDdeItem		= class(TObject)
		CommandLine	: string[144];
		DefaultDir	: string[80];
		IconPath		: string[80];
      IconLeft		: Word;
      IconTop		: Word;
		IconIndex	: Word;
		ShortCut		: Word;
		RunMinimized: Boolean;
	private
		constructor	Create;
		destructor	Destroy; override;
	end;

implementation

{Assumed Syntax of PM's answer on RequestDate(GroupName):
DDELineSeq	: Line CR+LF (Line CR+LF)* NUL
Line			: Item (, Item)*
Item			: "Char1* (with an even number of ")"
				| Char2*
Char1			: any char except CR+LF NUL
Char2			: any char except COMMA CR+LF NUL
CR+LF			: CR necessarily followed by a LF
*				: zero or more times the preceding (bracketed) element
}
function UnpackLine(BoL: PChar; SL: TStringList): PChar;
var 				{BoL to Begin of Line or to End of LineSeq, i.e. NUL}
	EoL				{End of Line: CR}
	, BoI				{Begin of lineItem}
	, EoI: PChar;	{End of lineItem}
	AC: array[0..255] of char;
const CR=#13; LF=#10;
function ForceDQuote(PC: PChar):PChar;
	begin
		PC:= StrScan(PC,'"');
		if (PC=nil) or (PC>=EoL) then
				raise Exception.Create('PMDdeGrp/2: doublequote error');
		Result:= PC+1
	end;
begin
	SL.Clear;
	if BoL^<>#0 then begin
		EoL:= StrScan(BoL, CR);
		if EoL=nil then
			raise Exception.Create('PMDdeGrp/2: CR missing in PM info');
		if (EoL+1)^<> LF then
			raise Exception.Create('PMDdeGrp/2: LF missing after CR in PM info');
		EoI:= BoL-1;
		repeat
			BoI:= EoI+1;
			if BoI^='"' then begin
				Inc(BoI);
				EoI:= ForceDQuote(BoI);
				while (EoI<EoL) and (EoI^<>',') do begin
					EoI:= ForceDQuote(EoI);
					EoI:= ForceDQuote(EoI)
				end;
				StrLCopy(Ac, BoI, EoI-1-BoI)
			end else begin
				EoI:= StrScan(BoI,',');
				if (EoI=nil) or (EoI>=EoL) then EoI:=EoL;
				StrLCopy(AC, BoI, EoI-BoI)
         end;
			SL.Add(StrPas(AC));
		until EoI=EoL;
		BoL:= EoL+2
	end;
	Result:= BoL
end;

constructor	TPMDdeGroups.Create(Aowner: TComponent);
begin
	inherited Create(AOwner);
	SetLink('Progman', 'Progman');
	OpenLink;
	Groups:= TStringList.Create;
	Groups.SetText(RequestData('Groups'));
end;

destructor	TPMDdeGroups.Destroy;
var G: Word;
begin
	for G:= 0 to Groups.Count-1 do CloseGroup(G);
	Groups.Free;
	CloseLink;
	inherited Destroy;
end;

procedure TPMDdeGroups.OpenGroup(G: GroupIndexSet);
var Group		: TPMDdeGroup;
	Item			: TPMDdeItem;
	DDELineSeq	: PChar;
	BoL			: PChar;
	I, NumLines	: Word;
	SLLine		: TStringList;
begin
	if G>=Groups.Count then
		raise Exception.CreateFmt(
			'PMDdeGrp/0: Group index %d too large; there are only %d items'
			,[G, Groups.Count]);
	if Groups.Objects[G]=nil then begin
		Group:=TPMDdeGroup.Create;
		DDELineSeq:= RequestData(Groups.Strings[G]);
		try
			SLLine:= TStringList.Create;
	      try
				BoL:= UnpackLine(DDELineSeq, SLLine);
				if SLLine.Count<> 4 then
            	raise Exception.Create('PMDdeGrp/2: PM group line does not contain 4 line items');
				if SLLine[0]<>Groups.Strings[G] then
					raise Exception.Create('PMDdeGrp/2: group item name error');
				Group.GrpFileName:= SLLine[1];
				try NumLines:=StrToInt(SLLine[2])
            except
					on EConvertError do raise Exception.Create(
               	'PMDdeGrp/2: third line item on PM group line is not numeric')
            end;
            {fourth line item: ????}
				for I:= 0 to NumLines-1 do begin
					BoL:= UnpackLine(BoL, SLLine);
					if SLLine.Count<>9 then
						raise Exception.Create('PMDdeGrp/2: PM item line does not contain 9 line items');
					Item:= TPMDdeItem.Create;
					with Item do begin
						CommandLine:= SLLine[1];
						DefaultDir:= SLLine[2];
						IconPath:= SLLine[3];
                  IconLeft:= StrToInt(SLLine[4]);
                  IconTop:= StrToInt(SLLine[5]);
						IconIndex:= StrToInt(SLLine[6]);
						ShortCut:= Word(StrToInt(SLLine[7]));
						if SLLIne[8]= '0' then RunMinimized:=False
							else RunMinimized:=True;
					end;
				Group.Items.AddObject(SLLine[0], Item);
				end
			finally
				SLLine.Destroy
         end
      finally
			StrDispose(DDELineSeq)
      end;
		Groups.Objects[G]:= Group;
   end
end;

procedure TPMDdeGroups.CloseGroup(G: GroupIndexSet);
begin
	if G>=Groups.Count then
		raise Exception.CreateFmt(
			'PMDdeGrp/0: Group index %d too large; there are only %d items'
			,[G, Groups.Count]);
	if Groups.Objects[G] is TPMDdeGroup then begin
		TPMDdeGroup(Groups.Objects[G]).Destroy;
		Groups.Objects[G]:= nil
	end
end;

constructor	TPMDdeGroup.Create;
begin
	inherited Create;
	Items:= TStringList.Create
end;

destructor	TPMDdeGroup.Destroy;
var W:Word;
begin
	for W:=0 to Items.Count-1 do (Items.Objects[W] as TPMDdeItem).Destroy;
	Items.Free;
	inherited Destroy
end;

constructor	TPMDdeItem.Create;
begin inherited Create end;

destructor TPMDdeItem.Destroy;
begin inherited Destroy end;

end.
 
