unit GrpsTstU;
{This unit is not very interesting: its only purpose is to demonstrate the use of
PMGrpFile and PMDdeGrp
Freeware, P.J. Veger, Best, The Netherlands }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, TabNotBk, PMDdeGrp, PMGrpFile, PMGrps;

type
  TGrpsTest = class(TForm)
    LBGroups: TListBox;
	 LBItems: TListBox;
    LGroup: TLabel;
	 LItem: TLabel;
	 TabbedNotebook1: TTabbedNotebook;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    GroupBox2: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox3: TGroupBox;
    Label3: TLabel;
    Label10: TLabel;
    Label11: TLabel;
	 EdFileName: TEdit;
	 EdCmdShow: TEdit;
	 EdNRLeft: TEdit;
	 EdNRBottom: TEdit;
	 EdNRRight: TEdit;
    EdNRTop: TEdit;
    EDMPLeft: TEdit;
    EdMPTop: TEdit;
    EdIILPX: TEdit;
    EdIILPY: TEdit;
	 EdIIP: TEdit;
    Label12: TLabel;
	 Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    GroupBox4: TGroupBox;
    EdIGCmdLine: TEdit;
    EdIGDfltDir: TEdit;
    EdIGShortCut: TEdit;
	 EdIGRunMin: TEdit;
    Label16: TLabel;
    Label17: TLabel;
    EdIGIPath: TEdit;
	 EdIGIIndex: TEdit;
    GroupBox5: TGroupBox;
    Label18: TLabel;
	 EdIGIPLower: TEdit;
    Label19: TLabel;
	 EdIGIPLeft: TEdit;
    GroupBox6: TGroupBox;
    Label20: TLabel;
    Label21: TLabel;
    EdIGIBWidth: TEdit;
	 EdIGIBHeight: TEdit;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
	 EdIPCmdLine: TEdit;
    EdIPDfltDir: TEdit;
	 EdIPShortCut: TEdit;
    Label25: TLabel;
	 EdIPRunMin: TEdit;
    GroupBox8: TGroupBox;
    Label30: TLabel;
    Label31: TLabel;
    EdIPIPath: TEdit;
	 EdIPIIndex: TEdit;
    GroupBox9: TGroupBox;
    Label32: TLabel;
    Label33: TLabel;
    EdIPIPLeft: TEdit;
	 EdIPIPTop: TEdit;
	 procedure FormCreate(Sender: TObject);
	 procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	 procedure LBGroupsClick(Sender: TObject);
	 procedure LBItemsClick(Sender: TObject);
  private
	PMGroups		: TPMDdeGroups;
	PMGroup		: TPMDdeGroup;
	PMItem		: TPMDdeItem;
	GrpGroup		: TPMGFGroup;
	GrpItem		: TPMGFItem;
	GI				: GroupIndexSet;
	II				: ItemIndexSet;
	procedure ShowFirstItem (G: GroupIndexSet);
	procedure ShowItem(I: ItemIndexSet);
  public
    { Public declarations }
  end;

var
  GrpsTest: TGrpsTest;

implementation

{$R *.DFM}

function BooleanToStr(B: Boolean): string;
begin if B then Result:= 'True' else Result:= 'False' end;

procedure TGrpsTest.FormCreate(Sender: TObject);
begin
	PMGroups:= TPMDdeGroups.Create(Self);
	LBGroups.Items:= PMGroups.Groups;
	ShowFirstItem(0);
end;

procedure TGrpsTest.LBGroupsClick(Sender: TObject);
begin
	if LBGroups.ItemIndex<>GI then begin
		GrpGroup.Free;
		PMGroups.CloseGroup(GI);
      ShowFirstItem(LBGroups.ItemIndex)
	end
end;

procedure TGrpsTest.ShowFirstItem (G: GroupIndexSet);
begin
	GI:= G;
	LBGroups.ItemIndex:= GI;
	PMGroups.OpenGroup(GI);
	PMGroup:= PMGroups.Groups.Objects[GI] as TPMDdeGroup;
	GrpGroup:= TPMGFGroup.Create(PMGroup.GrpFileName);
	with GrpGroup do begin
		EdFileName.Text:=GrpFileName;
		EdNRLeft.Text:= IntToStr(NormalRect.Left);
		EdNRTop.Text:= IntToStr(NormalRect.Top);
		EdNRRight.Text:= IntToStr(NormalRect.Right);
		EdNRBottom.Text:= IntToStr(NormalRect.Bottom);
		EdMPLeft.Text:= IntToStr(MinPoint.X);
		EdMPTop.Text:= IntToStr(MinPoint.Y);
		EdIILPX.Text:= IntToStr(LogPixelsX);
		EdIILPY.Text:= IntToStr(LogPixelsY);
		EdIIP.Text:= IntToStr(Planes);
		EdCmdShow.Text:= CmdShowToStr(CmdShow)
	end;
	GrpGroup.OpenAllItems;
	LBItems.Items:=PMGroup.Items;
	ShowItem(0);
end;

procedure TGrpsTest.LBItemsClick(Sender: TObject);
begin
	if LBItems.ItemIndex<>II then ShowItem(LBItems.ItemIndex)
end;

procedure TGrpsTest.ShowItem(I: ItemIndexSet);
begin
	II:= I;
	LBItems.ItemIndex:= II;
	GrpItem:= GrpGroup.Items.Objects[II] as TPMGFItem;
	with GrpItem do begin
		EdIGCmdLine.Text:= CommandLine;
		EdIGDfltDir.Text:= DefaultDir;
		EdIGShortCut.Text:= ShortcutToStr(Shortcut);
		EdIGRunMin.Text:= BooleanToStr(RunMinimized);
		EdIGIPath.Text:= IconPath;
		EdIGIIndex.Text:= IntToStr(IconIndex);
		EdIGIPLower.Text:= IntToStr(IconPoint.Y);
		EdIGIPLeft.Text:= IntToStr(IconPoint.X);
		EdIGIBWidth.Text:= IntToStr(IconWidth);
		EdIGIBHeight.Text:= IntToStr(IconHeight)
	end;
	PMItem:= PMGroup.Items.Objects[II] as TPMDdeItem;
	with PMItem do begin
		EdIPCmdLine.Text:= CommandLine;
		EdIPDfltDir.Text:= DefaultDir;
		EdIPShortcut.Text:= ShortcutToStr(Shortcut);
		EdIPRunMin.Text:= BooleanToStr(RunMinimized);
		EdIPIPath.Text:= IconPath;
		EdIPIIndex.Text:= IntToStr(IconIndex);
		EdIPIPLeft.Text:= IntToStr(IconLeft);
		EdIPIPTop.Text:= IntToStr(IconTop)
	end;
end;

procedure TGrpsTest.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	GrpGroup.Free;
	PMGroups.Free;
	Canclose:= True
end;

end.
 