unit Reload;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DdeMan, StdCtrls, IniFiles, ExtCtrls;

type
  TPM_Reload = class(TForm)
	 EdFilename: TEdit;
    BtnOK: TButton;
	 BtnCancel: TButton;
	 BtnBrowse: TButton;
	 DlgSelectFile: TOpenDialog;
	 DdeClient: TDdeClientConv;
	 CBCopy: TCheckBox;
    LFileName: TLabel;
    LB_Ini: TListBox;
    Label1: TLabel;
    Image2: TImage;
    Bevel1: TBevel;
	 procedure BtnBrowseClick(Sender: TObject);
	 procedure FormCreate(Sender: TObject);
	 procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
	 procedure BtnCancelClick(Sender: TObject);
	 procedure BtnOKClick(Sender: TObject);
  private
	Windir: string[80];
	PMIni : TIniFile;
	Groups: TStringList;
	FreeNumber: Word;
  public
    { Public declarations }
  end;

var
  PM_Reload: TPM_Reload;

implementation

{$R *.DFM}
type TFileName = record FullN, PathN, LongN, ShortN, ExtN: string end;

function ExtractFileNameParts(F: string): TFileName;
var FN: TFileName;
begin
	with FN do begin
		FullN:= ExpandFileName(F);
		PathN:= ExtractFilePath(FullN);
		LongN:= ExtractFileName(FullN);
		ExtN:= ExtractFileExt(FullN);
		if ExtN='' then ShortN:= LongN
			else ShortN:= Copy(LongN, 1, Pos('.', LongN)-1)
	end;
	Result:= FN
end;

procedure CheckGrpFile(FN: string);
var F		: file;
	FBuf	: PChar;
	FSize	: Longint;
type Words= array[0..32760] of Word;
var FW	 : ^Words absolute FBuf;
	CSum, N: Word;
begin
	try AssignFile(F, FN); Reset(F, 1)
	except
		on E: EInOutError do
			raise Exception.CreateFmt('Error %d when opening file %s'
											, [E.ErrorCode, FN])
	end;
	FSize:= FileSize(F);
	GetMem(FBuf,FSize);
	try BlockRead(F, FBuf^, FSize)
	except
		on E: EInOutError do
			raise Exception.CreateFmt('IO Error %d while reading file %s'
							, [E.ErrorCode, FN])
	end;
	if StrLComp(FBuf, 'PMCC', 4)<>0 then
		raise Exception.CreateFmt('File %s is not a .GRP file', [FN]);
	CSum:= 0;
	for N:= 0 to Pred(FSize div 2) do Inc(CSum, FW^[N]);
	if CSum<>0 then raise Exception.CreateFmt('File %s has a bad checksum', [FN]);
	FreeMem(FBuf,FSize);
	try Close(F)
	except
		on E: EinOutError do
				raise Exception.CreateFmt('GrpFile: Error %d while closing file %d', [E.ErrorCode, FN])
	end
end;

function FileCopy(const source, target: String ): Word;
var S,T: TFileStream;
begin
	Result := 0;
	S:= TFileStream.Create(source, fmOpenRead);
	try
		try T:= TFileStream.Create(target, fmOpenWrite or fmCreate)
		except
			raise Exception.Create('FileCopy/3: Error when creating copy target '+target)
		end;
		try
			try T.CopyFrom(S, S.Size)
			except
				raise Exception.CreateFmt('FileCopy/3: Error while copying %s to %s', [source, target])
			end;
			FileSetDate(T.Handle,FileGetDate(S.Handle));
		finally
			T.Free;
		end;
	finally
		S.Free;
	end;
end;

procedure TPM_Reload.BtnOKClick(Sender: TObject);
var FN	: TFileName;
	Aux, Aux1: string;
	Cmd	: array [0..255] of char;
	I, W	: Word;
	Grp	: string[8];
begin
	if EdFilename.Text<>'' then begin
		if not FileExists(EdFilename.Text) then begin
			ShowMessage('File '+EdFilename.Text+' does not exist');
			exit
		end;
		FN:= ExtractFileNameParts(EdFilename.Text);
		with FN do begin
			if ExtN <>'.GRP' then begin
				ShowMessage(LongN+' has not a .GRP extension');
				exit
			end;
			if (PathN<>Windir) and CBCopy.Checked then begin
				Aux:= Windir+'\'+LongN;
				Aux1:= Windir+'\'+ShortN+'.gr_';
				if FileExists(Aux) then begin
					if FileExists(Aux1) then DeleteFile(Aux1);
					RenameFile(Aux, Aux1);
					MessageDlg('The existing '+Aux+' has been renamed to '+Aux1
									, mtInformation, [mbOK], 0)
				end;
				FileCopy(FullN,Aux);
				FullN:= Aux;
				PathN:= Windir;
			end;
			try CheckGrpFile(FullN)
			except
				on E: Exception do begin ShowMessage(E.Message); exit end
			end;
			for I:= 0 to Groups.Count do begin
				if I=Groups.Count then begin
					PMIni.WriteString('Groups', 'Group'+IntToStr(FreeNumber), FN.FullN);
					PMIni.WriteString('Settings', 'Order'
							, PMIni.ReadString('Settings', 'Order', '')+' '+IntToStr(FreeNumber))
				end else if FullN=Groups[I] then Break
			end
		end
	end;
	StrPCopy (Cmd, '[Reload]'#13#10);
	DDEClient.OpenLink;
	if not DDEClient.ExecuteMacro(Cmd, False) then
			MessageDlg('Unable to reload', mtInformation, [mbOK], 0);
	DDEClient.CloseLink;
	Close
end;

procedure TPM_Reload.BtnBrowseClick(Sender: TObject);
begin
	if DlgSelectFile.Execute then
		EdFilename.Text:= DlgSelectfile.Filename
end;

procedure TPM_Reload.FormCreate(Sender: TObject);
var I, W, N: Word;
	Aux	: string;
	Used	: set of 0..255;
begin
	Windir[0]:= Chr(Lo(GetWindowsDirectory(PChar(@Windir[1]),W)));
	PMini:= TIniFile.Create(Windir+'\progman.ini');
	PMini.ReadSectionValues('Groups',LB_Ini.Items);
	Groups:= TStringList.Create;
	Used:= [];
	for I:= 0 to LB_Ini.Items.Count-1 do begin
		Aux:= LB_Ini.Items[I];
		W:= Pos('=', Aux);
		Groups.Add(ExpandFileName(Copy(Aux, W+1, 255)));
		N:= StrToInt(Copy(Aux, 6, W-6));
		if N<256 then Include(Used, N);
	end;
	for I:=1 to 256 do
		if I=256 then raise Exception.Create('Too many groups in Progman.ini for this program')
			else if not(I in Used) then begin FreeNumber:= I; Break end;
end;

procedure TPM_Reload.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
	Groups.Free;
	PMIni.Free;
	CanClose:= True
end;

procedure TPM_Reload.BtnCancelClick(Sender: TObject);
begin Close end;

end.
