unit Zoom;

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Zoom.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/25/2000
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user manipluation of the plot scale.

Known Issues:
      - This would normally be called Series, but TeeChart already uses that unit name.
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}
  Misc, Nedit;

type
  TZoomForm = class(TForm)
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    ZoomBitBtn: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    XMinNEdit: TNEdit;
    XMaxNEdit: TNEdit;
    YMinNEdit: TNEdit;
    YMaxNEdit: TNEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private

  public

  end;

var
  ZoomForm: TZoomForm;

implementation

{$R *.dfm}

{------------------------------------------------------------------------------
    Procedure: TZoomForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TZoomForm.FormCreate(Sender: TObject);
begin
  SetDialogGeometry(Self, ZoomBitBtn, Label1.Left);
end;

{------------------------------------------------------------------------------
    Procedure: TZoomForm.FormClose
  Description: standard FormClose procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: checks for valid user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TZoomForm.FormClose(Sender: TObject; var Action: TCloseAction);
var
  Test, TestMax: Single;
begin
{Check that floating point values are valid:}
  Action := caHide;
  try
    XMinNEdit.SetFocus;
    Test := StrToFloat(XMinNEdit.Text);
    XMaxNEdit.SetFocus;
    TestMax := StrToFloat(XMaxNEdit.Text);
    if (TestMax < Test) then
      ERangeError.CreateFmt('The Min (%g) MUST be less than the Max (%g)',
        [Test, TestMax]);
    YMinNEdit.SetFocus;
    Test := StrToFloat(YMinNEdit.Text);
    YMaxNEdit.SetFocus;
    TestMax := StrToFloat(YMaxNEdit.Text);
    if (TestMax < Test) then
      ERangeError.CreateFmt('The Min (%g) MUST be less than the Max (%g)',
        [Test, TestMax]);
{We do the above and below the squelch the warning messages.}
    Tag := Trunc(Test);
  except
{Prevent closure:}
    Action := caNone;
  end;
end;


end.
