unit Tooledit;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this.
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: ToolEdit.pas, released 12 May 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 04/19/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
To facilitate user manipluation of the TPlot ToolBar.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, Forms, Graphics, StdCtrls,
  ExtCtrls, ToolWin, ComCtrls, QControls, QStdCtrls, QExtCtrls, QComCtrls,
  QButtons;
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, {Graphics, }StdCtrls,
  ExtCtrls, ToolWin, ComCtrls;
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
  QExtCtrls, QComCtrls;
{$ENDIF}



type
  TToolBarEditForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    ApplyBitBtn: TBitBtn;
    DisplayToolBar: TToolBar;
    MiddlePanel: TPanel;
    ControlToolBar: TToolBar;
    TopPanel: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
  private
    OriginalHeight: Integer;
    FMaster: TToolBar;

    procedure ControlClick(Sender: TObject);
    {procedure DisplayMouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);}

  public
    procedure SetupButtons(Master: TToolBar);

  end;

var
  ToolBarEditForm: TToolBarEditForm;

implementation

{$R *.dfm}

uses
  Plottoolbar;

procedure TToolBarEditForm.FormCreate(Sender: TObject);
begin
{$IFDEF MSWINDOWS}
  Self.BorderStyle := bsSizeable;
{$ENDIF}
{$IFDEF LINUX}
  Self.BorderStyle := fbsSizeable;
{$ENDIF}
  Self.Scaled := FALSE;
  Self.HorzScrollBar.Visible := FALSE;
  Self.VertScrollBar.Visible := FALSE;

  Self.Left := 10;
  Self.Top := 10;
  Self.ClientWidth := ApplyBitBtn.Left + ApplyBitBtn.Width + OkBitBtn.Left;
  OriginalHeight := ApplyBitBtn.Top + 3*ApplyBitBtn.Height div 2;
  Self.ClientHeight := OriginalHeight;
end;

procedure TToolBarEditForm.SetupButtons(Master: TToolBar);
var
  i: Integer;
  TempToolButton: TToolButton;
begin
  FMaster := Master;
  DisplayToolBar.Images := FMaster.Images;
  ControlToolBar.Images := FMaster.Images;
{$IFDEF MSWINDOWS}
  for i := FMaster.ButtonCount-1 downto 0 do
{$ENDIF}
{$IFDEF LINUX}
  for i := 0 to FMaster.ButtonCount-1 do
{$ENDIF}
  begin
    TempToolButton := TToolButton.Create(DisplayToolBar);
    {TempToolButton.OnMouseDown := DisplayMouseDown;}
{$IFDEF MSWINDOWS}
    TempToolButton.Caption := FMaster.Buttons[i].Caption;
    TempToolButton.Hint := FMaster.Buttons[i].Hint;
    TempToolButton.ImageIndex := FMaster.Buttons[i].ImageIndex;
    TempToolButton.Style := FMaster.Buttons[i].Style;
    TempToolButton.Tag := i;
    TempToolButton.Width := FMaster.Buttons[i].Width;
{$ENDIF}
{$IFDEF LINUX}
    TempToolButton.Caption := TToolButton(FMaster.Controls[i]).Caption;
    TempToolButton.Hint := TToolButton(FMaster.Controls[i]).Hint;
    TempToolButton.ImageIndex := TToolButton(FMaster.Controls[i]).ImageIndex;
    TempToolButton.Style := TToolButton(FMaster.Controls[i]).Style;
    TempToolButton.Tag := TToolButton(FMaster.Controls[i]).Tag;
    TempToolButton.Width := TToolButton(FMaster.Controls[i]).Width;
{$ENDIF}
    TempToolButton.Parent := DisplayToolBar;
  end;

{$IFDEF MSWINDOWS}
  for i := FMaster.ButtonCount-1 downto 0 do
{$ENDIF}
{$IFDEF LINUX}
  for i := 0 to FMaster.ButtonCount-1 do
{$ENDIF}
  begin
    TempToolButton := TToolButton.Create(ControlToolBar);
{$IFDEF MSWINDOWS}
    TempToolButton.Caption := FMaster.Buttons[i].Caption;
    TempToolButton.Hint := FMaster.Buttons[i].Hint;
    TempToolButton.ImageIndex := FMaster.Buttons[i].ImageIndex;
    TempToolButton.Style := FMaster.Buttons[i].Style;
    TempToolButton.Tag := i;
    TempToolButton.Width := FMaster.Buttons[i].Width;
{$ENDIF}
{$IFDEF LINUX}
    TempToolButton.Caption := TToolButton(FMaster.Controls[i]).Caption;
    TempToolButton.Hint := TToolButton(FMaster.Controls[i]).Hint;
    TempToolButton.ImageIndex := TToolButton(FMaster.Controls[i]).ImageIndex;
    TempToolButton.Style := TToolButton(FMaster.Controls[i]).Style;
    TempToolButton.Tag := TToolButton(FMaster.Controls[i]).Tag;
    TempToolButton.Width := TToolButton(FMaster.Controls[i]).Width;
{$ENDIF}
    if (TempToolButton.Style = tbsButton) then
      TempToolButton.Style := tbsCheck;
    TempToolButton.OnClick := ControlClick;
    TempToolButton.Parent := ControlToolBar;
  end;
end;

procedure TToolBarEditForm.ControlClick(Sender: TObject);
{$IFDEF LINUX}
var
  TargetIndex: Integer;
  i,
  TheTag: Integer;
{$ENDIF}
begin
{$IFDEF LINUX}
  TargetIndex := -1;
{Why do it on tags ? Because Linux does amazing things to the order !}
  TheTag := TToolButton(Sender).Tag;
  for i := 0 to DisplayToolBar.ButtonCount-1 do
  begin
    if (TToolButton(DisplayToolBar.Controls[i]).Tag = TheTag) then
    begin
      TargetIndex := i;
      break;
    end;
  end;
  DisplayToolBar.Controls[TargetIndex].Visible :=
{$ENDIF}

{$IFDEF MSWINDOWS}
  DisplayToolBar.Buttons[TToolButton(Sender).Tag].Visible :=
{$ENDIF}
    not TToolButton(Sender).Down;
end;

procedure TToolBarEditForm.FormResize(Sender: TObject);
begin
  Self.ClientHeight := OriginalHeight;
end;

{procedure TToolBarEditForm.DisplayMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
end;}

procedure TToolBarEditForm.ApplyBitBtnClick(Sender: TObject);
begin
  TPlotToolBar(FMaster).ApplyChanges(DisplayToolBar);
end;

end.
