unit Ptedit;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: PtEdit.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 12/06/2000
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Purpose:
To facilitate user manipluation of Point values.

Known Issues: BCB problems with Spinedit - resolved by dynamic creation
              of different controls depending on compiler
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, ComCtrls, Controls, Forms, Graphics, StdCtrls,
  Spin,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, ComCtrls, Controls, Forms, Graphics, StdCtrls,
  {$IFDEF DELPHI}
  Spin,
  {$ENDIF}
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QComCtrls, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}

  Axis, Misc, Nedit, Slidebar;

type
  TPointEditorForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    DeleteBitBtn: TBitBtn;
    AddBitBtn: TBitBtn;
    DataGroupBox: TGroupBox;
    Label1: TLabel;
    YDataLabel: TLabel;
    ScreenGroupBox: TGroupBox;
    Label3: TLabel;
    YScreenLabel: TLabel;
    DetailsLabel: TLabel;
    Label5: TLabel;
    XStringDataEdit: TEdit;
    XScreenNEdit: TNEdit;
    YScreenNEdit: TNEdit;
    XDataNEdit: TNEdit;
    YDataNEdit: TNEdit;
    ApplyBitBtn: TBitBtn;
    PointSlideBar: TSlideBar;

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure CancelBitBtnClick(Sender: TObject);
    procedure PointSlideBarChange(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
    procedure XDataNEditKeyPress(Sender: TObject; var Key: Char);
    procedure XScreenNEditKeyPress(Sender: TObject; var Key: Char);
{$IFDEF MSWINDOWS}
    procedure PointEditChange(Sender: TObject);
{$ENDIF}
{$IFDEF LINUX}
    procedure PointEditChanged(Sender: TObject; NewValue: Integer);
{$ENDIF}
  private
    XData, YData: pSingleArray;
    XStringData: TStringList;
    XAxis, YAxis: TAxis;
    SpinLock: Boolean;

  public
{$IFDEF BCB}
    PointNEdit: TNEdit;
    PointUpDown: TUpDown;
{$ELSE}
    PointSpinEdit: TSpinEdit;
{$ENDIF}
    TheSeries: TObject;

    procedure Init(
      FXData, FYData: pSingleArray;
      FXStringData: TStringList;
      FXAxis, FYAxisCurrent: TAxis);
    procedure FillData(ThePoint: Integer);
  end;

var
  PointNEditorForm: TPointEditorForm;

implementation

{$R *.dfm}

uses
  Data;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.FormCreate(Sender: TObject);
begin
  SetDialogGeometry(Self, ApplyBitBtn, DetailsLabel.Left);

  SpinLock := FALSE;

{$IFDEF BCB}
  PointNEdit := TNEdit.Create(Self);
  PointNEdit.Parent := Self;
  PointNEdit.Left := PointSlideBar.Left + PointSlideBar.Width + 1;
  PointNEdit.Top := PointSlideBar.Top;
  PointNEdit.OnChange := PointEditChange;

  PointUpDown := TUpDown.Create(Self);
  PointUpDown.Parent := Self;
  PointUpDown.Associate := PointNEdit;

  {PointNEdit.Right := ScreenGroupBox.Right - PointUpDown.Width;}
  PointNEdit.Width :=
    ScreenGroupBox.Left + ScreenGroupBox.Width -
    PointUpDown.Width - PointNEdit.Left;
  //PointNEdit.TabOrder := 1;

{$ELSE}
  PointSpinEdit := TSpinEdit.Create(Self);
  PointSpinEdit.Parent := Self;
  PointSpinEdit.Left := PointSlideBar.Left + PointSlideBar.Width + 1;
  PointSpinEdit.Top := PointSlideBar.Top;
  {$IFDEF MSWINDOWS}
  PointSpinEdit.OnChange := PointEditChange;
  {$ENDIF}
  {$IFDEF LINUX}
  PointSpinEdit.OnChanged := PointEditChanged;
  {$ENDIF}
  {PointSpinEdit.Right := ScreenGroupBox.Right;}
  PointSpinEdit.Width :=
    ScreenGroupBox.Left + ScreenGroupBox.Width -
    PointSpinEdit.Left;
  //PointSpinEdit.TabOrder := 1;
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.Init
  Description: initializes pointers to data and axes
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 05/04/2000 by Mat Ballard
      Purpose: user management of data
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.Init(
  FXData, FYData: pSingleArray;
  FXStringData: TStringList;
  FXAxis, FYAxisCurrent: TAxis);
begin
  XData := FXData;
  YData := FYData;
  XStringData := FXStringData;
  XAxis := FXAxis;
  YAxis := FYAxisCurrent;
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FormClose
  Description: standard FormClose procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: checks for valid user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  Test: Single;
begin
{Check that floating point values are valid:}
  Action := caHide;
  if (DataGroupBox.Enabled = TRUE) then
  begin
    try
      Test := XDataNEdit.AsReal;
      Test := Test + YDataNEdit.AsReal;
{We do the above and below the squelch the warning messages.}
      Tag := Trunc(Test);
    except
{Prevent closure:}
      Action := caNone;
    end;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FillData
  Description: Gets the point data
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Synchronization of the two controls
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.FillData(ThePoint: Integer);
begin
  if ((ThePoint < 0) or (ThePoint > PointSlideBar.Position)) then raise
    ERangeError.CreateFmt(
      'FillData: the Point number %d is not within the valid range of 0 .. %d',
      [ThePoint, PointSlideBar.Position]);

  XDataNEdit.AsReal := XData^[ThePoint];
  YDataNEdit.AsReal := YData^[ThePoint];

  XScreenNEdit.AsInteger := XAxis.FofX(XData^[ThePoint]);
  YScreenNEdit.AsInteger := YAxis.FofY(YData^[ThePoint]);

  if ((XStringData <> nil) and
      (XStringData.Count > ThePoint)) then
  begin
    XStringDataEdit.Text := XStringData.Strings[ThePoint];
    XStringDataEdit.Visible := TRUE;
  end
  else
    XStringDataEdit.Visible := FALSE;
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.CancelBitBtnClick
  Description: Standard Cancel button event handler
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Disables the DataGroupBox, and hence prevents checking of edit boxes for validity
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.CancelBitBtnClick(Sender: TObject);
begin
  DataGroupBox.Enabled := FALSE;
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.PointSlideBarChange
  Description: Sets the value of PointNEdit
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: Synchronization of the two controls
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPointEditorForm.PointSlideBarChange(Sender: TObject);
begin
  if (not SpinLock) then
  begin
    SpinLock := TRUE;
{$IFDEF BCB}
    PointNEdit.AsInteger := PointSlideBar.Position;
{$ELSE}
    PointSpinEdit.Value := PointSlideBar.Position;
{$ENDIF}
    FillData(PointSlideBar.Position);
    SpinLock := FALSE;
  end;
  //DataGroupBox.Enabled := TRUE;
  //ScreenGroupBox.Enabled := TRUE;
end;

{$IFDEF MSWINDOWS}
procedure TPointEditorForm.PointEditChange(Sender: TObject);
begin
  if (not SpinLock) then
  begin
    SpinLock := TRUE;
{$IFDEF BCB}
    PointSlideBar.Position := PointNEdit.AsInteger;
{$ELSE}
    PointSlideBar.Position := PointSpinEdit.Value;
{$ENDIF}
    FillData(PointSlideBar.Position);
    SpinLock := FALSE;
  end;
end;
{$ENDIF}

{$IFDEF LINUX}
procedure TPointEditorForm.PointEditChanged(Sender: TObject; NewValue: Integer);
begin
  if (not SpinLock) then
  begin
    SpinLock := TRUE;
{$IFDEF BCB}
    PointSlideBar.Position := PointNEdit.AsInteger;
{$ELSE}
    PointSlideBar.Position := NewValue;
{$ENDIF}
    FillData(PointSlideBar.Position);
    SpinLock := FALSE;
  end;
end;
{$ENDIF}

procedure TPointEditorForm.ApplyBitBtnClick(Sender: TObject);
begin
  TSeries(TheSeries).ApplyPointChange(Self, mrOK);
end;

procedure TPointEditorForm.XDataNEditKeyPress(Sender: TObject;
  var Key: Char);
begin
  ScreenGroupBox.Enabled := FALSE;
end;

procedure TPointEditorForm.XScreenNEditKeyPress(Sender: TObject;
  var Key: Char);
begin
  DataGroupBox.Enabled := FALSE;
end;


end.
