unit Propedit;

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: PropEdit.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 10/10/2000
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To edit various TPlot properties not covered by other dialogs..

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils, TypInfo,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, ComCtrls, ExtCtrls, Forms, Graphics, Printers, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ComCtrls, ExtCtrls, Forms, Graphics, Printers, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QExtCtrls, QForms, QGraphics, QPrinters, QStdCtrls,
{$ENDIF}

  Axis, Misc, Plotdefs, Nedit, Coloredt;

type
  TPlotPropertyEditorForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    PlotTypeComboBox: TComboBox;
    PlotTypeLabel: TLabel;
    MultiplicityLabel: TLabel;
    Label3: TLabel;
    CreatedByEdit: TEdit;
    DescriptionEdit: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    MultiplicityPenGroupBox: TGroupBox;
    PenColorLabel: TLabel;
    PenWidthLabel: TLabel;
    PenStyleLabel: TLabel;
    PenWidthComboBox: TComboBox;
    PenStyleComboBox: TComboBox;
    PieRowCountComboBox: TComboBox;
    PieRowCountLabel: TLabel;
    ClickAndDragDelayNEdit: TNEdit;
    Label2: TLabel;
    ColumnGapLabel: TLabel;
    ColumnGapNEdit: TNEdit;
    Label6: TLabel;
    PrintOrientationComboBox: TComboBox;
    Label7: TLabel;
    BackColorEdit: TEdit;
    MultiplicityComboBox: TComboBox;
    ZAxisAngleNEdit: TNEdit;
    ZAxisAngleLabel: TLabel;
    ContourDetailLabel: TLabel;
    ContourDetailComboBox: TComboBox;
    LinkZSeriesCheckBox: TCheckBox;
    GridLabel: TLabel;
    GridComboBox: TComboBox;
    GridStyleComboBox: TComboBox;
    GridStyleLabel: TLabel;
    PenColorEdit: TColorEdit;
    PolarRangeLabel: TLabel;
    PolarRangeNEdit: TNEdit;
    ApplyBitBtn: TBitBtn;
    BubbleSizeLabel: TLabel;
    BubbleSizeNEdit: TNEdit;
    MultiJoinLabel: TLabel;
    MultiJoinEdit: TEdit;
    XYBridgeLabel: TLabel;
    XYBridgeNEdit: TNEdit;

    procedure FormCreate(Sender: TObject);
    procedure PlotTypeComboBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure BackColorEditClick(Sender: TObject);
    procedure BackColorEditKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure HelpBitBtnClick(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);

  private

  public
    ThePlot: TObject;

  end;

var
  PlotPropertyEditorForm: TPlotPropertyEditorForm;

implementation

{$R *.dfm}

uses
  Data, Plot;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.FormCreate(Sender: TObject);
var
  i: TColor;
begin
  SetDialogGeometry(Self, ApplyBitBtn, PlotTypeLabel.Left);

{set combo and edit box widths:}
  for i := 0 to Self.ComponentCount - 1 do
    if ((Self.Components[i] is TNEdit) or
        (Self.Components[i] is TColorEdit) or
        (Self.Components[i] is TComboBox)) then
      TControl(Self.Components[i]).Width := 88;
{the exceptions:}
  PieRowCountComboBox.Width := 64;
  PenWidthComboBox.Width := 64;
  ContourDetailComboBox.Width := 73;
  ClickAndDragDelayNEdit.Width := 48;
  ZAxisAngleNEdit.Width := 73;

  BubbleSizeNEdit.Top := MultiplicityComboBox.Top;
  BubbleSizeLabel.Top := MultiplicityLabel.Top;
  ColumnGapLabel.Top := MultiplicityLabel.Top;
  ColumnGapNEdit.Top := MultiplicityComboBox.Top;
  ContourDetailLabel.Top := MultiplicityLabel.Top;
  ContourDetailComboBox.Top := MultiplicityComboBox.Top;
  PieRowCountLabel.Top := MultiplicityLabel.Top;
  PieRowCountComboBox.Top := MultiplicityComboBox.Top;
  PolarRangeLabel.Top := MultiplicityLabel.Top;
  PolarRangeNEdit.Top := MultiplicityComboBox.Top;
  XYBridgeNEdit.Top := MultiplicityComboBox.Top;
  XYBridgeLabel.Top := MultiplicityLabel.Top;
  ZAxisAngleLabel.Top := MultiJoinLabel.Top;
  ZAxisAngleNEdit.Top := MultiJoinEdit.Top;

{Populate the combo boxes:}
  for i := 0 to Ord(High(TContourDetail)) do
    ContourDetailComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TContourDetail), i), 3, 99));
  for i := 0 to Ord(High(TGridType)) do
    GridComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TGridType), i), 3, 99));
  for i := 0 to Ord(High(TPenStyle)) do
    GridStyleComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPenStyle), i), 3, 99));
  for i := 0 to Ord(High(TPlotType)) do
    PlotTypeComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPlotType), i), 3, 99));
  for i := 0 to Ord(High(TPenStyle)) do
    PenStyleComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPenStyle), i), 3, 99));
  for i := 0 to Ord(High(TPrinterOrientation)) do
    PrintOrientationComboBox.Items.Add(Copy(GetEnumName(TypeInfo(TPrinterOrientation), i), 3, 99));
  for i := 0 to 20 do
    PenWidthComboBox.Items.Add(IntToStr(i));
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.CancelBitBtnClick
  Description: Standard ComboBoxChange event handler
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: Disables and enables edit and combo boxes depending on the Plot Type
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.PlotTypeComboBoxClick(Sender: TObject);
begin
  BubbleSizeNEdit.Visible := FALSE;
  ContourDetailComboBox.Visible := FALSE;
  ColumnGapNEdit.Visible := FALSE;
  GridLabel.Enabled := FALSE;
  LinkZSeriesCheckBox.Visible := FALSE;
  MultiplicityComboBox.Visible := FALSE;
  MultiJoinEdit.Visible := FALSE;
  PieRowCountComboBox.Visible := FALSE;
  PolarRangeNEdit.Visible := FALSE;
  XYBridgeNEdit.Visible := FALSE;
  ZAxisAngleNEdit.Visible := FALSE;

  case TPlotType(PlotTypeComboBox.ItemIndex) of
    ptXY:
      begin
        GridLabel.Enabled := TRUE;
        XYBridgeNEdit.Visible := TRUE;
      end;
    ptError: GridLabel.Enabled := TRUE;
    ptMultiple:
      begin
        GridLabel.Enabled := TRUE;
        MultiplicityComboBox.Visible := TRUE;
        MultiJoinEdit.Visible := TRUE;
      end;
    ptBubble:
      begin
        BubbleSizeNEdit.Visible := TRUE;
        GridLabel.Enabled := TRUE;
      end;
    ptColumn, ptStack, ptNormStack: ColumnGapNEdit.Visible := TRUE;
    ptPie: PieRowCountComboBox.Visible := TRUE;
    ptPolar: PolarRangeNEdit.Visible := TRUE;
    ptContour: ContourDetailComboBox.Visible := TRUE;
    pt3DContour:
      begin
        ContourDetailComboBox.Visible := TRUE;
        ZAxisAngleNEdit.Visible := TRUE;
      end;
    pt3DWire:
      begin
        ZAxisAngleNEdit.Visible := TRUE;
        LinkZSeriesCheckBox.Visible := TRUE;
      end;
  end;

  BubbleSizeLabel.Visible := BubbleSizeNEdit.Visible;
  ColumnGapLabel.Visible := ColumnGapNEdit.Visible;
  ContourDetailLabel.Visible := ContourDetailComboBox.Visible;
  GridStyleLabel.Enabled := GridLabel.Enabled;
  GridComboBox.Visible := GridLabel.Enabled;
  GridStyleComboBox.Visible := GridLabel.Enabled;
  MultiplicityLabel.Visible := MultiplicityComboBox.Visible;
  MultiplicityPenGroupBox.Visible := MultiplicityComboBox.Visible;
  MultiJoinLabel.Visible := MultiJoinEdit.Visible;
  PieRowCountLabel.Visible := PieRowCountComboBox.Visible;
  PolarRangeLabel.Visible := PolarRangeNEdit.Visible;
  XYBridgeLabel.Visible := XYBridgeNEdit.Visible;
  ZAxisAngleLabel.Visible := ZAxisAngleNEdit.Visible;
end;

procedure TPlotPropertyEditorForm.FormShow(Sender: TObject);
begin
  PlotTypeComboBoxClick(Self);
end;

procedure TPlotPropertyEditorForm.BackColorEditClick(Sender: TObject);
var
  AColor: TColor;
begin
  AColor := BackColorEdit.Color;
  if (InputColor(AColor)) then
  begin
    BackColorEdit.Color := AColor;
    BackColorEdit.Text := ColorToString(BackColorEdit.Color);
  end;
end;

procedure TPlotPropertyEditorForm.BackColorEditKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  BackColorEditClick(Self);
end;

procedure TPlotPropertyEditorForm.HelpBitBtnClick(Sender: TObject);
{$IFDEF LINUX}
var
  TheHelpFile: String;
{$ENDIF}
begin
{$IFDEF LINUX}
  TheHelpFile := 'hs' + IntToStr(HelpBitBtn.HelpContext) + '.htm';
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotPropertyEditorForm.ApplyBitBtnClick
  Description: Standard ButtonClick event handler
       Author: Mat Ballard
 Date created: 03/28/2001
Date modified: 03/28/2001 by Mat Ballard
      Purpose: Applies the currently selected properties
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.ApplyBitBtnClick(Sender: TObject);
begin
  TPlot(ThePlot).ApplyPropertiesChange(Self);
end;


end.
