unit Plottoolbar;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Plottoolbar.pas, released 12 May 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/25/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
An additional user interface for TPlot.


Known Issues: Does not work when component is added from the IDE.
              exception EClassNotFound: class TToolBar not found".
              even adding a NoButtons property, and modifying CreateToolButtons,
              so that 54 buttons DO exist, does not work. 

-----------------------------------------------------------------------------}
interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  ComCtrls, Controls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  ComCtrls, Controls, Dialogs,
{$ENDIF}
{$IFDEF LINUX}
  QComCtrls, QControls, 
{$ENDIF}

  Plotdefs, Plot, Misc, Tooledit;

type
  TPlotToolBar = class(TToolBar)
  private
    FCanConfigure: Boolean;
    //FNoButtons: Integer;
    FPlot: TPlot;

    function ToolButtonExists(ATag: Integer; ACaption: String): Boolean;
  protected
    function GetPlot(Target: TObject): TPlot; virtual;
{GetPlot is part of the Notification mechanism for linking components.}
    procedure SetPlot(Value: TPlot);
{This sets the Plot, and so creates the buttons.}
    {function GetNoButtons: Integer;
    procedure SetNoButtons(Value: Integer);}
{This creates the buttons.}
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
{Notification is part of the Notification mechanism for linking components.}
    procedure CreateToolButtons;
{This creates all the ToolButtons. It bascially "steals" them from the
 TPlot.PlotPopupMenu.}
    procedure DidMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
{This is the target OnClick method of all the ToolButtons.
 It calls the MouseDown for a right click.}
    procedure MouseDown(Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer); override;
{This calls the ancestor for a left click, or runs the ToolEditor for a right click.}
  public
    constructor Create(AOwner: TComponent); override;
{The standard constructor, in which the ToolButtonOptions are created and other
 properties set.}
    destructor Destroy; override;
{The standard destructor, in which the ToolButtonOptions are freed.}
    procedure ApplyChanges(Sender: TObject);
{This applies any changes (to ToolButton visibility) from the ToolEditor to this
 component.}
    procedure ApplyOptions(Value: TPopupOptions);
{This applies any changes (to ToolButton visibility) from TPlot to this
 component.}

    {procedure ShowArrangement;}
{This (leads to) the display of the ToolEditor as a design-time property editor.}
  published
    {property Arrangement: string read FArrangement write FArrangement {$IFDEF DELPHI2_UP . stored False .$ENDIF}
{This is used to invoke the ToolEditor as a design-time property editor.
 See ShowArrangement.}
    property CanConfigure: Boolean read FCanConfigure write FCanConfigure;
{Can the user configure the ToolBar ?}
    //property NoButtons: Integer read GetNoButtons write SetNoButtons;

    property Plot: TPlot read FPlot write SetPlot;
{This is the Plot to which this ToolBar is connected.}
end;

implementation

constructor TPlotToolBar.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPlot := nil;
  ShowHint := TRUE;
  AutoSize := TRUE;
  FCanConfigure := TRUE;
end;

destructor TPlotToolBar.Destroy;
begin
  inherited Destroy;
end;

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.ShowArrangement;
  Description: Property editor methods, et cetera
       Author: Mat Ballard
 Date created: 04/20/2001
Date modified: 05/02/2001 by Mat Ballard
      Purpose: design-time user interface
 Known Issues:
 ------------------------------------------------------------------------------}
{procedure TPlotToolBar.ShowArrangement;
begin
  Self.MouseDown(mbRight, [ssRight], 1, 1);
end;}

{ Check target object is a Plot }
function TPlotToolBar.GetPlot(Target: TObject): TPlot;
begin
  Result := Target as TPlot;
end;

{ Set the Plot component to affect }
procedure TPlotToolBar.SetPlot(Value: TPlot);
begin
  if Value <> FPlot then
  begin
    if (Value = nil) then
    begin
      FPlot := Value;
      FPlot.SetPlotToolBar(TToolBar(nil));
    end
    else
    begin
      FPlot := Value;
{$IFDEF DELPHI1}
      Value.Notification(Self, opInsert); {???}
{$ELSE}
      Value.FreeNotification(Self);
{$ENDIF}
      CreateToolButtons;
      FPlot.SetPlotToolBar(TToolBar(Self));
    end;
  end;
end;

{ Note deletion of attached Plot component }
procedure TPlotToolBar.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = Plot) then
    FPlot := nil;
end;

{function TPlotToolBar.GetNoButtons: Integer;
begin
  GetNoButtons := Self.ButtonCount;
end;}

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.SetNoButtons
  Description: This creates the buttons
       Author: Mat Ballard
 Date created: 11/18/2000
Date modified: 11/18/2000 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues:
 ------------------------------------------------------------------------------}
{procedure TPlotToolBar.SetNoButtons(Value: Integer);
var
  i: Integer;
  TempToolButton: TToolButton;
begin
  if ((Self.ButtonCount = 0) and
      (Value > 10)) then
  begin
    for i := 0 to Value-1 do
    begin
      TempToolButton := TToolButton.Create(Self);
{add the TempToolButton:
      TempToolButton.Parent := Self;
    end;
  end;
end;}

{------------------------------------------------------------------------------
    Procedure: TPlotToolBar.CreateToolButtons
  Description: creates tool buttons
       Author: Mat Ballard
 Date created: 11/18/2000
Date modified: 11/18/2000 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotToolBar.CreateToolButtons;
var
  i, j: Word;
  TempToolButton: TToolButton;
  TheName: String;
{$IFDEF COMPILER35}
  Index: Integer;
{$ENDIF}  
begin
{don't create ToolButtons when the Plot property is streamed in:}
  if (csLoading in ComponentState) then exit;
  if (FPlot = nil) then exit;

{who needs more than 32 menus ?!}
  if (FPlot.PlotPopupMenu.Items.Count > 32) then raise
    EComponentError.CreateFmt('TPlotToolBar.CreateToolButtons: I cannot handle more than %d Sub-menus !',
      [FPlot.PlotPopupMenu.Items.Count]);

{Create the main ToolButtons, which correspond to each sub-menu,
 then the menu items within each submenu.
 Note the bizzare order required by Windows}
{$IFDEF MSWINDOWS}
  for i := FPlot.PlotPopupMenu.Items.Count-1 downto 0 do
  begin
    for j := FPlot.PlotPopupMenu.Items[i].Count-1 downto 0 do
{$ENDIF}
{$IFDEF LINUX}
  for i := 0 to FPlot.PlotPopupMenu.Items.Count-1 do
  begin
    for j := 0 to FPlot.PlotPopupMenu.Items[i].Count-1 do
{$ENDIF}
    begin
      if (FPlot.PlotPopupMenu.Items[i].Items[j].Caption <> '-') then
      begin
        if (not ToolButtonExists(
           FPlot.PlotPopupMenu.Items[i].Items[j].Tag,
           FPlot.PlotPopupMenu.Items[i].Items[j].Caption)) then
        begin
          TempToolButton := TToolButton.Create(Self);
          TempToolButton.Caption := FPlot.PlotPopupMenu.Items[i].Items[j].Caption;
          TheName := CleanString(TempToolButton.Caption, '&');
          TheName := CleanString(TheName, ' ');
          TheName := CleanString(TheName, '.');
          TheName := CleanString(TheName, '!');
          TempToolButton.Name := TheName;
          TempToolButton.Style := tbsButton;
          TempToolButton.Tag := FPlot.PlotPopupMenu.Items[i].Items[j].Tag;
          TempToolButton.Hint := TheName + ' - ' + FPlot.PlotPopupMenu.Items[i].Items[j].Hint;
{$IFDEF COMPILER4_UP}
          TempToolButton.ImageIndex := FPlot.PlotPopupMenu.Items[i].Items[j].ImageIndex;
{$ENDIF}
          TempToolButton.OnClick := FPlot.PlotPopupMenu.Items[i].Items[j].OnClick;
{When the ToolButton is right-clicked, DidMouseDown calls MouseDown, which fires up the ToolEditor.}
          TempToolButton.OnMouseDown := DidMouseDown;
{add the TempToolButton:}
          TempToolButton.Parent := Self;
          {TempToolButton.Visible := TRUE;
          TempToolButton.Enabled := TRUE;}
        end;
      end;
    end; {j over menu items}
    if (i <> 0) then
    begin
      TempToolButton := TToolButton.Create(Self);
      TempToolButton.Style := tbsSeparator;
      //TempToolButton.Wrap := TRUE;
      TempToolButton.Width := 8;
      TempToolButton.Height := 8;
{add the seperator TempToolButton:}
      TempToolButton.Parent := Self;
    end
  end; {i over submenus}
{$IFDEF COMPILER35}
  Index := 0;
  for i := 0 to Self.ButtonCount-1 do
  begin
    if (Self.Buttons[i].Style = tbsButton) then
    begin
      Self.Buttons[i].ImageIndex := Index;
      Inc(Index);
    end;
  end;
{$ENDIF}
end;

{------------------------------------------------------------------------------
     Function: TPlotToolBar.ToolButtonExists
  Description: Does this ToolButton exist ? Based on Tag and Caption
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: do we need to add a ToolButton item ?
 Return Value: Boolean;
 Known Issues:
 ------------------------------------------------------------------------------}
function TPlotToolBar.ToolButtonExists(ATag: Integer; ACaption: String): Boolean;
var
  i: Integer;
begin
{$IFDEF MSWINDOWS}
  for i := 0 to Self.ButtonCount-1 do
  begin
    if ((Self.Buttons[i].Tag = ATag) and
        (TToolButton(Self.Buttons[i]).Caption = ACaption)) then
{$ENDIF}
{$IFDEF LINUX}
  for i := 0 to Self.ControlCount-1 do
  begin
    if ((Self.Controls[i].Tag = ATag) and
        (TToolButton(Self.Controls[i]).Caption = ACaption)) then
{$ENDIF}
    begin
      ToolButtonExists := TRUE;
      exit;
    end;
  end;
  ToolButtonExists := FALSE;
end;

procedure TPlotToolBar.DidMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbRight) then
    MouseDown(Button, Shift, X, Y);
end;

procedure TPlotToolBar.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  ToolBarEditForm: TToolBarEditForm;
begin
  if ((Button = mbRight) and (FCanConfigure)) then
  begin
    ToolBarEditForm := TToolBarEditForm.Create(nil);
    ToolBarEditForm.SetupButtons(TToolBar(Self));
    ToolBarEditForm.ShowModal;
    ToolBarEditForm.Free;
  end
  else
    inherited MouseDown(Button, Shift, X, Y);
end;

procedure TPlotToolBar.ApplyChanges(Sender: TObject);
var
  i: Integer;
{$IFDEF LINUX}
  j,
  TargetIndex,
  TheTag: Integer;
{$ENDIF}
begin
  for i := 0 to Self.ButtonCount-1 do
  begin
{$IFDEF MSWINDOWS}
    Self.Buttons[i].Visible :=
      TToolBar(Sender).Buttons[i].Visible;
{$ENDIF}
{$IFDEF LINUX}
    TargetIndex := -1;
    TheTag := TToolButton(TToolBar(Sender).Controls[i]).Tag;
    for j := 0 to Self.ButtonCount-1 do
    begin
      if (TToolButton(Self.Controls[j]).Tag = TheTag) then
      begin
        TargetIndex := j;
        break;
      end;
    end;
    Self.Controls[TargetIndex].Visible :=
      TToolBar(Sender).Controls[i].Visible;
{$ENDIF}
  end;
  {  for i := 0 to Ord(High(TMainMenus)) do
    FPlotPopUpMenu.Items[i].Visible :=
      FPlotPopUpMenu.Items[i].Visible and
        (TMainMenus(i) in FOptions.Menu);}
end;

procedure TPlotToolBar.ApplyOptions(Value: TPopupOptions);
var
  i, j, Index: Integer;
begin
  if (FPlot = nil) then exit;

  for Index := 0 to Self.ButtonCount-1 do
  begin
{$IFDEF MSWINDOWS}
    if (FPlot.GetIndicesFromTag(Self.Buttons[Index].Tag, i, j)) then
    begin
      case i of
        Ord(mnuFile): Self.Buttons[Index].Visible :=
          (TFileMenus(j) in Value.File_);
        Ord(mnuEdit): Self.Buttons[Index].Visible :=
          (TEditMenus(j) in Value.Edit);
        Ord(mnuView): Self.Buttons[Index].Visible :=
          (TViewMenus(j) in Value.View);
        Ord(mnuCalc): Self.Buttons[Index].Visible :=
          (TCalcMenus(j) in Value.Calc);
      end; {case}
    end; {GetIndicesFromTag}
{$ENDIF}
{$IFDEF LINUX}
    if (FPlot.GetIndicesFromTag(Self.Controls[Index].Tag, i, j)) then
    begin
      case i of
        Ord(mnuFile): Self.Controls[Index].Visible :=
          (TFileMenus(j) in Value.File_);
        Ord(mnuEdit): Self.Controls[Index].Visible :=
          (TEditMenus(j) in Value.Edit);
        Ord(mnuView): Self.Controls[Index].Visible :=
          (TViewMenus(j) in Value.View);
        Ord(mnuCalc): Self.Controls[Index].Visible :=
          (TCalcMenus(j) in Value.Calc);
      end; {case}
    end; {GetIndicesFromTag}
{$ENDIF}
  end; {for Index}
end;

{procedure TPlotToolBar.CreateToolButtons;
var
  i, j: Word;
  TempToolButton: TToolButton;
  TheName: String;
  Index: Integer;
begin
  if (csLoading in ComponentState) then exit;
  if (FPlot = nil) then exit;

{who needs more than 32 menus ?!
  if (FPlot.PlotPopupMenu.Items.Count > 32) then raise
    EComponentError.CreateFmt('TPlotToolBar.CreateToolButtons: I cannot handle more than %d Sub-menus !',
      [FPlot.PlotPopupMenu.Items.Count]);

{Create the main ToolButtons, which correspond to each sub-menu,
 then the menu items within each submenu.
 Note the bizzare order required by Windows
  Index := 0;
  for i := 0 to FPlot.PlotPopupMenu.Items.Count-1 do
  begin
    for j := 0 to FPlot.PlotPopupMenu.Items[i].Count-1 do
    begin
      if (FPlot.PlotPopupMenu.Items[i].Items[j].Caption <> '-') then
        Inc(Index);
    end;
{add the seperator TempToolButton:
    if (i <> 0) then
      Inc(Index);
  end;

  SetNoButtons(Index);

  Index := 0;
  for i := 0 to FPlot.PlotPopupMenu.Items.Count-1 do
  begin
    for j := 0 to FPlot.PlotPopupMenu.Items[i].Count-1 do
    begin
      if (FPlot.PlotPopupMenu.Items[i].Items[j].Caption <> '-') then
      begin
        Self.Buttons[Index].Caption := FPlot.PlotPopupMenu.Items[i].Items[j].Caption;
        TheName := CleanString(Self.Buttons[Index].Caption, '&');
        TheName := CleanString(TheName, ' ');
        TheName := CleanString(TheName, '.');
        TheName := CleanString(TheName, '!');
        Self.Buttons[Index].Name := TheName;
        Self.Buttons[Index].Style := tbsButton;
        Self.Buttons[Index].Tag := FPlot.PlotPopupMenu.Items[i].Items[j].Tag;
        Self.Buttons[Index].Hint := TheName + ' - ' + FPlot.PlotPopupMenu.Items[i].Items[j].Hint;
{.$ IFDEF COMPILER35_UP
        Self.Buttons[Index].ImageIndex := Index;
{.$ ENDIF
        Self.Buttons[Index].OnClick := FPlot.PlotPopupMenu.Items[i].Items[j].OnClick;
{When the ToolButton is right-clicked, DidMouseDown calls MouseDown, which fires up the ToolEditor.
        Self.Buttons[Index].OnMouseDown := DidMouseDown;
        Inc(Index);
      end;
    end; {j over menu items
    {if (i <> 0) then
    begin
      Self.Buttons[Index].Style := tbsSeparator;
      Self.Buttons[Index].Width := 8;
      Self.Buttons[Index].Height := 8;
      Inc(Index);
    end
  end; {i over submenus
end;}


end.
