unit Plotdefs;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Menus.pas, released 16 october 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 04/16/2001

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Known Issues:
-----------------------------------------------------------------------------}

{
HOWTO add menu items:

Warning: this is a complex multistep process!

1. Edit TPlot.wb1 and add the menu item(s) you want, where you want.
   Make sure you update the indices correctly.

2. Copy the 3000 series indices and captions to your favourite editor.

3. Ditto the 4000 ditto to ditto, add to the end of the 3000 ditto.

4. Remove the blank lines.

5. Change every 'CRLF' to '"CRLF '.

6. Change every tab to ', "'.

7. Open Strlist.res or Strlist32.res in your favourite String Resource editor.

8. Delete the existing 3000-4999 stringlist data.

9. Paste in the new stringlists from your editor.

10. Save the new stringlist resource.

11. Open Images32.res in the Image Editor.

12. for i := MaxImageNo downto NewIndex do
      ImageIndex := ImageIndex + NoNewMenuItems;

13. create your new 16x16x256 bitmap(s), and rename them to NewIndex, ....

14. Save Images32.Res.

15. Open Plotxxx_xx.bpg, open Plotxxx_Rxx.dpk, and ...

16. In Plotdefs.pas, insert your new mnuMyNewMenuItem(s).

17. In PlotImageList.pas, redefine NO_IMAGES to the new value.

18. In Plot.pas, create your new MyNewMenuClick method(s).

19. In Plot.pas, go to TCustomPlot.CreateMenus, and add:
  FPlotPopUpMenu.Items[Ord(mnuXXX)].Items[Ord(mnuMyNewMenuItem)].OnClick := MyNewMenuClick;

20. Change
          TPlot.DetermineMenuVisibility,
          TPlot.SetSeriesVisibility and
          TPlot.SetSeriesEnabledness
          TPopupOptions.Create
  as required.
}

interface

uses
  Classes, {SysUtils,}
{$IFDEF WINDOWS}
  Menus, Wintypes
{$ENDIF}
{$IFDEF WIN32}
  Menus, Windows
{$ENDIF}
{$IFDEF LINUX}
  QMenus, Types
{$ENDIF}
  ;

const
  TPLOT_VERSION = 200;

  FILE_FORMAT_VERSION = 200;
  MAX_FILE_VERSION = 200;

  TAG_BASE = 1000;
  CAPTION_BASE = 3000;
  HINT_BASE = 4000;

  TWO_PI = 2*PI;
  PI_ON_TWO = PI/2;
  THREE_PI_ON_TWO = 3*PI/2;

{$IFDEF MSWINDOWS}
  SMALL_FONT_SIZE = 8;
  MEDIUM_FONT_SIZE = 9;
  LARGE_FONT_SIZE = 14;
{$ENDIF}
{$IFDEF LINUX}
  SMALL_FONT_SIZE = 10;
  MEDIUM_FONT_SIZE = 12;
  LARGE_FONT_SIZE = 18;
{$ENDIF}


resourcestring
{constructor:}
  sArial = 'Arial';
  
type
{type definitions for dynamic menu arrays:}
  TMenuArray = array[0..127] of TMenuItem;
  pMenuArray = ^TMenuArray;

{Different possible plot types: these determine how the series are interpreted,
 and so how data are displayed on screen}
  TPlotType = (
    ptXY,
    ptError,
    ptMultiple,
    ptBubble,
    ptColumn,
    ptStack,
    ptNormStack,
    ptPie,
    ptPolar,
    ptContour,
    pt3DContour,
    pt3DWire{pt3DSurface, ptPipeLine, pt3DContour});
{ptXY          - a normal XY plot that everyone does in sigh school

 ptError       - every second (odd indexed) series is interpreted as the "error bar" of the
                 previous (even indexed) series.
                  
 ptMultiple    - each "point" is composed of a multiple of points from
                 the different series. This is a generalised extension of the previous
                 ptError type. It is used for High-Low-Close, High-Low-Open-Close, etc
                 plots. Eg:
  high, low        high, average, low        high, low, open, close;
     X                     X                           H
     |                     |                           |
     |                     |                           O
     |                     O                           |
     |                     |                           |
     |                     |                           |
     |                     |                           |
     |                     |                           C
     |                     |                           |
     X                     X                           L
                 See the Multiplicity property !

 ptColumn      - columns of data: the last X value is taken as Xn + (Xn - Xn-1),
                 so the appearance is:
                              (X1, Y1)----(X2, Y1)
                              |                  |
                              |                  (Xn, Yn)----(Xn+dX, Yn)
           (X0, Y0)----(X1, Y0)                  |                     |
           |                  |                  |                     |
           |                  |                  |                     |
           |                  |                  |                     |
           |                  |                  |                     |
           (X0, 0)---------(X1, 0)------------(X2, 0)---------(Xn+dX, 0)
                - when there are N (> 1) series, each gap is divided by (N+1):
                              -------
                              |     |
                              |     |
           -------            |     |
           |     |------      |     |
           |     |     |      |     |------
           |     |     |      |     |     |
           |     |     |      |     |     |
           (X0, 0)---------(X1, 0)------------(X2, 0)

 ptStack       - a stacked column, with each series on to of each other

 ptNormStack   - like a stack, but normalized to 100%

 ptPie         - very boring pie graphs

 ptPolar       - (x, y) = (r*cos(theta), r*sin(theta))

 ptContour     - a two-dimensional plot where the color represents the Y value.

 pt3DContour   - a three-dimensional plot where the color represents the Y value.

 pt3DWire      - a three-dimensional plot in which each series in order as succesive slices through the surface
}

  TScreenJob = (sjNone,
                sjDrag,
                sjHide,
                sjZoomIn,
                sjEditAxis,
                sjTouchNotePointer,
                sjMoveNotePointer,
                sjEditFont,
                sjEditPoint,
                sjEditSeries,
                sjFlashEdit,
                sjCopySeries,
                sjDisplace,
                sjCloneSeries,
                sjDeleteSeries,
                sjPosition,
                sjNearestPoint,
                sjAverage,
                sjContractSeries,
                sjContractAllSeries,
                sjSplineSeries,
                sjHighs,
                sjLows,
                sjMovingAverage,
                sjSmoothSeries,
                sjSortSeries,
                sjDifferentiate,
                sjIntegrate,
                sjIntegral,
                sjLineOfBestFit,
                sjDualLineBestFit1, sjDualLineBestFit2,
                sjSelection,
                sjDualSelection1, sjDualSelection2);
{What particular operation is to be carried out ?}
{}
{Note that a 2-region line of best fit is a 2 stage operation.}

  TObjectType = (soNone,
                 soTitle,
                 soLegend,
                 soResult,
                 soNote,
                 soXAxis, soXAxisTitle, soXAxisLabel,
                 soYAxis, soYAxisTitle,soYAxisLabel,
                 soLeftBorder, soTopBorder, soRightBorder, soBottomBorder,
                 soSeries);
{What object on the screen got clicked on ?}
{}
{Note that the soYAxis, soYAxisTitle, and soYAxisLabel are generic: several
 sub-components can share this type.}

  TDisplayMode = (dmNormal, dmNone, dmRun, dmHistory);
{What do we do when new data is added ?}
{}
{    dmNormal: Check (and adjust DisplayMode if neccessary) with the addition of every point.}
{    dmNone: Nothing;}
{    dmRun: Increase the Span of the X Axis by 100% to accomodate the new data,
 and alter (increase) the scale of the Y Axis if needed.}
{    dmHistory: Similar to dmRun, except that the X-Axis runs from (Min-Max)
 through (x-Max) to 0.}
{}
{Note that with dmRun we can expect more data with increasing X values.
 Rather than force a complete screen re-draw every time a data point is
 added, we extend the X Axis by 100%.}
{}
{History mode, dmHistory, deserves a few more words. In this mode TCustomPlot
 displays the data over the last History 's worth of points - older data is not
 displayed. The result is a graph that shows the last few seconds or minutes of
 data in great detail.}

  TContourDetail = (cdLow, cdMedium, cdHigh, cdVHigh);

  TGridType = (gtNone, gtHorizontal, gtVertical, gtBoth);

  TSymbol = (syNone,
    syCircle, sySquare,
    syUpTriangle, syDownTriangle,
    syPlus, syCross, syStar,
    syDash, syVertDash, syLeftDash, syRightDash);
{These are the different symbols that are used to represent the data points.}

{the actual menus:}
  TMainMenus = (
    mnuFile,
    mnuEdit,
    mnuView,
    mnuCalc
{$IFDEF FINANCIAL}
    , mnuFinance
{$ENDIF}
    );
  TMainOptions = set of TMainMenus;

  TFileMenus = (
    mnuNew,
    mnuOpen,
    mnuOverlayDiv, {convention: Name the Divs after the following menuitem}
    mnuOverlay,
    mnuClearOverlays,
    mnuSaveDiv,
    mnuSave,
    mnuSaveAs,
    mnuSaveImage,
    mnuPrintDiv,
    mnuPrint);
  TFileOptions = set of TFileMenus;

  TEditMenus = (
    mnuCopy,
    mnuCopyHTML,
    mnuCopySeries,
    mnuPaste,
    mnuDisplaceDiv,
    mnuDisplace,
    mnuResetDisplacement,
    mnuEditSeriesDiv,
    mnuNewSeries,
    mnuCloneSeries,
    mnuEditPoint,
    mnuEditData,
    mnuEditSeries,
    mnuDeleteSeries,
    mnuAxisDiv,
    mnuNewY2Axis,
    mnuEditAxis,
    mnuDeleteY2Axis,
    mnuEditFontDiv,
    mnuNewNote,
    mnuMoveNotePointer,
    mnuDeleteNote,
    mnuEditFont,
    mnuEditPropertiesDiv,
    mnuEditProperties); {19}
  TEditOptions = set of TEditMenus;

  TViewMenus = (
    mnuHide,
    mnuShowAll,
    mnuDisplayModeDiv,
    mnuDisplayMode,
    mnuLegend,
    mnuZoomDiv,
    mnuSetAsNormal,
    mnuNormalView,
    mnuManualZoom,
    mnuZoomIn,
    mnuZoomOut);
  TViewOptions = set of TViewMenus;

  TCalcMenus = (
    mnuPosition,
    mnuNearestPoint,
    mnuCalcAverageDiv,
    mnuCalcAverage,
    mnuCompressSeries,
    mnuCompressAllSeries,
    mnuContractSeries,
    mnuContractAllSeries,
    mnuCubicSplineSeries,
    mnuHighs,
    mnuMovingAverage,
    mnuSmoothSeries,
    mnuSortSeries,
    mnuCalculusDiv,
    mnuDifferentiate,
    mnuIntegrate,
    mnuIntegral,
    mnuLineOfBestFitDiv,
    mnuLineOfBestFit,
    mnuTwoRegionLineOfBestFit
{$IFDEF FUNCTIONS}
    , mnuFunctionDiv,
    mnuFunction);
{$ENDIF}
    );
  TCalcOptions = set of TCalcMenus;

{$IFDEF FINANCE}
  TFinanceMenus = (
    mnuRSI
    );
  TFinanceOptions = set of TFinanceMenus;
{$ENDIF}

  TModeMenus = (
    mnuNormal,
    mnuNone,
    mnuRun,
    mnuHistory);

  TSaveOption = (soAsText, soProperties);
  TSaveOptions = set of TSaveOption;

  T3DPoint = Record
    x: Integer;
    y: Integer;
    Z: Single;
    ZShift: TPoint;
  end;

  TPoints = array [0..600] of TPoint;
  pTPoints = ^TPoints;

  TPopupOptions = class(TPersistent)
  private
    FMenu: TMainOptions;
    FFile: TFileOptions;
    FEdit: TEditOptions;
    FView: TViewOptions;
    FCalc: TCalcOptions;
{$IFDEF FINANCE}
    FFinance: TFinanceOptions;
{$ENDIF}
  protected
    procedure AssignTo(Dest: TPersistent); override;
{TRectangle's implementation of the standard Assign(To) method.}
  public
    Constructor Create; {$IFDEF DELPHI4_UP}reintroduce;{$ENDIF}
{D1 cannot publish sets with more than 16 members}
{$IFNDEF DELPHI1}
  published
{$ENDIF}
    property Menu: TMainOptions read FMenu write FMenu;
    property File_: TFileOptions read FFile write FFile;
    property Edit: TEditOptions read FEdit write FEdit;
    property View: TViewOptions read FView write FView;
    property Calc: TCalcOptions read FCalc write FCalc;
{$IFDEF FINANCE}
    property Finance: TFinanceOptions read FFinance write FFinance;
{$ENDIF}
  end;

implementation

{------------------------------------------------------------------------------
  Constructor: TPopupOptions.Create;
  Description: standard constructor
       Author: Mat Ballard
 Date created: 10/15/1999
Date modified: 10/15/2000 by Mat Ballard
      Purpose: enables all menu options
 Known Issues:
 ------------------------------------------------------------------------------}
Constructor TPopupOptions.Create;
var
  i: Integer;
begin
  FMenu := [];
  FFile := [];
  FEdit := [];
  FView := [];
  FCalc := [];
{$IFDEF FINANCE}
  FFinance := [];
{$ENDIF}

  for i := 0 to Ord(High(TMainMenus)) do
    Include(FMenu, TMainMenus(i));
  for i := 0 to Ord(High(TFileMenus)) do
    Include(FFile, TFileMenus(i));
  for i := 0 to Ord(High(TEditMenus)) do
    Include(FEdit, TEditMenus(i));
  for i := 0 to Ord(High(TViewMenus)) do
    Include(FView, TViewMenus(i));
  for i := 0 to Ord(High(TCalcMenus)) do
    Include(FCalc, TCalcMenus(i));
{$IFDEF FINANCE}
  for i := 0 to Ord(High(TFinanceMenus)) do
    Include(FFinance, TFinanceMenus(i));
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPopupOptions.AssignTo;
  Description: standard copier
       Author: Mat Ballard
 Date created: 04/20/2001
Date modified: 04/20/2001 by Mat Ballard
      Purpose: copies values from a source
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPopupOptions.AssignTo(Dest: TPersistent);
begin
  TPopupOptions(Dest).Menu := FMenu;
  TPopupOptions(Dest).File_ := FFile;
  TPopupOptions(Dest).Edit := FEdit;
  TPopupOptions(Dest).View := FView;
  TPopupOptions(Dest).Calc := FCalc;
{$IFDEF FINANCE}
  TPopupOptions(Dest).Finance := FFinance;
{$ENDIF}
end;


end.
