unit Plot_Reg;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Plot_reg.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/15/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
Registration unit for the TPlot component.


Known Issues:
        - Property editors are stuffed under Kylix.
-----------------------------------------------------------------------------}

{$I Plot.inc}

interface

uses
  Classes,
{$IFDEF WINDOWS}
  DsgnIntf, 
{$ENDIF}
{$IFDEF WIN32}
  DsgnIntf, comctrls,
{$ENDIF}
{$IFDEF LINUX}
  {Designide, DesignEditors, DesignIntf,}QComCtrls,
{$ENDIF}
  Plot,

{$IFDEF COMPILER35_UP}
  Plottoolbar,
  Plotimagelist,
{$ENDIF}
  Plotmenu;

{$IFDEF MSWINDOWS}
type
  TPlotComponentEditor = class(TComponentEditor)
  public
    function GetVerb(Index: Integer): String; override;
    function GetVerbCount: Integer; override;
    procedure ExecuteVerb(Index: Integer); override;
    procedure Edit; override;
  end;
{$ENDIF}

procedure Register;

implementation

{$IFDEF WINDOWS}
{$R Plot16.dcr}
{$ENDIF}
{$IFDEF WIN32}
{$R Plot32.dcr}
{$ENDIF}
{$IFDEF LINUX}
{$R Plot32.dcr}
{$ENDIF}

{$IFDEF MSWINDOWS}
type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TAxesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TDataProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TSeriesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  {$IFDEF COMPILER35_UP}
  {TToolBarProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;}
  {$ENDIF}
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Samples', [TPlot]);
  RegisterComponents('Samples', [TPlotMenu]);
{$IFDEF COMPILER35_UP}
  RegisterComponents('Samples', [TPlotToolBar]);
  RegisterComponents('Samples', [TPlotImageList]);
  //RegisterComponents('Samples', [TPlotActionList]); - not quiet yet
{$ENDIF}

{$IFDEF MSWINDOWS}
{register the "About" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'About', TAboutProperty);
{register the "Data" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'DataProperties', TDataProperty);
{register the "Series" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'SeriesProperties', TSeriesProperty);
{register the "Axes" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'AxesProperties', TAxesProperty);
{register the component editor for menus:}
  RegisterComponentEditor(TPlot, TPlotComponentEditor);
  {$IFDEF COMPILER35_UP}
  {RegisterPropertyEditor(TypeInfo(String), TPlotToolBar, 'Arrangement', TToolBarProperty);}
  {$ENDIF}
{$ENDIF}
end;

{$IFDEF MSWINDOWS}
{TPlotComponentEditor methods:-------------------------------------------------}
function TPlotComponentEditor.GetVerb(Index: Integer): String;
begin
  case Index of
    0: Result := '&About TPlot...';
    1: Result := 'A&xes...';
    2: Result := '&Copy';
    3: Result := '&Data...';
    4: Result := '&Properties...';
    5: Result := '&Series...';
  end;
end;

function TPlotComponentEditor.GetVerbCount: Integer;
begin
  Result := 6;
end;

procedure TPlotComponentEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: (Component as TPlot).ShowAbout;
    1: (Component as TPlot).ShowAxes;
    2: (Component as TPlot).CopyClick(nil);
    3: (Component as TPlot).ShowData;
    4: (Component as TPlot).ShowProperties;
    5: (Component as TPlot).ShowSeries;
  end;
end;

procedure TPlotComponentEditor.Edit;
begin
  (Component as TPlot).ShowProperties;
end;
{end TPlotComponentEditor methods:---------------------------------------------}
{$ENDIF}

{$IFDEF MSWINDOWS}
{About bits and pieces:------------------------------------------------------}
procedure TAboutProperty.Edit;
{call the "About" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowAbout;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About...)';
end;

{End About bits and pieces:--------------------------------------------------}

{Data bits and pieces:------------------------------------------------------}
procedure TDataProperty.Edit;
{call the "Data" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowData;
end;

function TDataProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TDataProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Data...)';
end;

{End Data bits and pieces:--------------------------------------------------}

{Series bits and pieces:------------------------------------------------------}
procedure TSeriesProperty.Edit;
{call the "Series" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowSeries;
end;

function TSeriesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TSeriesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Series...)';
end;

{End Series bits and pieces:--------------------------------------------------}

{$IFDEF COMPILER35_UP}
{Toolbar bits and pieces:------------------------------------------------------}
{procedure TToolbarProperty.Edit;
begin
  TPlotToolBar(GetComponent(0)).ShowArrangement;
end;

function TToolbarProperty.GetAttributes: TPropertyAttributes;
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TToolbarProperty.GetValue: String;
begin
  GetValue := '(Arrangement...)';
end;}
{End Toolbar bits and pieces:--------------------------------------------------}
{$ENDIF}

{Axes bits and pieces:------------------------------------------------------}
procedure TAxesProperty.Edit;
{call the "Axes" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowAxes;
end;

function TAxesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAxesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Axes...)';
end;
{End Axes bits and pieces:--------------------------------------------------}
{$ENDIF}
end.
