unit Functons;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Functions.pas, released 12 April 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/04/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To create new series from existing series using mathematical expressions.

Known Issues: This requires FUNCTIONS to be defined in Plot.inc, and for the
  TParser10 to be installed in the TPlot/Parser10 subdirectory.
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}

  Misc;

type
  TFunctionsForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    SeriesLabel: TLabel;
    FunctionMemo: TMemo;
    FunctionComboBox: TComboBox;
    InsertBitBtn: TBitBtn;
    FunctionHintLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure InsertBitBtnClick(Sender: TObject);
    procedure FunctionComboBoxClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FunctionsForm: TFunctionsForm;

implementation

{$R *.dfm}

const
  FUNCTION_MAX = 30;
  {Functions: array [0..FUNCTION_MAX] of string =
    'PI',
    'COS',
    'SIN',
    'SINH',
    'COSH',
    'TAN',
    'COTAN',
    'ARCTAN',
    'ARG',
    'EXP',
    'LN',
    'LOG10',
    'LOG2',
    'LOGN',
    'SQRT',
    'SQR',
    'POWER',
    'INTPOWER',
    'MIN',
    'MAX',
    'ABS',
    'TRUNC',
    'INT',
    'CEIL',
    'FLOOR',
    'HEAV',
    'SIGN',
    'ZERO',
    'PH',
    'RND',
    'RANDOM'];}

  FunctionHints: array [0..FUNCTION_MAX] of string =
    ('3.14159...',
    'Cosine of X',
    'Sine of X',
    'Hyperbloic Sine of X',
    'Hyperbloic Cosine of X',
    'Tangent of X',
    'Cotangent of X',
    'Inverse Tangent of X',
    'ARG',
    'Exponent: e raised to X',
    'Natural logarithm to the base e',
    'Logarithm to base 10',
    'Logarithm to base 2',
    'Logarithm to base N',
    'Square root',
    'Square',
    'Power(Y, X): Y raised to the Xth power',
    'IntPower(Y, N): Y raised to the integer Nth power',
    'Min(A, B): minimium of A and B',
    'Max(A, B): maximium of A and B',
    'Absolute value of X',
    'the value of X rounded toward zero',
    'X rounded toward zero',
    'the lowest integer greater than or equal to X',
    'the highest integer less than or equal to X',
    'Heaviside function is 1 for x=>0, 0 for x<0',
    'Sign is 1 for x>1, 0 for x=0, -1 for x<0',
    'Zero is 0 for x=0, 1 for x<>0),',
    'Ph = x - 2*pi*round(x/2/pi)',
    'Rnd = int(x) * Random',
    'a random number within the range 0 <= X < Range');


procedure TFunctionsForm.FormCreate(Sender: TObject);
begin
  SetDialogGeometry(TForm(Self), TControl(CancelBitBtn), HelpBitBtn.Left);
  FunctionMemo.Hint :=
    'Type your expression in here:' + #10 +
    'eg:  4 * Series0 + Sqr(Series1) + Exp(Series3';

  FunctionComboBox.ItemIndex := 0;
  FunctionHintLabel.Caption := FunctionHints[0];
end;

procedure TFunctionsForm.InsertBitBtnClick(Sender: TObject);
begin
  with FunctionMemo do
  begin
    if (SelLength > 0) then
      SelText := FunctionComboBox.Text + '(' +SelText + ')'
     else
{$IFDEF MSWINDOWS}
      Lines[CaretPos.y] :=
        Copy (Lines[CaretPos.y], 1, CaretPos.x) +
        FunctionComboBox.Text + '() + ' +
        Copy (Lines[CaretPos.y], CaretPos.x+1, 999);
{$ENDIF}
{$IFDEF LINUX}
      Lines[CaretPos.Line] :=
        Copy (Lines[CaretPos.Line], 1, CaretPos.Col) +
        FunctionComboBox.Text + '() + ' +
        Copy (Lines[CaretPos.Line], CaretPos.Col+1, 999);
{$ENDIF}
  end;
end;

procedure TFunctionsForm.FunctionComboBoxClick(Sender: TObject);
begin
  FunctionHintLabel.Caption := FunctionHints[FunctionComboBox.ItemIndex];
end;

end.
