unit Displace;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Axis.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 02/25/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user setting of the displacement of a series.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, Forms, Graphics, StdCtrls, 
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, Forms, Graphics, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  QT,
  QButtons, QControls, QForms, QGraphics, QStdCtrls,
{$ENDIF}
  Misc, NEdit;

type
  TDisplacementForm = class(TForm)
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    SeriesLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    DeltaXNEdit: TNEdit;
    DeltaYNEdit: TNEdit;
    ApplyBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    TheSeries: TObject;
  end;

var
  DisplacementForm: TDisplacementForm;

implementation

{$R *.dfm}

uses
  Data;

{------------------------------------------------------------------------------
    Procedure: TDisplaceForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.FormCreate(Sender: TObject);
begin
  SetDialogGeometry(Self, ApplyBitBtn, SeriesLabel.Left);
end;

procedure TDisplacementForm.ApplyBitBtnClick(Sender: TObject);
begin
  TSeries(TheSeries).ApplyDisplacementChange(Self);
end;


end.
