// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Datalist.pas' rev: 3.00

#ifndef DatalistHPP
#define DatalistHPP
#include <Titles.hpp>
#include <Misc.hpp>
#include <Plotdefs.hpp>
#include <Parser.hpp>
#include <Functons.hpp>
#include <Data.hpp>
#include <Axis.hpp>
#include <Windows.hpp>
#include <Graphics.hpp>
#include <Dialogs.hpp>
#include <Controls.hpp>
#include <NoMath.hpp>
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Datalist
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS TSeriesList;
class PASCALIMPLEMENTATION TSeriesList : public Classes::TList 
{
	typedef Classes::TList inherited;
	
private:
	Classes::TList* FAxisList;
	bool FDataChanged;
	bool FIgnoreChanges;
	Axis::TAxis* FXAxis;
	Axis::TAxis* FYAxis;
	Classes::TNotifyEvent FOnStyleChange;
	Classes::TNotifyEvent FOnDataChange;
	int LastSavedPoint;
	Windows::TRect PlotBorder;
	int NoPieRows;
	float __fastcall GetXmin(void);
	float __fastcall GetXmax(void);
	float __fastcall GetYmin(void);
	float __fastcall GetYmax(void);
	float __fastcall GetZmin(void);
	float __fastcall GetZmax(void);
	float __fastcall GetYErrorMin(void);
	float __fastcall GetYErrorMax(void);
	int __fastcall GetMaxNoPts(void);
	int __fastcall GetMinNoPts(void);
	int __fastcall GetTotalNoPts(void);
	
protected:
	void __fastcall StyleChange(System::TObject* Sender);
	void __fastcall DataChange(System::TObject* Sender);
	virtual void __fastcall DoStyleChange(void);
	virtual void __fastcall DoDataChange(void);
	
public:
	__property bool DataChanged = {read=FDataChanged, write=FDataChanged, stored=false, nodefault};
	__property bool IgnoreChanges = {read=FIgnoreChanges, write=FIgnoreChanges, nodefault};
	__property int TotalNoPts = {read=GetTotalNoPts, stored=false, nodefault};
	__property int MaxNoPts = {read=GetMaxNoPts, stored=false, nodefault};
	__property int MinNoPts = {read=GetMinNoPts, stored=false, nodefault};
	__property float Xmin = {read=GetXmin, stored=false};
	__property float Xmax = {read=GetXmax, stored=false};
	__property float Ymin = {read=GetYmin};
	__property float Ymax = {read=GetYmax};
	__property float Zmin = {read=GetZmin};
	__property float Zmax = {read=GetZmax};
	__property float YErrorMin = {read=GetYErrorMin};
	__property float YErrorMax = {read=GetYErrorMax};
	__property Classes::TNotifyEvent OnStyleChange = {read=FOnStyleChange, write=FOnStyleChange};
	__property Classes::TNotifyEvent OnDataChange = {read=FOnDataChange, write=FOnDataChange};
	__fastcall virtual TSeriesList(Classes::TList* AxisListPtr);
	__fastcall virtual ~TSeriesList(void);
	HIDESBASE int __fastcall Add(int XSeriesIndex);
	int __fastcall AddExternal(Misc::pSingleArray XPointer, Misc::pSingleArray YPointer, int NumberOfPoints
		);
	int __fastcall AddInternal(Misc::pSingleArray XPointer, Misc::pSingleArray YPointer, int NumberOfPoints
		);
	void __fastcall ClearSeries(void);
	int __fastcall CloneSeries(int TheSeries);
	void __fastcall DeleteSeries(int Index, bool Ask);
	bool __fastcall ParseData(Classes::TStringList* TheData, System::AnsiString TheHelpFile);
	bool __fastcall ConvertTextData(int ColCount, int SeriesCount, int FirstLine, System::AnsiString Delimiter
		, Classes::TStringList* TheData, Parser::pSeriesInfoArray SeriesInfo);
	bool __fastcall ConvertXYZData(int FirstLine, System::AnsiString Delimiter, Classes::TStrings* InfoGridRows
		, Classes::TStringList* TheData);
	bool __fastcall ConvertBinaryData(int ColCount, int SeriesCount, Classes::TMemoryStream* TheStream, 
		Parser::pSeriesInfoArray SeriesInfo);
	void __fastcall DataAsHTMLTable(Classes::TStringList* &TheData);
	void __fastcall GetStream(bool AsText, char Delimiter, Classes::TMemoryStream* &TheStream);
	void __fastcall GetSubHeaderStream(char Delimiter, Classes::TMemoryStream* TheStream);
	void __fastcall GetBinaryStream(int Start, int Finish, Classes::TMemoryStream* TheStream);
	void __fastcall GetTextStream(char Delimiter, int Start, int Finish, Classes::TMemoryStream* TheStream
		);
	void __fastcall AppendStream(bool AsText, char Delimiter, Misc::TMemoryStreamEx* TheStream);
	bool __fastcall LoadFromStream(Classes::TMemoryStream* AStream, bool &AsText);
	void __fastcall Draw(Graphics::TCanvas* ACanvas, int XYBridge);
	void __fastcall DrawError(Graphics::TCanvas* ACanvas);
	void __fastcall DrawBubble(Graphics::TCanvas* ACanvas, int BubbleSize);
	void __fastcall DrawMultiple(Graphics::TCanvas* ACanvas, Byte Multiplicity, Graphics::TPen* MultiplePen
		, int MultiJoin1, int MultiJoin2);
	void __fastcall DrawColumns(Graphics::TCanvas* ACanvas, Misc::TPercent ColumnGap);
	void __fastcall DrawStack(Graphics::TCanvas* ACanvas, Misc::TPercent ColumnGap);
	void __fastcall DrawNormStack(Graphics::TCanvas* ACanvas, Misc::TPercent ColumnGap);
	void __fastcall DrawPie(Graphics::TCanvas* ACanvas, Titles::TBorder* Border, int NoRows);
	void __fastcall DrawPolar(Graphics::TCanvas* ACanvas, float PolarRange);
	void __fastcall Draw3DWire(Graphics::TCanvas* ACanvas, Axis::TAngleAxis* ZAxis, bool ZLink);
	void __fastcall Draw3DContour(Graphics::TCanvas* ACanvas, Axis::TAngleAxis* ZAxis, Plotdefs::TContourDetail 
		ContourDetail);
	void __fastcall DrawContour(Graphics::TCanvas* ACanvas, Plotdefs::TContourDetail ContourDetail);
	void __fastcall DrawColorScale(Graphics::TCanvas* ACanvas, float TheMin, float Span, Plotdefs::TContourDetail 
		TheContourDetail);
	void __fastcall DrawHistory(Graphics::TCanvas* ACanvas, float HistoryX);
	void __fastcall DrawHistoryMultiple(Graphics::TCanvas* ACanvas, Byte Multiplicity);
	int __fastcall GetNearestPoint(Plotdefs::TPlotType ThePlotType, int ColumnGap, int iX, int iY, int 
		&TheSeries, float &MinDistance, Data::TSeries* &pSeries);
	Data::TSeries* __fastcall GetSeriesOfZ(float ZValue);
};

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Datalist */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Datalist;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Datalist
