unit Dataedit;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Q Public License
("QPL"); you may not use this file except in compliance
with the QPL. You may obtain a copy of the QPL from 
the file QPL.html in this distribution, derived from:

http://www.trolltech.com/products/download/freelicense/license.html

The QPL prohibits development of proprietary software. 
There is a Professional Version of this software available for this. 
Contact sales@chemware.hypermart.net for more information.

Software distributed under the QPL is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the QPL for
the specific language governing rights and limitations under the QPL.

The Original Code is: Dataedit.pas, released 15 March 2001.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 03/13/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user manipluation of Series Data (ie: the numbers !).

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Clipbrd, Controls, ComCtrls, Forms, Graphics, Grids, StdCtrls,
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Clipbrd, Controls, ComCtrls, Forms, Graphics, Grids, StdCtrls,
{$ENDIF}
{$IFDEF LINUX}
  {QT,}Untranslated,
  QButtons, QClipbrd, QControls, QComCtrls, QExtCtrls, QForms, QGrids, QGraphics, QStdCtrls,
{$ENDIF}
  Nedit;

type
  TDataEditorForm = class(TForm)
    DataStringGrid: TStringGrid;
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    ZDataLabel: TLabel;
    AddRowBitBtn: TBitBtn;
    DeleteRowBitBtn: TBitBtn;
    ZDataNEdit: TNEdit;
    CopyBitBtn: TBitBtn;
    ApplyBitBtn: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure DataStringGridKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure AddRowBitBtnClick(Sender: TObject);
    procedure DeleteRowBitBtnClick(Sender: TObject);
    procedure CopyBitBtnClick(Sender: TObject);
    procedure HelpBitBtnClick(Sender: TObject);
    procedure ApplyBitBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    NumericDataChanged: Boolean;
{Has the X or Y numeric data, or the Z data, changed ?}
    StringDataChanged: Boolean;
{Has the X String data been changed ?}
    RowCountChanged: Boolean;
{Has the number of rows (points) changed ?}
    ExternalXSeries: Boolean;
{Is the X Data maintained in a different series ?
 If it is, then it cannot be changed here.}    
    DependentXSeries: Boolean;
    TheSeries: TObject;
  end;

var
  DataEditorForm: TDataEditorForm;

implementation

uses
  Data;
{$R *.dfm}

procedure TDataEditorForm.FormCreate(Sender: TObject);
begin
  Left := 10;
  Top := 10;

  AddRowBitBtn.Width := 88;
  DeleteRowBitBtn.Width := 88;
  ZDataNEdit.Width := 88;
  ApplyBitBtn.Width := 75;
  HelpBitBtn.Width := 75;
  OKBitBtn.Width := 75;
  CancelBitBtn.Width := 75;

{do the geometry of the grid:}
  DataStringGrid.Cells[0,0] := 'Point';
  DataStringGrid.ColWidths[0] := Canvas.TextWidth('Point') + 6;
  DataStringGrid.Cells[1, 0] := 'X Data';
  DataStringGrid.Cells[2, 0] := 'Y Data';
  DataStringGrid.Cells[3, 0] := 'X String';

  //ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;

  DataStringGrid.Hint := 'Press "F2" to edit, or just overtype,' + #10 +
    'and Ctrl-C to copy a single cell.';
  NumericDataChanged := FALSE;
  StringDataChanged := FALSE;
  RowCountChanged := FALSE;
end;

procedure TDataEditorForm.FormResize(Sender: TObject);
begin
  OKBitBtn.Top := ClientHeight - 3 * OKBitBtn.Height div 2;
  HelpBitBtn.Top := OKBitBtn.Top;
  CancelBitBtn.Top := OKBitBtn.Top;
  ApplyBitBtn.Top := OKBitBtn.Top;
  DataStringGrid.Width := ClientWidth - 2;
  DataStringGrid.ColWidths[3] := DataStringGrid.Width -
    DataStringGrid.ColWidths[0] -
    DataStringGrid.ColWidths[1] -
    DataStringGrid.ColWidths[2] - 25;
  DataStringGrid.Height := ClientHeight - DataStringGrid.Top - 2*OKBitBtn.Height;  
end;

procedure TDataEditorForm.DataStringGridKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if (((Key > 31) and (Key < 127)) or (Key = VK_BACK))then
  begin
{ ' ' thru to '~':}
    case DataStringGrid.Col of
      1:
        begin
          if (ExternalXSeries) then
            Key := 0
          else
            NumericDataChanged := TRUE;
        end;
      2: NumericDataChanged := TRUE;
      3: StringDataChanged := TRUE;
    end;
  end;
end;

procedure TDataEditorForm.AddRowBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  with DataStringGrid do
  begin
    RowCount := RowCount + 1;
    Cells[0, RowCount-1] :=
      IntToStr(RowCount-2);
    for i := RowCount-2 downto Row+1 do
    begin
      Cells[1, i+1] := Cells[1, i];
      Cells[2, i+1] := Cells[2, i];
      Cells[3, i+1] := Cells[3, i];
    end;
    Cells[1, Row+1] := '';
    Cells[2, Row+1] := '';
    Cells[3, Row+1] := '';
    Row := Row + 1;
    SetFocus;
  end;
  RowCountChanged := TRUE;
end;

procedure TDataEditorForm.DeleteRowBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  with DataStringGrid do
  begin
    for i := Row to RowCount-2 do
    begin
      Cells[0, i] := Cells[0, i+1];
      Cells[1, i] := Cells[1, i+1];
      Cells[2, i] := Cells[2, i+1];
      Cells[3, i] := Cells[3, i+1];
    end;
    RowCount := RowCount - 1;
    SetFocus;
  end;
  RowCountChanged := TRUE;
end;

procedure TDataEditorForm.CopyBitBtnClick(Sender: TObject);
var
  i: Integer;
  TheStringList: TStringList;
begin
  TheStringList := TStringList.Create;
  with DataStringGrid do
  begin
    for i := 0 to RowCount-1 do
    begin
      TheStringList.Add(
        Cells[0, i] + Chr(VK_TAB) +
        Cells[1, i] + Chr(VK_TAB) +
        Cells[2, i] + Chr(VK_TAB) +
        Cells[3, i]);
    end;
    Clipboard.AsText := TheStringList.Text;
  end;  
  TheStringList.Free;
end;

procedure TDataEditorForm.HelpBitBtnClick(Sender: TObject);
{$IFDEF LINUX}
var
  TheHelpFile: String;
{$ENDIF}
begin
{$IFDEF LINUX}
  TheHelpFile := 'hs' + IntToStr(HelpBitBtn.HelpContext) + '.htm';
{$ENDIF}
end;

{------------------------------------------------------------------------------
    Procedure: TPlotDataEditorForm.ApplyBitBtnClick
  Description: Standard ButtonClick event handler
       Author: Mat Ballard
 Date created: 03/28/2001
Date modified: 03/28/2001 by Mat Ballard
      Purpose: Applies the current Data to the Series
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDataEditorForm.ApplyBitBtnClick(Sender: TObject);
begin
  TSeries(TheSeries).ApplyDataChange(Self);
  NumericDataChanged := FALSE;
  StringDataChanged := FALSE;
end;


end.
