// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Axis.pas' rev: 3.00

#ifndef AxisHPP
#define AxisHPP
#include <Titles.hpp>
#include <Plotdefs.hpp>
#include <NoMath.hpp>
#include <Misc.hpp>
#include <Graphics.hpp>
#include <Windows.hpp>
#include <SysUtils.hpp>
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Axis
{
//-- type declarations -------------------------------------------------------
enum TAxisType { atPrimary, atSecondary, atTertiary };

enum TLabelFormat { lfGeneral, lfExponent, lfFixed, lfNumber, lfCurrency, lfSI, lfPercent, lfSeconds, 
	lfMinutes, lfHours, lfDays, lfShortTime, lfShortDate };

class DELPHICLASS TAxisLabel;
class PASCALIMPLEMENTATION TAxisLabel : public Titles::TCaption 
{
	typedef Titles::TCaption inherited;
	
private:
	TDirection FDirection;
	Byte FDigits;
	Byte FPrecision;
	TLabelFormat FNumberFormat;
	void __fastcall SetDirection(Titles::TDirection Value);
	void __fastcall SetDigits(Byte Value);
	void __fastcall SetPrecision(Byte Value);
	void __fastcall SetNumberFormat(TLabelFormat Value);
	
public:
	__fastcall virtual TAxisLabel(Classes::TPersistent* AOwner);
	__fastcall virtual ~TAxisLabel(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	
__published:
	__property Titles::TDirection Direction = {read=FDirection, write=SetDirection, nodefault};
	__property Byte Digits = {read=FDigits, write=SetDigits, nodefault};
	__property Byte Precision = {read=FPrecision, write=SetPrecision, nodefault};
	__property TLabelFormat NumberFormat = {read=FNumberFormat, write=SetNumberFormat, nodefault};
};

class DELPHICLASS TAxis;
class PASCALIMPLEMENTATION TAxis : public Titles::TRectangle 
{
	typedef Titles::TRectangle inherited;
	
private:
	Byte FArrowSize;
	bool FAutoScale;
	TAxisType FAxisType;
	TDirection FDirection;
	float FIntercept;
	TAxisLabel* FLabels;
	Classes::TPersistent* FLabelSeries;
	bool FLogScale;
	float FLogSpan;
	float FMin;
	float FMax;
	Graphics::TPen* FPen;
	float FStepSize;
	float FStepStart;
	float FSpan;
	Byte FTickMinor;
	int FTickSign;
	Byte FTickSize;
	TOrientation FTickDirection;
	Byte FTickNum;
	Titles::TTitle* FTitle;
	float FZoomIntercept;
	float FZoomMin;
	float FZoomMax;
	void __fastcall ReScale(void);
	void __fastcall SetupHorizontalEnvelope(void);
	void __fastcall SetupVerticalEnvelope(int StrWidth);
	
protected:
	void __fastcall SetArrowSize(Byte Value);
	void __fastcall SetAutoScale(bool Value);
	void __fastcall SetDirection(Titles::TDirection Value);
	void __fastcall SetIntercept(float Value);
	void __fastcall SetLogScale(bool Value);
	void __fastcall SetMin(float Value);
	void __fastcall SetMax(float Value);
	void __fastcall SetPen(Graphics::TPen* Value);
	void __fastcall SetStepSize(float Value);
	void __fastcall SetStepStart(float Value);
	void __fastcall SetTickMinor(Byte Value);
	void __fastcall SetTickSize(Byte Value);
	void __fastcall SetOrientation(Titles::TOrientation Value);
	virtual void __fastcall StyleChange(System::TObject* Sender);
	virtual void __fastcall TitleChange(System::TObject* Sender);
	
public:
	__property TAxisType AxisType = {read=FAxisType, write=FAxisType, nodefault};
	__property float ZoomIntercept = {read=FZoomIntercept, write=FZoomIntercept};
	__property float ZoomMin = {read=FZoomMin, write=FZoomMin};
	__property float ZoomMax = {read=FZoomMax, write=FZoomMax};
	__fastcall TAxis(Classes::TPersistent* AOwner);
	__fastcall virtual ~TAxis(void);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas);
	float __fastcall GetNextXValue(float XValue);
	System::AnsiString __fastcall LabelToStrF(float Value);
	float __fastcall StrToLabel(System::AnsiString Value);
	int __fastcall FofX(float X);
	int __fastcall FofY(float Y);
	float __fastcall XofF(int F);
	float __fastcall YofF(int F);
	void __fastcall SetLabelSeries(Classes::TPersistent* Value);
	void __fastcall SetMinFromSeries(float Value);
	void __fastcall SetMaxFromSeries(float Value);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	
__published:
	__property Byte ArrowSize = {read=FArrowSize, write=SetArrowSize, nodefault};
	__property bool AutoScale = {read=FAutoScale, write=SetAutoScale, nodefault};
	__property Titles::TTitle* Title = {read=FTitle, write=FTitle};
	__property Titles::TDirection Direction = {read=FDirection, write=SetDirection, nodefault};
	__property float Intercept = {read=FIntercept, write=SetIntercept};
	__property TAxisLabel* Labels = {read=FLabels, write=FLabels};
	__property bool LogScale = {read=FLogScale, write=SetLogScale, nodefault};
	__property float Min = {read=FMin, write=SetMin};
	__property float Max = {read=FMax, write=SetMax};
	__property Graphics::TPen* Pen = {read=FPen, write=SetPen};
	__property float StepSize = {read=FStepSize, write=SetStepSize};
	__property float StepStart = {read=FStepStart, write=SetStepStart};
	__property Byte TickMinor = {read=FTickMinor, write=SetTickMinor, nodefault};
	__property Byte TickSize = {read=FTickSize, write=SetTickSize, nodefault};
	__property Titles::TOrientation TickDirection = {read=FTickDirection, write=SetOrientation, nodefault
		};
};

class DELPHICLASS TAngleAxis;
class PASCALIMPLEMENTATION TAngleAxis : public Axis::TAxis 
{
	typedef Axis::TAxis inherited;
	
private:
	Word FAngle;
	float FAngleRadians;
	Word FLength;
	int FEndX;
	int FEndY;
	Extended FSin;
	Extended FCos;
	Extended FSinM30;
	Extended FCosM30;
	Extended FSinP30;
	Extended FCosP30;
	
protected:
	void __fastcall SetAngle(Word Value);
	void __fastcall SetLength(Word Value);
	
public:
	__fastcall TAngleAxis(Classes::TPersistent* AOwner);
	__fastcall virtual ~TAngleAxis(void);
	virtual bool __fastcall ClickedOn(int iX, int iY);
	HIDESBASE void __fastcall Outline(Graphics::TCanvas* ACanvas);
	tagPOINT __fastcall dFofZ(float Z);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas);
	
__published:
	__property Word Angle = {read=FAngle, write=SetAngle, nodefault};
	__property Word Length = {read=FLength, write=SetLength, nodefault};
};

//-- var, const, procedure ---------------------------------------------------

}	/* namespace Axis */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Axis;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Axis
