unit Options;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License Version 1.1 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for the specific language governing rights and limitations under the License.

The Original Code is: Options.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 05/25/2000
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose:
This form is used to display a standard "About" dialog box with a few extra wrinkles.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils,
{$IFDEF WINDOWS}
  WinTypes, WinProcs,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls
{$ENDIF}
{$IFDEF WIN32}
  Windows,
  Buttons, Controls, ExtCtrls, Forms, StdCtrls
{$ENDIF}
{$IFDEF LINUX}
  QT,
  QButtons, QControls, QExtCtrls, QForms, QStdCtrls
{$ENDIF}
  ;

type
  TOptionsForm = class(TForm)
    OptionsRadioGroup: TRadioGroup;
    QuestionLabel: TLabel;
    OKBitBtn: TBitBtn;
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    procedure OKBitBtnClick(Sender: TObject);
    procedure CancelBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
  public
    procedure DoGeometry;
  end;

var
  OptionsForm: TOptionsForm;

implementation

{$R *.dfm}

procedure TOptionsForm.FormCreate(Sender: TObject);
begin {Form has not yet had properties set}
{$IFDEF MSWINDOWS}
  {Self.PixelsPerInch := 96;}
  Self.BorderStyle := bsDialog;
{$ENDIF}
{$IFDEF LINUX}
  {Self.PixelsPerInch := 75;}
  Self.BorderStyle := fbsDialog;
{$ENDIF}
end;


procedure TOptionsForm.DoGeometry;
var
  i: Integer;
  StrLength: Integer;
  StrMax: String;
  Size: Integer;
begin
  QuestionLabel.Left := QuestionLabel.Left;
  QuestionLabel.Top := QuestionLabel.Top;

  StrLength := 0;
  StrMax := '';
  for i := 0 to OptionsRadioGroup.ControlCount-1 do
  begin
    if (Length(TRadioButton(OptionsRadioGroup.Controls[i]).Caption) > StrLength) then
    begin
      StrMax := TRadioButton(OptionsRadioGroup.Controls[i]).Caption;
      StrLength := Length(StrMax);
    end;
  end;
  if (Length(OptionsRadioGroup.Caption) > StrLength) then
    StrMax := OptionsRadioGroup.Caption;
  StrMax := StrMax + 'WWWWW';

  Size := Canvas.TextWidth(StrMax);
  if (Size < 265) then Size := 265;

  if (QuestionLabel.Width > Size) then
    OptionsRadioGroup.Width := QuestionLabel.Width
   else
    OptionsRadioGroup.Width := Size;

  OptionsRadioGroup.Top := 2 * QuestionLabel.Top +
                           QuestionLabel.Height;
  OptionsRadioGroup.Height := (OptionsRadioGroup.Items.Count +1)*
                              OKBitBtn.Height;

  OKBitBtn.Top := OptionsRadioGroup.Top +
                  OptionsRadioGroup.Height +
                  QuestionLabel.Top;
  CancelBitBtn.Top := OKBitBtn.Top;
  HelpBitBtn.Top := OKBitBtn.Top;

  ClientHeight := OKBitBtn.Top + 3 * OKBitBtn.Height div 2;
  ClientWidth := 2 * QuestionLabel.Left + OptionsRadioGroup.Width;


  HelpBitBtn.Left := Width - QuestionLabel.Left - HelpBitBtn.Width;
  CancelBitBtn.Left := HelpBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;
  OKBitBtn.Left := CancelBitBtn.Left - QuestionLabel.Left - CancelBitBtn.Width;

  Left := 10;
  Top := 10;
end;

procedure TOptionsForm.FormShow(Sender: TObject);
begin {Form is ALREADY VISIBLE !}
  DoGeometry;
  OptionsRadioGroup.ItemIndex := 0;
  TRadioButton(OptionsRadioGroup.Controls[0]).SetFocus;
end;

procedure TOptionsForm.OKBitBtnClick(Sender: TObject);
begin
{note: if ModalResult is 0, then the form DOES NOT CLOSE,
 so selection is 1..n:}
  ModalResult := OptionsRadioGroup.ItemIndex + 1;
end;

procedure TOptionsForm.CancelBitBtnClick(Sender: TObject);
begin
  ModalResult := -1;
end;

end.

