unit NoMath;

{$I Misc.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License Version 1.1 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at

http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for the specific language governing rights and limitations under the License.

The Original Code is: NoMath.pas, released 10 Jan 2001.
Portions were originally present in Misc.pas.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@chemware.hypermart.net.

Last Modified: 01/12/2001
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.


Purpose:
Collection of routines to substitute for the Math unit in the Pro versions.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Classes, SysUtils
{$IFDEF WINDOWS}
{$ENDIF}
{$IFDEF WIN32}
{$ENDIF}
{$IFDEF LINUX}
{$ENDIF}
  ;

{type}

  function Floor(X: Extended): Integer;
  function IntPower(Base: Extended; Exponent: Integer): Extended;
  function Log10(X: Extended): Extended;
  function Power(Base, Exponent: Extended): Extended;
  function Min(A, B: Integer): Integer;
  function Max(A, B: Integer): Integer;
  procedure SinCos(Theta: Extended; var SinTheta, CosTheta: Extended);

const
  TWO_PI = 6.28318530717958; {6476925286766559}

implementation

{The following routines are also found in the Math unit in the Pro versions.
 However, the Borland versions are far more efficient.}

function Log10(X: Extended): Extended;
begin
{divide by ln(10):}
  Result :=  Ln(X) / 2.3025850929940456840179914546844;
end;

function IntPower(Base: Extended; Exponent: Integer): Extended;
begin
  Result := Power(Base, Exponent);
end;

function Power(Base, Exponent: Extended): Extended;
begin
  if Exponent = 0.0 then
    Result := 1.0               { n**0 = 1 }
  else if (Base = 0.0) and (Exponent > 0.0) then
    Result := 0.0               { 0**n = 0, n > 0 }
  else
    Result := Exp(Exponent * Ln(Base))
end;

function Floor(X: Extended): Integer;
begin
  Result := Integer(Trunc(X));
  if Frac(X) < 0 then
    Result := Result - 1;
end;

function Min(A, B: Integer): Integer;
begin
  if (A < B) then
    Result := A
   else
    Result := B;
end;

function Max(A, B: Integer): Integer;
begin
  if (A > B) then
    Result := A
   else
    Result := B;
end;

procedure SinCos(Theta: Extended; var SinTheta, CosTheta: Extended);
begin
  SinTheta := Sin(Theta);
  CosTheta := Cos(Theta);
end;

end.
