unit Fileinfo;

{$I Misc.inc}

{-----------------------------------------------------------------------------
FileVersionInfo is an original work by Helmut Schottmueller and is hereby placed in the Public Domain.

The Original Code is: FileVersionInfo.pas, released 1998-1999.

The Initial Developer of the Original Code is Helmut Schottmueller.

Contributor(s): Helmut Schottmueller   e-mail: hschottm@informatik.uni-bremen.de

Last Modified: 05/25/2000
Current Version: 2.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 


Purpose: extract resource information from executable

Known Issues:
-----------------------------------------------------------------------------}

{Note from Mat Ballard:
 This component is used by both the TSplash and TAbout dialog boxes in the
 TSplashDlg and TAboutDlg components.}

interface

uses
  Classes, SysUtils
{$IFDEF WINDOWS}
  ,WinTypes, WinProcs, Ver
{$ENDIF}
{$IFDEF WIN32}
  ,Windows
{$ENDIF}
{$IFDEF LINUX}

{$ENDIF}
  ;

type
  TFileVersionInfo = class(TComponent)
  private
    { private declarations }
    fCompanyName : String;
    fFileDescription : String;
    fFileVersion : String;
    fInternalName : String;
    fLegalCopyright : String;
    fLegalTradeMarks : String;
    fOriginalFilename : String;
    fProductName : String;
    fProductVersion : String;
    fComments : String;
    fExecutableFile : String;
    fCountryCode    : String;
    procedure setExecutableFile(FileName : String);
    procedure clearInfo;
  protected
    { protected declarations }
  public
    { public declarations }
    constructor Create(AOwner : TComponent); override;
    procedure FindFileVersionInfo;
  published
    { published declarations }
    property Comments : String read fComments write fComments;
    property CompanyName : String read fCompanyName write fCompanyName;
    property CountryCode : String read fCountryCode write fCountryCode;
    property ExecutableFile : String read fExecutableFile write setExecutableFile;
    property FileDescription : String read fFileDescription write fFileDescription;
    property FileVersion : String read fFileVersion write fFileVersion;
    property InternalName : String read fInternalName write fInternalName;
    property LegalCopyright : String read fLegalCopyright write fLegalCopyright;
    property LegalTradeMarks : String read fLegalTradeMarks write fLegalTradeMarks;
    property OriginalFilename : String read fOriginalFilename write fOriginalFilename;
    property ProductName : String read fProductName write fProductName;
    property ProductVersion : String read fProductVersion write fProductVersion;
  end;

	TTranslation = record
  	b1 : byte;
    b2 : byte;
    b3 : byte;
    b4 : byte;
  end;

  PTranslation = ^TTranslation;

implementation

{-----------------------------------------------------------------------------}
constructor TFileVersionInfo.Create(AOwner : TComponent);
{creates a TFileVersionInfo object}
begin
  inherited Create(AOwner);
  setExecutableFile(ParamStr(0));
end;

{-----------------------------------------------------------------------------}
procedure TFileVersionInfo.setExecutableFile(FileName : String);
{sets the executable filename and calls the fileversioninfo API}
begin
  fExecutableFile := FileName;
  FindFileVersionInfo;
end;

{-----------------------------------------------------------------------------}
{$IFDEF MSWINDOWS}
procedure TFileVersionInfo.FindFileVersionInfo;
{calls the fileversioninfo API and sets the component properties}
var
  StringBuffer       : PChar;
  VersionPointer     : PChar;
  QueryStr           : String;
  pQueryStr          : array [0..255] of char;
{$IFDEF DELPHI1}
  Size               : Longint;
  VersionValueLength : Word;
  lpExecutableFile   : array [0..255] of char;
{$ELSE}
  Size               : DWord;
  VersionValueLength : DWord;
{$ENDIF}
begin
	{clear all properties}
  clearInfo;

	{get size of fileversioninfo buffer}
{$IFDEF WINDOWS}
  StrPCopy(lpExecutableFile, fExecutableFile);
  Size := GetFileVersionInfoSize(lpExecutableFile, Size);
{$ENDIF}
{$IFDEF WIN32}
  Size := GetFileVersionInfoSize(PChar(fExecutableFile), Size);
{$ENDIF}

  if Size > 0 then
  begin {fileversioninfo exists}
{allocate memory for fileversioninfo strings}
    StringBuffer := AllocMem(Size);
		{copy fileversioninfo into buffer}
{$IFDEF WINDOWS}
    GetFileVersionInfo(lpExecutableFile, 0, Size, StringBuffer);
{$ENDIF}
{$IFDEF WIN32}
    GetFileVersionInfo(PChar(fExecutableFile), 0, Size, StringBuffer);
{$ENDIF}

{convert Translation to correct countrycode}
    VerQueryValue(StringBuffer, PChar('\VarFileInfo\Translation'),
      Pointer(VersionPointer), VersionValueLength);

    fCountryCode :=
      IntToHex(PTranslation(VersionPointer)^.b2, 2) +
      IntToHex(PTranslation(VersionPointer)^.b1, 2) +
      IntToHex(PTranslation(VersionPointer)^.b4, 2) +
      IntToHex(PTranslation(VersionPointer)^.b3, 2);

		{get company name}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'CompanyName';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fCompanyName := StrPas(VersionPointer);
		{get file description}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'FileDescription';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fFileDescription := StrPas(VersionPointer);
		{get file version}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'FileVersion';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fFileVersion := StrPas(VersionPointer);
		{get internal name}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'InternalName';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fInternalName := StrPas(VersionPointer);
		{get legal copyright}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'LegalCopyright';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fLegalCopyright := StrPas(VersionPointer);
		{get legal trademarks}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'LegalTradeMarks';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fLegalTradeMarks := StrPas(VersionPointer);
		{get original filename}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'OriginalFilename';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fOriginalFilename := StrPas(VersionPointer);
		{get product name}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'ProductName';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fProductName := StrPas(VersionPointer);
		{get product version}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'ProductVersion';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fProductVersion := StrPas(VersionPointer);
		{get comments}
    QueryStr := '\StringFileInfo\' + fCountryCode + '\' + 'Comments';
    StrPCopy(pQueryStr, QueryStr);
    if VerQueryValue(StringBuffer, pQueryStr, Pointer(VersionPointer), VersionValueLength) then
      fComments := StrPas(VersionPointer);

		{free previously allocated memory}
    FreeMem(StringBuffer, Size);
  end;
end;
{$ENDIF}

{$IFDEF LINUX}
procedure TFileVersionInfo.FindFileVersionInfo;
begin
end;
{$ENDIF}

{-----------------------------------------------------------------------------}
procedure TFileVersionInfo.clearInfo;
{clear all properties}
begin
  fCompanyName := '';
  fFileDescription := '';
  fFileVersion := '';
  fInternalName := '';
  fLegalCopyright := '';
  fLegalTradeMarks := '';
  fOriginalFilename := '';
  fProductName := '';
  fProductVersion := '';
  fComments := '';
  fCountryCode := '';
end;


end.
