// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Titles.pas' rev: 3.00

#ifndef TitlesHPP
#define TitlesHPP
#include <Misc.hpp>
#include <Windows.hpp>
#include <SysUtils.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Titles
{
//-- type declarations -------------------------------------------------------
enum TDirection { dHorizontal, dVertical };

enum TOrientation { orRight, orLeft };

class DELPHICLASS TRectangle;
class PASCALIMPLEMENTATION TRectangle : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TAlignment FAlignment;
	bool FFireEvents;
	int FLeft;
	int FTop;
	int FRight;
	int FBottom;
	System::AnsiString FName;
	Classes::TPersistent* FOwner;
	int FTag;
	bool FVisible;
	int __fastcall GetHeight(void);
	int __fastcall GetWidth(void);
	void __fastcall SetAlignment(Classes::TAlignment Value);
	void __fastcall SetRight(int Value);
	void __fastcall SetBottom(int Value);
	void __fastcall SetVisible(bool Value);
	void __fastcall SetHeight(int Value);
	void __fastcall SetWidth(int Value);
	void __fastcall SetDeltaX(int Value);
	void __fastcall SetDeltaY(int Value);
	
protected:
	Classes::TNotifyEvent FOnChange;
	int __fastcall GetMidX(void);
	int __fastcall GetMidY(void);
	virtual void __fastcall SetLeft(int Value);
	virtual void __fastcall SetMidX(int Value);
	virtual void __fastcall SetMidY(int Value);
	virtual void __fastcall SetTop(int Value);
	virtual void __fastcall DoHandleChange(void);
	
public:
	__property int DeltaX = {write=SetDeltaX, nodefault};
	__property int DeltaY = {write=SetDeltaY, nodefault};
	__property Classes::TPersistent* Owner = {read=FOwner};
	__property int Tag = {read=FTag, write=FTag, nodefault};
	__fastcall virtual TRectangle(Classes::TPersistent* AOwner);
	__fastcall virtual ~TRectangle(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	bool __fastcall ClickedOn(int iX, int iY);
	
__published:
	__property Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, nodefault};
	__property bool FireEvents = {read=FFireEvents, write=FFireEvents, nodefault};
	__property System::AnsiString Name = {read=FName, write=FName};
	__property int Left = {read=FLeft, write=SetLeft, nodefault};
	__property int Top = {read=FTop, write=SetTop, nodefault};
	__property int Right = {read=FRight, write=SetRight, nodefault};
	__property int Bottom = {read=FBottom, write=SetBottom, nodefault};
	__property bool Visible = {read=FVisible, write=SetVisible, nodefault};
	__property int Height = {read=GetHeight, write=SetHeight, nodefault};
	__property int Width = {read=GetWidth, write=SetWidth, nodefault};
	__property int MidX = {read=GetMidX, write=SetMidX, nodefault};
	__property int MidY = {read=GetMidY, write=SetMidY, nodefault};
	__property Classes::TNotifyEvent OnChange = {read=FOnChange, write=FOnChange};
};

class DELPHICLASS TBorder;
class PASCALIMPLEMENTATION TBorder : public Titles::TRectangle 
{
	typedef Titles::TRectangle inherited;
	
private:
	int FRightEx;
	int FBottomEx;
	void __fastcall SetRightEx(int Value);
	void __fastcall SetBottomEx(int Value);
	int __fastcall GetRightGap(void);
	int __fastcall GetBottomGap(void);
	int __fastcall GetHeightEx(void);
	int __fastcall GetWidthEx(void);
	void __fastcall SetRightGap(int Value);
	void __fastcall SetBottomGap(int Value);
	void __fastcall SetHeightEx(int Value);
	void __fastcall SetWidthEx(int Value);
	
protected:
	virtual void __fastcall SetLeft(int Value);
	virtual void __fastcall SetTop(int Value);
	
public:
	__fastcall virtual TBorder(Classes::TPersistent* AOwner);
	
__published:
	__property int RightEx = {read=FRightEx, write=SetRightEx, nodefault};
	__property int BottomEx = {read=FBottomEx, write=SetBottomEx, nodefault};
	__property int RightGap = {read=GetRightGap, write=SetRightGap, nodefault};
	__property int BottomGap = {read=GetBottomGap, write=SetBottomGap, nodefault};
	__property int HeightEx = {read=GetHeightEx, write=SetHeightEx, nodefault};
	__property int WidthEx = {read=GetWidthEx, write=SetWidthEx, nodefault};
public:
	/* TRectangle.Destroy */ __fastcall virtual ~TBorder(void) { }
	
};

class DELPHICLASS TCaption;
class PASCALIMPLEMENTATION TCaption : public Titles::TRectangle 
{
	typedef Titles::TRectangle inherited;
	
private:
	System::AnsiString FCaption;
	Graphics::TFont* FFont;
	Classes::TNotifyEvent FOnCaptionChange;
	void __fastcall SetFont(Graphics::TFont* Value);
	
protected:
	virtual void __fastcall CreateName(void);
	virtual void __fastcall SetCaption(System::AnsiString Value);
	
public:
	__fastcall virtual TCaption(Classes::TPersistent* AOwner);
	__fastcall virtual ~TCaption(void);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	
__published:
	__property System::AnsiString Caption = {read=FCaption, write=SetCaption};
	__property Graphics::TFont* Font = {read=FFont, write=SetFont};
	__property Classes::TNotifyEvent OnCaptionChange = {read=FOnCaptionChange, write=FOnCaptionChange};
		
};

class DELPHICLASS TTitle;
class PASCALIMPLEMENTATION TTitle : public Titles::TCaption 
{
	typedef Titles::TCaption inherited;
	
private:
	TDirection FDirection;
	TOrientation FOrientation;
	Windows::TRect FEnvelope;
	System::AnsiString FUnits;
	System::AnsiString FFullCaption;
	void __fastcall SetDirection(TDirection Value);
	void __fastcall SetOrientation(TOrientation Value);
	void __fastcall SetEnvelope(const Windows::TRect &Value);
	void __fastcall SetUnits(System::AnsiString Value);
	
protected:
	DYNAMIC void __fastcall DoGeometry(Graphics::TCanvas* ACanvas, System::AnsiString TheText);
	virtual void __fastcall SetCaption(System::AnsiString Value);
	
public:
	__property Windows::TRect Envelope = {read=FEnvelope, write=SetEnvelope};
	__property System::AnsiString FullCaption = {read=FFullCaption};
	__fastcall virtual TTitle(Classes::TPersistent* AOwner);
	void __fastcall Draw(Graphics::TCanvas* ACanvas);
	virtual void __fastcall AssignTo(Classes::TPersistent* Dest);
	
__published:
	__property System::AnsiString Units = {read=FUnits, write=SetUnits};
	__property TDirection Direction = {read=FDirection, write=SetDirection, nodefault};
	__property TOrientation Orientation = {read=FOrientation, write=SetOrientation, nodefault};
public:
	/* TCaption.Destroy */ __fastcall virtual ~TTitle(void) { }
	
};

class DELPHICLASS TLegend;
class PASCALIMPLEMENTATION TLegend : public Titles::TCaption 
{
	typedef Titles::TCaption inherited;
	
private:
	int FCount;
	TDirection FDirection;
	int FFontHeight;
	int FStringWidth;
	int __fastcall GetSymbolWidth(void);
	void __fastcall SetDirection(TDirection Value);
	void __fastcall SetCount(int Value);
	void __fastcall SetFontHeight(int Value);
	void __fastcall SetStringWidth(int Value);
	void __fastcall DoSize(void);
	
public:
	__property int Count = {read=FCount, write=SetCount, nodefault};
	__property int StringWidth = {read=FStringWidth, write=SetStringWidth, nodefault};
	__property int SymbolWidth = {read=GetSymbolWidth, nodefault};
	int __fastcall GetHit(int iX, int iY, Windows::TRect &TheRect);
	
__published:
	__property TDirection Direction = {read=FDirection, write=SetDirection, nodefault};
	__property int FontHeight = {read=FFontHeight, write=SetFontHeight, nodefault};
public:
	/* TCaption.Create */ __fastcall virtual TLegend(Classes::TPersistent* AOwner) : Titles::TCaption(AOwner
		) { }
	/* TCaption.Destroy */ __fastcall virtual ~TLegend(void) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define STRING_DIV_SYMBOL (Byte)(3)

}	/* namespace Titles */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Titles;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Titles
