unit Plot_Reg;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: XXX.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@molsci.csiro.au.

Last Modified: 05/25/2000
Current Version: 1.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
Registration unit for the TPlot component.


Known Issues:
-----------------------------------------------------------------------------}

{$I Plot.inc}

interface

uses
  Classes, DsgnIntf,

  Plot,
{$IFDEF COMPILER4_UP}
  PlotImageList,
{$ENDIF}
  PlotMenu;

procedure Register;

implementation


{$IFDEF DELPHI1}
{$R Plot16.dcr}
{$ELSE}
{$R Plot32.dcr}
{$ENDIF}

type
  TAboutProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TSeriesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

  TAxesProperty = class(TPropertyEditor)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue:string; override;
  end;

procedure Register;
begin
  RegisterComponents('Samples', [TPlot]);
  RegisterComponents('Samples', [TPlotMenu]);
{$IFDEF COMPILER4_UP}
  RegisterComponents('Samples', [TPlotImageList]);
{$ENDIF}
{register the "About" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'About', TAboutProperty);
{register the "Series" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'SeriesProperties', TSeriesProperty);
{register the "Axes" property editor}
  RegisterPropertyEditor(TypeInfo(String), TPlot, 'AxesProperties', TAxesProperty);
end;

{About bits and pieces:------------------------------------------------------}
procedure TAboutProperty.Edit;
{call the "About" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowAbout;
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(About...)';
end;

{End About bits and pieces:--------------------------------------------------}

{Series bits and pieces:------------------------------------------------------}
procedure TSeriesProperty.Edit;
{call the "Series" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowSeries;
end;

function TSeriesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TSeriesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Series...)';
end;

{End Series bits and pieces:--------------------------------------------------}

{Axes bits and pieces:------------------------------------------------------}
procedure TAxesProperty.Edit;
{call the "Axes" dialog window when clicking on ... in the Object Inspector}
begin
  TPlot(GetComponent(0)).ShowAxes;
end;

function TAxesProperty.GetAttributes: TPropertyAttributes;
{set up to display a string in the Object Inspector}
begin
  GetAttributes := [paDialog, paReadOnly];
end;

function TAxesProperty.GetValue: String;
{set string to appear in the Object Inspector}
begin
  GetValue := '(Axes...)';
end;

{End Axes bits and pieces:--------------------------------------------------}

end.
