unit PlotImageList;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Plot.PAS, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@molsci.csiro.au.

Last Modified: 09/18/2000
Current Version: 1.10

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind.

Known Issues:
        - while TImageList exists from Delphi 2 onwards, TMenu and TPopupMenu
          do not have an Images property until Delphi 4, and so this unit is
          not needed until Delphi 4. 

-----------------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs{, ImgList};

const
  TPLOTIMAGELIST_VERSION = 110;

  IMAGE_BASE = 5000;

  NO_IMAGES = 48;

type
  TPlotImageList = class(TImageList)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    Constructor Create(AOwner: TComponent); override;
  published
    { Published declarations }
  end;

implementation
{$R images32.res}

Constructor TPlotImageList.Create(AOwner: TComponent); 
var
  i: Integer;
  TheBitmap: TBitmap;
begin
  inherited Create(AOwner);

  Height := 16;
  Width := 16;
  AllocBy := 9;
  TheBitmap := TBitmap.Create;

  for i := 1 to NO_IMAGES do
  begin
    TheBitmap.LoadFromResourceID(HInstance, IMAGE_BASE + i);
    AddMasked(TheBitmap, clOlive);
  end;
  TheBitmap.Free;
end;

end.
