unit PlotAction;

interface

uses
  Classes, Dialogs, ExtDlgs, ActnList, Plot;

type

  { Generic TPlot action }
  TPlotAction = class(TAction)
  private
    FPlot: TPlot;
    procedure SetPlot(Value: TPlot);
  protected
    function GetPlot(Target: TObject): TPlot; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    function HandlesTarget(Target: TObject):Boolean; override;
  published
    property Plot: TPlot read FPlot write SetPlot;
  end;

  TPlotActionList = class(TActionList)
  private
    FPlot: TPlot;
    procedure SetPlot(Value: TPlot);
  protected
    function GetPlot(Target: TObject): TPlot; virtual;
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CreateActions;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Plot: TPlot read FPlot write SetPlot;
  end;

implementation

{ Check target object is a Plot }
function TPlotAction.GetPlot(Target: TObject): TPlot;
begin
  Result := Target as TPlot;
end;

{ Set the Plot component to affect }
procedure TPlotAction.SetPlot(Value: TPlot);
begin
  if Value <> FPlot then
  begin
    FPlot := Value;
    if Value <> nil then
      Value.FreeNotification(Self);
  end;
end;

{ Determine whether we can act on this target }
function TPlotAction.HandlesTarget(Target: TObject): Boolean;
begin
  Result := ((Plot <> nil) and (Target = Plot)) or
    ((Plot = nil) and (Target is TPlot));
end;

{ Note deletion of attached Plot component }
procedure TPlotAction.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = Plot) then
    Plot := nil;
end;

{******************************************************************************}
constructor TPlotActionList.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FPlot := nil;
end;

destructor TPlotActionList.Destroy;
begin
  inherited Destroy;
end;

{ Check target object is a Plot }
function TPlotActionList.GetPlot(Target: TObject): TPlot;
begin
  Result := Target as TPlot;
end;

{ Set the Plot component to affect }
procedure TPlotActionList.SetPlot(Value: TPlot);
begin
  if Value <> FPlot then
  begin
    if (Value = nil) then
    begin
      FPlot.SetPlotMenu(TMainMenu(nil));
      FPlot := Value;
    end
    else
    begin
      FPlot := Value;
{$IFDEF DELPHI1}
      Value.Notification(Self, opInsert); {???}
{$ELSE}
      Value.FreeNotification(Self);
{$ENDIF}
      {CreateActions;
      SetUpOnClicks;
      CreateReopenSubMenu;
      FPlot.SetPlotMenu(TMainMenu(Self));}
    end;
  end;
end;

{ Note deletion of attached Plot component }
procedure TPlotActionList.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation = opRemove) and (AComponent = Plot) then
    Plot := nil;
end;

{------------------------------------------------------------------------------
    Procedure: TCustomPlot.CreateActions
  Description: creates popup menus that are accessible by right-click
       Author: Mat Ballard
 Date created: 12/1/1999
Date modified: 04/20/2000 by Mat Ballard
      Purpose: modularize user-interface code
 Known Issues: this was a bitch to get right !
 ------------------------------------------------------------------------------}
procedure TPlotActionList.CreateActions;
var
  i, j: Word;
{This following is just a dummy matrix of menu items used to create sub-menus,
 then removed and the menuitems freed.}
  TempAction: TPlotAction;
begin
{don't create menus when the Plot property is streamed in:}
  if (csLoading in ComponentState) then exit;

{who needs more than 32 menus ?!}
  if (FPlot.PlotPopupMenu.Items.Count > 32) then raise
    EComponentError.CreateFmt('TPlotMenu.CreateMenus: I cannot handle more than %d Sub-menus !',
      [FPlot.PlotPopupMenu.Items.Count]);

{create the sub-menu actions:}
  for i := 0 to FPlot.PlotPopupMenu.Items.Count-1 do
  begin
{we create a temporary action}
    TempAction := TPlotAction.Create(Self);
    TempAction.Caption := FPlot.PlotPopupMenu.Items[i].Caption;
    TempAction.Name := FPlot.PlotPopupMenu.Items[i].Name + 'Action';
    Self.CreateAction
{don't re-create a menu if it already exists:
    if (not MenuExists(FPlot.PlotPopupMenu.Items[i])) then
    begin
      TempMenuItem := NewSubMenu(
        FPlot.PlotPopupMenu.Items[i].Caption,
        0,
        FPlot.PlotPopupMenu.Items[i].Name,
        TempMenu[i]);
      TempMenuItem.Tag := FPlot.PlotPopupMenu.Items[i].Tag;
      Self.Items.Add(TempMenuItem);
    end;}

{create the menus in each sub-menu:}
    for j := 0 to FPlot.PlotPopupMenu.Items[i].Count-1 do
    begin
      if (not MenuExists(FPlot.PlotPopupMenu.Items[i].Items[j])) then
      begin
        TempMenuItem := TMenuItem.Create(Self);
        TempMenuItem.Caption := FPlot.PlotPopupMenu.Items[i].Items[j].Caption;
        TempMenuItem.Name := FPlot.PlotPopupMenu.Items[i].Items[j].Name;
        TempMenuItem.Tag := FPlot.PlotPopupMenu.Items[i].Items[j].Tag;
        TempMenuItem.Hint := FPlot.PlotPopupMenu.Items[i].Items[j].Hint;
{$IFDEF COMPILER4_UP}
        TempMenuItem.ImageIndex := FPlot.PlotPopupMenu.Items[i].Items[j].ImageIndex;
{$ENDIF}
{add the TempMenuItem to the popup:}
        Self.Items[i].Add(TempMenuItem);
      end;
    end; {j over menu items}
{remove the temporary menu array used to create the submenu:}
    if (Self.Items[i].Items[0].Caption = '') then
    begin
      Self.Items[i].Remove(TempMenu[i][0]);
{then free it:}
      TempMenu[i][0].Free;
    end;
  end; {i over submenus}

{Add a divider to the File menu:}
  TempMenuItem := TMenuItem.Create(Self);
  TempMenuItem.Caption := '-';
  TempMenuItem.Tag := 1098;
  if (MenuExists(TempMenuItem)) then
    TempMenuItem.Free
   else
    Self.Items[0].Add(TempMenuItem);
{Add an "Exit" to the File menu:}
  TempMenuItem := TMenuItem.Create(Self);
  TempMenuItem.Caption := 'E&xit';
  TempMenuItem.Tag := EXIT_TAG;
  TempMenuItem.Name := 'ExitMenuItem';
  if (MenuExists(TempMenuItem)) then
    TempMenuItem.Free
   else
    Self.Items[0].Add(TempMenuItem);
end;

end.
