// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'Plot.pas' rev: 3.00

#ifndef PlotHPP
#define PlotHPP
#include <Zoom.hpp>
#include <Titles.hpp>
#include <pSeries.hpp>
#include <PropEdit.hpp>
#include <Misc.hpp>
#include <SerEdit.hpp>
#include <SerList.hpp>
#include <Parser.hpp>
#include <AxisEdit.hpp>
#include <Axis.hpp>
#include <OptnsDlg.hpp>
#include <Windows.hpp>
#include <SysUtils.hpp>
#include <StdCtrls.hpp>
#include <Printers.hpp>
#include <Messages.hpp>
#include <Menus.hpp>
#include <Graphics.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>
#include <Controls.hpp>
#include <Clipbrd.hpp>
#include <Classes.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Plot
{
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TOnFileEvent)(System::TObject* Sender, System::AnsiString TheFile
	);

typedef void __fastcall (__closure *TOnHeaderEvent)(System::TObject* Sender, Classes::TMemoryStream* 
	TheStream);

typedef void __fastcall (__closure *TOnRequestHeaderEvent)(System::TObject* Sender, Classes::TMemoryStream* 
	TheStream);

typedef void __fastcall (__closure *TOnRequestHTMLHeaderEvent)(System::TObject* Sender, Classes::TStringList* 
	Header);

typedef void __fastcall (__closure *TOnSelectionEvent)(System::TObject* Sender, const Windows::TRect 
	&Sel);

typedef void __fastcall (__closure *TOnDualSelectionEvent)(System::TObject* Sender, const Windows::TRect 
	&Sel1, const Windows::TRect &Sel2);

enum TScreenJob { sjNone, sjDrag, sjHide, sjZoomIn, sjEditAxis, sjEditFont, sjEditPoint, sjEditSeries, 
	sjFlashEdit, sjCopySeries, sjDisplace, sjCloneSeries, sjDeleteSeries, sjPosition, sjNearestPoint, sjAverage, 
	sjContractSeries, sjSplineSeries, sjHighs, sjLows, sjMovingAverage, sjSmoothSeries, sjSortSeries, sjDifferentiate, 
	sjIntegrate, sjIntegral, sjLineOfBestFit, sjDualLineBestFit1, sjDualLineBestFit2, sjSelection, sjDualSelection1, 
	sjDualSelection2 };

enum TObjectType { soNone, soTitle, soLegend, soResult, soXAxis, soXAxisTitle, soXAxisLabel, soYAxis, 
	soYAxisTitle, soYAxisLabel, soLeftBorder, soTopBorder, soRightBorder, soBottomBorder, soSeries };

enum TDisplayMode { dmNormal, dmNone, dmRun, dmHistory };

typedef Menus::TMenuItem* TMenuArray[128];

typedef TMenuArray *pMenuArray;

enum TPlotType { ptXY, ptMultiple, ptColumn };

enum TMainMenus { mnuFile, mnuEdit, mnuView, mnuCalc };

typedef Set<TMainMenus, mnuFile, mnuCalc>  TMainOptions;

enum TFileMenus { mnuNew, mnuOpen, mnuOverlayDiv, mnuOverlay, mnuClearOverlays, mnuSaveDiv, mnuSave, 
	mnuSaveAs, mnuSaveImage, mnuPrintDiv, mnuPrint };

typedef Set<TFileMenus, mnuNew, mnuPrint>  TFileOptions;

enum TEditMenus { mnuCopy, mnuCopyHTML, mnuCopySeries, mnuPaste, mnuDisplaceDiv, mnuDisplace, mnuResetDisplacement, 
	mnuEditSeriesDiv, mnuNewSeries, mnuCloneSeries, mnuEditPoint, mnuEditSeries, mnuDeleteSeries, mnuAxisDiv, 
	mnuNewY2Axis, mnuEditAxis, mnuDeleteY2Axis, mnuEditFontDiv, mnuEditFont, mnuEditPropertiesDiv, mnuEditProperties 
	};

typedef Set<TEditMenus, mnuCopy, mnuEditProperties>  TEditOptions;

enum TViewMenus { mnuHide, mnuShowAll, mnuDisplayModeDiv, mnuDisplayMode, mnuLegend, mnuZoomDiv, mnuSetAsNormal, 
	mnuNormalView, mnuManualZoom, mnuZoomIn, mnuZoomOut };

typedef Set<TViewMenus, mnuHide, mnuZoomOut>  TViewOptions;

enum TCalcMenus { mnuPosition, mnuNearestPoint, mnuCalcAverageDiv, mnuCalcAverage, mnuContractSeries, 
	mnuContractAllSeries, mnuCubicSplineSeries, mnuHighs, mnuMovingAverage, mnuSmoothSeries, mnuSortSeries, 
	mnuCalculusDiv, mnuDifferentiate, mnuIntegrate, mnuIntegral, mnuLineOfBestFitDiv, mnuLineOfBestFit, 
	mnuTwoRegionLineOfBestFit };

typedef Set<TCalcMenus, mnuPosition, mnuTwoRegionLineOfBestFit>  TCalcOptions;

enum TModeMenus { mnuNormal, mnuNone, mnuRun, mnuHistory };

enum TSaveOption { soAsText, soProperties };

typedef Set<TSaveOption, soAsText, soProperties>  TSaveOptions;

class DELPHICLASS TPopupOptions;
class PASCALIMPLEMENTATION TPopupOptions : public Classes::TPersistent 
{
	typedef Classes::TPersistent inherited;
	
private:
	TMainOptions FMenu;
	TFileOptions FFile;
	TEditOptions FEdit;
	TViewOptions FView;
	TCalcOptions FCalc;
	
public:
	__fastcall TPopupOptions(void);
	
__published:
	__property TMainOptions Menu = {read=FMenu, write=FMenu, nodefault};
	__property TFileOptions File_ = {read=FFile, write=FFile, nodefault};
	__property TEditOptions Edit = {read=FEdit, write=FEdit, nodefault};
	__property TViewOptions View = {read=FView, write=FView, nodefault};
	__property TCalcOptions Calc = {read=FCalc, write=FCalc, nodefault};
public:
	/* TPersistent.Destroy */ __fastcall virtual ~TPopupOptions(void) { }
	
};

typedef System::AnsiString Plot__3[4];

class DELPHICLASS TCustomPlot;
class PASCALIMPLEMENTATION TCustomPlot : public Extctrls::TCustomPanel 
{
	typedef Extctrls::TCustomPanel inherited;
	
private:
	System::AnsiString FAbout;
	System::AnsiString FAxesProperties;
	Classes::TList* FAxisList;
	Titles::TBorder* FBorder;
	Classes::TStringList* FInstructions;
	System::AnsiString FCreatedBy;
	System::AnsiString FDescription;
	TDisplayMode FDisplayMode;
	float FDisplayHistory;
	bool FEditable;
	System::AnsiString FDefaultExtension;
	System::AnsiString FFileName;
	System::AnsiString OpenDriveDir;
	System::AnsiString OverlayDriveDir;
	System::AnsiString ImageDriveDir;
	System::AnsiString PropsFileName;
	int OpenFilterIndex;
	int SaveFilterIndex;
	int ImageFilterIndex;
	Graphics::TFont* FHighFont;
	int FMenuTag;
	bool FMovable;
	Byte FMultiplicity;
	int FOutlineWidth;
	Graphics::TPen* FMultiplePen;
	Menus::TMainMenu* FPlotMenu;
	TPlotType FPlotType;
	TPopupOptions* FPopupOptions;
	TPrinterOrientation FPrintOrientation;
	TSaveOptions FSaveOptions;
	bool FAsText;
	System::AnsiString FSeriesProperties;
	Serlist::TSeriesList* FSeriesList;
	Axis::TAxis* FXAxis;
	Axis::TAxis* FYAxis;
	TOnFileEvent FOnFileOpen;
	TOnFileEvent FOnFileClose;
	TOnHeaderEvent FOnHeader;
	TOnRequestHeaderEvent FOnHeaderRequest;
	TOnRequestHTMLHeaderEvent FOnHTMLHeaderRequest;
	TOnSelectionEvent FOnSelection;
	TOnDualSelectionEvent FOnDualSelection;
	Titles::TTitle* FTitle;
	Titles::TCaption* FResult;
	Titles::TLegend* FLegend;
	Titles::TRectangle* LeftBorder;
	Titles::TRectangle* TopBorder;
	Titles::TRectangle* RightBorder;
	Titles::TRectangle* BottomBorder;
	bool IgnoreChanges;
	TScreenJob FScreenJob;
	Classes::TList* ScreenObjectList;
	Extctrls::TTimer* MouseTimer;
	tagPOINT MouseStart;
	TObjectType ClickedObjectType;
	void *pClickedObject;
	TObjectType SecondClickedObjectType;
	void *pSecondClickedObject;
	tagPOINT ClickedObjectOffset;
	float Slope;
	float Intercept;
	Titles::TRectangle* Selection;
	Windows::TRect Sel1;
	Windows::TRect Sel2;
	Menus::TPopupMenu* FPlotPopUpMenu;
	Menus::TPopupMenu* WhichPopUpMenu;
	Menus::TMenuItem* WhichPopUpItems[2];
	Stdctrls::TEdit* FFlashEdit;
	int TheSeries;
	Pseries::TSeries* pSeries;
	int ThePointNumber;
	int TheAxis;
	Axis::TAxis* pAxis;
	int ClipBoardFormatForHTML;
	int FirstOverlay;
	int BevelGap;
	System::AnsiString FileExtensions[4];
	System::AnsiString FileTypes;
	int __fastcall GetClickAndDragDelay(void);
	int __fastcall GetNoYAxes(void);
	Pseries::TSeries* __fastcall GetSeries(int Index);
	bool __fastcall GetSeriesFromUser(void);
	bool __fastcall GetAxisFromUser(Word StartAxis);
	int __fastcall GetFilterIndex(System::AnsiString Ext);
	void __fastcall SetAxisDimensions(void);
	void __fastcall SetDisplayModeHistory(float HistoryValue, TDisplayMode ScalingValue);
	void __fastcall SetMetafileDescription(void);
	void __fastcall GetTheClickedObject(int X, int Y);
	void __fastcall MouseTimeOut(System::TObject* Sender);
	void __fastcall MoveTheClickedObjectTo(int X, int Y);
	void __fastcall OutlineTheClickedObject(void);
	void __fastcall OutlineTheSelection(void);
	void __fastcall SetResult(float Slope, float Intercept, float Rsq);
	void __fastcall StretchTheClickedObjectTo(int X, int Y);
	void __fastcall SwapEnds(void);
	void __fastcall MoveTheClickedObjectClick(System::TObject* Sender);
	void __fastcall MoveSecondClickedObjectClick(System::TObject* Sender);
	void __fastcall CreateFlashEditor(void);
	void __fastcall FlashEditKeyDown(System::TObject* Sender, Word &Key, Classes::TShiftState Shift);
	void __fastcall FlashEditExit(System::TObject* Sender);
	MESSAGE void __fastcall WMUser(Messages::TMessage &Message);
	
protected:
	void __fastcall SetDefaultExtension(System::AnsiString Value);
	void __fastcall SetDisplayMode(TDisplayMode Value);
	void __fastcall SetHistory(float Value);
	void __fastcall SetFileName(System::AnsiString Value);
	void __fastcall SetNoYAxes(int Value);
	void __fastcall SetPlotType(TPlotType Value);
	void __fastcall SetOutlineWidth(int Value);
	void __fastcall SetMultiplicity(Byte Value);
	void __fastcall SetMultiplePen(Graphics::TPen* Value);
	void __fastcall SetClickAndDragDelay(int Value);
	void __fastcall SetOnSelection(TOnSelectionEvent Value);
	void __fastcall SetOnDualSelection(TOnDualSelectionEvent Value);
	void __fastcall StyleChange(System::TObject* Sender);
	virtual void __fastcall CopyText(void);
	virtual void __fastcall CopyHTML(Word Format);
	virtual void __fastcall CopyBitmap(void);
	virtual void __fastcall CopyWMF(bool Enhanced);
	void __fastcall CreateMenus(void);
	DYNAMIC void __fastcall DoFileClose(System::AnsiString AFileName);
	DYNAMIC void __fastcall DoFileOpen(System::AnsiString AFileName);
	DYNAMIC void __fastcall DoHeader(Classes::TMemoryStream* TheStream);
	DYNAMIC void __fastcall DoHeaderRequest(Classes::TMemoryStream* TheStream);
	DYNAMIC void __fastcall DoHTMLHeaderRequest(Classes::TStringList* TheHeader);
	DYNAMIC void __fastcall DoSelection(const Windows::TRect &Sel1);
	DYNAMIC void __fastcall DoDualSelection(const Windows::TRect &Sel1, const Windows::TRect &Sel2);
	void __fastcall OpenProperties(System::AnsiString AFileName);
	void __fastcall SaveTheProperties(System::AnsiString AFileName);
	virtual void __fastcall SaveAsBitmap(System::AnsiString AFileName);
	virtual void __fastcall SaveAsWMF(System::AnsiString AFileName, bool Enhanced);
	void __fastcall ParseData(Classes::TStringList* TheData);
	void __fastcall ConvertTextData(int ColCount, int SeriesCount, int FirstLine, System::AnsiString Delimiter
		, Classes::TStringList* TheData, Parser::pSeriesInfoArray SeriesInfo);
	void __fastcall ConvertBinaryData(int ColCount, int SeriesCount, Classes::TMemoryStream* TheStream, 
		Parser::pSeriesInfoArray SeriesInfo);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	virtual void __fastcall ProcessClickedObject(void * pObject, TObjectType TheObjectType);
	virtual void __fastcall Draw(Graphics::TCanvas* ACanvas);
	void __fastcall DrawLegend(Graphics::TCanvas* ACanvas);
	virtual void __fastcall Paint(void);
	void __fastcall DrawInstructions(void);
	DYNAMIC void __fastcall Resize(void);
	DYNAMIC void __fastcall ZeroScreenStuff(void);
	void __fastcall DetermineMenuVisibility(void);
	void __fastcall SetSeriesVisibility(bool Value);
	void __fastcall SetSeriesEnabledness(Menus::TMenu* TheMenu);
	__property System::AnsiString About = {read=FAbout, write=FAbout, stored=false};
	__property System::AnsiString AxesProperties = {read=FAxesProperties, write=FAxesProperties, stored=false
		};
	__property Titles::TBorder* Border = {read=FBorder, write=FBorder};
	__property Classes::TStringList* Instructions = {read=FInstructions, write=FInstructions};
	__property int ClickAndDragDelay = {read=GetClickAndDragDelay, write=SetClickAndDragDelay, nodefault
		};
	__property System::AnsiString CreatedBy = {read=FCreatedBy, write=FCreatedBy};
	__property System::AnsiString Description = {read=FDescription, write=FDescription};
	__property float DisplayHistory = {read=FDisplayHistory, write=SetHistory};
	__property TDisplayMode DisplayMode = {read=FDisplayMode, write=SetDisplayMode, nodefault};
	__property bool Editable = {read=FEditable, write=FEditable, nodefault};
	__property System::AnsiString DefaultExtension = {read=FDefaultExtension, write=SetDefaultExtension
		};
	__property System::AnsiString FileName = {read=FFileName, write=SetFileName, stored=false};
	__property Graphics::TFont* HighFont = {read=FHighFont, write=FHighFont};
	__property Titles::TLegend* Legend = {read=FLegend, write=FLegend};
	__property Graphics::TPen* MultiplePen = {read=FMultiplePen, write=SetMultiplePen};
	__property TPlotType PlotType = {read=FPlotType, write=SetPlotType, nodefault};
	__property TPopupOptions* PopupOptions = {read=FPopupOptions, write=FPopupOptions};
	__property bool Movable = {read=FMovable, write=FMovable, nodefault};
	__property Byte Multiplicity = {read=FMultiplicity, write=SetMultiplicity, nodefault};
	__property int NoYAxes = {read=GetNoYAxes, write=SetNoYAxes, nodefault};
	__property Printers::TPrinterOrientation PrintOrientation = {read=FPrintOrientation, write=FPrintOrientation
		, nodefault};
	__property int OutlineWidth = {read=FOutlineWidth, write=SetOutlineWidth, nodefault};
	__property TSaveOptions SaveOptions = {read=FSaveOptions, write=FSaveOptions, nodefault};
	__property System::AnsiString SeriesProperties = {read=FSeriesProperties, write=FSeriesProperties, 
		stored=false};
	__property Titles::TTitle* Title = {read=FTitle, write=FTitle};
	__property Axis::TAxis* XAxis = {read=FXAxis, write=FXAxis};
	__property Axis::TAxis* YAxis = {read=FYAxis, write=FYAxis};
	__property TOnFileEvent OnFileOpen = {read=FOnFileOpen, write=FOnFileOpen};
	__property TOnFileEvent OnFileClose = {read=FOnFileClose, write=FOnFileClose};
	__property TOnHeaderEvent OnHeader = {read=FOnHeader, write=FOnHeader};
	__property TOnRequestHeaderEvent OnHeaderRequest = {read=FOnHeaderRequest, write=FOnHeaderRequest};
		
	__property TOnRequestHTMLHeaderEvent OnHTMLHeaderRequest = {read=FOnHTMLHeaderRequest, write=FOnHTMLHeaderRequest
		};
	__property TOnSelectionEvent OnSelection = {read=FOnSelection, write=SetOnSelection};
	__property TOnDualSelectionEvent OnDualSelection = {read=FOnDualSelection, write=SetOnDualSelection
		};
	
public:
	__property Menus::TPopupMenu* PlotPopUpMenu = {read=FPlotPopUpMenu};
	__property Pseries::TSeries* Series[int Index] = {read=GetSeries/*, default*/};
	__property Serlist::TSeriesList* SeriesList = {read=FSeriesList, stored=false};
	__property TScreenJob ScreenJob = {read=FScreenJob, write=FScreenJob, stored=false, nodefault};
	__fastcall virtual TCustomPlot(Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomPlot(void);
	System::AnsiString __fastcall GetFileExtension();
	System::AnsiString __fastcall GetFileDriveDir();
	System::AnsiString __fastcall GetFileRoot();
	void __fastcall ShowAbout(void);
	void __fastcall ShowSeries(void);
	void __fastcall ShowAxes(void);
	int __fastcall Add(int XSeriesIndex);
	int __fastcall AddExternal(Misc::pSingleArray XPointer, Misc::pSingleArray YPointer, int NumberOfPoints
		);
	int __fastcall AddInternal(Misc::pSingleArray XPointer, Misc::pSingleArray YPointer, int NumberOfPoints
		);
	int __fastcall CloneSeries(int TheSeries);
	void __fastcall DeleteSeries(int Index);
	void __fastcall DetermineMenuEnabledness(Menus::TMenu* TheMenu);
	void __fastcall AddSlice(int NoPoints, Misc::pXYArray XYArray);
	void __fastcall Trace(void);
	void __fastcall CopyClick(System::TObject* Sender);
	void __fastcall HideClick(System::TObject* Sender);
	void __fastcall PrintClick(System::TObject* Sender);
	void __fastcall ShowAllClick(System::TObject* Sender);
	void __fastcall PositionClick(System::TObject* Sender);
	void __fastcall NearestPointClick(System::TObject* Sender);
	void __fastcall DeleteSeriesClick(System::TObject* Sender);
	void __fastcall CopySeriesClick(System::TObject* Sender);
	void __fastcall CloneSeriesClick(System::TObject* Sender);
	void __fastcall ModeClick(System::TObject* Sender);
	void __fastcall PasteClick(System::TObject* Sender);
	void __fastcall LineBestFitClick(System::TObject* Sender);
	void __fastcall TwoRegionLineBestFitClick(System::TObject* Sender);
	void __fastcall SmoothSeriesClick(System::TObject* Sender);
	void __fastcall ContractSeriesClick(System::TObject* Sender);
	void __fastcall ContractAllSeriesClick(System::TObject* Sender);
	void __fastcall LegendClick(System::TObject* Sender);
	void __fastcall EditAxisClick(System::TObject* Sender);
	void __fastcall EditFontClick(System::TObject* Sender);
	void __fastcall EditPointClick(System::TObject* Sender);
	void __fastcall EditSeriesClick(System::TObject* Sender);
	void __fastcall ResetDisplacementClick(System::TObject* Sender);
	void __fastcall PropertiesClick(System::TObject* Sender);
	void __fastcall NewClick(System::TObject* Sender);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	void __fastcall OpenClick(System::TObject* Sender);
	void __fastcall OpenFile(System::AnsiString TheFile);
	void __fastcall ClearOverlaysClick(System::TObject* Sender);
	void __fastcall OverlayClick(System::TObject* Sender);
	void __fastcall SaveImageClick(System::TObject* Sender);
	void __fastcall SaveClick(System::TObject* Sender);
	void __fastcall SaveAsClick(System::TObject* Sender);
	virtual void __fastcall LoadFromFile(System::AnsiString AFileName);
	void __fastcall AppendToFile(void);
	virtual void __fastcall SaveToFile(System::AnsiString AFileName, bool FAsText);
	void __fastcall SetAsNormalClick(System::TObject* Sender);
	void __fastcall NormalViewClick(System::TObject* Sender);
	void __fastcall ManualZoomClick(System::TObject* Sender);
	void __fastcall ZoomOutClick(System::TObject* Sender);
	void __fastcall MakeDummyData(int NoSteps);
	void __fastcall CopyHTMLClick(System::TObject* Sender);
	void __fastcall DisplaceClick(System::TObject* Sender);
	void __fastcall DifferentiateClick(System::TObject* Sender);
	void __fastcall HandleClick(System::TObject* Sender, int TheTag);
	bool __fastcall GetIndicesFromTag(int TheTag, int &i, int &j);
	void __fastcall IntegrateClick(System::TObject* Sender);
	void __fastcall IntegralClick(System::TObject* Sender);
	void __fastcall SortClick(System::TObject* Sender);
	void __fastcall SplineClick(System::TObject* Sender);
	int __fastcall Spline(int ASeries);
	void __fastcall ZoomInClick(System::TObject* Sender);
	void __fastcall HighsClick(System::TObject* Sender);
	void __fastcall MovingAverageClick(System::TObject* Sender);
	void __fastcall AverageClick(System::TObject* Sender);
	void __fastcall AddAxisClick(System::TObject* Sender);
	void __fastcall DeleteAxis(int Index, bool Confirm);
	void __fastcall DeleteAxisClick(System::TObject* Sender);
	void __fastcall SetPlotMenu(Menus::TMainMenu* Value);
	void __fastcall Clear(bool Cancellable);
public:
	/* TWinControl.CreateParented */ __fastcall TCustomPlot(HWND ParentWindow) : Extctrls::TCustomPanel(
		ParentWindow) { }
	
};

class DELPHICLASS TPlot;
class PASCALIMPLEMENTATION TPlot : public Plot::TCustomPlot 
{
	typedef Plot::TCustomPlot inherited;
	
__published:
	__property About ;
	__property AxesProperties ;
	__property Border ;
	__property ClickAndDragDelay ;
	__property CreatedBy ;
	__property Description ;
	__property DisplayHistory ;
	__property DisplayMode ;
	__property DefaultExtension ;
	__property Editable ;
	__property FileName ;
	__property HighFont ;
	__property Instructions ;
	__property Legend ;
	__property Movable ;
	__property Multiplicity ;
	__property MultiplePen ;
	__property NoYAxes ;
	__property OutlineWidth ;
	__property PlotType ;
	__property PopupOptions ;
	__property PrintOrientation ;
	__property SaveOptions ;
	__property SeriesProperties ;
	__property Title ;
	__property XAxis ;
	__property YAxis ;
	__property OnFileOpen ;
	__property OnFileClose ;
	__property OnHeader ;
	__property OnHeaderRequest ;
	__property OnHTMLHeaderRequest ;
	__property OnSelection ;
	__property OnDualSelection ;
	__property Align ;
	__property BevelInner ;
	__property BevelOuter ;
	__property BevelWidth ;
	__property BorderWidth ;
	__property BorderStyle ;
	__property Color ;
	__property Ctl3D ;
	__property DragCursor ;
	__property DragMode ;
	__property Enabled ;
	__property Font ;
	__property Locked ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property ShowHint ;
	__property TabOrder ;
	__property TabStop ;
	__property Visible ;
	__property OnClick ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnResize ;
	__property FullRepaint ;
	__property OnStartDrag ;
public:
	/* TCustomPlot.Create */ __fastcall virtual TPlot(Classes::TComponent* AOwner) : Plot::TCustomPlot(
		AOwner) { }
	/* TCustomPlot.Destroy */ __fastcall virtual ~TPlot(void) { }
	
public:
	/* TWinControl.CreateParented */ __fastcall TPlot(HWND ParentWindow) : Plot::TCustomPlot(ParentWindow
		) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define TPLOT_VERSION (Byte)(110)
#define SUBHEADER "Subheader"
#define FILE_FORMAT_VERSION (Byte)(100)
#define MAX_FILE_VERSION (Byte)(100)
#define DEF_EXTENSION "plot"
#define PROP_EXTENSION "props"
#define FROM_FLASH_EDIT (Byte)(37)
#define FREE_FLASH_EDIT (Byte)(39)
#define TAG_BASE (Word)(1000)
#define CAPTION_BASE (Word)(3000)
#define HINT_BASE (Word)(4000)
#define crScope (Byte)(1)
#define crX (Byte)(2)
extern PACKAGE System::AnsiString ImageExtensions[5];
#define PICTURE_TYPES "Metafile (picture)|*.wmf|Enhanced Metafile (picture)|*.emf"\
	"|Bitmap|*.bmp"
extern PACKAGE System::ResourceString _CompanyName;
#define Plot_CompanyName System::LoadResourceString(&Plot::_CompanyName)
extern PACKAGE System::ResourceString _ProductName;
#define Plot_ProductName System::LoadResourceString(&Plot::_ProductName)
extern PACKAGE System::ResourceString _Version;
#define Plot_Version System::LoadResourceString(&Plot::_Version)
extern PACKAGE System::ResourceString _Copyright;
#define Plot_Copyright System::LoadResourceString(&Plot::_Copyright)

}	/* namespace Plot */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Plot;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// Plot
