unit PropEdit;

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: PropEdit.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@molsci.csiro.au.

Last Modified: 10/10/2000
Current Version: 1.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To edit various TPlot properties not covered by other dialogs..

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,

{These are the D1 units, aliased to Windows:}
{$IFDEF WIN}
  WinTypes, WinProcs,
{$ENDIF}
{$IFDEF WIN32}
  ComCtrls,
{$ENDIF}

  Axis, Misc, ShapeEx, ExtCtrls;

type
  TPlotPropertyEditorForm = class(TForm)
    HelpBitBtn: TBitBtn;
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    MultiplicityEdit: TEdit;
    Panel1: TPanel;
    UpShapeEx: TShapeEx;
    DownShapeEx: TShapeEx;
    PlotTypeComboBox: TComboBox;
    Label1: TLabel;
    MultiplicityLabel: TLabel;
    Label3: TLabel;
    BackColorComboBox: TComboBox;
    CreatedByEdit: TEdit;
    DescriptionEdit: TEdit;
    Label4: TLabel;
    Label5: TLabel;
    PenGroupBox: TGroupBox;
    PenColorLabel: TLabel;
    PenWidthLabel: TLabel;
    PenStyleLabel: TLabel;
    PenColorComboBox: TComboBox;
    PenWidthComboBox: TComboBox;
    PenStyleComboBox: TComboBox;

    procedure IntEditKeyPress(Sender: TObject; var Key: Char);
    procedure FloatEditKeyPress(Sender: TObject; var Key: Char);
    procedure FormCreate(Sender: TObject);
    procedure UpShapeExClick(Sender: TObject);
    procedure DownShapeExClick(Sender: TObject);
    procedure MultiplicityEditChange(Sender: TObject);
    procedure PlotTypeComboBoxChange(Sender: TObject);

  private

  public

  end;

var
  PlotPropertyEditorForm: TPlotPropertyEditorForm;

implementation

{$R *.DFM}

uses
  pSeries;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.FormCreate(Sender: TObject);
var
  i: TColor;
begin
  for i := 0 to MY_COLORS_MAX do
  begin
    BackColorComboBox.Items.Add(MyColors[i].Name);
    PenColorComboBox.Items.Add(MyColors[i].Name);
  end;
  Left := 10;
  Top := 10;
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.IntEditKeyPress
  Description: allows only integer keys to be pressed
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: restrict user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.IntEditKeyPress(Sender: TObject;
  var Key: Char);
begin
  if not (Key in [#8, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9']) then
    Key := Chr(0);
end;

{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.FloatEditKeyPress
  Description: allows only "real" keys to be pressed
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: restrict user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.FloatEditKeyPress(Sender: TObject;
  var Key: Char);
begin
  if not (Key in [#8, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '.', 'e']) then
    Key := Chr(0);
end;


{------------------------------------------------------------------------------
    Procedure: TPointEditorForm.CancelBitBtnClick
  Description: Standard Cancel button event handler
       Author: Mat Ballard
 Date created: 10/10/2000
Date modified: 10/10/2000 by Mat Ballard
      Purpose: Disables the DataGroupBox, and hence prevents checking of edit boxes for validity
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TPlotPropertyEditorForm.UpShapeExClick(Sender: TObject);
begin
  MultiplicityEdit.Tag := MultiplicityEdit.Tag + 1;
  MultiplicityEdit.Text := IntToStr(MultiplicityEdit.Tag);
end;

procedure TPlotPropertyEditorForm.DownShapeExClick(Sender: TObject);
begin
  MultiplicityEdit.Tag := MultiplicityEdit.Tag - 1;
  MultiplicityEdit.Text := IntToStr(MultiplicityEdit.Tag);
end;

procedure TPlotPropertyEditorForm.MultiplicityEditChange(Sender: TObject);
begin
  try
    MultiplicityEdit.Tag := StrToInt(MultiplicityEdit.Text);
  finally
  end;  
end;

procedure TPlotPropertyEditorForm.PlotTypeComboBoxChange(Sender: TObject);
begin
  MultiplicityEdit.Enabled := (PlotTypeComboBox.ItemIndex = 1);
  MultiplicityLabel.Enabled := MultiplicityEdit.Enabled;
  PenGroupBox.Enabled := MultiplicityEdit.Enabled;
  PenColorLabel.Enabled := MultiplicityEdit.Enabled;
  PenWidthLabel.Enabled := MultiplicityEdit.Enabled;
  PenStyleLabel.Enabled := MultiplicityEdit.Enabled;
end;

end.
