unit Normal1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, PlotImageList, Menus, PlotMenu, Plot, Grids, ExtCtrls, StdCtrls,
  NEdit, Buttons,

  pSeries;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    StringGrid1: TStringGrid;
    MinNEdit: TNEdit;
    Label1: TLabel;
    Label2: TLabel;
    MaxNEdit: TNEdit;
    Label3: TLabel;
    StepSizeNEdit: TNEdit;
    Label4: TLabel;
    MeanNEdit: TNEdit;
    Label5: TLabel;
    StdDevNEdit: TNEdit;
    GoBitBtn: TBitBtn;
    GoCrazyBitBtn: TBitBtn;
    CrazyTimer: TTimer;
    ClearAllBitBtn: TBitBtn;
    NoisyBitBtn: TBitBtn;
    TraceBitBtn: TBitBtn;
    Plot1: TPlot;
    PlotImageList1: TPlotImageList;
    TypeBitBtn: TBitBtn;
    PlotMenu1: TPlotMenu;
    procedure ClearAllBitBtnClick(Sender: TObject);
    procedure GoBitBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure PlotMenu1ExitMenuItemClick(Sender: TObject);
    procedure NoisyBitBtnClick(Sender: TObject);
    procedure GoCrazyBitBtnClick(Sender: TObject);
    procedure CrazyTimerTimer(Sender: TObject);
    procedure Plot1FileOpen(Sender: TObject; TheFile: String);
    procedure TraceBitBtnClick(Sender: TObject);
    procedure TypeBitBtnClick(Sender: TObject);
  private
    //Plot1: TPlot;
    //PlotMenu1: TPlotMenu;
    StartWidth,
    StartHeight: Integer;
    Angle,
    AngleInc: Single;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

const
  RADIUS = 50.0;

procedure TMainForm.ClearAllBitBtnClick(Sender: TObject);
var
  i: Integer;
begin
  Plot1.SeriesList.ClearSeries;
  for i := 1 to StringGrid1.ColCount-1 do
  begin
    StringGrid1.Cells[i, 0] := '';
    StringGrid1.Cells[i, 1] := '';
  end;
end;

procedure TMainForm.GoBitBtnClick(Sender: TObject);
var
  X, Y: Single;
  Mean: Single;
  StdDev: Single;
  Min: Single;
  Max: Single;
  StepSize: Single;
  TheSeries: Integer;
  TheScore: Single;
  i: Integer;
begin
  Plot1.Clear(False);
  Plot1.Add(-1);

  Mean := MeanNEdit.AsReal;
  StdDev := StdDevNEdit.AsReal;
  Min := MinNEdit.AsReal;
  Max := MaxNEdit.AsReal;
  StepSize := StepSizeNEdit.AsReal;

{Set the axes:}
  Plot1.XAxis.Max := Max;
  Plot1.XAxis.Min := Min;
  Plot1.YAxis.Min := 0;
  Plot1.XAxis.Intercept := 0;

  X := Min;
  while (X <= Max) do
  begin
    Y := Exp(-Sqr((X-Mean)/(2*StdDev))) /
      Sqrt(2*Pi*StdDev);
{Don't fire any events, and don't adjust axes:}
    Plot1[0].AddPoint(X, Y, FALSE, FALSE);
    X := X + StepSize;
  end;
  Plot1[0].Visible := TRUE;

  {Plot1.YAxis.Min := Plot1.Series[0].YMin;}
  Plot1.YAxis.Max := Plot1.Series[0].YMax;

  for i := 1 to StringGrid1.ColCount-1 do
  begin
    if (Length(StringGrid1.Cells[i, 0]) > 0) then
    begin
      if (Length(StringGrid1.Cells[i, 1]) > 0) then
      begin
        try
          TheScore := StrToFloat(StringGrid1.Cells[i, 1]);
          TheSeries := Plot1.Add(-1);
          Plot1[TheSeries].Name := StringGrid1.Cells[i, 0];
          Plot1[TheSeries].AddPoint(TheScore, Plot1.YAxis.Min, TRUE, TRUE);
          Plot1[TheSeries].AddPoint(TheScore, Plot1.YAxis.Max, TRUE, TRUE);
          Plot1[TheSeries].Visible := TRUE;
          Plot1[TheSeries].Symbol := TSymbol(i mod (1+Ord(sDownTriangle)));
        finally
        end;
      end;
    end;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var
  PlotImageList : TPlotImageList;
begin
  //Plot1 := TPlot.Create(Self);
  //Plot1.Parent := MainForm;
  Plot1.Align := alClient;
  //PlotMenu1.Plot := Plot1;
  //PlotMenu1.SetUpOnClicks;
  StringGrid1.Cells[0, 0] := 'Test:';
  StringGrid1.Cells[0, 1] := 'Score:';
  StringGrid1.ColWidths[0] := 60;
  //PlotImageList := TPlotImageList.Create(Self);
  //PlotImageList.Free;
  //GoBitBtnClick(Sender);
end;

procedure TMainForm.PlotMenu1ExitMenuItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.NoisyBitBtnClick(Sender: TObject);
begin
  Plot1.MakeDummyData(100);
end;

procedure TMainForm.GoCrazyBitBtnClick(Sender: TObject);
begin
  if (CrazyTimer.Enabled) then
  begin
    CrazyTimer.Enabled := FALSE;
    GoCrazyBitBtn.Caption := 'Go Crazy';
    TraceBitBtn.Enabled := TRUE;
  end
  else
  begin
    StartWidth := Width;
    StartHeight := Height;
    Angle := 0;
    AngleInc := 4 * Pi / 180;
    GoCrazyBitBtn.Caption := 'Enough !';
    CrazyTimer.Enabled := TRUE;
    TraceBitBtn.Enabled := FALSE;
  end;
end;

procedure TMainForm.CrazyTimerTimer(Sender: TObject);
begin
  Width := StartWidth + Round(RADIUS * Sin(Angle));
  Height := StartHeight + Round(RADIUS * Cos(Angle));
  Angle := Angle + AngleInc;
end;

procedure TMainForm.Plot1FileOpen(Sender: TObject; TheFile: String);
var
  TheTitle: String;
begin
  TheTitle := ExtractFileName(Application.ExeName);
  TheTitle := Copy(TheTitle, 1, Length(TheTitle)-4);
  TheTitle := TheTitle + ' - ' + ExtractFileName(TheFile);
  Application.Title := TheTitle;
  MainForm.Caption := TheTitle;
end;

procedure TMainForm.TraceBitBtnClick(Sender: TObject);
begin
  Plot1.Trace;
end;

procedure TMainForm.TypeBitBtnClick(Sender: TObject);
var
 ThePlotType: Integer;
begin
  ThePlotType := Ord(Plot1.PlotType);
  ThePlotType := (ThePlotType+1) mod (Ord(High(TPlotType))+1);
  Plot1.SeriesList.ClearSeries;
  Plot1.PlotType := TPlotType(ThePlotType);
  case Plot1.PlotType of
    ptXY: Plot1.MakeDummyData(100);
    ptMultiple: Plot1.MakeDummyData(20);
    ptColumn: Plot1.MakeDummyData(10);
  else ;
  end;
end;

end.
