unit Displace;

{$I Plot.inc}

{-----------------------------------------------------------------------------
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/MPL-1.1.html

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either expressed or implied. See the License for
the specific language governing rights and limitations under the License.

The Original Code is: Axis.pas, released 12 September 2000.

The Initial Developer of the Original Code is Mat Ballard.
Portions created by Mat Ballard are Copyright (C) 1999 Mat Ballard.
Portions created by Microsoft are Copyright (C) 1998, 1999 Microsoft Corp.
All Rights Reserved.

Contributor(s): Mat Ballard                 e-mail: mat.ballard@molsci.csiro.au.

Last Modified: 02/25/2000
Current Version: 1.00

You may retrieve the latest version of this file from:

        http://Chemware.hypermart.net/

This work was created with the Project JEDI VCL guidelines:

        http://www.delphi-jedi.org/Jedi:VCLVCL

in mind. 

Purpose:
To facilitate user setting of the displacement of a series.

Known Issues:
-----------------------------------------------------------------------------}

interface

uses
{$IFDEF WIN}
  WinTypes, WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TDisplacementForm = class(TForm)
    CancelBitBtn: TBitBtn;
    OKBitBtn: TBitBtn;
    SeriesLabel: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    DeltaXEdit: TEdit;
    DeltaYEdit: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure IntEditKeyPress(Sender: TObject; var Key: Char);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DisplacementForm: TDisplacementForm;

implementation

{$R *.DFM}
{------------------------------------------------------------------------------
    Procedure: TDisplaceForm.FormCreate
  Description: standard FormCreate procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: sets the position
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.FormCreate(Sender: TObject);
begin
  Left := 10;
  Top := 10;
end;

{------------------------------------------------------------------------------
    Procedure: TDisplaceForm.FormClose
  Description: standard FormClose procedure
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: checks for valid user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
var
  Test: Integer;
begin
{Check that floating point values are valid:}
  Action := caHide;
  try
    Test := StrToInt(DeltaXEdit.Text);
    Test := Test + StrToInt(DeltaYEdit.Text);
{We do the above and below the squelch the warning messages.}
    Tag := Trunc(Test);
  except
{Prevent closure:}
    Action := caNone;
  end;
end;

{------------------------------------------------------------------------------
    Procedure: TDisplaceForm.IntEditKeyPress
  Description: allows only "integer" keys to be pressed
       Author: Mat Ballard
 Date created: 04/25/2000
Date modified: 04/25/2000 by Mat Ballard
      Purpose: restrict user input
 Known Issues:
 ------------------------------------------------------------------------------}
procedure TDisplacementForm.IntEditKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in [#8, '0', '1', '2', '3', '4', '5', '6', '7', '8', '9']) then
    Key := Chr(0);
end;


end.
