unit Demou;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Parser9, P9Build, StdCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Edit1: TEdit;
    IterationEdit: TEdit;
    Button1: TButton;
    Button2: TButton;
    CountLabel: TLabel;
    Parser1: TParser;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure IterationEditKeyPress(Sender: TObject; var Key: Char);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    constructor Create(AnOwner: TComponent); override;

{ remove dot for dynamic creation of the parser }
{$DEFINE DynaCreate}

  public
{$IFDEF DynaCreate}
    DynaParser: TParser;
{$ENDIF}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

constructor TForm1.Create(AnOwner: TComponent);
begin
  inherited Create(AnOwner);
{$IFDEF DynaCreate}
  DynaParser := TParser.Create(Self);
{$ENDIF}
end;

procedure TForm1.IterationEditKeyPress(Sender: TObject; var Key: Char);
begin
  if not (Key in ['0'..'9',#8]) then
    Key := #0;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  StartTime,
  counter: longint;

  dummy : extended;

  TheParser: TParser;
begin
{$IFDEF DynaCreate}
  TheParser := DynaParser;
{$ELSE}
  TheParser := Parser1;
{$ENDIF}


  TheParser.Expression := Edit1.Text;


  StartTime := GetTickCount;


  { this does the calculation }
  for counter := 1 to StrToInt(IterationEdit.Text) do
    dummy := TheParser.Value;



  StartTime := GetTickCount - StartTime;
  ShowMessage(Format('Result: %g', [TheParser.Value]));
  if StartTime > 500 then
    ShowMessage( 'Did that seem slow?'#13+
                 'Well, this expression was evaluated '+IterationEdit.Text+' times!'#13+
                 '  (see the little edit box below the button)');
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  TheParser: TParser;

  StartTime1,
  StartTime2,
  i : longint;

  pf: PFloat;
begin
{$IFDEF DynaCreate}
  TheParser := DynaParser;
{$ELSE}
  TheParser := MathParser1;
{$ENDIF}

  { This is the slowest way...}
  ShowMessage('This is the slowest way to set variables...');

  Screen.Cursor := crHourGlass;
  try
    TheParser.Variable['Counter1'] := StrToFloat(CountLabel.Caption);
    TheParser.Expression := 'Counter1+1';

    StartTime1 := GetTickCount;
    for i := 1 to 10000 do
    begin
      TheParser.Variable['Counter1'] := TheParser.Value; { calculate and assign to "Counter" }
  (*
      CountLabel.Caption := FloatToStr( TheParser.Variable['Counter1'] );
      Application.ProcessMessages; *)
    end;
    CountLabel.Caption := FloatToStr( TheParser.Variable['Counter1'] );
    StartTime1 := GetTickCount - StartTime1;
  finally
    Screen.Cursor := crDefault;
  end;

  ShowMessage(Format('Time: %d ms', [StartTime1]));





  { This is the FAST way...}
  ShowMessage('This is the FAST way to do it...');
  Screen.Cursor := crHourGlass;
  try
    { we remember where the component actually stored the variable and
      access the memory directly }
    pf := TheParser.SetVariable('Counter2', StrToFloat(CountLabel.Caption));
    { BTW, this is yet another way to change variables;
      if the variable exists already only the pointer to existing memory
      is returned }

    TheParser.Expression := 'Counter2+1';

    StartTime2 := GetTickCount;
    for i := 1 to 10000 do
    begin
      pf^ := TheParser.Value; { calculate and assign to "Counter" }
  (*
      CountLabel.Caption := FloatToStr( TheParser.Variable['Counter2'] );
      Application.ProcessMessages; *)
    end;
    CountLabel.Caption := FloatToStr( TheParser.Variable['Counter2'] );
    StartTime2 := GetTickCount - StartTime2;
  finally
    Screen.Cursor := crDefault;
  end;

  ShowMessage(Format('Time: %d ms'#13#13'Just %d times faster...', [StartTime2, Trunc(StartTime1/StartTime2)]));
end;

end.
