unit P8build;
{$H+,B-,S-}
interface
uses Classes, Dialogs;

type rpointer=^double;
     onestep=procedure;
     operationpointer=^operation;
     operation=record
             arg1,arg2:rpointer;
             dest:rpointer;
             next:operationpointer;
             op:onestep;
             opnum:word;
            end;
var randomsize,randomresult:word;
    randomiterates,contrand:boolean;
    contrandresult:double;

procedure parsefunction(s:string;var fop:operationpointer;
            vars: TStringlist; var numop:integer;
           var error:boolean);
type
termsorttype=(variab,constant,brack,minus,sum,diff,prod,divis,
              intpower,realpower,cosine,sine,expo,logar,sqroot,arctang,
              square,third,forth,abso,maxim,minim,heavi,
              phase,randfunc,argu,hypersine,hypercosine,radius,
              randrand,sign,zero);

implementation
uses Sysutils;

procedure parsefunction( s:string;var fop:operationpointer;
                         vars: TStringList; var numop:integer;
                         var error:boolean);

procedure chopblanks(var s:string);  forward;
{deletes all blanks in s}

function checkbracketnum(const s:string):boolean; forward;
{checks whether # of '(' equ. # of ')'}

function checknum(const s:string; var num:double):boolean; forward;
{checks whether s is a number}

function checkvar(const s:string;var varsort:word): boolean; forward;
{checks whether s is a variable string}

function checkbrack(const s:string; var s1:string): boolean; forward;
{checks whether s =(...(s1)...) and s1 is a valid term}

function checkmin(const s:string; var s1:string): boolean; forward;
{checks whether s denotes the negative value of a valid operation}

function checksum(const s:string; var s1,s2:string): boolean; forward;
{checks whether '+' is the primary operation in s}

function checkdiff(const s:string; var s1,s2:string): boolean; forward;
{checks whether '-' is the primary operation in s}

function checkprod(const s:string; var s1,s2:string): boolean; forward;
{checks whether '*' is the primary operation in s}

function checkdiv(const s:string; var s1,s2:string): boolean;  forward;
{checks whether '/' is the primary operation in s}

function check2varfunct(const s:string; var s1,s2:string; var fsort: termsorttype):boolean; forward;
{checks whether s=f(s1,s2); s1,s2 being valid terms}

function checkfunct(const s:string; var s1:string; var fsort:termsorttype):boolean; forward;
{checks whether s denotes the evaluation of a function fsort(s1)}

function checkintpower(const s:string; var s1,s2:string): boolean; forward;
{checks whether s=s1^s2, s2 integer}

function checkrealpower(const s:string; var s1,s2:string): boolean; forward;
{checks whether s=s1^s2, s2 real}

procedure ShowError( const ErrMsg: string);
begin
   MessageDlg( ErrMsg, mtWarning, [mbOK], 0)
end;

procedure chopblanks(var s: string);
var i:byte;
begin
  while pos(' ',s)>0 do
  begin
    i:=pos(' ',s);
    delete(s,i,1);
  end;
  s := uppercase(s);
end;

function checkbracketnum(const s:string):boolean;
var lauf,lzu,i:integer;
begin
  lauf:=0;lzu:=0;i:=0;
  repeat
    i:=i+1;
    if {copy(s,i,1)} s[i] ='(' then
      lauf:=lauf+1;
    if {copy(s,i,1)} s[i] =')' then
      lzu:=lzu+1;
  until i>=length(s);
  Result := lauf = lzu
end;

function checknum( const s:string; var num:double):boolean;
var code: integer;
begin
  Result:=false;
  if s = 'PI' then
  begin
    Result:=true;
    num:=Pi;
    exit;
  end
  else
  begin
    val(s,num,code);
    if code=0 then
      Result :=true;
  end;
end;

function checkvar(const s:string; var varsort:word): boolean;
begin
  varsort := Vars.IndexOf(s);
  Result := varsort <> word(-1);
end;

function checkbrack(const s:string; var s1:string) :boolean;
var s2,s3:  string;
    num:    double;
    fsort:  termsorttype;
    varsort:word;
begin
  Result:=false;
  if (s[1]='(') and (s[length(s)]=')') then
    begin
      s1:=copy(s,2,length(s)-2);
      if checksum(s1,s2,s3) or
         checknum(s1,num) or
         checkdiff(s1,s2,s3) or
         checkmin(s1,s2) or
         checkprod(s1,s2,s3) or
         checkdiv(s1,s2,s3) or
         check2varfunct(s1,s2,s3,fsort) or
         checkfunct(s1,s2,fsort) or
         checkvar(s1,varsort) or
         checkintpower(s1,s2,s3) or
         checkrealpower(s1,s2,s3)
      then Result := true
      else
        if checkbrack(s1,s2) then begin
          s1:=s2;
          Result := true
        end;
    end;
end;
function checkmin(const s:string; var s1:string) :boolean;
var s2,s3:   string;
    fsort:   termsorttype;
    varsort: word;
begin
  Result :=false;
  if s[1]='-' then
  begin
    s1:=copy(s,2,length(s)-1);
    if checkbrack(s1,s2) then begin
      s1:=s2;
      result := true
    end
    else
      Result :=
        checkvar(s1,varsort) or
        checkfunct(s1,s2,fsort) or
        check2varfunct(s1,s2,s3,fsort) or
        checkintpower(s1,s2,s3) or
        checkrealpower(s1,s2,s3);
  end;
end;

function checksum(const s:string; var s1,s2:string) :boolean;
var s3,s4:     string;
    i,j:       byte;
    num:       double;
    fsort:     termsorttype;
    varsort:   word;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('+',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (i<length(s)) and (i>1) then
      begin
        s1:=copy(s,1,i-1);
        s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and checkbracketnum(s2);
        if Result then
        begin
          Result := checkvar(s1,varsort) or checknum(s1,num);
          if not Result then
          begin
            Result := checkbrack(s1,s3);
            if Result then s1:=s3;
          end;
          if not Result then
            Result := checkmin(s1,s3) or
                      checkdiff(s1,s3,s4) or
                      checkprod(s1,s3,s4) or
                      checkdiv(s1,s3,s4) or
                      check2varfunct(s1,s3,s4,fsort) or
                      checkfunct(s1,s3,fsort) or
                      checkintpower(s1,s3,s4) or
                      checkrealpower(s1,s3,s4);
          if Result then
          begin
            Result := checkvar(s2,varsort) or
                      checknum(s2,num);
            if not Result then begin
              Result := checkbrack(s2,s3);
              if Result then s2:=s3
              else Result := checksum(s2,s3,s4) or
                             checkdiff(s2,s3,s4) or
                             checkprod(s2,s3,s4) or
                             checkdiv(s2,s3,s4) or
                             checkfunct(s2,s3,fsort) or
                             check2varfunct(s2,s3,s4,fsort) or
                             checkintpower(s2,s3,s4) or
                             checkrealpower(s2,s3,s4);
            end
          end;
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

function checkdiff(const s:string; var s1,s2:string) :boolean;
var s3,s4:    string;
    i,j:      integer;
    num:      double;
    fsort:    termsorttype;
    varsort:  word;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('-',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (i<length(s)) and (i>1) then
      begin
        s1:=copy(s,1,i-1);
        s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and checkbracketnum(s2);
        if Result then
        begin
          Result := checkvar(s1,varsort) or checknum(s1,num);
          if not Result then
          begin
            Result := checkbrack(s1,s3);
            if Result then s1:=s3;
          end;
          if not Result then
            Result := checkmin(s1,s3) or
                      checkdiff(s1,s3,s4) or
                      checkprod(s1,s3,s4) or
                      checkdiv(s1,s3,s4) or
                      check2varfunct(s1,s3,s4,fsort) or
                      checkfunct(s1,s3,fsort) or
                      checkintpower(s1,s3,s4) or
                      checkrealpower(s1,s3,s4);
          if Result then
          begin
            Result :=  checkvar(s2,varsort) or
                       checknum(s2,num);
            if not Result then begin
               Result := checkbrack(s2,s3);
               if Result then s2:=s3
               else
                 Result := checkprod(s2,s3,s4) or
                         checkdiv(s2,s3,s4) or
                         checkfunct(s2,s3,fsort) or
                         check2varfunct(s2,s3,s4,fsort) or
                         checkintpower(s2,s3,s4) or
                         checkrealpower(s2,s3,s4)
            end;
          end;
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

function checkprod(const s:string; var s1,s2:string): boolean;
var s3,s4:    string;
    i,j:      integer;
    num:      double;
    fsort:    termsorttype;
    varsort:  word;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('*',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (i<length(s)) and (i>1) then
      begin
        s1:=copy(s,1,i-1);  s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and checkbracketnum(s2);
        if Result then
        begin
          Result := checkvar(s1,varsort) or
                    checknum(s1,num);
          if not Result then
          begin
            Result := checkbrack(s1,s3);
            if Result then s1:=s3;
          end;
          if not Result then
            Result := checkmin(s1,s3) or
                      checkdiv(s1,s3,s4) or
                      checkfunct(s1,s3,fsort) or
                      check2varfunct(s1,s3,s4,fsort) or
                      checkintpower(s1,s3,s4) or
                      checkrealpower(s1,s3,s4);
          if Result then
          begin
            Result := checkvar(s2,varsort) or
                      checknum(s2,num);
            if not Result then begin
              Result := checkbrack(s2,s3);
              if Result then s2:=s3
              else
                 Result := checkprod(s2,s3,s4) or
                           checkdiv(s2,s3,s4) or
                           checkfunct(s2,s3,fsort) or
                           check2varfunct(s2,s3,s4,fsort) or
                           checkintpower(s2,s3,s4) or
                           checkrealpower(s2,s3,s4)
            end
          end
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

function checkdiv(const s:string; var s1,s2:string): boolean;
var s3,s4:  string;
    i,j:    integer;
    varsort:word;
    num:    double;
    fsort:  termsorttype;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('/',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (i<length(s)) and (i>1) then
      begin
        s1:=copy(s,1,i-1);
        s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and checkbracketnum(s2);
        if Result then
        begin
           Result := checkvar(s1,varsort) or
                     checknum(s1,num);
           if not Result then
           begin
              Result := checkbrack(s1,s3);
              if Result then s1:=s3;
           end;
           if not Result then
              Result := checkmin(s1,s3) or
                        checkdiv(s1,s3,s4) or
                        checkfunct(s1,s3,fsort) or
                        check2varfunct(s1,s3,s4,fsort) or
                        checkintpower(s1,s3,s4) or
                        checkrealpower(s1,s3,s4);
           if Result then
           begin
             Result := checkvar(s2,varsort) or
                       checknum(s2,num);
             if not Result then begin
               Result := checkbrack(s2,s3);
               if Result then  s2:=s3
               else
                Result := checkfunct(s2,s3,fsort) or
                          check2varfunct(s2,s3,s4,fsort) or
                          checkintpower(s2,s3,s4) or
                          checkrealpower(s2,s3,s4)
             end
           end;
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

function check2varfunct(const s:string; var s1,s2:string;var fsort:termsorttype) :boolean;

  function checkcomma(const s:string; var s1,s2:string) :boolean;
  var s3: string;
      i,j:integer;
  begin
    Result:=false;
    i:=0;
    repeat
      j:=pos(',',copy(s,i+1,length(s)-i));
      if j>0 then
      begin
        i:=i+j;
        if (i<length(s)) and (i>1) then
        begin
          s1:=copy(s,1,i-1);
          s2:=copy(s,i+1,length(s)-i);
          s3:='('+s1+')';
          Result := checkbrack(s3,s1);
          if Result then
          begin
            s3:='('+s2+')';
            Result := checkbrack(s3,s2);
          end;
        end;
      end;
    until Result or (i>=length(s)) or (j=0);
  end;

var ss: string;

  function CheckFun( const name: string; afsort:termsorttype): boolean;
  var l: integer;
  begin
    Result := false;
    l := length(name);
    if copy( s, 1, l) = name then
    begin
      ss:=copy(s,succ(l),length(s)-l);
      if (ss[1]='(') and (ss[length(ss)]=')') then
      begin
        ss:=copy(ss,2,length(ss)-2);
        Result := checkcomma(ss,s1,s2);
      end;
      if Result then
         fsort := afsort;
    end;
  end;

begin
  Result := CheckFun('MIN', minim) or
            CheckFun('MAX', maxim) or
            CheckFun('RN', randfunc) or
            CheckFun('ARG', argu) or
            Checkfun('R', radius) or
            CheckFun('RM', randrand);
end;

function checkfunct(const s:string; var s1:string; var fsort:termsorttype): boolean;
var s2,s3,s4  :string;
    i,j       :integer;
    num       :double;
    ffsort    :termsorttype;
    varsort   :word;

  function CheckFun( const name: string; afsort: termsorttype): boolean;
  var l: integer;
  begin
     Result := false;
     l := length(name);
     if copy( s, 1, l) = name then begin
        s2 := copy( s, succ(l), length(s)-l);
        Result := checkbrack( s2, s1);
        if Result then
          fsort := afsort;
     end
  end;

begin
  Result := CheckFun('COS', cosine) or
            Checkfun('SIN', sine) or
            Checkfun('EXP', expo) or
            CheckFun('LN', logar) or
            CheckFun('ARCTAN', arctang) or
            CheckFun('SQRT', sqroot) or
            Checkfun('ABS', abso) or
            Checkfun('HEAV', heavi) or
            CheckFun('SIGN', sign) or
            CheckFun('ZERO', zero) or
            Checkfun('PH', phase) or
            CheckFun('SINH', hypersine) or
            CheckFun('COSH', hypercosine);
  if not Result then
  begin
    i:=0;
    repeat
      j:=pos('^',copy(s,i+1,length(s)-i));
      if j>0 then
      begin
        i:=i+j;
        if (1<i) and (i<length(s)) then
        begin
          s1:=copy(s,1,i-1);
          s2:=copy(s,i+1,length(s)-i);
          Result := checkbracketnum(s1) and
                    checkbracketnum(s2);
          if Result then
          begin
            Result := checkvar(s1,varsort);
            if not Result then
            begin
              Result := checkbrack(s1,s3);
              if Result then s1:=s3;
            end;
            if not Result then
              Result := checknum(s1,num) or
                        checkfunct(s1,s3,ffsort) or
                        check2varfunct(s1,s3,s4,ffsort);
            if Result then
            begin
              Result := checknum(s2,num);
              if Result then
                 if (trunc(num)<>num) or (num<0) then
                   Result:=false
                 else if trunc(num) in [2,3,4] then
                      case trunc(num) of
                        2:fsort:=square;
                        3:fsort:=third;
                        4:fsort:=forth;
                      end
                      else Result:=false;
            end;
          end;
        end;
      end;
    until Result or (i>=length(s)) or (j=0);
  end;
end;

function checkintpower(const s:string; var s1,s2:string) :boolean;
var s3,s4   :string;
    i,j     :integer;
    num     :double;
    fsort   :termsorttype;
    varsort :word;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('^',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (1<i) and (i<length(s)) then
      begin
        s1:=copy(s,1,i-1);
        s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and
                  checkbracketnum(s2);
        if Result then
        begin
          result := checkvar(s1,varsort) or
                    checkbrack(s1,s3);
          if Result then s1:=s3;
        end;
        if not Result then
          Result := checknum(s1,num) or
                    checkfunct(s1,s3,fsort) or
                    check2varfunct(s1,s3,s4,fsort);
        if Result then
        begin
          Result := checknum(s2,num);
          if Result then
            if (trunc(num)<>num) then
              Result :=false
            else if trunc(num) in [2,3,4] then
              Result :=false;
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

function checkrealpower(const s:string; var s1,s2: string ) :boolean;
var  i,j   :integer;
     num   :double;
     s3,s4 :string;
     fsort :termsorttype;
     varsort:word;
begin
  Result:=false;
  i:=0;
  repeat
    j:=pos('^',copy(s,i+1,length(s)-i));
    if j>0 then
    begin
      i:=i+j;
      if (1<i) and (i<length(s)) then
      begin
        s1:=copy(s,1,i-1);
        s2:=copy(s,i+1,length(s)-i);
        Result := checkbracketnum(s1) and
                  checkbracketnum(s2);
        if Result then
        begin
           Result := checkvar(s1,varsort) or
                     checknum(s1,num);
           if not Result then
           begin
              Result := checkbrack(s1,s3);
              if Result then s1:=s3;
           end;
           if not Result then
              Result := checkfunct(s1,s3,fsort) or
                        check2varfunct(s1,s3,s4,fsort);
           if Result then
           begin
              Result := checknum(s2,num);
              if Result then begin
                if (trunc(num)=num) then Result:=false
                else begin
                   Result := checkvar(s2,varsort) or
                             checkbrack(s2,s3);
                   if Result then s2:=s3
                   else Result := checkfunct(s2,s3,fsort) or
                                  check2varfunct(s2,s3,s4,fsort);
                end
              end;
           end;
        end;
      end;
    end;
  until Result or (i>=length(s)) or (j=0);
end;

const maxlevels=20;  maxlevelsize=50;

type

         termpointer=^termrec;

         operation1pointer=^operation1;

         termrec=record
                 s:string;
                 termsort:termsorttype;
                 s1,s2:string;
                 posit:array[1..3] of integer;
                 next1,next2,prev:termpointer
                 end;

         operation1=record
                   theop:operationpointer;
                   end;

         levelsizearray=array[0..maxlevels] of integer;

  procedure ini(var theop:operationpointer;term:termsorttype);
  begin
    new(theop);
    with theop^ do
    begin
      arg1:=nil; arg2:=nil; dest:=nil; next:=nil;
      opnum:=ord(term);
    end;
  end;

var Res,done,found:       boolean;
    code,l,i,levels,p:    integer;
    ab,levelsize:         levelsizearray;
    s3,blanks:            string;
    firstterm,next1term,next2term,lastterm: termpointer;
    fsort:                termsorttype;
    matrix:array[0..maxlevels,1..maxlevelsize] of operation1pointer;
    lastop:               operationpointer;
    num:                  double;
    varsort:              word;

begin
  error:=false;
  blanks:=' ';
  chopblanks(s);
  repeat
    Res := checkbrack(s,s3);
    if Res then s:=s3;
  until not Res;
  done:=false;
  levels:=0;
  levelsize[0]:=1;
  for l:=0 to maxlevels do
    ab[l]:=0;
  new(firstterm);
  firstterm^.s:=s;
  with firstterm^ do
  begin
    s1:=blanks; s2:=blanks; termsort:=variab;
    next1:=nil; next2:=nil; prev:=nil;
    new(matrix[0,1]);
    new(matrix[0,1]^.theop);
    with matrix[0,1]^.theop^ do
    begin
      arg1:=nil; arg2:=nil; dest:=nil;
      opnum:=ord(variab); next:=nil;
    end;
  end;
  lastterm:=firstterm;
  lastterm^.posit[1]:=0;
  lastterm^.posit[2]:=1;
  lastterm^.posit[3]:=1;
  repeat
    code:=0;
    repeat
       l:=lastterm^.posit[1];
       i:=lastterm^.posit[2];
      if lastterm^.next1=nil then
      with lastterm^ do
      begin
        Res := checkvar(s,varsort);
        if Res then
        begin
          termsort:=variab;
          if posit[3]=1 then matrix[l,i]^.theop^.arg1:= rpointer(Vars.objects[varsort])
                        else matrix[l,i]^.theop^.arg2:= rpointer(Vars.objects[varsort])
        end
        else
        begin
            Res := checknum(s,num);
            if Res then
            begin
               termsort:=constant;
              if posit[3]=1 then
              begin
                new(matrix[l,i]^.theop^.arg1);
                matrix[l,i]^.theop^.arg1^:=num;
              end else
              begin
                new(matrix[l,i]^.theop^.arg2);
                matrix[l,i]^.theop^.arg2^:=num;
              end;
            end
            else
            begin
              Res := checkmin(s,s1);
              if Res then
                termsort:=minus
              else begin
                Res := checksum(s,s1,s2);
                if Res then
                  termsort:=sum
                else
                begin
                  Res := checkdiff(s,s1,s2);
                  if Res then
                    termsort:=diff
                  else
                  begin
                    Res := checkprod(s,s1,s2);
                    if Res then
                      termsort:=prod
                    else
                    begin
                      Res := checkdiv(s,s1,s2);
                      if Res then
                        termsort:=divis
                      else
                      begin
                        Res := checkfunct(s,s1,fsort);
                        if Res then
                        begin
                          termsort:=fsort;
                        end
                        else
                        begin
                          Res := checkintpower(s,s1,s2);
                          if Res then
                            termsort:=intpower
                          else
                          begin
                            Res := checkrealpower(s,s1,s2);
                            if Res then
                              termsort:=realpower
                            else
                            begin
                              Res := check2varfunct(s,s1,s2,fsort);
                              if Res then
                              begin
                                termsort:=fsort;
                                if fsort=randfunc then
                                begin
                                  val(s1,num,code);
                                  randomsize:=round(num);
                                  randomiterates:=true;
                                  randomize;
                                end;
                                if termsort=randrand then
                                begin
                                  contrand:=true;
                                  randomize;
                                end;
                              end
                              else
                              begin
                                error:=true;
                                ShowError('Syntax Error!');
                                exit;
                              end;
                            end;
                          end;
                        end;
                      end;
                    end;
                  end;
                end;
              end;
            end;
        end;
      end; {with lastterm^}
      if lastterm^.termsort in [brack,minus,cosine,sine,expo,logar,
                          sqroot,arctang,square,third,forth,
                          abso,heavi,phase,hypersine,hypercosine,zero,sign] then
        begin
          new(next1term);
          l:=l+1;
          if l>maxlevels then
          begin
            ShowError('Too many nestings!');
            error:=true; exit;
          end;
          if levels<l then
            levels:=l;
          i:=ab[l]+1;
          if i>maxlevelsize then
          begin
            ShowError('Term too long, sorry!');
            error:=true; exit;
          end;
          with next1term^ do
          begin
            s:=lastterm^.s1;
            prev:=lastterm;
            posit[1]:=l;  posit[2]:=i; posit[3]:=1;
            termsort:=variab;
            s1:=blanks; s2:=blanks; num:=0;
             next1:=nil; next2:=nil;
             new(matrix[l,i]);
             ini(matrix[l,i]^.theop,lastterm^.termsort);
             p:=lastterm^.posit[3];
             new(matrix[l,i]^.theop^.dest);
             matrix[l,i]^.theop^.dest^:=0;
             if p=1 then
               matrix[lastterm^.posit[1],lastterm^.posit[2]]^.theop^.arg1:=
                           matrix[l,i]^.theop^.dest else
               matrix[lastterm^.posit[1],lastterm^.posit[2]]^.theop^.arg2:=
                           matrix[l,i]^.theop^.dest;
           end;
          lastterm^.next1:=next1term;
          ab[l]:=ab[l]+1;
        end;
      if lastterm^.termsort in
                 [sum,diff,prod,divis,intpower,realpower,maxim,minim,
                 randfunc,argu,radius,randrand] then
        begin
          if lastterm^.next1=nil then
          begin
            new(next1term);
            l:=l+1;
            if l>maxlevels then
            begin
              ShowError('Too many nestings!');
              error:=true; exit;
            end;
            if levels<l then
              levels:=l;
            i:=ab[l]+1;
            if i>maxlevelsize then
            begin
              ShowError('Term too long, sorry!');
              error:=true; exit;
            end;
            with next1term^ do
            begin
              s:=lastterm^.s1;
              prev:=lastterm;
              posit[1]:=l;
              posit[2]:=i; posit[3]:=1;
              num:=0;
              s1:=blanks; s2:=blanks; termsort:=variab;
              next1:=nil; next2:=nil;
              new(matrix[l,i]);
              ini(matrix[l,i]^.theop,lastterm^.termsort);
              p:=lastterm^.posit[3];
              new(matrix[l,i]^.theop^.dest);
              matrix[l,i]^.theop^.dest^:=0;
              if p=1 then
               matrix[lastterm^.posit[1],lastterm^.posit[2]]^.theop^.arg1:=
                           matrix[l,i]^.theop^.dest else
               matrix[lastterm^.posit[1],lastterm^.posit[2]]^.theop^.arg2:=
                           matrix[l,i]^.theop^.dest;
            end;
            lastterm^.next1:=next1term;
          end
          else
          begin
            new(next2term);
            l:=l+1;
            if l>maxlevels then
            begin
              ShowError('Too many nestings!');
              error:=true; exit;
            end;
            if levels<l then
              levels:=l;
            i:=ab[l]+1;
            if i>maxlevelsize then
            begin
              ShowError('Term too long, sorry!');
              error:=true; exit;
            end;
            with next2term^ do
            begin
              s:=lastterm^.s2;
              prev:=lastterm;
              posit[1]:=l; posit[2]:=i; posit[3]:=2;
              num:=0;
              s1:=blanks; s2:=blanks; termsort:=variab;
              next1:=nil; next2:=nil;
            end;
            lastterm^.next2:=next2term;
            ab[l]:=ab[l]+1;
          end;
        end;
      if lastterm^.next1=nil then
        code:=1
      else
        if lastterm^.next2=nil then
          lastterm:=lastterm^.next1
        else
          lastterm:=lastterm^.next2;
   until code=1;
   if lastterm=firstterm then
   begin
     done:=true;
     dispose(lastterm);
     firstterm:=nil;
   end
   else
   begin
     repeat
       if lastterm^.next1<>nil then
         dispose(lastterm^.next1);
       if lastterm^.next2<>nil then
         dispose(lastterm^.next2);
       lastterm:=lastterm^.prev;
     until ((lastterm^.termsort in [sum,diff,prod,divis,intpower,realpower,
                  maxim,minim,randfunc,argu,radius,randrand])
             and
            (lastterm^.next2=nil)) or (lastterm=firstterm);
     if (lastterm=firstterm) and ((firstterm^.termsort in [brack,minus,cosine,sine,
                expo,logar,sqroot,arctang,square,third,forth,
                abso,heavi,phase,hypersine,hypercosine,zero,sign])
                   or ((firstterm^.termsort in [sum,diff,prod,divis,intpower,
                      realpower,maxim,minim,randfunc,argu,radius,randrand])
                       and (firstterm^.next2<>nil))) then
         done:=true;
   end;
 until done;
 if firstterm<>nil then
 begin
   if firstterm^.next1<>nil then dispose(firstterm^.next1);
   if firstterm^.next2<>nil then dispose(firstterm^.next2);
   dispose(firstterm);
 end;
 for l:=1 to levels do
   levelsize[l]:=ab[l];
 if levels=0 then
 begin
   fop:=matrix[0,1]^.theop;
   fop^.dest:=fop^.arg1;
   numop:=0;
   dispose(matrix[0,1]);
 end
 else
 begin
   for l:=levels downto 1 do
   for i:=1 to levelsize[l] do
   begin
     if (l=levels) and (i=1) then
     begin
       numop:=1;
       fop:=matrix[l,i]^.theop;
       lastop:=fop;
       dispose(matrix[l,i]);
     end
     else
     begin
       inc(numop);
       lastop^.next:=matrix[l,i]^.theop;
       lastop:=lastop^.next;
       dispose(matrix[l,i]);
     end;
   end;
   with matrix[0,1]^.theop^ do
   begin
     arg1:=nil; arg2:=nil; dest:=nil;
   end;
   dispose(matrix[0,1]^.theop);
   dispose(matrix[0,1]);
 end;
end;
end.
