{ Copyright (C) 1995  Vitaly Monastirsky }

unit OvrChars;

interface

uses WinTypes;

function IsInsMode: boolean;
function ProcessKbdMessages(var Msg: TMsg): boolean;

implementation

uses Messages, WinProcs, Forms, StdCtrls, Grids, DBGrids;

type
  TFakeGrid = class(TCustomGrid)
  public
    property InplaceEditor;
  end;

  TSelection = record
    StartPos, EndPos: Integer;
  end;

const
  InsMode: boolean = TRUE;

const
  MsgToControl: array [0..1,0..1] of word =
                  ((EM_GETSEL,    EM_SETSEL),
                   (CB_GETEDITSEL,CB_SETEDITSEL));

{-----------------------------}
  function IsInsMode: boolean;
{-----------------------------}
begin
  Result := InsMode;
end;

{------------------------------------------------------}
  function ProcessKbdMessages(var Msg: TMsg): boolean;
{------------------------------------------------------}
var
  ControlHandle: HWND;
  ControlID: byte;
  Sel: TSelection;
begin

  Result := FALSE;

  case Msg.Message of

    WM_KEYDOWN:
      if (Msg.wParam=VK_INSERT) and
         (GetKeyState(VK_SHIFT)>=0) and
         (GetKeyState(VK_CONTROL)>=0) then
        if Screen.ActiveControl is TCustomDBGrid then
          begin
            if (TFakeGrid(Screen.ActiveControl).InplaceEditor<>nil) and
               (TFakeGrid(Screen.ActiveControl).InplaceEditor.Focused) then
              begin
                InsMode := not InsMode;
                Result := TRUE;
              end;
          end
        else if (Screen.ActiveControl is TCustomComboBox) or
                (Screen.ActiveControl is TCustomGrid) or
                (Screen.ActiveControl is TCustomEdit) then
          begin
            InsMode := not InsMode;
            Result := TRUE;
          end;

    WM_CHAR:
      if (not InsMode) and (Msg.wParam>$1F) and (Msg.wParam<$FF) then
        begin
          ControlHandle := 0;
          ControlID     := 0;
          if Screen.ActiveControl is TCustomEdit then
            ControlHandle := Screen.ActiveControl.Handle
          else if (Screen.ActiveControl is TCustomGrid) and
                  (TFakeGrid(Screen.ActiveControl).InplaceEditor<>nil) then
            ControlHandle := TFakeGrid(Screen.ActiveControl).InplaceEditor.Handle
          else if Screen.ActiveControl is TCustomComboBox then
            begin
              ControlHandle := Screen.ActiveControl.Handle;
              ControlID     := 1;
            end;
          if ControlHandle<>0 then
            begin
              Longint(Sel) := SendMessage(ControlHandle, MsgToControl[ControlID,0], 0, 0);
              if Sel.StartPos=Sel.EndPos then
                begin
                  Inc(Sel.EndPos);
                  if Screen.ActiveControl is TCustomMemo then
                    begin
                      { Check the end of line in Memo control }
                      if (SendMessage(ControlHandle, EM_LINELENGTH, Sel.StartPos, 0)=
                          SendMessage(ControlHandle, EM_LINELENGTH,Sel.Startpos+2, 0)) and
                         (SendMessage(ControlHandle, EM_LINEFROMCHAR,Sel.StartPos ,0)=
                          SendMessage(ControlHandle, EM_LINEFROMCHAR,Sel.StartPos+2 ,0)) then
                        SendMessage(ControlHandle, EM_SETSEL, 0, Longint(Sel))
                    end
                  else
                    SendMessage(ControlHandle, MsgToControl[ControlID,1], 0, Longint(Sel));
                end;
            end
        end;
  end;
end;

end.
