{
 Designer: Craig Ward, 100554.2072@compuserve.com
 Date:     9/11/95
 Version:  1.0

 Function: Example of how to use a TOutline component inconjunction with a table.

 Notes:    TOutlines can not be made to be data-aware simply because you can not
           actually get at the text in a TOutline, though this might be different
           in Delphi32 where you have the addition of the Win95 Tree component
           (I'm not sure about this, so please check!). Therefore you have to
           programmatically populate a TOutline with data from a table, let the user
           play around with the TOutlines, and then write the amended data back to
           the tables.

           Clearly you'll need methods for reading and writing to\from the tables,
           and the obvious place to put these would be on the form's  activate and
           close events.
*******************************************************************************}
unit Ex11;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, Grids, Outline, DB, DBTables, DBGrids;

type
  TForm1 = class(TForm)
    tabMasterDetail: TTable;
    tabMasterDetailParent: TStringField;
    tabMasterDetailChild: TStringField;
    Outline1: TOutline;
    DataSource1: TDataSource;
    Outline2: TOutline;
    tabMaster: TTable;
    tabMasterParent: TStringField;
    tabDetail: TTable;
    tabDetailChild: TStringField;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Database1: TDatabase;
    procedure Outline2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Outline1DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure Outline1DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure Outline2EndDrag(Sender, Target: TObject; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
  private
    { Private declarations }
    procedure fillOutline1;
    procedure fillOutline2;
    procedure WriteTabMasterDetail;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{***populate outline with table data*******************************************}

{read tables to populate first outline}
procedure TForm1.FillOutline1;
var
 i: integer;
begin
 outline1.clear;
 tabMaster.first;
 {***}
 with Outline1 do
  begin
   {read from master table}
   while not tabMaster.eof do
    begin
     i := add(0,tabMasterPARENT.value);
     tabMasterDetail.first;
     {read from masterDetail table}
     while not tabMasterDetail.eof do
      begin
       if tabMasterDetailPARENT.value = tabMasterPARENT.value then
        addChild(i,tabMasterDetailCHILD.value);
       tabMasterDetail.next;
      end;
    tabMaster.next;
    end;
  end;
end;


{read tables to populate second outline}
procedure TForm1.FillOutline2;
var
 i: integer;
begin
 outline2.clear;
 tabDetail.first;
 {***}
 with Outline2 do
  begin
   {read from detail table}
   while not tabDetail.eof do
    begin
     i := add(0,tabDetailCHILD.value);
     tabMasterDetail.first;
     {read from masterDetail table}
     while not tabMasterDetail.eof do
      begin
       if tabMasterDetailCHILD.value = tabDetailCHILD.value then
        addChild(i,tabMasterDetailPARENT.value);
       tabMasterDetail.next;
      end;
    tabDetail.next;
    end;
  end;
end;

{***populate table with outline data*******************************************}
procedure TForm1.WriteTabMasterDetail;
var
 i, iFin: integer;
 sP, sC: string;
begin

 {clear table}
 try
  tabMasterDetail.close;
  tabMasterDetail.emptyTable;
 except
  on EDatabaseError do
   begin
    messageDlg('Could not empty table. Are you running this from Delphi? If so, close down the project,'+
                      ' and run the EXE file from Program\File Manager. All changes will be cancelled.',mtWarning,[mbOK],0);
    exit;
   end;
 end;
  tabMasterDetail.open;

 {write to table}
 try
  begin
   iFin := outline2.itemCount;
   tabMasterDetail.first;
   for i := 1 to (iFin) do
    begin
     if outline2.items[i].level > 1 then
       begin
        tabMasterDetail.InsertRecord([outline2.items[i].text, outline2.items[i].parent.text]);
        tabMasterDetail.next;
       end;
    end;
  end;
 except
  on EDatabaseError do
   begin
    messageDlg('Could not write to table. All changes to data will be cancelled.',mtWarning,[mbOK],0);
    exit;
   end;
 end;
end;

{***drag methods***************************************************************}

{set beginDrag}
procedure TForm1.Outline2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 {drag on the usual left mouse-button}
 if button = mbLeft then
 {drag only if a parent value is selected}
 if outline2.items[outline2.getItem(x,y)].level <> 1 then
  exit
 else
  with Sender as TOutline do
   begin
     BeginDrag(False);
   end;
end;

{accept drag}
procedure TForm1.Outline1DragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
 if source is TOutline then
  accept := true;
end;

{drag drop}
procedure TForm1.Outline1DragDrop(Sender, Source: TObject; X, Y: Integer);
var
 sText, sNew, sOld: string;
 i, iFin, iD, iChild: integer;
begin
 if source is TOutline then
  begin
  {only allow item to be added if parent, and not a child}
  if outline1.items[outline1.getItem(x,y)].level <> 1 then
   exit;

  {find data on item begin dragged}
  i := outline2.selectedItem;                                 {index}
  sText := outline2.lines.strings[i - 1];                     {text}
  sNew := outline1.lines.strings[outline1.GetItem(x,y)-1];    {new child text}
  sOld := outline2.items[i+1].text;                           {old child text}

  outline1.beginUpdate;                                       {turn off screen repainting}
  try
   begin
    iChild := 0;
    iChild := (outline1.GetItem(x,y));
    {making sure that the user adds to an existing parent, and does not create a new parent}
    if iChild = 0 then
     iChild := 1;
    outline1.addChild(iChild,sText);
   end;

  {delete old item}
   begin
   iFin := outline1.itemCount;
   {loop to find sChild in outline1}
    for i := 1 to (iFin) do
     begin
      {find the child item, and then remove it}
       if outline1.items[i].text = sText then
       if outline1.items[i].parent.text = sOld then
        iD := (outline1.items[i].index)-1;                   {minus 1, because Lines indices start from 0, and not 1}
     end;
    outline1.lines.delete(iD);
   end;

  finally
   outline1.endUpdate;
   outline1.update;
  end;


  {must update outline2 to keep in synch with outline1}
  begin
   outline2.items[(outline2.selectedItem)+1].text := sNew; {plus 1, because Lines indices start from 0, and not 1}
   outline2.update;
  end;

  end;
end;


{end drag}
procedure TForm1.Outline2EndDrag(Sender, Target: TObject; X, Y: Integer);
begin
 if target <> nil then outline2.update;
end;


{***form's preferences*********************************************************}

procedure TForm1.FormActivate(Sender: TObject);
begin
 fillOutline1;
 fillOutline2;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
 close;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
 writeTabMasterDetail;
 close;
end;

end.
