{ One-way encryption by BWSB aka Mikael Mre <pcmicke@2.sbbs.se>. }
Unit OneWay;
{$Q-}
Interface
	{ Types }
	Type
		TCString = String[15];
	{ Procedures }
	Procedure Crypt(Var S:TCString);
Implementation
{ We have to be sure we always use the same randomizer. }
Var
	RandSeed	:LongInt;
Function Random(Range:LongInt):LongInt;
	{ I wrote this randomizer without any idea.
	  Just because we need the same randomizer
	  independing on pascal compiler and such. }
	Begin
		RandSeed := Swap(RandSeed * Randseed shr 2) + Randseed - Swap(Randseed) + 1 xor Randseed;
		Random := RandSeed mod Range;
	End;

{ This is the sub-encryption routine. Here, the actual encryption is done. }
Procedure SubCrypt(Var S:TCString);
	Var B:Byte;
	Begin
		For B := 1 to Length(S) do Begin
			Inc(Randseed,Byte(S[B]));
			S[B] := Char(Random(255));
		End;
	End;

{ This encodes any TCString to a human-readable (A..Z and a..z) one. }
Procedure Encode(Var S:TCString);
	Var
		B	:Byte;
		OS	:TCString;
	Begin
		OS := S;
		FillChar(S,SizeOf(S),0);
		S[0] := #15;
		For B := 1 to Length(S) do
			S[B] := Char(Random(255) + Byte(OS[(B mod Length(OS)) + 1]));
		For B := Length(S) downto 1 do
			If B < Random(Length(S)) then
				Byte(S[B]) := Byte(S[B]) mod 23 + 65
			Else
				Byte(S[B]) := Byte(S[B]) mod 23 + 97;
	End;

{ This is the main encryption routine. }
Procedure Crypt(Var S:TCString);
	Var B:Byte;
	Begin
		If S = '' then
			Exit;
		Randseed := 0;
		For B := 1 to Length(S) * 4 do
			SubCrypt(S);
		Encode(S);
	End;

End.