unit Imprtdlg;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Import;

type
  TPyroImportDialog = class(TComponent)
  private
    { Private declarations }
    FImportForm:TImportForm;
    function GetCaption:string;
    procedure SetCaption(newcaption:string);
    function GetInitialDir:string;
    procedure SetInitialDir(newdir:string);
    function GetFileSpec:string;
    procedure SetFileSpec(newspec:string);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(Aowner:TComponent); override;
    destructor Destroy; override;
    function Execute:TStringList; virtual;
  published
    { Published declarations }
    property Caption:string read GetCaption write SetCaption;
    property InitialDir:string read GetInitialDir write SetInitialDir;
    property FileSpec:string read GetFileSpec write SetFileSpec;

  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PyroSoft', [TPyroImportDialog]);
end;

constructor TPyroImportDialog.Create(Aowner:TComponent);
begin
     inherited Create(Aowner);
     FImportForm:=TImportForm.Create(Self);
end;

destructor TPyroImportDialog.Destroy;
begin
     FImportForm.Release;
     inherited Destroy;
end;

function TPyroImportDialog.Execute:TStringList;
var
   files:TStringList;
   a:Integer;
begin
     if FImportForm.Showmodal=mrOk then begin
        if FImportForm.Importfilelist.Items.Count>0 then begin
           files:=TStringlist.create;
           files.BeginUpdate;
           for a:=0 to FImportForm.ImportFileList.items.count-1 do
               files.add(FImportForm.Importfilelist.items[a]);
           files.EndUpdate;
           result:=files;
        end
        else
            result:=nil;
     end
     else
         result:=nil;
end;

function TPyroImportDialog.GetCaption:string;
begin
     result:=FImportForm.Caption;
end;

procedure TPyroImportDialog.SetCaption(newcaption:string);
begin
     FImportForm.Caption:=newcaption;
end;

function TPyroImportDialog.GetInitialDir:string;
begin
     result:=FImportForm.DirectoryList.Directory;
end;

procedure TPyroImportDialog.SetInitialDir(newdir:string);
begin
     FImportForm.drivecombo.drive:=newdir[1];
     FImportForm.directorylist.directory:=newdir;
end;

function TPyroImportDialog.GetFileSpec:string;
begin
     result:=Fimportform.filespec.text;
end;

procedure TPyroImportDialog.SetFileSpec(newspec:string);
begin
     FImportForm.filespec.text:=newspec;
end;

end.
