unit Import;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, FileCtrl;

type
  TImportForm = class(TForm)
    FileList: TFileListBox;
    DirectoryList: TDirectoryListBox;
    DriveCombo: TDriveComboBox;
    ImportFileList: TListBox;
    Label1: TLabel;
    RemoveButton: TButton;
    FileSpec: TEdit;
    Label2: TLabel;
    AddButton: TButton;
    DoneButton: TBitBtn;
    PromoteButton: TBitBtn;
    DemoteButton: TBitBtn;
    Button1: TButton;
    procedure addfile(Sender: TObject);
    procedure addfilespec(Sender: TObject);
    procedure RemoveButtonClick(Sender: TObject);
    procedure PromoteButtonClick(Sender: TObject);
    procedure DemoteButtonClick(Sender: TObject);
    procedure addfromlist(Sender: TObject);
    procedure clearlist(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ImportForm: TImportForm;

implementation

{$R *.DFM}

procedure TImportForm.addfile(Sender: TObject);
begin
     if filelist.filename<>'' then begin
        ImportFilelist.items.add(filelist.filename);
     end;
end;

procedure TImportForm.addfilespec(Sender: TObject);
var
a,found:Integer;
fileinfo:TSearchRec;
path:String;
begin
     try
           path:=Directorylist.Directory+'\'+Filespec.text;
           found:=FindFirst(path,$3f,fileinfo);
           if found<>0 then
              Application.MessageBox('No files found.','Error',0);

           while found=0 do begin
                 if (fileinfo.attr<>faSysfile) and (fileinfo.attr<>faVolumeId) and (fileinfo.attr<>faDirectory) then begin
                     importFilelist.items.add(directorylist.directory+'\'+fileinfo.name);
                 end;
                 found:=FindNext(fileinfo);
           end;
           findclose(fileinfo);
     except
     end;
end;

procedure TImportForm.RemoveButtonClick(Sender: TObject);
var
a:Integer;
begin
     a:=0;
     if importfilelist.items.count>0 then begin
        repeat
           Application.ProcessMessages;
           if importfilelist.selected[a] then begin
              importfilelist.items.delete(a);
              a:=0;
           end
           else
               Inc(a);
        until (a>importfilelist.items.count-1) or (importfilelist.items.count=0);
        importfilelist.invalidate;
     end;
end;

procedure TImportForm.PromoteButtonClick(Sender: TObject);
var
a:Integer;
begin
     if importfilelist.items.count>1 then begin
        for a:=1 to importfilelist.items.count-1 do begin
            if importfilelist.selected[a] then begin
               importfilelist.items.exchange(a,a-1);
               importfilelist.selected[a-1]:=true;
            end;
        end;
     end;
end;

procedure TImportForm.DemoteButtonClick(Sender: TObject);
var
a:Integer;
begin
     if importfilelist.items.count>1 then begin
        for a:=importfilelist.items.count-2 downto 0 do begin
            if importfilelist.selected[a] then begin
               importfilelist.items.exchange(a,a+1);
               importfilelist.selected[a+1]:=true;
            end;
        end;
     end;
end;

procedure TImportForm.addfromlist(Sender: TObject);
var
a:Integer;
begin
     if filelist.filename<>'' then begin
        for a:=0 to filelist.items.count-1 do begin
            if filelist.selected[a] then
               importFilelist.items.add(directorylist.directory+'\'+filelist.items[a]);
        end;
     end;
end;

procedure TImportForm.clearlist(Sender: TObject);
begin
     importfilelist.items.clear;
end;

end.
