unit Clb;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TCheckListBox = class(TListBox)
  private
  FFlags:Longint;
  function exp(base,exp:Integer):Longint;
    { Private declarations }
  protected
    { Protected declarations }
  procedure DrawItem(Index:Integer; Rect:TRect; State:TOwnerDrawState); override;
  procedure RedrawItem(Index:Integer); virtual;
  procedure SetFlag(Xpos,Ypos:Integer); virtual;
  procedure WndProc(var Msg:TMessage); override;

  public
  constructor Create(AOwner:TComponent); override;
  destructor Destroy; override;

  property Flags:Longint read FFlags write FFlags;

    { Public declarations }
  published
    { Published declarations }
  end;

procedure Register;

implementation

{$R CLB.RES}

var
   truebm,falsebm:TBitmap;

procedure Register;
begin
  RegisterComponents('PyroSoft', [TCheckListBox]);
end;

constructor TCheckListBox.create(Aowner:TComponent);
begin
     inherited create(Aowner);
     truebm:=TBitMap.create;
     falsebm:=TBitMap.create;
     truebm.handle:=LoadBitMap(hinstance,'CHECKBOXTRUE');
     falsebm.handle:=LoadBitMap(hinstance,'CHECKBOXFALSE');
end;

destructor TCheckListBox.destroy;
begin
     truebm.free;
     falsebm.free;
     inherited destroy;
end;

procedure TCheckListBox.WndProc(var Msg:TMessage);
begin
     if Msg.msg=WM_LBUTTONUP then
        SetFlag(msg.lparamlo,msg.lparamhi);

     inherited WndProc(Msg);
end;

{
 This procedure checks the flag for each item it draws, and draws the appropriate bitmap.
}
procedure TCheckListBox.DrawItem(Index:Integer; Rect:TRect; State:TOwnerDrawState);
var
xoffset,height:Integer;
bitmap:TBitMap;
begin
     with canvas do begin
          fillrect(rect);
          if (flags and exp(2,index))<>0 then
             bitmap:=truebm
          else
              bitmap:=falsebm;
          Draw(rect.left+2,rect.top,bitmap);
          xoffset := Bitmap.width + 6;	{ add four pixels between bitmap and text }
          TextOut(Rect.Left + xoffset, Rect.Top,Items[index]);	{ display the text }
     end;
end;

procedure TCheckListBox.RedrawItem(Index:Integer);
begin
     DrawItem(Index,ItemRect(Index),[]);
end;

{
 This procedure does the changing of the flags...
}
procedure TCheckListBox.SetFlag(Xpos,Ypos:Integer);
var
idx:Integer;
begin
     idx:=ItemAtPos(Point(xpos,ypos),True);
     flags:=(Flags xor exp(2,idx));
     RedrawItem(idx);
end;

function TChecklistbox.exp(base,exp:Integer):Longint;
var
a:Integer;
begin
     result:=base;
     for a:=1 to exp do
         result:=result*base;
end;


end.

