unit Pyroedit;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls;

type
  TPyroEdit = class(TEdit)
  private
  FOnEnterKey:TNotifyEvent;
  procedure Setnumber(num:Longint);
  function Getnumber:Longint;
    { Private declarations }
  protected
    { Protected declarations }
    procedure KeyPress(var Key: char); override;
  public
    { Public declarations }
  published
  property Number:Longint read GetNumber write SetNumber;
  property OnEnterKey:TNotifyEvent read FOnEnterKey write FOnEnterKey;
    { Published declarations }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('PyroSoft', [TPyroEdit]);
end;

function TPyroEdit.Getnumber:Longint;
begin
     try
        result:=StrToInt(text);
     except
           result:=0;
     end;
end;

procedure TPyroEdit.Setnumber(num:Longint);
begin
     if not((num=0) and (text='')) then
        text:=IntToStr(num);
end;

procedure TPyroEdit.KeyPress(var Key: char);
begin
     if key=#13 then begin
        if Assigned(FOnEnterKey) then FOnEnterKey(Self);
        key:=#0;
     end;
     if key<>#0 then inherited Keypress(key);
end;


end.
